/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ImageFilter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.chooser.color.ColorChoiceListener;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPalettePane;
import oracle.bali.ewt.chooser.color.ColorPickerPane;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class ColorChoice
extends JButton {
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    public static final String PROPERTY_CUSTOM_COLOR_NAMES = "customColorNames";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_DEFAULT_SELECTED = "defaultSelected";
    public static final String PROPERTY_AUTOMATIC_SELECTED = "automaticSelected";
    public static final String PROPERTY_POPUP_VISIBLE = "popupVisible";
    private static final String _ACCESS_RESOURCE_FILE = "oracle.bali.ewt.resource.AccessibilityBundle";
    private static final String _KEY_ACCESS_NAME = "COLORCHOICE.ACCESSIBLE_NAME";
    private static final String _KEY_FULL_ACCESS_NAME = "COLORCHOICE.FULL_ACCESSIBLE_NAME";
    private static final String _KEY_COLOR_VALUE = "COLORPALETTE.TOOLTIP";
    private static final String _KEY_NO_COLOR = "COLORPALETTE.NO_COLOR";
    private static final String _IMAGE_NO_COLOR = "images/trans.gif";
    private static final String _IMAGE_AUTO = "images/auto.gif";
    private static final String _IMAGE_DEFAULT = "images/color.gif";
    private static final String _RESOURCE_FILE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_AUTOMATIC = "COLORCHOICE.AUTOMATIC";
    private static final String _KEY_TRANSPARENT = "COLORCHOICE.NO_COLOR";
    private static final long _VISIBLE_MILLIS = 400L;
    private static final int _BOTTOM = 0;
    private static final int _TOP = 1;
    private static final int _RIGHT = 2;
    private static final int _LEFT = 3;
    private static boolean _sShowCustomColorPane = false;
    private static Image _sDefaultImage;
    private static Color _sDefaultColorToChange;
    private static ImageIcon _sAutomaticIcon;
    private static ImageIcon _sDisabledAutomaticIcon;
    private static ImageIcon _sTransparentIcon;
    private static ImageIcon _sDisabledTransparentIcon;
    private Image _image;
    private Color _colorToChange;
    private ImageFilter _filter;
    private ColorPalettePane _colorPalettePane;
    private ColorPickerPane _colorPickerPane;
    private ColorPopup _colorPopup;
    private boolean _customDialogVisible;
    private long _popMillis;
    private ColorChoiceListener _listener;

    public ColorChoice() {
        this._init(null, null, null, null);
    }

    public ColorChoice(String label) {
        this._init(label, null, null, null);
    }

    public ColorChoice(Icon icon) {
        this._init(null, icon, null, null);
    }

    public ColorChoice(String label, TwoDModel colorPalette, Color selectColor) {
        this._init(label, null, colorPalette, selectColor);
    }

    public ColorChoice(Icon icon, TwoDModel colorPalette, Color selectColor) {
        this._init(null, icon, colorPalette, selectColor);
    }

    public static boolean isColorInPalette(TwoDModel palette, Color c) {
        if (palette == null) {
            return false;
        }
        if (c == null) {
            return true;
        }
        int colCount = palette.getColumnCount();
        int rowCount = palette.getRowCount();
        for (int i = 0; i < colCount; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                if (!c.equals(palette.getData(i, j))) continue;
                return true;
            }
        }
        return false;
    }

    public static final void setCustomColorPaneSupported(boolean customPane) {
        _sShowCustomColorPane = customPane;
    }

    public static final boolean isCustomColorPaneSupported() {
        return _sShowCustomColorPane;
    }

    public void setImage(Image image, Color colorToChange) {
        if (this._image != image) {
            if (image == null) {
                image = ColorChoice._getDefaultColorImage();
                colorToChange = _sDefaultColorToChange;
            }
            this._image = image;
            this._filter = null;
            this._colorToChange = colorToChange;
            this._updateButtonIcon();
        }
    }

    public Image getImage() {
        return this._image;
    }

    public Color getColorToChange() {
        return this._colorToChange;
    }

    public void setDefaultAllowed(boolean defaultAllowed) {
        this._colorPickerPane.setDefaultAllowed(defaultAllowed);
    }

    public boolean isDefaultAllowed() {
        return this._colorPickerPane.isDefaultAllowed();
    }

    public void setDefaultColor(Color defaultColor) {
        this._colorPickerPane.setDefaultColor(defaultColor);
    }

    public Color getDefaultColor() {
        return this._colorPickerPane.getDefaultColor();
    }

    public void setDefaultSelected(boolean selected) {
        this._colorPickerPane.setDefaultSelected(selected);
    }

    public boolean isDefaultSelected() {
        return this._colorPickerPane.isDefaultSelected();
    }

    public void setAutomaticAllowed(boolean automaticAllowed) {
        this._colorPickerPane.setAutomaticAllowed(automaticAllowed);
    }

    public boolean isAutomaticAllowed() {
        return this._colorPickerPane.isAutomaticAllowed();
    }

    public void setAutomaticSelected(boolean selected) {
        this._colorPickerPane.setAutomaticSelected(selected);
    }

    public boolean isAutomaticSelected() {
        return this._colorPickerPane.isAutomaticSelected();
    }

    public void setTransparentAllowed(boolean transparentAllowed) {
        if (transparentAllowed != this.isTransparentAllowed()) {
            this._colorPickerPane.setTransparentAllowed(transparentAllowed);
            if (this.getSelectedColor() == null && !this.isAutomaticSelected()) {
                this._updateButtonIcon();
            }
        }
    }

    public boolean isTransparentAllowed() {
        return this._colorPickerPane.isTransparentAllowed();
    }

    public void setTransparentLabelUsed(boolean transparent) {
        this._colorPickerPane.setTransparentLabelUsed(transparent);
    }

    public boolean isTransparentLabelUsed() {
        return this._colorPickerPane.isTransparentLabelUsed();
    }

    public void setEditAllowed(boolean isEditAllowed) {
        this._colorPickerPane.setCustomizationAllowed(isEditAllowed);
    }

    public boolean isEditAllowed() {
        return this._colorPickerPane.isCustomizationAllowed();
    }

    public void setColorPalette(TwoDModel colorPalette) {
        this._colorPickerPane.setColorPalette(colorPalette);
        this.setEnabled(this.isEnabled());
    }

    public TwoDModel getColorPalette() {
        return this._colorPickerPane.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel colorPalette) {
        this._colorPickerPane.setCustomColorPalette(colorPalette);
    }

    public TwoDModel getCustomColorPalette() {
        return this._colorPickerPane.getCustomColorPalette();
    }

    public void setCustomColorNames(TwoDModel colorNames) {
        this._colorPickerPane.setCustomColorNames(colorNames);
    }

    public TwoDModel getCustomColorNames() {
        return this._colorPickerPane.getCustomColorNames();
    }

    public String getCustomColorName() {
        return this._colorPickerPane.getCustomColorName();
    }

    public void setSelectedColor(Color c) {
        this._colorPickerPane.setSelectedColor(c);
    }

    public Color getSelectedColor() {
        return this._colorPickerPane.getSelectedColor();
    }

    @Deprecated
    public void setSelectedColor(Color c, boolean colorInCustomPalette) {
        this.setSelectedColor(c);
    }

    @Deprecated
    public boolean isCustomColorSelected() {
        ColorGrid customGrid = this._colorPickerPane.__getCustomGrid();
        return customGrid.isVisible() && customGrid.__getSelectedColumn() != -1 && customGrid.__getSelectedRow() != -1;
    }

    public Color getClosestColor(Color color) {
        return this.getClosestColor(color, false);
    }

    public Color getClosestColor(Color color, boolean useCustomPalette) {
        TwoDModel palette = useCustomPalette ? this.getCustomColorPalette() : this.getColorPalette();
        return ColorGrid.getClosestColor(palette, color);
    }

    public void setToolTipMode(int mode) {
        this._colorPickerPane.setToolTipMode(mode);
    }

    public int getToolTipMode() {
        return this._colorPickerPane.getToolTipMode();
    }

    @Deprecated
    public ColorPalettePane getColorPalettePane() {
        if (this._colorPalettePane == null) {
            this._colorPalettePane = new ColorPalettePane();
            this._initPane(this._colorPalettePane);
        }
        return this._colorPalettePane;
    }

    public CustomColorPane getCustomColorPane() {
        return this._colorPickerPane.getCustomColorPane();
    }

    public boolean isPopupVisible() {
        return this.__isDropDownVisible() || this._customDialogVisible;
    }

    public void dispose() {
        if (this._colorPickerPane == null) {
            return;
        }
        if (this._colorPopup != null) {
            this.__setDropDownVisible(false);
            this._colorPopup = null;
        }
        if (this._colorPalettePane != null) {
            this._colorPalettePane.dispose();
            this._colorPalettePane = null;
        }
        this._colorPickerPane.dispose();
        this._colorPickerPane = null;
        this._listener.unregisterColorChoice();
        this._listener = null;
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this._clearImage();
    }

    @Override
    public void setDisabledIcon(Icon icon) {
        super.setDisabledIcon(icon);
        this._clearImage();
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable && this._isDropDownAllowed());
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        if (this._colorPickerPane != null) {
            this._colorPickerPane.setLocale(l);
        }
    }

    @Override
    public void removeNotify() {
        this.__setDropDownVisible(false);
        super.removeNotify();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getMargin() == null || this.getMargin() instanceof UIResource) {
            this.setMargin(ColorPickerUtils.getDefaultButtonMargin());
        }
        if (this._colorPopup != null) {
            SwingUtilities.updateComponentTreeUI(this._colorPopup);
        } else if (this._colorPickerPane != null) {
            SwingUtilities.updateComponentTreeUI(this._colorPickerPane);
        }
        if (this._colorPalettePane != null) {
            SwingUtilities.updateComponentTreeUI(this._colorPalettePane);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    @Override
    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (PROPERTY_SELECTED_COLOR.equals(name)) {
            this._updateButtonIcon();
        }
        super.firePropertyChange(name, oldValue, newValue);
    }

    boolean __isDropDownVisible() {
        return this._colorPopup != null && this._colorPopup.isVisible();
    }

    void __setDropDownVisible(boolean visible) {
        if (visible != this.__isDropDownVisible()) {
            if (visible) {
                this._getColorPopup().showPopup();
            } else {
                this._getColorPopup().hidePopup();
            }
        }
    }

    boolean __canDispatchMouseEventToGrid() {
        long time = System.currentTimeMillis();
        return time - this._popMillis >= 400L;
    }

    void __setCustomDialogVisible(boolean visible) {
        this._customDialogVisible = visible;
    }

    ColorPickerPane __getColorPickerPane() {
        return this._colorPickerPane;
    }

    void __fireAccessibleEvent(String name) {
        if (this.accessibleContext != null) {
            this._colorPopup.fireAccessibleEvent(name);
        }
    }

    private static Image _getDefaultColorImage() {
        if (_sDefaultImage == null) {
            _sDefaultImage = ImageUtils.getImageResource(ColorChoice.class, _IMAGE_DEFAULT);
            _sDefaultColorToChange = new Color(100, 100, 100);
        }
        return _sDefaultImage;
    }

    private void _init(String label, Icon icon, TwoDModel colors, Color selectColor) {
        this._listener = new ColorChoiceListener(this);
        this._colorPickerPane = new ColorChoicePane(colors, selectColor);
        this.setText(label);
        if (label == null) {
            if (icon != null) {
                this.setIcon(icon);
            } else {
                Image image = ColorChoice._getDefaultColorImage();
                this.setImage(image, _sDefaultColorToChange);
            }
        }
        this.setModel(new Model());
    }

    private void _initPane(ColorPalettePane pane) {
        boolean visible;
        pane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        pane.setColorPalette(this.getColorPalette());
        TwoDModel custom = this.getCustomColorPalette();
        boolean bl = visible = custom != null && custom.getColumnCount() > 0 && custom.getRowCount() > 0;
        if (visible) {
            int columns = custom.getColumnCount();
            int rows = custom.getRowCount();
            ArrayTwoDModel ds = new ArrayTwoDModel(columns, rows);
            for (int i = 0; i < columns; ++i) {
                for (int j = 0; j < rows; ++j) {
                    ds.setData(i, j, custom.getData(i, j));
                }
            }
            pane.setCustomColorPalette(ds);
        }
        pane.setCustomColorsVisible(visible);
        pane.setEditVisible(visible);
        if (!this.isDefaultSelected()) {
            try {
                pane.setSelectedColor(this.getSelectedColor(), this.isCustomColorSelected());
            }
            catch (IllegalArgumentException e) {
                pane.setSelectedColor(null);
            }
        } else {
            pane.setSelectedColor(null);
        }
    }

    private void _updateButtonIcon() {
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        if (this.isAutomaticSelected()) {
            this._setAutomaticIcons();
            return;
        }
        Color c = this.getSelectedColor();
        if (c == null && this.isTransparentAllowed()) {
            this._setTransparentIcons();
        } else {
            this._setSelectedColorIcon(image, c);
        }
    }

    private void _setAutomaticIcons() {
        if (_sAutomaticIcon == null) {
            Image image = ImageUtils.getImageResource(ColorChoice.class, _IMAGE_AUTO);
            _sAutomaticIcon = new ImageIcon(image);
            _sDisabledAutomaticIcon = new ImageIcon(ImageUtils.createDisabledImage(image));
        }
        super.setIcon(_sAutomaticIcon);
        super.setDisabledIcon(_sDisabledAutomaticIcon);
    }

    private void _setTransparentIcons() {
        if (_sTransparentIcon == null) {
            Image image = ImageUtils.getImageResource(ColorChoice.class, _IMAGE_NO_COLOR);
            _sTransparentIcon = new ImageIcon(image);
            _sDisabledTransparentIcon = new ImageIcon(ImageUtils.createDisabledImage(image));
        }
        super.setIcon(_sTransparentIcon);
        super.setDisabledIcon(_sDisabledTransparentIcon);
    }

    private void _setSelectedColorIcon(Image image, Color c) {
        if (this._filter == null) {
            this._filter = ColorPickerUtils.createColorFilter(this.getColorToChange());
        }
        image = ColorPickerUtils.createFilteredImage(image, this._filter, c);
        ImageIcon icon = new ImageIcon(image);
        super.setIcon(icon);
        image = ImageUtils.createDisabledImage(image);
        super.setDisabledIcon(new ImageIcon(image));
    }

    private void _clearImage() {
        this._image = null;
        this._colorToChange = null;
        this._filter = null;
    }

    private ColorPopup _getColorPopup() {
        if (this._colorPopup == null) {
            this._colorPopup = new ColorPopup();
        }
        return this._colorPopup;
    }

    private boolean _isDropDownAllowed() {
        TwoDModel model = this.getColorPalette();
        return model != null && model.getColumnCount() > 0 && model.getRowCount() > 0;
    }

    private String _getAccessTranslatedString(String key) {
        ResourceBundle b = ResourceBundle.getBundle(_ACCESS_RESOURCE_FILE, LocaleUtils.getDefaultableLocale((Component)this));
        return b.getString(key);
    }

    private class ColorPopup
    extends JPopupMenu {
        private FocusManager _prevFocusManager;
        private Component _prevFocussed;
        private Window _nonFocusableWindow;
        private StatusBar _statusBar;
        private AccessibleJLabel _statusBarLabel;

        public ColorPopup() {
            Border border = LineBorder.createBlackLineBorder();
            Border margin = BorderFactory.createEmptyBorder(3, 3, 3, 3);
            this.setBorder(new CompoundBorder(border, margin));
            FocusUtils.setFocusable(this, false);
            this.setLayout(new BorderLayout());
            this.add(ColorChoice.this._colorPickerPane);
        }

        public void showPopup() {
            Rectangle buttonBounds = ColorChoice.this.getBounds();
            buttonBounds.setLocation(ColorChoice.this.getLocationOnScreen());
            Rectangle displayBounds = null;
            GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (int i = 0; i < gds.length; ++i) {
                GraphicsConfiguration dgc = gds[i].getDefaultConfiguration();
                Rectangle bounds = dgc.getBounds();
                Insets screenInsets = MenuUtils.getScreenInsets(dgc);
                bounds.x += screenInsets.left;
                bounds.y += screenInsets.top;
                bounds.width -= screenInsets.left + screenInsets.right;
                bounds.height -= screenInsets.top + screenInsets.bottom;
                if (bounds.contains(buttonBounds.x, buttonBounds.y)) {
                    displayBounds = bounds;
                    break;
                }
                if (!bounds.intersects(buttonBounds)) continue;
                displayBounds = bounds;
            }
            if (displayBounds == null) {
                return;
            }
            Dimension popupSize = this.getPreferredSize();
            Rectangle screenBounds = new Rectangle(displayBounds);
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                Container root;
                Container parent = root = ColorChoice.this.getParent();
                while (root != null) {
                    parent = root.getParent();
                    if (root instanceof JRootPane && (parent instanceof Window || parent instanceof Applet)) {
                        Rectangle avail = root.getBounds();
                        avail.setLocation(root.getLocationOnScreen());
                        SwingUtilities.computeIntersection(avail.x, avail.y, avail.width, avail.height, displayBounds);
                        break;
                    }
                    root = parent;
                }
            }
            if (displayBounds.intersects(buttonBounds)) {
                SwingUtilities.computeIntersection(displayBounds.x, displayBounds.y, displayBounds.width, displayBounds.height, buttonBounds);
            }
            Dimension[] regions = this._calculateBounds(displayBounds, buttonBounds);
            Dimension bottomArea = regions[0];
            Dimension topArea = regions[1];
            Dimension rightArea = regions[2];
            Dimension leftArea = regions[3];
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                Dimension min = this.getMinimumSize();
                if (!(bottomArea.width >= min.width && bottomArea.height >= min.height || topArea.width >= min.width && topArea.height >= min.height || rightArea.width >= min.width && rightArea.height >= min.height || leftArea.width >= min.width && leftArea.height >= min.height)) {
                    regions = this._calculateBounds(screenBounds, buttonBounds);
                    bottomArea = regions[0];
                    topArea = regions[1];
                    rightArea = regions[2];
                    leftArea = regions[3];
                }
            }
            int[] area = new int[]{Math.min(bottomArea.width, popupSize.width) * Math.min(bottomArea.height, popupSize.height), Math.min(topArea.width, popupSize.width) * Math.min(topArea.height, popupSize.height), Math.min(rightArea.width, popupSize.width) * Math.min(rightArea.height, popupSize.height), Math.min(leftArea.width, popupSize.width) * Math.min(leftArea.height, popupSize.height)};
            int maxArea = area[0];
            int pos = 0;
            for (int i = 1; i < area.length; ++i) {
                if (maxArea >= area[i]) continue;
                maxArea = area[i];
                pos = i;
            }
            switch (pos) {
                case 0: {
                    popupSize.width = Math.min(popupSize.width, bottomArea.width);
                    popupSize.height = Math.min(popupSize.height, bottomArea.height);
                    break;
                }
                case 1: {
                    popupSize.width = Math.min(popupSize.width, topArea.width);
                    popupSize.height = Math.min(popupSize.height, topArea.height);
                    break;
                }
                case 2: {
                    popupSize.width = Math.min(popupSize.width, rightArea.width);
                    popupSize.height = Math.min(popupSize.height, rightArea.height);
                    break;
                }
                case 3: {
                    popupSize.width = Math.min(popupSize.width, leftArea.width);
                    popupSize.height = Math.min(popupSize.height, leftArea.height);
                }
            }
            this.setPreferredSize(popupSize);
            int x = 0;
            int y = 0;
            if (pos == 0 || pos == 1) {
                int usableLeftWidth;
                int usableRightWidth = Math.min(rightArea.width + buttonBounds.width, popupSize.width);
                x = usableRightWidth >= (usableLeftWidth = Math.min(leftArea.width + buttonBounds.width, popupSize.width)) ? usableRightWidth - popupSize.width : buttonBounds.width - usableLeftWidth;
                y += pos == 0 ? buttonBounds.height : -popupSize.height;
            } else {
                x += pos == 2 ? buttonBounds.width : -popupSize.width;
                int usableBottomHeight = Math.min(bottomArea.height + buttonBounds.height, popupSize.height);
                int usableTopHeight = Math.min(topArea.height + buttonBounds.height, popupSize.height);
                y = usableBottomHeight >= usableTopHeight ? usableBottomHeight - popupSize.height : buttonBounds.height - usableTopHeight;
            }
            this.show(ColorChoice.this, x, y);
        }

        public void hidePopup() {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selection = manager.getSelectedPath();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] != this) continue;
                manager.clearSelectedPath();
                break;
            }
            ColorChoice.this.requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ColorChoice.this.getAccessibleContext().firePropertyChange("AccessibleName", null, ColorChoice.this.getAccessibleContext().getAccessibleName());
                }
            });
        }

        public void fireAccessibleEvent(String text) {
            if (this._statusBarLabel != null) {
                this._statusBarLabel.setText(text);
            }
        }

        @Override
        public Color getBackground() {
            if (ColorChoice.this != null) {
                return ColorChoice.this.getBackground();
            }
            return super.getBackground();
        }

        @Override
        public void setVisible(boolean visible) {
            boolean wasVisible = this.isVisible();
            if (visible != wasVisible) {
                super.setVisible(visible);
                Component focus = null;
                if (this.isVisible()) {
                    ColorChoice.this._popMillis = System.currentTimeMillis();
                    if (FocusUtils.areNewFocusAPIsAvailable()) {
                        Window w;
                        if (!FocusUtils.isFocusable(ColorChoice.this)) {
                            List focusComps;
                            Component root = SwingUtilities.getRoot(ColorChoice.this);
                            if (root != null) {
                                this._prevFocussed = SwingUtilities.findFocusOwner(root);
                            }
                            if ((focusComps = ColorChoice.this._colorPickerPane.__getFocusCycle()).size() > 0) {
                                focus = (Component)focusComps.get(0);
                            }
                        }
                        if ((w = WindowUtils.getWindow(this)) != null && !FocusUtils.getFocusableWindowState(w)) {
                            FocusUtils.setFocusableWindowState(w, true);
                            this._nonFocusableWindow = w;
                        }
                        FocusUtils.setFocusTraversalKeysEnabled(ColorChoice.this, false);
                        FocusUtils.setFocusTraversalKeysEnabled(this, false, true);
                    } else {
                        this._prevFocusManager = FocusManager.getCurrentManager();
                        FocusManager.disableSwingFocusManager();
                    }
                } else {
                    ColorChoice.this._popMillis = 0L;
                    this.setPreferredSize(null);
                    if (FocusUtils.areNewFocusAPIsAvailable()) {
                        if (this._prevFocussed != null) {
                            focus = this._prevFocussed;
                            this._prevFocussed = null;
                        }
                        if (this._nonFocusableWindow != null) {
                            FocusUtils.setFocusableWindowState(this._nonFocusableWindow, false);
                            this._nonFocusableWindow = null;
                        }
                        FocusUtils.setFocusTraversalKeysEnabled(ColorChoice.this, true);
                    } else {
                        FocusManager.setCurrentManager(this._prevFocusManager);
                    }
                    ToolTipManager tipManager = ToolTipManager.sharedInstance();
                    boolean tipEnable = tipManager.isEnabled();
                    tipManager.setEnabled(false);
                    tipManager.setEnabled(tipEnable);
                }
                if (focus != null) {
                    final Component temp = focus;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            temp.requestFocus();
                        }
                    });
                }
                if (!ColorChoice.this._customDialogVisible) {
                    ColorChoice.this.firePropertyChange(ColorChoice.PROPERTY_POPUP_VISIBLE, !visible, visible);
                }
                ColorChoice.this.repaint();
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = super.getAccessibleContext();
                this.accessibleContext.setAccessibleParent(ColorChoice.this);
                this._statusBar = new StatusBar();
                this._statusBarLabel = new AccessibleJLabel();
                this._statusBar.add(this._statusBarLabel);
                this._statusBar.setPreferredSize(new Dimension(0, 0));
                this.add((Component)this._statusBar, "South");
            }
            return this.accessibleContext;
        }

        private Dimension[] _calculateBounds(Rectangle displayBounds, Rectangle buttonBounds) {
            Dimension[] regions = new Dimension[]{new Dimension(displayBounds.width, displayBounds.y + displayBounds.height - (buttonBounds.y + buttonBounds.height)), new Dimension(displayBounds.width, buttonBounds.y - displayBounds.y), new Dimension(displayBounds.x + displayBounds.width - (buttonBounds.x + buttonBounds.width), displayBounds.height), new Dimension(buttonBounds.x - displayBounds.x, displayBounds.height)};
            return regions;
        }

        private class AccessibleJLabel
        extends JLabel {
            private AccessibleJLabel() {
            }

            @Override
            public void setText(String text) {
                String oldName = this.getText();
                super.setText(text);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", oldName, text);
                }
            }
        }
    }

    private class Access
    extends JButton.AccessibleJButton {
        private MessageFormat _format;

        private Access() {
            super(ColorChoice.this);
        }

        @Override
        public String getAccessibleName() {
            String s = super.getAccessibleName();
            if (s == null || "".equals(s)) {
                s = ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_ACCESS_NAME);
            } else {
                this._applyPattern(ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_FULL_ACCESS_NAME));
                Object[] args = new Object[]{s};
                s = this._format.format(args);
            }
            Color selColor = ColorChoice.this.getSelectedColor();
            String text = null;
            if (selColor != null) {
                this._applyPattern(ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_COLOR_VALUE));
                Object[] args = new Object[]{IntegerUtils.getInteger((int)selColor.getRed()), IntegerUtils.getInteger((int)selColor.getGreen()), IntegerUtils.getInteger((int)selColor.getBlue())};
                text = this._format.format(args);
            } else if (ColorChoice.this.isAutomaticAllowed() && ColorChoice.this.isAutomaticSelected() || ColorChoice.this.isTransparentAllowed() && ColorChoice.this.isTransparentLabelUsed()) {
                String key = ColorChoice.this.isAutomaticAllowed() && ColorChoice.this.isAutomaticSelected() ? ColorChoice._KEY_AUTOMATIC : ColorChoice._KEY_TRANSPARENT;
                ResourceBundle b = ResourceBundle.getBundle(ColorChoice._RESOURCE_FILE, LocaleUtils.getDefaultableLocale((Component)ColorChoice.this));
                text = StringUtils.stripMnemonic((String)b.getString(key));
            } else {
                text = ColorChoice.this._getAccessTranslatedString(ColorChoice._KEY_NO_COLOR);
            }
            s = s == null ? text : s + " " + text;
            return s;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 1;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i == 0) {
                return ColorChoice.this._getColorPopup();
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i == 0) {
                ColorChoice.this.__setDropDownVisible(!ColorChoice.this.__isDropDownVisible());
                return true;
            }
            return false;
        }

        private void _applyPattern(String text) {
            if (this._format == null) {
                this._format = new MessageFormat(text);
            } else {
                this._format.applyPattern(text);
            }
        }
    }

    private class ColorChoicePane
    extends ColorPickerPane {
        public ColorChoicePane(TwoDModel palette, Color selectedColor) {
            super(palette, null, selectedColor);
            ColorChoice.this._listener.registerColorGrid(this.__getStandardGrid());
            ColorChoice.this._listener.registerColorGrid(this.__getCustomGrid());
            ColorChoice.this._listener.registerColorPickerPane(this);
            FocusUtils.setFocusable(this, false);
        }

        @Override
        public void dispose() {
            ColorGrid customGrid;
            ColorGrid grid = this.__getStandardGrid();
            if (grid != null) {
                ColorChoice.this._listener.unregisterColorGrid(grid);
            }
            if ((customGrid = this.__getCustomGrid()) != null) {
                ColorChoice.this._listener.unregisterColorGrid(customGrid);
            }
            ColorChoice.this._listener.unregisterColorPickerPane(this);
            super.dispose();
        }

        @Override
        JLabel __createColorLabel() {
            return null;
        }

        @Override
        void __registerButtonActions(JToggleButton toggleButton) {
            super.__registerButtonActions(toggleButton);
            ColorChoice.this._listener.registerToggleButtons(toggleButton);
        }

        @Override
        void __unregisterButtonActions(JToggleButton toggleButton) {
            super.__unregisterButtonActions(toggleButton);
            ColorChoice.this._listener.unregisterToggleButtons(toggleButton);
        }

        @Override
        void __registerCustomButtonActions(JButton button) {
            super.__registerCustomButtonActions(button);
            ColorChoice.this._listener.registerCustomButton(button);
        }

        @Override
        void __unregisterCustomButtonActions(JButton button) {
            super.__unregisterCustomButtonActions(button);
            ColorChoice.this._listener.unregisterCustomButton(button);
        }

        @Override
        CustomColorPane __getCustomColorPane() {
            return ColorChoice.this.getCustomColorPane();
        }

        @Override
        void __launchCustomColorPane() {
            if (ColorChoice.isCustomColorPaneSupported()) {
                super.__launchCustomColorPane();
            } else {
                ColorPalettePane pane = ColorChoice.this.getColorPalettePane();
                ColorChoice.this._initPane(pane);
                ColorChoice.this._listener.showColorPalettePane(pane);
            }
        }

        @Override
        boolean __showPaneInDialog(CustomColorPane pane) {
            return ColorChoice.this._listener.showCustomColorPane(pane);
        }
    }

    private class Model
    extends DefaultButtonModel {
        private Model() {
        }

        @Override
        public boolean isArmed() {
            return ColorChoice.this.__isDropDownVisible();
        }

        @Override
        public boolean isPressed() {
            return ColorChoice.this.__isDropDownVisible();
        }
    }
}

