/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.lang.reflect.Method;
import oracle.bali.ewt.beaninfo.RulerStyleEditor;
import oracle.bali.ewt.beaninfo.TextWrapperEditor;
import oracle.bali.ewt.graphics.ImageUtils;

public abstract class EWTBeanInfo
extends SimpleBeanInfo {
    public static final String BOUND = "bound";
    public static final String CONSTRAINED = "constrained";
    public static final String PROPERTYEDITORCLASS = "propertyEditorClass";
    public static final String READMETHOD = "readMethod";
    public static final String WRITEMETHOD = "writeMethod";
    public static final String DISPLAYNAME = "displayName";
    public static final String EXPERT = "expert";
    public static final String HIDDEN = "hidden";
    public static final String PREFERRED = "preferred";
    public static final String SHORTDESCRIPTION = "shortDescription";
    public static final String CUSTOMIZERCLASS = "customizerClass";

    protected void throwError(Exception e, String s) {
        throw new Error(e.toString() + " " + s);
    }

    private void initFeatureDescriptor(FeatureDescriptor fd, String key, Object value) {
        if (DISPLAYNAME.equals(key)) {
            fd.setDisplayName((String)value);
        }
        if (EXPERT.equals(key)) {
            fd.setExpert((Boolean)value);
        }
        if (HIDDEN.equals(key)) {
            fd.setHidden((Boolean)value);
        }
        if (PREFERRED.equals(key)) {
            if (PREFERRED.equals(key)) {
                fd.setValue(key, value);
            }
        } else if (SHORTDESCRIPTION.equals(key)) {
            fd.setShortDescription((String)value);
        } else {
            fd.setValue(key, value);
        }
    }

    public PropertyDescriptor createPropertyDescriptor(Class cls, String name, Object[] args) {
        PropertyDescriptor pd = null;
        try {
            pd = new PropertyDescriptor(name, cls);
        }
        catch (IntrospectionException e) {
            try {
                pd = this.createReadOnlyPropertyDescriptor(name, cls);
            }
            catch (IntrospectionException ie) {
                this.throwError(ie, "Can't create PropertyDescriptor for " + name + " ");
            }
        }
        for (int i = 0; i < args.length; i += 2) {
            Method method;
            String methodName;
            String key = (String)args[i];
            Object value = args[i + 1];
            if (BOUND.equals(key)) {
                pd.setBound((Boolean)value);
                continue;
            }
            if (CONSTRAINED.equals(key)) {
                pd.setConstrained((Boolean)value);
                continue;
            }
            if (PROPERTYEDITORCLASS.equals(key)) {
                pd.setPropertyEditorClass((Class)value);
                continue;
            }
            if (READMETHOD.equals(key)) {
                methodName = (String)value;
                try {
                    method = cls.getMethod(methodName, new Class[0]);
                }
                catch (Exception e) {
                    this.throwError(e, cls + " no such method as \"" + methodName + "\"");
                }
                continue;
            }
            if (WRITEMETHOD.equals(key)) {
                methodName = (String)value;
                try {
                    Class<?> type = pd.getPropertyType();
                    method = cls.getMethod(methodName, type);
                }
                catch (Exception e) {
                    this.throwError(e, cls + " no such method as \"" + methodName + "\"");
                }
                continue;
            }
            this.initFeatureDescriptor(pd, key, value);
        }
        return pd;
    }

    public BeanDescriptor createBeanDescriptor(Class cls, Object[] args) {
        Class customizerClass = null;
        for (int i = 0; i < args.length; i += 2) {
            if (!CUSTOMIZERCLASS.equals((String)args[i])) continue;
            customizerClass = (Class)args[i + 1];
            break;
        }
        BeanDescriptor bd = new BeanDescriptor(cls, customizerClass);
        for (int i = 0; i < args.length; i += 2) {
            String key = (String)args[i];
            Object value = args[i + 1];
            this.initFeatureDescriptor(bd, key, value);
        }
        return bd;
    }

    @Override
    public int getDefaultPropertyIndex() {
        return 0;
    }

    @Override
    public Image getIcon(int kind) {
        String fullname = this.getClass().getName();
        String basename = fullname.substring(fullname.lastIndexOf(".") + 1, fullname.indexOf("BeanInfo"));
        return switch (kind) {
            case 2 -> ImageUtils.getImageResource(EWTBeanInfo.class, "beaninfo/images/" + basename + "Color32.gif");
            case 1 -> ImageUtils.getImageResource(EWTBeanInfo.class, "beaninfo/images/" + basename + "Color16.gif");
            case 4 -> ImageUtils.getImageResource(EWTBeanInfo.class, "beaninfo/images/" + basename + "Mono32.gif");
            case 3 -> ImageUtils.getImageResource(EWTBeanInfo.class, "beaninfo/images/" + basename + "Mono16.gif");
            default -> null;
        };
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        Class<?> superClass = this.getBeanDescriptor().getBeanClass().getSuperclass();
        BeanInfo superBeanInfo = null;
        try {
            superBeanInfo = Introspector.getBeanInfo(superClass);
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (superBeanInfo != null) {
            BeanInfo[] ret = new BeanInfo[]{superBeanInfo};
            return ret;
        }
        return null;
    }

    private PropertyDescriptor createReadOnlyPropertyDescriptor(String name, Class cls) throws IntrospectionException {
        Method readMethod = null;
        String base = EWTBeanInfo.capitalize(name);
        Class[] parameters = new Class[]{};
        try {
            readMethod = cls.getMethod("is" + base, parameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (readMethod == null) {
            try {
                readMethod = cls.getMethod("get" + base, parameters);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (readMethod != null) {
            return new PropertyDescriptor(name, readMethod, null);
        }
        try {
            parameters = new Class[]{Integer.TYPE};
            readMethod = cls.getMethod("get" + base, parameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new IntrospectionException("cannot find accessor method for " + name + " property.");
        }
        return new IndexedPropertyDescriptor(name, null, null, readMethod, null);
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    static {
        TextWrapperEditor.register();
        RulerStyleEditor.register();
    }
}

