/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.lang.reflect.Array;
import oracle.aurora.util.Cursor;
import oracle.aurora.util.OrderedCollectionCursor;

public class OrderedCollection {
    protected int size;
    protected int first;
    protected Object[] data;
    protected static final float growthFactor = 1.6f;
    protected static final int defCap = 10;
    protected static final int minCap = 3;

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int getCapacity() {
        return this.data.length;
    }

    public OrderedCollection() {
        this(10);
    }

    public OrderedCollection(int initCap) {
        if (initCap < 3) {
            initCap = 3;
        }
        this.size = 0;
        this.first = 0;
        this.data = new Object[initCap];
    }

    public OrderedCollection(OrderedCollection src) {
        this.data = new Object[Math.max(3, src.size)];
        if (src.size > 0) {
            if (src.first < (src.first + src.size) % src.data.length) {
                System.arraycopy(src.data, src.first, this.data, 0, src.size);
            } else {
                int toCopy = src.data.length - src.first;
                System.arraycopy(src.data, src.first, this.data, 0, toCopy);
                System.arraycopy(src.data, 0, this.data, toCopy, src.size - toCopy);
            }
        }
        this.size = src.size;
        this.first = 0;
    }

    public OrderedCollection(Object[] objs) {
        this.data = new Object[Math.max(3, objs.length)];
        System.arraycopy(objs, 0, this.data, 0, objs.length);
        this.size = objs.length;
        this.first = 0;
    }

    public Cursor enumerate() {
        return new OrderedCollectionCursor(this);
    }

    public Object[] getObjects() {
        Object[] result = new Object[this.size];
        this.getObjects(result);
        return result;
    }

    public Object[] getObjects(Class componentType) {
        Object[] result = (Object[])Array.newInstance(componentType, this.size);
        this.getObjects(result);
        return result;
    }

    public void getObjects(Object[] array) {
        int toCopy = Math.min(this.size, array.length);
        int length = Math.min(this.data.length - this.first, toCopy);
        System.arraycopy(this.data, this.first, array, 0, length);
        if (length < toCopy) {
            System.arraycopy(this.data, 0, array, length, toCopy - length);
        }
    }

    public Object elementAt(int idx) {
        if (idx > this.size || idx < 0) {
            this.referenceError(idx);
        }
        return this.data[(this.first + idx) % this.data.length];
    }

    public final Object firstElement() {
        return this.elementAt(0);
    }

    public final Object peek() {
        return this.elementAt(0);
    }

    public final Object lastElement() {
        return this.elementAt(this.size - 1);
    }

    public Object setElementAt(Object obj, int idx) {
        if (idx > this.size) {
            this.referenceError(idx);
        }
        int ridx = (this.first + idx) % this.data.length;
        Object result = this.data[ridx];
        this.data[ridx] = obj;
        return result;
    }

    public final Object setFirstElement(Object obj) {
        return this.setElementAt(obj, 0);
    }

    public void addFirstElement(Object obj) {
        if (this.size >= this.data.length) {
            this.grow();
        }
        this.first = (this.first - 1 + this.data.length) % this.data.length;
        this.data[this.first] = obj;
        ++this.size;
    }

    public final void push(Object obj) {
        this.addFirstElement(obj);
    }

    public Object removeFirstElement() {
        Object result = this.elementAt(0);
        this.setElementAt(null, 0);
        this.first = (this.first + 1) % this.data.length;
        --this.size;
        return result;
    }

    public void removeFirstElements(int n) {
        for (int i = 0; i < n; ++i) {
            this.setElementAt(null, i);
        }
        this.first = (this.first + n) % this.data.length;
        this.size -= n;
    }

    public final Object pop() {
        return this.removeFirstElement();
    }

    public void addLastElement(Object obj) {
        if (this.size >= this.data.length) {
            this.grow();
        }
        this.data[(this.first + this.size++) % this.data.length] = obj;
    }

    public final void append(Object obj) {
        this.addLastElement(obj);
    }

    public Object removeLastElement() {
        if (this.size <= 0) {
            this.referenceError(0);
        }
        Object result = this.elementAt(this.size - 1);
        this.setElementAt(null, this.size - 1);
        --this.size;
        return result;
    }

    public void removeLastElements(int n) {
        for (int i = this.size - n; i < this.size; ++i) {
            this.setElementAt(null, i);
        }
        this.size -= n;
    }

    public void clear() {
        this.removeLastElements(this.size);
    }

    public final Object truncate() {
        return this.removeLastElement();
    }

    protected void referenceError(int idx) {
        throw new ArrayIndexOutOfBoundsException("index: " + idx + " out of bounds: " + this.size);
    }

    protected void grow() {
        Object[] newData = new Object[Math.round((float)this.size * 1.6f)];
        for (int i = 0; i < this.size; ++i) {
            newData[i] = this.elementAt(i);
        }
        this.data = newData;
        this.first = 0;
    }

    protected static void printInts(OrderedCollection oc) {
        System.out.print("(");
        for (int i = 0; i < oc.getSize(); ++i) {
            System.out.print(" " + (Integer)oc.elementAt(i));
        }
        System.out.println(" )");
    }

    public static void main(String[] args) {
        OrderedCollection oc = new OrderedCollection(3);
        OrderedCollection.printInts(oc);
        oc.addFirstElement(new Integer(1));
        OrderedCollection.printInts(oc);
        oc.addLastElement(new Integer(2));
        OrderedCollection.printInts(oc);
        oc.addFirstElement(new Integer(0));
        OrderedCollection.printInts(oc);
        oc.addLastElement(new Integer(3));
        OrderedCollection.printInts(oc);
        oc.removeFirstElement();
        OrderedCollection.printInts(oc);
        oc.removeLastElement();
        OrderedCollection.printInts(oc);
        oc.addFirstElement(new Integer(0));
        OrderedCollection.printInts(oc);
        oc.addLastElement(new Integer(3));
        OrderedCollection.printInts(oc);
        oc.addLastElement(new Integer(4));
        OrderedCollection.printInts(oc);
        oc.addFirstElement(new Integer(-1));
        OrderedCollection.printInts(oc);
        oc.addLastElement(new Integer(5));
        OrderedCollection.printInts(oc);
        oc.addFirstElement(new Integer(-2));
        OrderedCollection.printInts(oc);
        oc.addLastElement(new Integer(6));
        OrderedCollection.printInts(oc);
        int expected = -2;
        boolean passed = true;
        Cursor curs = oc.enumerate();
        while (curs.next()) {
            int i = (Integer)curs.get();
            if (i != expected) {
                System.err.println("Error - expected: " + expected + ", got: " + i);
                passed = false;
            }
            ++expected;
        }
        System.out.println("Test " + (passed ? "passed" : "failed"));
    }
}

