/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.RefAddr;
import javax.naming.Reference;
import oracle.aurora.util.BufferedOutputStream;
import oracle.aurora.util.ErrorMessages;
import oracle.aurora.util.LocalStringManagerImpl;

public class ExProperties
extends Properties {
    public static final String DEFAULT_PROPS = "systemDefaults.properties";
    public static final String PROPFILE_SUFFIX = ".properties";
    public static LocalStringManagerImpl ls;
    static final long serialVersionUID = 8882286348782174409L;

    public ExProperties() {
    }

    public ExProperties(Properties defaults) {
        super(defaults);
    }

    public ExProperties(Reference ref) {
        this();
        Enumeration<RefAddr> e = ref.getAll();
        while (e.hasMoreElements()) {
            RefAddr addr = e.nextElement();
            this.put(addr.getType(), addr.getContent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backUpAndSave(String name, String header) throws IOException {
        File newFile = new File(name);
        File oldFile = new File(name + ".bak");
        IOException exception = null;
        if (newFile.exists()) {
            oldFile.delete();
            newFile.renameTo(oldFile);
            oldFile = new File(name + ".bak");
        }
        if (!oldFile.exists()) {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(name));
            this.saveTo(out, header);
            ((OutputStream)out).close();
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(oldFile)));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(name)));
        try {
            Hashtable clone = (Hashtable)this.clone();
            if (header != null) {
                writer.write("# " + header);
                writer.newLine();
            }
            String line = this.readLine(reader);
            while (line != null) {
                int equalTo;
                if (!(line.equals("") || line.equals("\n") || line.startsWith("#") || (equalTo = line.indexOf("=")) == -1)) {
                    String lhs = line.substring(0, equalTo);
                    String rhs = line.substring(equalTo + 1, line.length());
                    if (lhs != null && rhs != null) {
                        if (this.containsKey(lhs)) {
                            clone.remove(lhs);
                            line = lhs + "=" + (String)this.get(lhs);
                        } else {
                            line = "";
                        }
                    }
                }
                if (line != "") {
                    writer.write(line);
                    writer.newLine();
                }
                line = this.readLine(reader);
                writer.flush();
            }
            Enumeration enm = clone.keys();
            while (enm.hasMoreElements()) {
                String key = (String)enm.nextElement();
                String value = (String)this.get(key);
                writer.write(key + "=" + value);
                writer.newLine();
            }
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception any) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception any) {}
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void delete(ExProperties other) {
        Enumeration<?> propNames = other.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            this.remove(propName);
        }
    }

    public static ExProperties getConfiguration(File configDir) {
        ExProperties newConfig = new ExProperties();
        newConfig.loadDir(configDir);
        return newConfig;
    }

    public static ExProperties getConfiguration(String configDir) {
        return ExProperties.getConfiguration(new File(configDir));
    }

    private String getLine(DataInputStream ds) throws IOException {
        String line = ds.readLine();
        if (line == null) {
            return line;
        }
        if (line.startsWith("#")) {
            return line;
        }
        while (line.endsWith("\\")) {
            String nextLine = ds.readLine();
            if (nextLine == null) {
                return line;
            }
            line = line.substring(0, line.length() - 1) + nextLine.trim();
        }
        return line;
    }

    public ExProperties getMatchingProperties(String propNamePrefix) {
        ExProperties group = new ExProperties();
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(propNamePrefix)) continue;
            group.put(key, this.get(key));
        }
        return group;
    }

    public int getProperty(String key, int def) throws NumberFormatException {
        String v = this.getProperty(key);
        return v != null ? Integer.parseInt(v) : def;
    }

    public long getProperty(String key, long def) throws NumberFormatException {
        String v = this.getProperty(key);
        return v != null ? Long.parseLong(v) : def;
    }

    public boolean getProperty(String key, boolean def) {
        String v = this.getProperty(key);
        return v != null ? v.equals("true") : def;
    }

    public void load(File file) throws IOException {
        this.load(file.getPath());
    }

    public void load(InputStream in) throws IOException {
        this.loadFrom(in);
    }

    public void load(Reader in) throws IOException {
        this.loadFrom(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String name) throws IOException {
        IOException exc = null;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(name));
        try {
            this.load(in);
        }
        catch (IOException e) {
            exc = e;
        }
        finally {
            ((InputStream)in).close();
        }
        if (exc != null) {
            throw exc;
        }
    }

    private void loadDir(File dirName) {
        File[] dirs = new File[]{dirName};
        this.loadDirs(dirs);
    }

    private void loadDirs(File[] configDirs) {
        String m;
        int i;
        String[] propFileNames;
        int idir;
        for (idir = 0; idir < configDirs.length; ++idir) {
            propFileNames = configDirs[idir].list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(ExProperties.PROPFILE_SUFFIX);
                }
            });
            if (propFileNames == null) continue;
            for (i = 0; i < propFileNames.length; ++i) {
                if (!propFileNames[i].equals(DEFAULT_PROPS)) continue;
                this.defaults = new ExProperties();
                try {
                    ((ExProperties)this.defaults).load(new File(configDirs[idir], propFileNames[i]));
                    continue;
                }
                catch (IOException exc) {
                    m = ExProperties.ls().getLocalString("pconf.error3", "Cannot load property file {0} in {1}: {2}", new Object[]{propFileNames[i], configDirs[idir], exc.getMessage()});
                    ErrorMessages.error(m);
                }
            }
        }
        for (idir = 0; idir < configDirs.length; ++idir) {
            propFileNames = configDirs[idir].list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(ExProperties.PROPFILE_SUFFIX);
                }
            });
            if (propFileNames == null) continue;
            for (i = 0; i < propFileNames.length; ++i) {
                if (propFileNames[i].equals(DEFAULT_PROPS)) continue;
                try {
                    this.load(new File(configDirs[idir], propFileNames[i]));
                    continue;
                }
                catch (IOException exc) {
                    m = ExProperties.ls().getLocalString("pconf.error3", "Cannot load property file {0} in {1}: {2}", new Object[]{propFileNames[i], configDirs[idir], exc.getMessage()});
                    ErrorMessages.error(m);
                }
            }
        }
    }

    private void loadFrom(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        this.loadFrom(reader);
    }

    private void loadFrom(Reader in) throws IOException {
        String line = null;
        BufferedReader f = null;
        f = !(in instanceof BufferedReader) ? new BufferedReader(in) : (BufferedReader)in;
        while ((line = this.readLine(f)) != null) {
            this.processLine(line);
        }
    }

    protected static LocalStringManagerImpl ls() {
        if (ls == null) {
            ls = new LocalStringManagerImpl(ExProperties.class);
        }
        return ls;
    }

    public void merge(ExProperties other) {
        Enumeration<?> propNames = other.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            this.put(propName, other.getProperty(propName));
        }
    }

    private void processLine(String line) {
        String lhs = null;
        String rhs = null;
        if (line.startsWith("#")) {
            return;
        }
        int equalTo = line.indexOf("=");
        if (equalTo == -1) {
            return;
        }
        lhs = line.substring(0, equalTo);
        rhs = line.substring(equalTo + 1, line.length());
        if (lhs != null && rhs != null) {
            this.put(lhs, rhs);
        }
    }

    private String readLine(BufferedReader f) throws IOException {
        String line = f.readLine();
        if (line == null) {
            return line;
        }
        if (line.startsWith("#")) {
            return line;
        }
        while (line.endsWith("\\")) {
            String nextLine = f.readLine();
            if (nextLine == null) {
                return line;
            }
            line = line.substring(0, line.length() - 1) + nextLine.trim();
        }
        return line;
    }

    public void replace(ExProperties other) {
        Enumeration<?> propNames = other.propertyNames();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!this.containsKey(propName)) continue;
            this.put(propName, other.getProperty(propName));
        }
    }

    public void save(File file, String header) throws IOException {
        this.save(file.getPath(), header);
    }

    public void save(OutputStream out, String header) {
        this.saveTo(out, header);
    }

    public void save(Writer out, String header) {
        this.saveTo(out, header);
    }

    public void save(String name, String header) throws IOException {
        this.backUpAndSave(name, header);
    }

    private void saveTo(OutputStream out, String header) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(out));
        this.saveTo(pw, header);
    }

    private void saveTo(Writer out, String header) {
        PrintWriter ps = !(out instanceof PrintWriter) ? new PrintWriter(out) : (PrintWriter)out;
        Enumeration<Object> e = this.keys();
        if (header != null) {
            ps.println("# " + header);
        }
        while (e.hasMoreElements()) {
            String lhs = (String)e.nextElement();
            String rhs = (String)this.get(lhs);
            ps.println(lhs + "=" + rhs);
        }
        ps.println();
        ps.flush();
    }

    public void setProperty(String key, int i) {
        this.put(key, String.valueOf(i));
    }

    public void setProperty(String key, long l) {
        this.put(key, String.valueOf(l));
    }

    public Object setProperty(String key, String s) {
        return this.put(key, s);
    }

    public void setProperty(String key, boolean b) {
        this.put(key, b ? "true" : "false");
    }
}

