/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.sql.SQLException;
import oracle.aurora.memoryManager.Callback;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.ReadOnlySchema;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.vm.Id;
import oracle.aurora.vm.IdManager;
import oracle.aurora.vm.IdNotFoundException;
import oracle.sql.CHAR;

public final class SystemSchema
extends ReadOnlySchema
implements Callback,
IdManager {
    SystemSchema() {
        this.ownerNumberField = 0;
    }

    public void act(Object obj) {
        SystemSchema.clearCachedSchemaRoles();
    }

    public boolean hasRole(Schema role) {
        return true;
    }

    public CHAR name() {
        if (systemCharName == null) {
            systemCharName = SystemSchema.lookupName(0, false, true, false, null);
        }
        return systemCharName;
    }

    public String toString() {
        if (systemStringName == null) {
            systemStringName = this.name().toString();
        }
        return systemStringName;
    }

    public Id getId(String name) throws IdNotFoundException {
        try {
            return this.getId(new CHAR(name, CHAR.DEFAULT_CHARSET));
        }
        catch (SQLException ex) {
            throw new IdNotFoundException(name);
        }
    }

    public Id getId(CHAR name) throws IdNotFoundException {
        Schema result = null;
        int ownerNumber = Schema.lookupOwnerNumber(name, true, false, false, null);
        if (ownerNumber >= 0) {
            result = Schema.get(ownerNumber);
            Schema s = new Schema(name, ownerNumber);
            s.intern();
            result = s;
        }
        if (result == null) {
            throw new IdNotFoundException(name.toString() + " : user or role id does not exist");
        }
        return result;
    }

    public Id getId(long ownerNumberL) throws IdNotFoundException {
        CHAR name;
        Schema result = null;
        int ownerNumber = (int)ownerNumberL;
        if (ownerNumber >= 0 && (result = Schema.get(ownerNumber)) == null && (name = Schema.lookupName(ownerNumber, true, true, false, null)) != null) {
            Schema s = new Schema(name, ownerNumber);
            s.intern();
            result = s;
        }
        if (result == null) {
            throw new IdNotFoundException(ownerNumber + " user or role id does not exist");
        }
        return result;
    }

    public Id owner(Class clazz) throws IdNotFoundException {
        ClassHandle h = ClassHandle.lookup(clazz);
        if (h == null) {
            throw new IdNotFoundException(clazz + " not loaded from a schema ");
        }
        return h.schema();
    }

    public Id currentId() {
        return Schema.currentSchema();
    }

    public Id invalidId() {
        return Schema.noSchema;
    }
}

