/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.util.Hashtable;
import oracle.aurora.compiler.ExternalEntity;
import oracle.aurora.compiler.FinderFactory;
import oracle.aurora.compiler.MemoizedFinderFactory;
import oracle.aurora.compiler.QName;

public class CacheUsingFinders {
    FinderFactory factory;
    Hashtable forwardTable = new Hashtable();
    Hashtable simpleTable = new Hashtable();
    boolean distinguishOnKind;

    public CacheUsingFinders(FinderFactory factory) {
        this(factory, false);
    }

    public CacheUsingFinders(FinderFactory factory, boolean distinguishOnKind) {
        this.distinguishOnKind = distinguishOnKind;
        this.factory = factory;
        if (!(this.factory instanceof MemoizedFinderFactory)) {
            this.factory = new MemoizedFinderFactory(this.factory);
        }
    }

    public Object get(ExternalEntity refFrom, QName name) {
        return this.get(refFrom, name, -1);
    }

    public Object get(ExternalEntity refFrom, QName name, int kind) {
        return this.get(new Key(refFrom, name, kind));
    }

    public void put(ExternalEntity refFrom, QName name, Object obj) {
        this.put(new Key(refFrom, name, -1), obj);
    }

    public void put(ExternalEntity refFrom, QName name, int kind, Object obj) {
        this.put(new Key(refFrom, name, kind), obj);
    }

    public Object get(ExternalEntity entity) {
        Object result = this.simpleTable.get(entity);
        return result;
    }

    protected Object get(Key key) {
        Object result = this.forwardTable.get(key);
        return result;
    }

    protected void put(Key key, Object obj) {
        this.forwardTable.put(key, obj);
        ExternalEntity entity = key.found;
        if (entity != null && this.simpleTable.get(entity) == null) {
            this.simpleTable.put(entity, obj);
        }
    }

    class Key {
        ExternalEntity found;
        QName name;
        int kind;

        Key(ExternalEntity refFrom, QName name, int kind) {
            this.name = name;
            this.found = kind >= 0 ? CacheUsingFinders.this.factory.finder(refFrom).find(name, kind) : CacheUsingFinders.this.factory.finder(refFrom).find(name);
            this.kind = CacheUsingFinders.this.distinguishOnKind ? kind : 0;
        }

        public int hashCode() {
            int h = this.name.hashCode() + this.kind;
            if (this.found != null) {
                h += this.found.hashCode();
            }
            return h;
        }

        public boolean equals(Object other) {
            boolean eq = false;
            if (other instanceof Key) {
                Key otherKey = (Key)other;
                boolean bl = eq = this.name.equals(otherKey.name) && this.kind == otherKey.kind;
                if (this.found != null && eq) {
                    eq = this.found.equals(otherKey.found);
                }
            }
            return eq;
        }

        public String toString() {
            return "Key(" + this.name + "," + this.kind + "," + this.found + ")";
        }
    }
}

