/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.executors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.DataPumpQuery;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.commands.CSCommon;
import oracle.dbtools.common.DataPumpArguments;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleDbDirectoryLocation;

public class DataPumpTransfer {
    private static final String NL = "\n";
    private DataPumpModel _model;
    private DataPumpArguments _args;

    public DataPumpTransfer(DataPumpModel model) {
        this._model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean transferFromCloud() throws ProcessFailedException {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(DataPumpResources.getString("DP_TRANS"));
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
                return false;
            }
        }
        int i = 0;
        boolean copyFailed = false;
        this._args = this._model.getArgs();
        List fileNames = (List)this._args.get("dumpfile");
        List uris = (List)this._args.get("dumpuri");
        try {
            for (String fileName : fileNames) {
                String tgt = this._args.get("dumpdirectory") + "/" + fileName;
                String src = (String)uris.get(i);
                this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_TRANSFER", src, tgt));
                if (!this._model.ToolLoggerFlushLog()) {
                    this._model.isValid(false);
                    boolean bl = false;
                    return bl;
                }
                CloudStorageUrl csFinalUrl = new CloudStorageUrl(src);
                this._args.put("cloud_url", csFinalUrl);
                Location srcLocation = CSCommon.getOciLocation((Map)this._args);
                OracleDbDirectoryLocation tgtLocation = CSCommon.getDbDirectoryLocation((Connection)this._model.getConn());
                srcLocation.connect();
                try (BufferedInputStream is = new BufferedInputStream(srcLocation.asInputStream(null, 0L, 0L));){
                    tgtLocation.connect();
                    tgtLocation.copy((InputStream)is, tgt);
                    this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPIED", tgt, src) + NL);
                }
                catch (IOException e) {
                    this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", tgt, src) + NL);
                    if (!this._model.ToolLoggerFlushLog()) {
                        this._model.isValid(false);
                        boolean bl = false;
                        if (this._model.isVerbose() || this._model.isDebug()) {
                            this._model.getToolLogger().logProcessEnd();
                        }
                        if (!this._model.ToolLoggerFlushLog()) {
                            this._model.isValid(false);
                            return false;
                        }
                        return bl;
                    }
                    try {
                        throw new ProcessFailedException(e, DataPumpResources.getString("DP_TRANS"));
                    }
                    catch (IOException e2) {
                        this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", tgt, src) + NL);
                        if (!this._model.ToolLoggerFlushLog()) {
                            this._model.isValid(false);
                            boolean bl = false;
                            return bl;
                        }
                        throw new ProcessFailedException(e2, DataPumpResources.getString("DP_TRANS"));
                    }
                }
                ++i;
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (this._model.isVerbose() || this._model.isDebug()) {
                this._model.getToolLogger().logProcessEnd();
            }
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
                return false;
            }
        }
        return this._model.isValid();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean transferToCloud() throws ProcessFailedException {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(DataPumpResources.getString("DP_TRANS"));
        }
        int i = 0;
        boolean copyFailed = false;
        this._args = this._model.getArgs();
        List origFileNames = (List)this._args.get("dumpfile");
        List origUris = (List)this._args.get("dumpuri");
        List<String> usedFileNames = null;
        try {
            usedFileNames = this.readUsedFileNames();
        }
        catch (SQLException e) {
            throw new ProcessFailedException(e, DataPumpResources.getString("DP_TRANS"));
        }
        List<String> fileNames = this.substituteVariablesInFilenames(origFileNames, usedFileNames);
        List<String> uris = this.substituteVariablesInFilenames(origUris, usedFileNames);
        for (String fileName : fileNames) {
            block24: {
                String src = this._args.get("dumpdirectory") + "/" + fileName;
                Path srcPath = new File(src).toPath();
                String tgt = uris.get(i);
                this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_TRANSFER", src, tgt));
                if (!this._model.ToolLoggerFlushLog()) {
                    this._model.isValid(false);
                    return false;
                }
                try {
                    CloudStorageUrl csFinalUrl = new CloudStorageUrl(tgt);
                    this._args.put("cloud_url", csFinalUrl);
                    Location tgtLocation = CSCommon.getOciLocation((Map)this._model.getArgs());
                    OracleDbDirectoryLocation srcLocation = CSCommon.getDbDirectoryLocation((Connection)this._model.getConn());
                    try (BufferedInputStream is = new BufferedInputStream(srcLocation.asInputStream(srcPath, -1L, -1L));){
                        if (tgtLocation != null) {
                            tgtLocation.connect();
                            tgtLocation.copy((InputStream)is, null);
                            this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPIED", tgt, src) + NL);
                            if (!this._model.ToolLoggerFlushLog()) {
                                this._model.isValid(false);
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    catch (IOException se) {
                        copyFailed = true;
                        this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", src, tgt) + NL);
                        if (!this._model.ToolLoggerFlushLog()) {
                            this._model.isValid(false);
                            return false;
                        }
                    }
                }
                catch (IOException se) {
                    copyFailed = true;
                    this._model.getToolLogger().log(DataPumpResources.format("DPTRANS_COPY_FAILED", src, tgt) + NL);
                    if (this._model.ToolLoggerFlushLog()) break block24;
                    this._model.isValid(false);
                    return false;
                }
            }
            ++i;
        }
        try {
            if (!copyFailed) return this._model.isValid();
            if (i >= true) return this._model.isValid();
            this._model.isValid(false);
            throw new IOException(DataPumpResources.getString("DPTRANS_COPY_ERROR") + NL);
        }
        catch (IOException e) {
            throw new ProcessFailedException(e, DataPumpResources.getString("DP_TRANS"));
        }
        finally {
            if (this._model.isVerbose() || this._model.isDebug()) {
                this._model.getToolLogger().logProcessEnd();
            }
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
                return false;
            }
        }
    }

    private void doDebug(String msg) {
        if (this._model.isDebug()) {
            this._model.getToolLogger().log(msg);
        }
    }

    private List<String> substituteVariablesInFilenames(List<String> fileNames, List<String> usedFileNames) {
        ArrayList<String> result = new ArrayList<String>();
        block0: for (String fileName : fileNames) {
            int maxIterations = 1;
            if (fileName.contains("%L") || fileName.contains("%L")) {
                maxIterations = Integer.MAX_VALUE;
            } else if (fileName.contains("%U") || fileName.contains("%u")) {
                maxIterations = 99;
            }
            for (int i = 1; i <= maxIterations; ++i) {
                String name = fileName;
                String num = String.format("%02d", i);
                name = name.replaceAll("%U", num).replaceAll("%u", num);
                name = name.replaceAll("%L", num).replaceAll("%l", num);
                LocalDate now = LocalDate.now();
                String day = String.format("%02d", now.getDayOfMonth());
                name = name.replaceAll("%D", day).replaceAll("%d", day);
                String month = String.format("%02d", now.getMonthValue());
                name = name.replaceAll("%M", month).replaceAll("%m", month);
                String year = String.format("%04d", now.getYear());
                name = name.replaceAll("%Y", year).replaceAll("%y", year);
                String time = year + month + day;
                name = name.replaceAll("%T", time).replaceAll("%t", time);
                boolean found = false;
                for (String usedFileName : usedFileNames) {
                    if (!name.endsWith(usedFileName)) continue;
                    result.add(name);
                    found = true;
                }
                if (!found) continue block0;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readUsedFileNames() throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        Connection conn = this._model.getConn();
        String jobName = this._args.getString("jobname");
        String query = DataPumpQuery.getQuery("datapumpUsedFileNames", this._model.getConn());
        if (query != null) {
            query = query.replace("<JOBNAME>", jobName);
        }
        boolean amILocked = false;
        try {
            amILocked = LockManager.lock((Connection)conn);
            if (amILocked) {
                DBUtil dbUtil = DBUtil.getInstance((Connection)this._model.getConn());
                List rtn = dbUtil.executeReturnListofList(query, null);
                for (int i = 1; i < rtn.size(); ++i) {
                    result.add((String)((List)rtn.get(i)).get(0));
                }
                SQLException e = dbUtil.getLastException();
                if (e != null) {
                    throw e;
                }
            }
        }
        catch (SQLException e) {
            this.doDebugDisplay(e.getLocalizedMessage());
        }
        finally {
            if (amILocked) {
                try {
                    LockManager.unlock((Connection)conn);
                }
                catch (Exception exception) {}
            }
            if (!this._model.ToolLoggerFlushLog()) {
                this._model.isValid(false);
            }
        }
        return result;
    }

    private void doDebugDisplay(String msg) {
        this._model.getToolLogger().log(DataPumpResources.format("DPEXEC_INFORMATIONAL_MESSAGE", msg));
    }
}

