/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeDeferringRoot;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.DTreeMultipleSelectionManager;
import oracle.bali.ewt.dTree.DTreeRootItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.tree.TopicTreeListener;
import oracle.help.java.tree.TopicTreeModel;
import oracle.help.java.tree.TopicTreePane;
import oracle.help.library.Library;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.favoritesNavigator.FavoriteBranchItem;
import oracle.help.navigator.favoritesNavigator.FavoriteItemFactory;
import oracle.help.navigator.favoritesNavigator.FavoriteLeafItem;
import oracle.help.navigator.favoritesNavigator.FavoritesActionUtils;
import oracle.help.navigator.favoritesNavigator.FavoritesModel;
import oracle.help.navigator.favoritesNavigator.FavoritesNavigator;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevHelpSystemImpl;
import oracle.jdevimpl.help.JDevNavigator;

public final class JDevFavoritesNavigator
extends FavoritesNavigator
implements JDevNavigator {
    private HelpWindow _helpWindow;
    private IdeAction _addExternalURLAction;
    private IdeAction _newFavoriteFolderAction;
    private IdeAction _renameFavoriteAction;
    private IdeAction _deleteFavoriteAction;
    private HelpNavigatorToolbar _toolbar;
    private DummyView _dummyView = new DummyView();
    private TopicTreeComponent _topicTreeComponent;
    private FocusTraversalPolicy _focusTraversalPolicy;
    private static FavoritesModel _favoritesModel;
    private static final int ADD_EXTERNAL_URL_CMD_ID;
    private static final int NEW_FAVORITES_FOLDER_CMD_ID;
    private static final int RENAME_FAVORITE_CMD_ID;
    private static final int DELETE_FAVORITE_CMD_ID;

    public JDevFavoritesNavigator(HelpWindow helpWindow, Library library, String label) throws NavigatorException {
        HelpSystem helpSys;
        this._helpWindow = helpWindow;
        this.label = label;
        this.labelImage = null;
        this.library = library;
        this.filterByLabel = true;
        this.type = "oracle.jdevimpl.help.JDevFavoritesNavigator";
        oracle.help.common.View[] initialViews = null;
        int iter = 0;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            initialViews = this.filterViewsByLabel(library.getAllViews(), label);
            if (initialViews != null) {
                for (iter = 0; iter < initialViews.length; ++iter) {
                    this.views.add(initialViews[iter]);
                }
            }
        }
        if ((helpSys = HelpSystem.getHelpSystem()) != null && helpSys instanceof JDevHelpSystemImpl) {
            _favoritesModel = ((JDevHelpSystemImpl)helpSys).getFavoritesModel();
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_favsnav_html");
        this.initNavigator(initialViews);
    }

    @Override
    public Toolbar getToolbar() {
        return this._toolbar;
    }

    @Override
    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this._focusTraversalPolicy;
    }

    @Override
    public void setActive(boolean active) {
        if (this._toolbar != null) {
            this._toolbar.setActiveToolbar(active);
        }
        HelpUtils.setNavigatorBorderActive(this, active);
    }

    protected void doInitializationNow() {
        super.doInitializationNow();
        this.setItemFactory();
        Component[] comps = this.getComponents();
        if (comps != null) {
            for (Component comp : comps) {
                if (!(comp instanceof TopicTreePane)) continue;
                ((TopicTreePane)comp).setBorder(BorderFactory.createEmptyBorder());
                this._topicTreeComponent = ((TopicTreePane)comp).getTopicTreeComponent();
                this._topicTreeComponent.setSelectionManager((DTreeSelectionManager)new DTreeMultipleSelectionManager());
                KeyStroke stroke = KeyStroke.getKeyStroke(127, 0);
                ActionMap actionMap = this._topicTreeComponent.getActionMap();
                InputMap inputMap = this._topicTreeComponent.getInputMap(1);
                actionMap.put(DELETE_FAVORITE_CMD_ID, (Action)this.getDeleteFavoriteAction());
                inputMap.put(stroke, DELETE_FAVORITE_CMD_ID);
                this.remove(comp);
                this.add(comp, "Center");
                break;
            }
        }
        this._toolbar = new HelpNavigatorToolbar();
        ToolButton btn = new ToolButton((Action)this.getNewFavoriteFolderAction());
        btn.setFocusable(true);
        this._toolbar.add((Component)btn);
        btn = new ToolButton((Action)this.getAddExternalAction());
        btn.setFocusable(true);
        this._toolbar.add((Component)btn);
        btn = new ToolButton((Action)this.getDeleteFavoriteAction());
        btn.setFocusable(true);
        this._toolbar.add((Component)btn);
        this.add((Component)((Object)this._toolbar), "North");
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addTopicTreeListener(new JDevFavoritesListener());
        this._focusTraversalPolicy = new LayoutFocusTraversalPolicy();
    }

    private void setItemFactory() {
        Component[] comps;
        for (Component c : comps = this.getComponents()) {
            if (!(c instanceof TopicTreePane)) continue;
            TopicTreePane ttp = (TopicTreePane)c;
            TopicTreeComponent ttc = ttp.getTopicTreeComponent();
            DTreeDeferringRoot root = (DTreeDeferringRoot)ttc.getRoot();
            String label = root.getLabel();
            Icon icon = root.getIcon();
            OneDModel model = root.getModel();
            JDevFavoritesItemFactory factory = new JDevFavoritesItemFactory(this.getFavoritesModel());
            DTreeDeferringRoot newRoot = new DTreeDeferringRoot(label, icon, model, (DTreeItemFactory)factory);
            ttc.setRoot((DTreeRootItem)newRoot);
        }
    }

    boolean hasSingleSelection() {
        DTreeSelection dtreeSelection = this._topicTreeComponent.getSelection();
        return dtreeSelection != null && dtreeSelection.getItemCount() == 1;
    }

    IdeAction getAddExternalAction() {
        if (this._addExternalURLAction == null) {
            String label = HelpArb.getString(58);
            this._addExternalURLAction = IdeAction.get((int)ADD_EXTERNAL_URL_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), (Icon)OracleIcons.getIcon((String)"addexternalfavorite.png"), null, (boolean)true);
            this._addExternalURLAction.addController(new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    JPanel panel = new JPanel();
                    panel.setLayout(new GridBagLayout());
                    GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0);
                    JLabel label = new JLabel();
                    final JTextField nameField = new JTextField(50);
                    ResourceUtils.resLabel((JLabel)label, (Component)nameField, (String)HelpArb.getString(60));
                    panel.add((Component)label, gbc);
                    ++gbc.gridy;
                    panel.add((Component)nameField, gbc);
                    HelpSystem helpSystem = HelpSystem.getHelpSystem();
                    helpSystem.registerTopic((JComponent)panel, "f1_idedaddexternallink_html");
                    ++gbc.gridy;
                    label = new JLabel();
                    final URLTextField urlField = new URLTextField();
                    urlField.setDirectoryOnly(false);
                    ResourceUtils.resLabel((JLabel)label, (Component)urlField, (String)HelpArb.getString(61));
                    panel.add((Component)label, gbc);
                    ++gbc.gridy;
                    panel.add((Component)urlField, gbc);
                    TopicTreeNode rootTopicTreeNode = _favoritesModel.getFavoritesRoot().getParent();
                    TopicTreeComponent tree = new TopicTreeComponent(rootTopicTreeNode, (DTreeItemFactory)new FavoriteItemFactory(_favoritesModel));
                    tree.setPreferredItemsOnScreen(5);
                    TopicTreePane treePane = new TopicTreePane(tree);
                    tree.selectTopicTreeNode(rootTopicTreeNode);
                    label = new JLabel();
                    ResourceUtils.resLabel((JLabel)label, (Component)tree, (String)HelpArb.getString(62));
                    ++gbc.gridy;
                    panel.add((Component)label, gbc);
                    ++gbc.gridy;
                    gbc.gridheight = 4;
                    gbc.weighty = 1.0;
                    panel.add((Component)treePane, gbc);
                    Window window = HelpCenterWindow.getInstance().getWindow();
                    final JEWTDialog dlg = window instanceof JDialog ? new JEWTDialog((Dialog)((JDialog)window), HelpArb.getString(59), 3) : new JEWTDialog((Frame)((JFrame)window), HelpArb.getString(59), 3);
                    dlg.setContent((Component)panel);
                    dlg.setInitialFocus((Component)nameField);
                    dlg.setDefaultButton(1);
                    treePane.addTopicTreeListener(new TopicTreeListener(){

                        public void topicActivated(TopicTreeItem item, boolean newWindow) {
                        }

                        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
                        }

                        public void topicSelected(TopicTreeItem item) {
                            dlg.setOKButtonEnabled(item != null && HelpUtils.isFolderNode(item.getTopicTreeNode()));
                        }
                    });
                    dlg.addVetoableChangeListener(new VetoableChangeListener(){

                        @Override
                        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                                if (!ModelUtil.hasLength((String)nameField.getText()) || !ModelUtil.hasLength((String)urlField.getText())) {
                                    JOptionPane.showMessageDialog((Component)dlg, HelpArb.getString(64), HelpArb.getString(63), 0);
                                    throw new PropertyVetoException("no", evt);
                                }
                                Object urlText = urlField.getText();
                                if (!((String)urlText).startsWith("http") && !((String)urlText).startsWith("file")) {
                                    urlText = "http://" + (String)urlText;
                                    urlField.setText((String)urlText);
                                }
                                if (urlField.getURL() == null) {
                                    JOptionPane.showMessageDialog((Component)dlg, HelpArb.getString(65), HelpArb.getString(63), 0);
                                    throw new PropertyVetoException("no", evt);
                                }
                                boolean isValid = false;
                                try {
                                    isValid = URLFileSystem.canRead((URL)urlField.getURL());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (!isValid) {
                                    JOptionPane.showMessageDialog((Component)dlg, HelpArb.getString(65), HelpArb.getString(63), 0);
                                    throw new PropertyVetoException("no", evt);
                                }
                            }
                        }
                    });
                    if (WizardLauncher.runDialog((JDialog)dlg)) {
                        TopicTreeNode parentNode = null;
                        TopicTreeItem selectedItem = treePane.getSelectedItem();
                        if (selectedItem != null) {
                            parentNode = selectedItem.getTopicTreeNode();
                        }
                        _favoritesModel.addFavoriteItem(nameField.getText(), null, null, urlField.getText(), parentNode);
                    }
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    action.setEnabled(true);
                    return true;
                }
            });
        }
        return this._addExternalURLAction;
    }

    IdeAction getRenameFavoriteAction() {
        if (this._renameFavoriteAction == null) {
            String label = HelpArb.getString(40);
            this._renameFavoriteAction = IdeAction.get((int)RENAME_FAVORITE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
            this._renameFavoriteAction = IdeAction.newLocalAction((int)RENAME_FAVORITE_CMD_ID, (View)this._dummyView);
            this._renameFavoriteAction.addController(new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    if (_favoritesModel != null) {
                        MyWindowListener l = new MyWindowListener("f1_idedrenamefavorites_html");
                        Toolkit.getDefaultToolkit().addAWTEventListener(l, 64L);
                        FavoritesActionUtils.renameFavoriteItem((Component)((Object)JDevFavoritesNavigator.this), (TopicTreeNode)JDevFavoritesNavigator.this.getCurrentSelectionNode(), (FavoritesModel)_favoritesModel);
                    }
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    if (JDevFavoritesNavigator.this.hasSingleSelection()) {
                        action.setEnabled(true);
                    } else {
                        action.setEnabled(false);
                    }
                    return true;
                }
            });
        }
        return this._renameFavoriteAction;
    }

    IdeAction getNewFavoriteFolderAction() {
        if (this._newFavoriteFolderAction == null) {
            String label = HelpArb.getString(39);
            this._newFavoriteFolderAction = IdeAction.get((int)NEW_FAVORITES_FOLDER_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), (Icon)OracleIcons.getIcon((String)"folderNew.png"), null, (boolean)true);
            this._newFavoriteFolderAction = IdeAction.newLocalAction((int)NEW_FAVORITES_FOLDER_CMD_ID, (View)this._dummyView);
            this._newFavoriteFolderAction.addController(new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    if (_favoritesModel != null) {
                        TopicTreeNode node = JDevFavoritesNavigator.this.getCurrentSelectionNode();
                        MyWindowListener l = new MyWindowListener("f1_idednewfolderfavorites_html");
                        Toolkit.getDefaultToolkit().addAWTEventListener(l, 64L);
                        FavoritesActionUtils.createNewFolder((Component)((Object)JDevFavoritesNavigator.this), (TopicTreeNode)node, (FavoritesModel)_favoritesModel);
                        if (node != null && node.getClientData() != null) {
                            DTreeItem item = (DTreeItem)node.getClientData();
                            item.setExpanded(true);
                            ArrayList arrayList = node.getChildren();
                            try {
                                TopicTreeNode newNode = (TopicTreeNode)arrayList.get(arrayList.size() - 1);
                                JDevFavoritesNavigator.this._topicTreeComponent.selectTopicTreeNode(newNode);
                            }
                            catch (NullPointerException npe) {
                                JDevFavoritesNavigator.this._topicTreeComponent.selectTopicTreeNode(node);
                            }
                            catch (ArrayIndexOutOfBoundsException aex) {
                                JDevFavoritesNavigator.this._topicTreeComponent.selectTopicTreeNode(node);
                            }
                        }
                    }
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    if (_favoritesModel != null) {
                        TopicTreeNode node = JDevFavoritesNavigator.this.getCurrentSelectionNode();
                        action.setEnabled(node != null && HelpUtils.isFolderNode(node));
                    }
                    return true;
                }
            });
        }
        return this._newFavoriteFolderAction;
    }

    IdeAction getDeleteFavoriteAction() {
        if (this._deleteFavoriteAction == null) {
            String label = HelpArb.getString(41);
            this._deleteFavoriteAction = IdeAction.get((int)DELETE_FAVORITE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), (Icon)OracleIcons.getIcon((String)"delete.png"), null, (boolean)true);
            this._deleteFavoriteAction = IdeAction.newLocalAction((int)DELETE_FAVORITE_CMD_ID, (View)this._dummyView);
            this._deleteFavoriteAction.addController(new Controller(){

                public boolean handleEvent(IdeAction action, Context context) {
                    DTreeSelection dtreeSelection = JDevFavoritesNavigator.this._topicTreeComponent.getSelection();
                    if (dtreeSelection != null && dtreeSelection.getItemCount() > 0) {
                        DTreeItem[] selItems;
                        for (DTreeItem item : selItems = dtreeSelection.getItems()) {
                            TopicTreeNode rootNode;
                            TopicTreeNode ttnode;
                            if (!(item instanceof TopicTreeItem) || (ttnode = ((TopicTreeItem)item).getTopicTreeNode()) == (rootNode = _favoritesModel.getFavoritesRoot())) continue;
                            _favoritesModel.removeFavoriteItem(ttnode);
                        }
                    }
                    return true;
                }

                public boolean update(IdeAction action, Context context) {
                    TopicTreeNode treeNode = JDevFavoritesNavigator.this.getCurrentSelectionNode();
                    TopicTreeNode rootNode = _favoritesModel.getFavoritesRoot();
                    action.setEnabled(treeNode != null && treeNode != rootNode);
                    return true;
                }
            });
        }
        return this._deleteFavoriteAction;
    }

    static {
        ADD_EXTERNAL_URL_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.JDevFavoritesNavigator.AddExternalLinkAsFavoriteCmd");
        NEW_FAVORITES_FOLDER_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.NewFavoritesFolderCmd");
        RENAME_FAVORITE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.RenameFavoriteCmd");
        DELETE_FAVORITE_CMD_ID = Ide.findOrCreateCmdID((String)"oracle.jdevimpl.help.HelpWindow.DeleteFavoriteCmd");
    }

    private class DummyView
    extends View {
        private DummyView() {
        }

        public Component getGUI() {
            return null;
        }
    }

    private class JDevFavoritesListener
    implements TopicTreeListener {
        private JDevFavoritesListener() {
        }

        public void topicActivated(TopicTreeItem item, boolean newWindow) {
        }

        public void topicSelected(TopicTreeItem item) {
            JDevFavoritesNavigator.this._deleteFavoriteAction.updateAction();
            JDevFavoritesNavigator.this._addExternalURLAction.updateAction();
            JDevFavoritesNavigator.this._newFavoriteFolderAction.updateAction();
        }

        public void popupDisplayed(TopicTreeItem item, JPopupMenu popup) {
            int compCount = popup.getComponentCount();
            for (int i = 0; i < compCount; ++i) {
                popup.remove(0);
            }
            JDevFavoritesNavigator.this._helpWindow.addMenuItems(popup, item.getTopic());
            popup.addSeparator();
            ContextMenu cm = new ContextMenu();
            JMenuItem menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getNewFavoriteFolderAction());
            popup.add(menuItem);
            menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getAddExternalAction());
            popup.add(menuItem);
            popup.addSeparator();
            menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getRenameFavoriteAction());
            popup.add(menuItem);
            JDevFavoritesNavigator.this.getRenameFavoriteAction().updateAction(new Context());
            menuItem = cm.createMenuItem((ToggleAction)JDevFavoritesNavigator.this.getDeleteFavoriteAction());
            popup.add(menuItem);
        }
    }

    private static final class JDevFavoritesItemFactory
    extends FavoriteItemFactory {
        private FavoritesModel _model;

        public JDevFavoritesItemFactory(FavoritesModel model) {
            super(model);
            this._model = model;
        }

        public DTreeItem createItem(DTreeDeferringParent parent, int index) {
            OneDModel src = parent.getModel();
            TopicTreeNode node = (TopicTreeNode)src.getData(index);
            JDevFavoriteLeafItem item = null;
            if (node == null) {
                return null;
            }
            item = node.isBranch() || !node.getTopic().hasTarget() ? new FavoriteBranchItem((OneDModel)new TopicTreeModel(node), (DTreeItemFactory)this, this._model) : new JDevFavoriteLeafItem(this._model);
            node.setClientData((Object)item);
            return item;
        }

        private static final class JDevFavoriteLeafItem
        extends FavoriteLeafItem {
            public JDevFavoriteLeafItem(FavoritesModel model) {
                super(model);
            }

            public Icon getIcon() {
                Icon icon = null;
                Topic topic = this.getTopic();
                if (topic != null && topic.hasTarget() && topic.getTarget() instanceof SimpleURLTarget) {
                    SimpleURLTarget urlTarget = (SimpleURLTarget)topic.getTarget();
                    try {
                        if (urlTarget.getURL().getProtocol().startsWith("http")) {
                            icon = HelpArb.getIcon(45);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                if (icon != null) {
                    return icon;
                }
                return OracleIcons.getIcon((String)"file.png");
            }
        }
    }

    private static final class MyWindowListener
    implements AWTEventListener {
        private String _helpId;

        public MyWindowListener(String helpId) {
            this._helpId = helpId;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 200) {
                Component comp;
                Object obj = event.getSource();
                if (obj instanceof JEWTDialog && (comp = ((JEWTDialog)obj).getContent()) instanceof JComponent) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)comp, this._helpId);
                }
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            }
        }
    }
}

