/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.IdeHook;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.Pair;

public final class HelpHook
extends IdeHook {
    public static final ElementName ELEMENT = HelpHook.element((String)"help");
    private static final ElementName ITEM = HelpHook.element((String)"item");
    private static final ElementName HELP_NAME = HelpHook.element((String)"helpName");
    private static final ElementName HELP_ACTION = HelpHook.element((String)"helpAction");
    private static final ElementName HELP_URL = HelpHook.element((String)"helpURL");
    private static final ElementName RELATIVE_TO = HelpHook.element((String)"relativeTo");
    private static final ElementName RELATIVE_POSITION = HelpHook.element((String)"relativePosition");
    private static final ElementName BROWSESYMBOL_RESOLVER = HelpHook.element((String)"browseSymbolResolver-class");
    private static final ElementName BOOK = HelpHook.element((String)"book");
    private static final ElementName BOOK_TITLE = HelpHook.element((String)"title");
    private static final ElementName BOOK_LABEL = HelpHook.element((String)"viewLabel");
    private static final ElementName CALLBACK_WIZARD_HANDLER = HelpHook.element((String)"callbackWizardHandler-class");
    private static final String KEY_HELP_ITEM = "help-item";
    private static final String KEY_BOOK_PAIR = "book-pair";
    private static final String BEFORE = "before";
    private static final String REMOVE_ACTION = "remove";
    private final List _helpEntries = new ArrayList();
    private final List _browseSymbolResolverEntries = new ArrayList();
    private final List _callbackWizardHandlerEntries = new ArrayList();
    private final ElementVisitor _item = new ItemHandler();
    private final ElementVisitor _helpName = new HelpNameHandler();
    private final ElementVisitor _helpAction = new HelpActionHandler();
    private final ElementVisitor _helpURL = new HelpURLHandler();
    private final ElementVisitor _relativeTo = new RelativeToHandler();
    private final ElementVisitor _relativePosition = new RelativePositionHandler();
    private final ElementVisitor _browseSymbolResolver = new BrowseSymbolResolverHandler();
    private final ElementVisitor _book = new BookHandler();
    private final ElementVisitor _bookTitle = new BookTitleHandler();
    private final ElementVisitor _bookLabel = new BookLabelHandler();
    private final ElementVisitor _callbackWizardHandlerVisitor = new CallbackWizardHandlerVisitor();

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ITEM, this._item);
    }

    private static String[] splitJarPath(String path) {
        String[] parts = new String[2];
        int jarBangPos = path.toLowerCase().indexOf(".jar!");
        if (jarBangPos == -1) {
            parts[0] = path;
            parts[1] = null;
        } else {
            parts[0] = path.substring(0, jarBangPos + 4);
            parts[1] = path.substring(jarBangPos + 6);
        }
        return parts;
    }

    private URL getHelpURL(ElementContext context, String value) {
        try {
            String[] parts = HelpHook.splitJarPath(value);
            URI absURI = this.resolvePath(context, parts[0]);
            if (absURI != null) {
                URL absURL = VirtualFileSystem.getVirtualFileSystem().toURL(absURI);
                if (parts[1] == null) {
                    return absURL;
                }
                return URLFactory.newJarURL((URL)absURL, (String)parts[1]);
            }
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
        }
        return null;
    }

    private HelpObject getHelp(ElementContext context) {
        return (HelpObject)context.getScopeData().get(KEY_HELP_ITEM);
    }

    private Pair getBookPair(ElementContext context) {
        return (Pair)context.getScopeData().get(KEY_BOOK_PAIR);
    }

    void registerHelpSetJars(HelpSystem helpSystem) {
        for (HelpObject help : this._helpEntries) {
            helpSystem.registerHelpSetURL(help.getHelpName(), help.getHelpAction(), help.getHelpURL(), help.getRelativeTo(), help.getRelativePosition(), help.getBookMap());
        }
        this._helpEntries.clear();
    }

    void registerBrowseSymbolResolvers(List list) {
        list.addAll(this._browseSymbolResolverEntries);
        this._browseSymbolResolverEntries.clear();
    }

    void registerCallbackWizardHandlers(List list) {
        list.addAll(this._callbackWizardHandlerEntries);
        this._callbackWizardHandlerEntries.clear();
    }

    private final class ItemHandler
    extends ElementVisitor {
        private ItemHandler() {
        }

        public void start(ElementStartContext context) {
            context.getScopeData().put(HelpHook.KEY_HELP_ITEM, new HelpObject());
            context.registerChildVisitor(HELP_NAME, HelpHook.this._helpName);
            context.registerChildVisitor(HELP_ACTION, HelpHook.this._helpAction);
            context.registerChildVisitor(HELP_URL, HelpHook.this._helpURL);
            context.registerChildVisitor(RELATIVE_TO, HelpHook.this._relativeTo);
            context.registerChildVisitor(RELATIVE_POSITION, HelpHook.this._relativePosition);
            context.registerChildVisitor(BROWSESYMBOL_RESOLVER, HelpHook.this._browseSymbolResolver);
            context.registerChildVisitor(BOOK, HelpHook.this._book);
            context.registerChildVisitor(CALLBACK_WIZARD_HANDLER, HelpHook.this._callbackWizardHandlerVisitor);
        }

        public void end(ElementEndContext context) {
            HelpHook.this._helpEntries.add(HelpHook.this.getHelp((ElementContext)context));
        }
    }

    private final class HelpNameHandler
    extends ElementVisitor {
        private HelpNameHandler() {
        }

        public void end(ElementEndContext context) {
            HelpHook.this.getHelp((ElementContext)context).setHelpName(context.getText().trim());
        }
    }

    private final class HelpActionHandler
    extends ElementVisitor {
        private HelpActionHandler() {
        }

        public void end(ElementEndContext context) {
            HelpHook.this.getHelp((ElementContext)context).setHelpAction(context.getText().trim());
        }
    }

    private class HelpURLHandler
    extends ElementVisitor {
        private HelpURLHandler() {
        }

        public final void end(ElementEndContext context) {
            String value = context.getText().trim();
            URL url = HelpHook.this.getHelpURL((ElementContext)context, value);
            if (url == null) {
                this.log((ElementContext)context, Level.SEVERE, "Unable to use help url " + value);
            } else {
                this.url((ElementContext)context, url);
            }
        }

        protected void url(ElementContext context, URL url) {
            HelpHook.this.getHelp(context).setHelpURL(url);
        }
    }

    private final class RelativeToHandler
    extends ElementVisitor {
        private RelativeToHandler() {
        }

        public void end(ElementEndContext context) {
            HelpHook.this.getHelp((ElementContext)context).setRelativeTo(context.getText().trim());
        }
    }

    private final class RelativePositionHandler
    extends ElementVisitor {
        private RelativePositionHandler() {
        }

        public void end(ElementEndContext context) {
            HelpHook.this.getHelp((ElementContext)context).setRelativePosition(context.getText().trim());
        }
    }

    private final class BrowseSymbolResolverHandler
    extends ElementVisitor {
        private BrowseSymbolResolverHandler() {
        }

        public void end(ElementEndContext context) {
            String value = context.getText();
            HelpHook.this._browseSymbolResolverEntries.add(value);
        }
    }

    private final class BookHandler
    extends ElementVisitor {
        private BookHandler() {
        }

        public void start(ElementStartContext context) {
            context.getScopeData().put(HelpHook.KEY_BOOK_PAIR, new Pair());
            context.registerChildVisitor(BOOK_TITLE, HelpHook.this._bookTitle);
            context.registerChildVisitor(BOOK_LABEL, HelpHook.this._bookLabel);
        }

        public void end(ElementEndContext context) {
            Pair bookPair = HelpHook.this.getBookPair((ElementContext)context);
            HelpObject helpObject = HelpHook.this.getHelp((ElementContext)context);
            helpObject.addBookPair((String)bookPair.getFirst(), (String)bookPair.getSecond());
        }
    }

    private class BookTitleHandler
    extends ElementVisitor {
        private BookTitleHandler() {
        }

        public final void end(ElementEndContext context) {
            String value = context.getText().trim();
            Pair bookPair = HelpHook.this.getBookPair((ElementContext)context);
            bookPair.setFirst((Object)value);
        }
    }

    private class BookLabelHandler
    extends ElementVisitor {
        private BookLabelHandler() {
        }

        public final void end(ElementEndContext context) {
            String value = context.getText().trim();
            Pair bookPair = HelpHook.this.getBookPair((ElementContext)context);
            bookPair.setSecond((Object)value);
        }
    }

    private final class CallbackWizardHandlerVisitor
    extends ElementVisitor {
        private CallbackWizardHandlerVisitor() {
        }

        public void end(ElementEndContext context) {
            String value = context.getText();
            HelpHook.this._callbackWizardHandlerEntries.add(value);
        }
    }

    private class HelpObject {
        private String _helpName;
        private int _helpAction;
        private URL _helpURL;
        private String _relativeTo;
        private int _relativePos = 1;
        private Map<String, String> _bookMap = new HashMap<String, String>();

        private HelpObject() {
        }

        public String getHelpName() {
            return this._helpName;
        }

        public void setHelpName(String name) {
            this._helpName = name;
        }

        public int getHelpAction() {
            return this._helpAction;
        }

        public void setHelpAction(String helpAction) {
            this._helpAction = helpAction.equalsIgnoreCase(HelpHook.REMOVE_ACTION) ? 1 : 0;
        }

        public void setHelpURL(URL url) {
            this._helpURL = url;
        }

        public URL getHelpURL() {
            return this._helpURL;
        }

        public void setRelativeTo(String relativeTo) {
            this._relativeTo = relativeTo;
        }

        public String getRelativeTo() {
            return this._relativeTo;
        }

        public void setRelativePosition(String position) {
            this._relativePos = position.equalsIgnoreCase(HelpHook.BEFORE) ? 0 : 1;
        }

        public int getRelativePosition() {
            return this._relativePos;
        }

        public void addBookPair(String title, String label) {
            this._bookMap.put(title, label);
        }

        public Map<String, String> getBookMap() {
            return this._bookMap;
        }
    }
}

