/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.library.Library;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorHelper;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ScrollableTabBar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.data.ListStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.HelpExtArb;
import oracle.jdevimpl.help.HelpNavigatorToolbar;
import oracle.jdevimpl.help.HelpOptions;
import oracle.jdevimpl.help.HelpSystemConstants;
import oracle.jdevimpl.help.HelpTopicDocument;
import oracle.jdevimpl.help.HelpTopicEditor;
import oracle.jdevimpl.help.HelpWindow;
import oracle.jdevimpl.help.JDevFavoritesNavigator;
import oracle.jdevimpl.help.JDevNavigator;
import oracle.jdevimpl.help.JDevTOCNavigator;
import oracle.jdevimpl.help.SearchOptionsPanel;
import oracle.jdevimpl.help.SearchResultsEditor;

public final class HelpCenterWindow {
    private static HelpCenterWindow INSTANCE;
    private static Window _instanceWindow;
    private static HelpCenterView _helpCenterView;
    private static HelpWindow _helpWindow;
    private static WindowAdapter _windowAdapter;
    private static boolean _userAlwaysOnTopSetting;
    private static SearchModel _searchModel;
    private static int _windowXPos;
    private static int _windowYPos;
    private static final int TOGGLE_WINDOW_ON_TOP_CMD_ID;
    private static final String VIEW_NAVIGATORS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.ViewNavigatorsCommand";
    private static final int VIEW_NAVIGATORS_CMD_ID;
    private static final String GOTO_TOC_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToTOCCmd";
    private static final int GOTO_TOC_CMD_ID;
    private static final String GOTO_FAV_CMD = "oracle.jdevimpl.help.HelpCenterWindow.GoToFavCmd";
    private static final int GOTO_FAV_CMD_ID;
    private static final String CLOSE_TAB_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseTabCmd";
    private static final int CLOSE_TAB_CMD_ID;
    private static final String CLOSE_OTHER_TABS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseOtherTabsCmd";
    private static final int CLOSE_OTHER_TABS_CMD_ID;
    private static final String CLOSE_ALL_TABS_CMD = "oracle.jdevimpl.help.HelpCenterWindow.CloseAllTabsCmd";
    private static final int CLOSE_ALL_TABS_CMD_ID;
    private static final int RIGHT = 0;
    private static final int LEFT = 1;
    private static final int TOP = 2;
    private static final int BOTTOM = 3;
    private static final int OFFSET = 1;
    private static ReentrantLock _lock;

    private HelpCenterWindow() {
    }

    static void lock() {
        _lock.lock();
    }

    static void unlock() {
        _lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setVisible(boolean visible) {
        _lock.lock();
        try {
            if (_instanceWindow != null) {
                _instanceWindow.setVisible(visible);
                Frame frame = (Frame)_instanceWindow;
                int frameState = frame.getState();
                if (frameState == 1) {
                    frame.setState(0);
                }
            }
        }
        finally {
            _lock.unlock();
        }
    }

    void requestFocus() {
        _instanceWindow.requestFocus();
    }

    String getSearchText() {
        return _helpCenterView.getSearchText();
    }

    static SearchModel getSearchModel() {
        Library library;
        if (_searchModel == null && (library = HelpWindow.getLibrary()) != null) {
            oracle.help.common.View[] searchViews = NavigatorHelper.filterViewsByLabel((oracle.help.common.View[])library.getAllViews(), (String)"Search");
            _searchModel = new SearchModel((SearchModelData)new OHJSearchModelData(), searchViews);
        }
        return _searchModel;
    }

    private static DefaultCustomTabPage getSearchResultsPage() {
        if (_helpCenterView != null) {
            return _helpCenterView.findSearchResultsEditor();
        }
        return null;
    }

    private static void removeTabPage(DefaultCustomTabPage tabPage) {
        if (_helpCenterView != null) {
            _helpCenterView.removeTabPage(tabPage);
        }
    }

    public static HelpCenterWindow getInstance() {
        _lock.lock();
        try {
            if (INSTANCE == null) {
                INSTANCE = new HelpCenterWindow();
                _instanceWindow = new MyJFrame(Ide.getMainWindow().getGraphicsConfiguration());
                _instanceWindow.setVisible(true);
            }
            HelpCenterWindow helpCenterWindow = INSTANCE;
            return helpCenterWindow;
        }
        finally {
            _lock.unlock();
        }
    }

    public Editor getCurrentEditor() {
        Object userObject;
        CustomTabPage tabPage;
        CustomTab customTab;
        int selectedPage;
        if (_helpCenterView != null && HelpCenterWindow._helpCenterView._scrollableTabBar != null && (selectedPage = (customTab = HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs()).getSelectedPage()) != -1 && (tabPage = customTab.getPage(selectedPage)) != null && tabPage instanceof DefaultCustomTabPage && (userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof Editor) {
            return (Editor)userObject;
        }
        return null;
    }

    public Component getCurrentNavigator() {
        Object userObject;
        CustomTabPage tabPage;
        CustomTab customTab;
        int selectedPage;
        if (_helpWindow != null && (selectedPage = (customTab = _helpWindow.getCustomTab()).getSelectedPage()) != -1 && (tabPage = customTab.getPage(selectedPage)) != null && tabPage instanceof DefaultCustomTabPage && (userObject = ((DefaultCustomTabPage)tabPage).getUserObject()) instanceof HelpWindow.NavigatorHolder) {
            HelpWindow.NavigatorHolder holder = (HelpWindow.NavigatorHolder)userObject;
            return holder.getNavigator();
        }
        return null;
    }

    static HelpCenterWindow peekInstance() {
        return INSTANCE;
    }

    static JDevTOCNavigator getTOCNavigator() {
        if (_helpWindow != null) {
            return _helpWindow.getTOCNavigator();
        }
        return null;
    }

    static Component getGUI() {
        if (_helpCenterView != null) {
            return _helpCenterView.getGUI();
        }
        return null;
    }

    static void add(HelpTopicEditor helpTopicEditor) {
        _helpCenterView.add(helpTopicEditor);
        HelpCenterWindow.handleEditorBorder(helpTopicEditor, "active");
    }

    static void remove(final HelpTopicEditor helpTopicEditor) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                _helpCenterView.remove(helpTopicEditor);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    static HelpTopicEditor findEditorForTopic(Topic topic) {
        HelpTopicEditor retval;
        block5: {
            retval = null;
            if (topic.hasTarget() && _helpCenterView != null) {
                try {
                    URL findURL = topic.getTarget().getURL();
                    if (HelpCenterWindow._helpCenterView._scrollableTabBar == null) {
                        return retval;
                    }
                    ListModel model = HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs().getModel();
                    if (model == null) break block5;
                    int numElements = model.getSize();
                    for (int i = 0; i < numElements; ++i) {
                        HelpTopicEditor hte;
                        URL editorURL;
                        DefaultCustomTabPage tabPage;
                        Object obj = model.getElementAt(i);
                        if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor) || (editorURL = (hte = (HelpTopicEditor)((Object)obj)).getURL()) == null || !URLFileSystem.equals((URL)findURL, (URL)editorURL)) continue;
                        retval = hte;
                        break;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return retval;
    }

    static void selectHelpTopicEditor(HelpTopicEditor helpTopicEditor) {
        ListModel model;
        if (_helpCenterView != null && (model = HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs().getModel()) != null) {
            int numElements = model.getSize();
            for (int i = 0; i < numElements; ++i) {
                HelpTopicEditor hte;
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor) || (hte = (HelpTopicEditor)((Object)obj)) != helpTopicEditor) continue;
                HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs().setSelectedPage(i);
                HelpCenterWindow._helpCenterView._scrollableTabBar.ensureSelectedTabVisible();
                GraphicsUtils.focusComponentOrChild((Component)helpTopicEditor.getGUI(), (boolean)true);
            }
        }
    }

    static void updateTabLabelForEditor(HelpTopicEditor editor) {
        ListModel model;
        if (_helpCenterView != null && (model = HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs().getModel()) != null) {
            int numElements = model.getSize();
            for (int i = 0; i < numElements; ++i) {
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof HelpTopicEditor) || obj != editor) continue;
                URL editorURL = editor.getBrowser().getURL();
                String newTitle = HelpTopicDocument.getTitleFromURL(editorURL);
                tabPage.setLabel(newTitle);
                HelpCenterWindow._helpCenterView._scrollableTabBar.repaint();
                break;
            }
        }
    }

    void switchNavigator(int navigatorToShow) {
        if (_helpWindow != null) {
            _helpWindow.switchNavigator(navigatorToShow);
        }
        if (_helpCenterView != null && HelpCenterWindow._helpCenterView._splitPane != null) {
            int fullWidth = HelpCenterWindow._helpCenterView._splitPane.getWidth();
            int navigatorWidth = HelpCenterWindow._helpCenterView._splitPane.getLeftComponent().getWidth();
            if (navigatorWidth < fullWidth / 4) {
                HelpCenterWindow._helpCenterView._splitPane.setDividerLocation(0.35);
            }
        }
    }

    void focusSearchControl() {
        if (_helpCenterView != null && HelpCenterWindow._helpCenterView._searchField != null) {
            HelpCenterWindow._helpCenterView._searchField.requestFocus();
        }
    }

    public Window getWindow() {
        return _instanceWindow;
    }

    HelpWindow getHelpWindow() {
        return _helpWindow;
    }

    static void setupSplitPaneDivider(final JSplitPane splitPane) {
        splitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        splitPane.setDividerSize(2);
        splitPane.setOpaque(false);
        Component[] comps = splitPane.getComponents();
        if (comps != null) {
            for (Component c : comps) {
                if (c == null) continue;
                Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
                c.setBackground(color);
                HelpCenterWindow.callSetBorderMethod(c);
                c.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (_instanceWindow != null) {
                            _instanceWindow.setCursor(Cursor.getPredefinedCursor(splitPane.getOrientation() == 1 ? 11 : 8));
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        if (_instanceWindow != null) {
                            _instanceWindow.setCursor(null);
                        }
                    }
                });
            }
        }
    }

    private static void callSetBorderMethod(Component divider) {
        if (divider instanceof BasicSplitPaneDivider) {
            ((BasicSplitPaneDivider)divider).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    private static void handleEditorsBorder(String state) {
        if (HelpCenterWindow._helpCenterView._scrollableTabBar == null) {
            return;
        }
        ListModel model = HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs().getModel();
        if (model != null) {
            int numElements = model.getSize();
            for (int i = 0; i < numElements; ++i) {
                DefaultCustomTabPage tabPage;
                Object obj = model.getElementAt(i);
                if (!(obj instanceof DefaultCustomTabPage) || !((obj = (tabPage = (DefaultCustomTabPage)obj).getUserObject()) instanceof Editor)) continue;
                HelpCenterWindow.handleEditorBorder((Editor)obj, state);
            }
        }
    }

    private static void handleEditorBorder(Editor editor, String state) {
        if (Themes.isThemed()) {
            ThemeProperties themeProperties = Themes.getActiveTheme().getStateProperties("view", state);
            Color color = themeProperties.getColor("bordercolor");
            Component c = editor.getGUI();
            CompoundBorder cb = new CompoundBorder(JavatoolsBorderFactory.createLeftRightBorder((Color)color), JavatoolsBorderFactory.createBottomBorder((Color)color));
            ((JPanel)c).setBorder(cb);
            if (editor instanceof HelpTopicEditor) {
                if (state.equals("active")) {
                    editor.activate();
                } else {
                    editor.deactivate();
                }
            }
        }
    }

    private HelpCenterView createHelpCenterView(boolean alwaysOnTop) {
        _helpCenterView = new HelpCenterView(_helpWindow, alwaysOnTop);
        return _helpCenterView;
    }

    private static void handleMapsForExit(JRootPane rootPane) {
        InputMap imIde = Ide.getIdeInputMap();
        InputMap imMe = rootPane.getInputMap(1);
        imMe.setParent(imIde.getParent());
        ActionMap amIde = Ide.getIdeActionMap();
        ActionMap amMe = rootPane.getActionMap();
        amMe.setParent(amIde);
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        MultiInputMap imap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
        IdeAction exitAction = IdeAction.newLocalAction((int)4, (View)_helpCenterView);
        exitAction.addController((Controller)_helpCenterView);
        HelpCenterWindow.updateMyMapWithAction(kso, amMe, imap, 4, exitAction);
        ksc = kscr.getContext("oracle/jdevimpl/help/accelerators.xml");
        IdeAction fontAction = IdeAction.find((String)"oracle.jdevimpl.help.HelpContentPanel.IncreaseFontSizeCmd");
        fontAction.addController((Controller)_helpCenterView);
        HelpCenterWindow.updateMyMapWithAction(kso, amMe, imap, HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID, fontAction);
        fontAction = IdeAction.find((String)"oracle.jdevimpl.help.HelpContentPanel.DecreaseFontSizeCmd");
        fontAction.addController((Controller)_helpCenterView);
        HelpCenterWindow.updateMyMapWithAction(kso, amMe, imap, HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID, fontAction);
    }

    private static void updateMyMapWithAction(KeyStrokeOptions kso, ActionMap aMap, MultiInputMap myMap, int cmdId, IdeAction action) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/localaccelerators.xml");
        List kList = HelpCenterWindow.getKeyStrokesFor(kso, cmdId, ksc);
        if (kList != Collections.EMPTY_LIST) {
            int numKeys = kList.size();
            Integer integer = cmdId;
            for (int i = 0; i < numKeys; ++i) {
                aMap.put(integer, (Action)action);
                myMap.put((KeyStrokes)kList.get(i), (Object)integer);
            }
        }
    }

    private static List getKeyStrokesFor(KeyStrokeOptions kso, int cmdId, KeyStrokeContext ksc) {
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        List kList = ksm.getKeyStrokesFor(cmdId);
        if (kList == Collections.EMPTY_LIST) {
            ksm = kso.getLocalKeyMap(ksc);
            kList = ksm.getKeyStrokesFor(cmdId);
        }
        return kList;
    }

    static void saveLayout() {
        if (_instanceWindow == null) {
            HelpOptions helpOptions = HelpOptions.getInstance();
            helpOptions.setHelpCenterWindowOpen(false);
        } else {
            _helpCenterView.saveLayout();
        }
    }

    private static void positionWindow(Window window, int direction, Dimension windowSize) {
        Rectangle candidateRect = HelpCenterWindow.getAvailableScreenRectangle(direction, windowSize);
        window.setLocation(candidateRect.x, candidateRect.y);
    }

    private static Rectangle getAvailableScreenRectangle(int direction, Dimension windowSize) {
        Rectangle screenRect = Ide.getMainWindow().getGraphicsConfiguration().getBounds();
        Dimension ideDim = Ide.getMainWindow().getSize();
        Point idePoint = Ide.getMainWindow().getLocationOnScreen();
        int ideBegin = idePoint.x;
        int ideEnd = idePoint.x + ideDim.width + 1;
        int ideTop = idePoint.y;
        int ideBottom = idePoint.y + ideDim.height + 1;
        int availWidth = 0;
        int availHeight = 0;
        int x = 0;
        int y = 0;
        if (direction == 0) {
            availWidth = screenRect.width - ideEnd;
            availHeight = screenRect.height - ideTop;
            x = ideEnd;
            y = ideTop;
        } else if (direction == 1) {
            availWidth = ideBegin - 1;
            availHeight = screenRect.height - ideTop;
            x = ideBegin - 1 - windowSize.width;
            y = ideTop;
        } else if (direction == 2) {
            availWidth = screenRect.width - ideBegin;
            availHeight = ideTop - 1;
            x = ideBegin;
            y = ideTop - 1 - windowSize.height;
        } else if (direction == 3) {
            availWidth = screenRect.width - ideBegin;
            availHeight = screenRect.height - (ideBottom + 1);
            x = ideBegin;
            y = ideBottom + 1;
        }
        x = Math.max(0, x);
        x = Math.min(x, screenRect.width - windowSize.width);
        y = Math.max(0, y);
        y = Math.min(y, screenRect.height - windowSize.height);
        return new Rectangle(x, y, availWidth, availHeight);
    }

    private static void recreateOpenDocuments(HelpOptions helpOptions) {
        ListStructure openDocuments = helpOptions.getOpenDocuments();
        if (openDocuments != null && openDocuments.size() > 0) {
            int numDocuments = openDocuments.size();
            for (int i = 0; i < numDocuments; ++i) {
                URL url = (URL)openDocuments.get(i);
                if (url == null) continue;
                String urlString = url.toString();
                urlString = urlString.replace(".helpT", "");
                urlString = urlString.replace(".help", "");
                int jarHashPosition = urlString.indexOf("jar#");
                int bangPosition = urlString.indexOf("!");
                if (jarHashPosition != -1 && bangPosition != -1) {
                    StringBuffer sb = new StringBuffer(urlString);
                    String deleteString = sb.substring(jarHashPosition + 3, bangPosition);
                    sb.delete(jarHashPosition + 3, bangPosition);
                    sb.append(deleteString);
                    urlString = sb.toString();
                }
                SimpleURLTarget theTarget = new SimpleURLTarget(null, urlString);
                SimpleTopic theTopic = new SimpleTopic(null, (Target)theTarget);
                HelpTopicDocument htd = null;
                try {
                    htd = new HelpTopicDocument((Topic)theTopic);
                }
                catch (Exception e) {
                    return;
                }
                Context ctx = Context.newIdeContext((Node)htd);
                ctx.setWorkspace(null);
                ctx.setProject(null);
                HelpTopicEditor helpTopicEditor = new HelpTopicEditor();
                helpTopicEditor.setContext(ctx);
                helpTopicEditor.displayTopic((Topic)theTopic);
                HelpCenterWindow.add(helpTopicEditor);
                helpTopicEditor.setParent(INSTANCE);
            }
        }
    }

    static {
        _windowXPos = -1;
        TOGGLE_WINDOW_ON_TOP_CMD_ID = Ide.findCmdID((String)"oracle.jdevimpl.help.HelpCenterWindow.ToggleWindowOnTopCmd");
        VIEW_NAVIGATORS_CMD_ID = Ide.findOrCreateCmdID((String)VIEW_NAVIGATORS_CMD);
        GOTO_TOC_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_TOC_CMD);
        GOTO_FAV_CMD_ID = Ide.findOrCreateCmdID((String)GOTO_FAV_CMD);
        CLOSE_TAB_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_TAB_CMD);
        CLOSE_OTHER_TABS_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_OTHER_TABS_CMD);
        CLOSE_ALL_TABS_CMD_ID = Ide.findOrCreateCmdID((String)CLOSE_ALL_TABS_CMD);
        _lock = new ReentrantLock();
    }

    public class HelpCenterView
    extends View
    implements Controller {
        private HelpNavigatorToolbar _toolbar = new HelpNavigatorToolbar();
        private JSplitPane _splitPane;
        private JPanel _mainPanel;
        private ScrollableTabBar _scrollableTabBar;
        private JPanel _editorPanel;
        private DefaultListModel _listModel = new DefaultListModel();
        private Editor _currentEditor;
        private Component _currentEditorComponent;
        private SearchField _searchField;
        private Action _showOptionsAction;
        private SearchOptionsPanel _optionPanel;
        private List<DefaultCustomTabPage> _tabPages = new ArrayList<DefaultCustomTabPage>();
        private ToggleToolButton onTopBtn;
        private MenuToolButton viewButton;
        private ToolButton toolButton;
        private ListSelectionListener _listSelectionListener;
        private ListDataListener _listDataListener;
        private SearchListener _searchListener;
        private List<IdeAction> _actions = new ArrayList<IdeAction>(4);
        private MouseListener _doubleClickListener = new DoubleClickListener();
        private TabCloseAction _closeAction;

        public HelpCenterView(HelpWindow helpWindow, boolean alwaysOnTop) {
            _helpWindow = helpWindow;
            this._mainPanel = new JPanel();
            this._mainPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._mainPanel.setOpaque(false);
            this._mainPanel.setLayout(new BorderLayout());
            this._mainPanel.setFocusTraversalPolicyProvider(true);
            this._mainPanel.setFocusTraversalPolicy(new HelpFocusTraversalPolicy());
            this.createSplitPane();
            this._mainPanel.add((Component)this._splitPane, "Center");
            _helpWindow.getCustomTab().setTabComponentOwner((JComponent)this._mainPanel);
            this._listDataListener = new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                    ListModel listModel = (ListModel)e.getSource();
                    if (listModel.getSize() > 0 && HelpCenterView.this._splitPane.getLeftComponent() == null) {
                        HelpCenterView.this._splitPane.setLeftComponent(_helpWindow.getGUI());
                    }
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    ListModel listModel = (ListModel)e.getSource();
                    if (listModel.getSize() == 0 && HelpCenterView.this._splitPane.getLeftComponent() != null) {
                        HelpCenterView.this._splitPane.setLeftComponent(null);
                        HelpCenterView.this._splitPane.repaint();
                    }
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            };
            helpWindow.getCustomTab().addListDataListener(this._listDataListener);
            helpWindow.getCustomTab().addMouseListener(this._doubleClickListener);
            this._toolbar.forcePrimaryViewToolbar(true);
            this._toolbar.setBorder(new EmptyBorder(3, 2, 3, 2));
            this._mainPanel.add((Component)((Object)this._toolbar), "North");
            IdeAction action = IdeAction.find((int)TOGGLE_WINDOW_ON_TOP_CMD_ID);
            action.addController((Controller)this);
            this._actions.add(action);
            action.putValue("State", (Object)(alwaysOnTop ? Boolean.TRUE : Boolean.FALSE));
            this.onTopBtn = new ToggleToolButton((ToggleAction)action);
            this.onTopBtn.setFocusable(true);
            ResourceUtils.resButton((AbstractButton)this.onTopBtn, (String)HelpArb.getString(20));
            this._toolbar.add((Component)this.onTopBtn);
            String label = HelpArb.getString(21);
            action = IdeAction.get((int)VIEW_NAVIGATORS_CMD_ID, (String)HelpCenterWindow.VIEW_NAVIGATORS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), (Icon)OracleIcons.getIcon((String)"viewnavigators.png"), null, (boolean)true);
            action.addController((Controller)this);
            this._actions.add(action);
            action.setEnabled(true);
            this.viewButton = new MenuToolButton((ToggleAction)action);
            this.viewButton.setFocusable(true);
            this.addActionsToViewButton(this.viewButton);
            ResourceUtils.resButton((AbstractButton)this.viewButton, (String)label);
            this._toolbar.add((Component)this.viewButton);
            action = IdeAction.find((String)"oracle.jdevimpl.help.ShowOTNForum");
            if (action != null) {
                this.toolButton = new ToolButton((Action)action);
                this.toolButton.setFocusable(true);
                this.toolButton.setIcon(OracleIcons.getIcon((String)"forum.png"));
                ResourceUtils.resButton((AbstractButton)this.toolButton, (String)HelpExtArb.format("FORUM_MENU_ITEM", ProductInformation.getProductInformation().getShortName()));
                this._toolbar.add((Component)this.toolButton);
            }
            this._searchField = new SearchField();
            this._searchField.setStyle(SearchField.Style.SEARCH);
            Dimension d = this._searchField.getPreferredSize();
            d = new Dimension(250, this._searchField.getPreferredSize().height);
            this._searchField.setPreferredSize(d);
            this._searchField.setMaximumSize(d);
            this._searchField.setMinimumSize(new Dimension(150, d.height));
            this._searchListener = new HelpSearchListener();
            this._searchField.addSearchListener(this._searchListener);
            JPanel spacerPanel = new JPanel();
            spacerPanel.setLayout(new GridBagLayout());
            spacerPanel.add((Component)this._searchField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            spacerPanel.setOpaque(false);
            this._toolbar.add(spacerPanel, -1);
            this._showOptionsAction = new MyAction('O');
            this._showOptionsAction.putValue("SmallIcon", OracleIcons.getIcon((String)"find.png"));
            KeyStroke keyStroke = KeyStroke.getKeyStroke("alt DOWN");
            this._showOptionsAction.putValue("AcceleratorKey", keyStroke);
            String tooltip = HelpArb.format(98, KeyUtil.toString((KeyStroke)keyStroke));
            this._showOptionsAction.putValue("ShortDescription", tooltip);
            this._searchField.setPopDownAction(this._showOptionsAction);
            JTextField textField = this.getTextField((Container)this._searchField);
            InputMap inputMap = textField.getInputMap(0);
            ActionMap actionMap = textField.getActionMap();
            MyAction cancelAction = new MyAction('C');
            inputMap.put(KeyStroke.getKeyStroke(27, 0), cancelAction);
            actionMap.put(cancelAction, cancelAction);
            actionMap.put(this._showOptionsAction, this._showOptionsAction);
            this._searchField.setPrompt(HelpArb.getString(24));
            this._editorPanel = new JPanel(new BorderLayout());
            this._editorPanel.setBorder(new EmptyBorder(2, 5, 5, 3));
            this._editorPanel.setOpaque(false);
            this._editorPanel.setMinimumSize(new Dimension(0, 5));
        }

        private void ensureEditorPanelInitialized() {
            if (this._scrollableTabBar != null) {
                return;
            }
            this._scrollableTabBar = new ScrollableTabBar(1);
            this._scrollableTabBar.setName("HelpCenterView.ScrollableTabBarForEditors");
            CustomTab customTab = this._scrollableTabBar.getTabs();
            customTab.setName("HelpCenterView.CustomTabForEditors");
            customTab.setTabComponentOwner((JComponent)this._editorPanel);
            customTab.setModel((ListModel)this._listModel);
            customTab.setOpaque(false);
            customTab.setFocused(true);
            this._closeAction = new TabCloseAction(this);
            customTab.setCloseAction((Action)this._closeAction);
            customTab.addMouseListener(this._doubleClickListener);
            customTab.setCtrlClickCloseEnabled(true);
            this._listSelectionListener = new ListSelectionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ScrollableTabBar scrollableTabBar = HelpCenterView.this._scrollableTabBar;
                    synchronized (scrollableTabBar) {
                        if (!e.getValueIsAdjusting()) {
                            URL editorURL;
                            JDevTOCNavigator tocNavigator;
                            Editor editor;
                            if (HelpCenterView.this._currentEditorComponent != null) {
                                HelpTopicEditor hte;
                                HelpContentPanel hcp;
                                HelpCenterView.this._editorPanel.remove(HelpCenterView.this._currentEditorComponent);
                                if (HelpCenterView.this._currentEditor instanceof HelpTopicEditor && (hcp = (hte = (HelpTopicEditor)HelpCenterView.this._currentEditor).getHelpContentPanel()) != null) {
                                    hcp.closeFindDialog();
                                }
                            }
                            int selPageIdx = HelpCenterView.this._scrollableTabBar.getTabs().getSelectedPage();
                            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)HelpCenterView.this._scrollableTabBar.getTabs().getPage(selPageIdx);
                            HelpCenterView.this._currentEditor = editor = (Editor)tabPage.getUserObject();
                            Component newEditorComponent = editor.getGUI();
                            HelpCenterView.this._editorPanel.add(newEditorComponent, "Center");
                            Component focusComp = newEditorComponent;
                            if (editor instanceof HelpTopicEditor) {
                                focusComp = (Component)((HelpTopicEditor)editor).getTopicDisplayPanel();
                            }
                            HelpCenterView.this._currentEditorComponent = newEditorComponent;
                            if (editor instanceof HelpTopicEditor && (tocNavigator = HelpCenterWindow.getTOCNavigator()) != null && (editorURL = ((HelpTopicEditor)editor).getBrowser().getURL()) != null) {
                                tocNavigator.selectMatchingTopic(editorURL);
                            }
                            HelpCenterView.this._scrollableTabBar.ensureSelectedTabVisible();
                            HelpCenterView.this._editorPanel.invalidate();
                            HelpCenterView.this._editorPanel.repaint();
                            HelpCenterView.this._splitPane.repaint();
                        }
                    }
                }
            };
            customTab.addSelectionListener(this._listSelectionListener);
            customTab.addMouseListener((MouseListener)new TabMouseListener());
            this._listModel.addListDataListener(new ListDataListener(){

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                    int numTabs = HelpCenterView.this._listModel.size();
                    if (numTabs == 0) {
                        HelpCenterView.this._splitPane.remove(HelpCenterView.this._editorPanel);
                        HelpCenterView.this._splitPane.repaint();
                        HelpCenterView.this._mainPanel.repaint();
                    }
                    ArrayList<DefaultCustomTabPage> removeList = new ArrayList<DefaultCustomTabPage>();
                    for (DefaultCustomTabPage page : HelpCenterView.this._tabPages) {
                        HelpTopicEditor hte;
                        HelpContentPanel hcp;
                        boolean found = false;
                        for (int i = 0; i < HelpCenterView.this._listModel.getSize(); ++i) {
                            CustomTabPage tabPage = (CustomTabPage)HelpCenterView.this._listModel.getElementAt(i);
                            if (tabPage != page) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        if (page.getUserObject() instanceof HelpTopicEditor && (hcp = (hte = (HelpTopicEditor)((Object)page.getUserObject())).getHelpContentPanel()) != null) {
                            hcp.dispose();
                        }
                        removeList.add(page);
                    }
                    if (removeList != null) {
                        HelpCenterView.this._tabPages.removeAll(removeList);
                        if (HelpCenterView.this._listModel.size() == 0) {
                            HelpCenterView.this._currentEditor = null;
                            HelpCenterView.this._currentEditorComponent = null;
                        }
                    }
                }

                @Override
                public void contentsChanged(ListDataEvent e) {
                }
            });
            this._scrollableTabBar.setScrollMode(ScrollableTabBar.ScrollMode.SWITCH_TABS);
            this._editorPanel.add((Component)this._scrollableTabBar, "North");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            IdeAction fontAction;
            Object textField;
            if (this._searchField != null) {
                this._searchField.removeSearchListener(this._searchListener);
            }
            if (this._searchField != null && this._showOptionsAction != null) {
                textField = this.getTextField((Container)this._searchField);
                ActionMap actionMap = ((JComponent)textField).getActionMap();
                actionMap.remove(this._showOptionsAction);
            }
            if (this._scrollableTabBar != null) {
                textField = this._scrollableTabBar;
                synchronized (textField) {
                    ListDataListener[] customTab = this._scrollableTabBar.getTabs();
                    if (customTab != null) {
                        MouseListener[] mls;
                        customTab.removeSelectionListener(this._listSelectionListener);
                        for (MouseListener ml : mls = (MouseListener[])customTab.getListeners(MouseListener.class)) {
                            customTab.removeMouseListener(ml);
                        }
                    }
                }
                if (this._listModel != null) {
                    ListDataListener[] ldls;
                    for (ListDataListener ldl : ldls = this._listModel.getListDataListeners()) {
                        this._listModel.removeListDataListener(ldl);
                    }
                    for (int i = 0; i < this._listModel.size(); ++i) {
                        DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.get(i);
                        Object editorObj = tabPage.getUserObject();
                        if (editorObj == null || !(editorObj instanceof HelpTopicEditor)) continue;
                        ((HelpTopicEditor)((Object)editorObj)).close();
                    }
                    this._listModel.clear();
                    this._listModel = null;
                }
                this._scrollableTabBar.removeAll();
                this._scrollableTabBar = null;
            }
            _helpWindow.getCustomTab().removeListDataListener(this._listDataListener);
            _helpWindow.getCustomTab().removeMouseListener(this._doubleClickListener);
            this._doubleClickListener = null;
            for (IdeAction a : this._actions) {
                a.removeController((Controller)this);
            }
            this._actions.clear();
            this.onTopBtn.setAction(null);
            if (this.viewButton != null) {
                this.viewButton.setAction(null);
                this.viewButton.removeAllPopupItems();
            }
            if (this.toolButton != null) {
                this.toolButton.setAction(null);
                this.toolButton = null;
            }
            if (this._closeAction != null) {
                this._closeAction.dispose();
                this._closeAction = null;
            }
            if ((fontAction = IdeAction.find((String)"oracle.jdevimpl.help.HelpContentPanel.IncreaseFontSizeCmd")) != null) {
                fontAction.removeController((Controller)this);
            }
            if ((fontAction = IdeAction.find((String)"oracle.jdevimpl.help.HelpContentPanel.DecreaseFontSizeCmd")) != null) {
                fontAction.removeController((Controller)this);
            }
            if (this._toolbar != null) {
                this._toolbar.removeAll();
            }
            this._currentEditor = null;
            this._optionPanel = null;
            this._searchField = null;
            this._showOptionsAction = null;
            this._splitPane.removeAll();
            this._splitPane = null;
            this._toolbar = null;
            this._optionPanel = null;
            this._mainPanel.removeAll();
            this._mainPanel = null;
        }

        private void createSplitPane() {
            this._splitPane = new JSplitPane(1);
            this._splitPane.setResizeWeight(0.5);
            HelpCenterWindow.setupSplitPaneDivider(this._splitPane);
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new BorderLayout());
            jpanel.setOpaque(false);
            jpanel.setBorder(new EmptyBorder(2, 3, 5, 0));
            Component guiComp = _helpWindow.getGUI();
            jpanel.add(guiComp, "Center");
            guiComp.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Component c = e.getComponent();
                    c.invalidate();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            this._splitPane.setLeftComponent(jpanel);
        }

        public HelpInfo getHelpInfo() {
            String topicId = null;
            KeyboardFocusManager focusMgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component comp = focusMgr.getPermanentFocusOwner();
            if (comp instanceof TopicTreeComponent || comp instanceof JTree) {
                Component navigatorComp = HelpCenterWindow.this.getCurrentNavigator();
                if (navigatorComp instanceof JDevTOCNavigator) {
                    topicId = "f1_helpnav_html";
                } else if (navigatorComp instanceof JDevFavoritesNavigator) {
                    topicId = "f1_favsnav_html";
                }
            } else if (comp instanceof PromptedTextField) {
                topicId = "f1_searchoptions_html";
            } else if (comp instanceof JTable) {
                topicId = "f1_searchresults_html";
            } else if (comp.getClass().getName().contains("DocPanel")) {
                String cName = comp.getClass().getName();
                topicId = "f1_helpviewer_html";
            }
            if (topicId == null) {
                topicId = "f1_helpnav_html";
            }
            return new HelpInfo(topicId);
        }

        public ContextMenu getContextMenu() {
            for (Component comp = GraphicsUtils.getFocusedChildComponent((Component)_instanceWindow); comp != null; comp = comp.getParent()) {
                if (comp == HelpCenterWindow._helpCenterView._splitPane.getLeftComponent()) {
                    return _helpWindow.getContextMenu();
                }
                if (comp != HelpCenterWindow._helpCenterView._splitPane.getRightComponent()) continue;
                Editor editor = HelpCenterWindow.this.getCurrentEditor();
                return editor.getContextMenu();
            }
            return null;
        }

        public Toolbar getToolbar() {
            return this._toolbar;
        }

        private CustomTab getEditorCustomTab() {
            return this._scrollableTabBar.getTabs();
        }

        private void maximizeOrMinimize(CustomTab cTab) {
            int dividerLocation = this._splitPane.getDividerLocation();
            boolean editorTab = cTab == this.getEditorCustomTab();
            int min = this._splitPane.getMinimumDividerLocation();
            int max = this._splitPane.getMaximumDividerLocation();
            if (editorTab) {
                if (dividerLocation <= min) {
                    this._splitPane.setDividerLocation(this._splitPane.getLastDividerLocation());
                } else {
                    this._splitPane.setDividerLocation(min);
                }
            } else if (dividerLocation >= max) {
                this._splitPane.setDividerLocation(this._splitPane.getLastDividerLocation());
            } else {
                this._splitPane.setDividerLocation(max);
            }
        }

        private CustomTab getNavigatorCustomTab() {
            return _helpWindow.getCustomTab();
        }

        public String getSearchText() {
            return this._searchField.getText();
        }

        public Component getGUI() {
            return this._mainPanel;
        }

        public DefaultCustomTabPage findSearchResultsEditor() {
            int numTabs = this._listModel.size();
            for (int i = 0; i < numTabs; ++i) {
                DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.get(i);
                if (!(tabPage.getUserObject() instanceof SearchResultsEditor)) continue;
                return tabPage;
            }
            return null;
        }

        public void removeTabPage(DefaultCustomTabPage tabPage) {
            this._listModel.removeElement(tabPage);
            Editor editor = (Editor)tabPage.getUserObject();
            this._editorPanel.remove(editor.getGUI());
            int selPage = this._scrollableTabBar.getTabs().getSelectedPage();
            if (this._listModel.size() > 0 && selPage != -1) {
                DefaultCustomTabPage selTabPage = (DefaultCustomTabPage)this._scrollableTabBar.getTabs().getPage(selPage);
                editor = (Editor)selTabPage.getUserObject();
                if (this._currentEditorComponent != null) {
                    this._editorPanel.remove(this._currentEditorComponent);
                }
                if (editor != null) {
                    this._editorPanel.add(editor.getGUI(), "Center");
                    this._currentEditorComponent = editor.getGUI();
                    this._currentEditor = editor;
                }
            }
            if (this._listModel.size() == 0) {
                this._splitPane.remove(this._editorPanel);
            }
            this._splitPane.repaint();
            this._mainPanel.repaint();
        }

        public void remove(Editor editor) {
            DefaultCustomTabPage pageToRemove = null;
            for (int i = 0; i < this._listModel.size(); ++i) {
                DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.getElementAt(i);
                if (tabPage.getUserObject() != editor) continue;
                pageToRemove = tabPage;
                break;
            }
            if (pageToRemove != null) {
                this.removeTabPage(pageToRemove);
            }
        }

        public void add(Editor editor) {
            String title = null;
            Icon icon = null;
            if (editor instanceof HelpTopicEditor) {
                Context c = editor.getContext();
                HelpTopicDocument htd = (HelpTopicDocument)c.getNode();
                title = htd.getLongLabel();
                icon = htd.getIcon();
            } else if (editor instanceof SearchResultsEditor) {
                title = HelpArb.getString(68);
                icon = OracleIcons.getIcon((String)"find.png");
            } else {
                return;
            }
            DefaultCustomTabPage tabPage = new DefaultCustomTabPage(icon, title, (Object)editor);
            this.add(tabPage, editor);
        }

        public void add(DefaultCustomTabPage tabPage, Editor editor) {
            this.ensureEditorPanelInitialized();
            this._tabPages.add(tabPage);
            this._listModel.addElement(tabPage);
            int newPageNum = this.getPageForTabPage((CustomTabPage)tabPage);
            if (newPageNum != -1) {
                this._scrollableTabBar.getTabs().setSelectedPage(newPageNum);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (HelpCenterView.this._scrollableTabBar != null) {
                            HelpCenterView.this._scrollableTabBar.ensureSelectedTabVisible();
                            HelpCenterView.this._scrollableTabBar.repaint();
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
            this._currentEditorComponent = editor.getGUI();
            this._currentEditor = editor;
            if (this._editorPanel.getParent() == null || this._splitPane.getDividerLocation() >= this._splitPane.getMaximumDividerLocation()) {
                int desiredWidth = 0;
                int desiredHeight = 0;
                if (this._splitPane.getLeftComponent() != null) {
                    desiredWidth = this._splitPane.getLeftComponent().getWidth() / 2;
                    desiredHeight = this._splitPane.getLeftComponent().getHeight();
                }
                if (desiredWidth > 0) {
                    this._editorPanel.setSize(desiredWidth, desiredHeight);
                }
                this.ensureEditorPanelInitialized();
                this._splitPane.setRightComponent(this._editorPanel);
                this._splitPane.setDividerLocation(0.35);
            }
            this._editorPanel.repaint();
            this._mainPanel.repaint();
        }

        public void resetSplitterPosition(int position) {
            if (this._splitPane.getLeftComponent() != null && this._splitPane.getRightComponent() != null) {
                this._splitPane.setDividerLocation(position);
            }
        }

        private void addActionsToViewButton(final MenuToolButton viewButton) {
            final HelpCenterView controller = this;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IdeAction action = null;
                    String label = null;
                    if (_helpWindow.isNavigatorAvailable(0)) {
                        label = HelpArb.getString(18);
                        action = IdeAction.get((int)GOTO_TOC_CMD_ID, (String)HelpCenterWindow.GOTO_TOC_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), (Icon)OracleIcons.getIcon((String)"library.png"), null, (boolean)true);
                        viewButton.addPopupItem((ToggleAction)action);
                        action.addController(controller);
                        HelpCenterView.this._actions.add(action);
                    }
                    if (_helpWindow.isNavigatorAvailable(1)) {
                        label = HelpArb.getString(19);
                        action = IdeAction.get((int)GOTO_FAV_CMD_ID, (String)HelpCenterWindow.GOTO_FAV_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), (Icon)OracleIcons.getIcon((String)"favorites.png"), null, (boolean)true);
                        viewButton.addPopupItem((ToggleAction)action);
                        action.addController(controller);
                        HelpCenterView.this._actions.add(action);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void setPageSelected(DefaultCustomTabPage tabPage) {
            CustomTab cTab = this._scrollableTabBar.getTabs();
            int selPage = cTab.searchPage((CustomTabPage)tabPage);
            cTab.setSelectedPage(selPage);
            this._scrollableTabBar.ensureSelectedTabVisible();
        }

        private int getPageForTabPage(CustomTabPage tabPage) {
            int pageNum = -1;
            CustomTab cTab = this._scrollableTabBar.getTabs();
            int pageCount = cTab.getPageCount();
            for (int i = 0; i < pageCount; ++i) {
                if (cTab.getPage(i) != tabPage) continue;
                pageNum = i;
                break;
            }
            return pageNum;
        }

        void saveLayout() {
            if (_instanceWindow != null) {
                HelpOptions helpOptions = HelpOptions.getInstance();
                _windowXPos = _instanceWindow.getX();
                _windowYPos = _instanceWindow.getY();
                helpOptions.setHelpCenterWidth(_instanceWindow.getWidth());
                helpOptions.setHelpCenterHeight(_instanceWindow.getHeight());
                helpOptions.setHelpCenterWindowOpen(true);
                helpOptions.setSplitterPosition(this._splitPane.getDividerLocation());
                if (this._listModel != null && this._listModel.getSize() > 0) {
                    int numTabs = this._listModel.getSize();
                    ArrayList<URL> urlList = new ArrayList<URL>(numTabs);
                    for (int i = 0; i < numTabs; ++i) {
                        HelpTopicDocument doc;
                        URL url;
                        DefaultCustomTabPage tabPage = (DefaultCustomTabPage)this._listModel.get(i);
                        Editor editor = (Editor)tabPage.getUserObject();
                        if (!(editor instanceof HelpTopicEditor) || (url = (doc = ((HelpTopicEditor)editor).getHelpTopicDocument()).getRealURL()) == null) continue;
                        urlList.add(url);
                    }
                    helpOptions.setOpenDocuments(urlList);
                } else {
                    helpOptions.setOpenDocuments(null);
                }
            }
        }

        private JTextField getTextField(Container parent) {
            if (parent instanceof JTextField) {
                JTextField jTextField = (JTextField)parent;
                return jTextField;
            }
            Component[] children = parent.getComponents();
            for (int i = 0; i < children.length; ++i) {
                Container container;
                JTextField textField;
                Component child = children[i];
                if (!(child instanceof Container) || (textField = this.getTextField(container = (Container)child)) == null) continue;
                return textField;
            }
            return null;
        }

        private void whenAccept() {
            if (this._optionPanel != null) {
                this._optionPanel.dismiss(true);
            }
            this._searchField.requestFocus();
            this._optionPanel = null;
        }

        private void whenCancel() {
            if (this._optionPanel != null) {
                this._optionPanel.dismiss(true);
            }
            this._searchField.requestFocus();
            this._optionPanel = null;
        }

        private void showOptionPanel() {
            if (this._optionPanel == null) {
                this._optionPanel = SearchOptionsPanel.getSearchOptionsPanel();
                InputMap inputMap = this._optionPanel.getInputMap(1);
                ActionMap actionMap = this._optionPanel.getActionMap();
                inputMap.put(KeyStroke.getKeyStroke(40, 8), "showOptions");
                inputMap.put(KeyStroke.getKeyStroke(38, 8), "showOptions");
                inputMap.put(KeyStroke.getKeyStroke(10, 0), "showOptions");
                actionMap.put("showOptions", this._showOptionsAction);
                inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancelOptions");
                actionMap.put("cancelOptions", new MyAction('C'));
            }
            if (this._optionPanel.isShowing()) {
                this._optionPanel.dismiss(true);
                this._searchField.requestFocus();
                return;
            }
            this._optionPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    HelpCenterView.this._optionPanel.removeAncestorListener(this);
                    HelpCenterView.this._optionPanel = null;
                }
            });
            this._optionPanel.show((Component)this._searchField, 3, this._searchField.getHeight() + 3);
        }

        private void handleMultiRemove(DefaultCustomTabPage excludePage) {
            int numTabs = this._listModel.size();
            ArrayList<DefaultCustomTabPage> removeList = new ArrayList<DefaultCustomTabPage>(numTabs);
            for (int i = 0; i < numTabs; ++i) {
                if (excludePage != null && excludePage == this._listModel.getElementAt(i)) continue;
                removeList.add((DefaultCustomTabPage)this._listModel.getElementAt(i));
            }
            if (removeList.size() > 0) {
                for (DefaultCustomTabPage removePage : removeList) {
                    this.removeTabPage(removePage);
                }
            }
        }

        public final boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == TOGGLE_WINDOW_ON_TOP_CMD_ID) {
                _instanceWindow.setAlwaysOnTop(!_instanceWindow.isAlwaysOnTop());
                _userAlwaysOnTopSetting = _instanceWindow.isAlwaysOnTop();
                action.putValue("State", (Object)(_instanceWindow.isAlwaysOnTop() ? Boolean.TRUE : Boolean.FALSE));
                return true;
            }
            if (cmdId == GOTO_TOC_CMD_ID) {
                HelpCenterWindow.this.switchNavigator(0);
                return true;
            }
            if (cmdId == GOTO_FAV_CMD_ID) {
                HelpCenterWindow.this.switchNavigator(1);
                return true;
            }
            if (cmdId == CLOSE_ALL_TABS_CMD_ID) {
                this.handleMultiRemove(null);
                return true;
            }
            if (cmdId == CLOSE_OTHER_TABS_CMD_ID) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                int selPage = cTab.getSelectedPage();
                DefaultCustomTabPage currentPage = (DefaultCustomTabPage)cTab.getPage(selPage);
                this.handleMultiRemove(currentPage);
                return true;
            }
            if (cmdId == CLOSE_TAB_CMD_ID) {
                CustomTab cTab = this._scrollableTabBar.getTabs();
                int selPage = cTab.getSelectedPage();
                if (selPage != -1) {
                    cTab.removePage(selPage);
                }
                return true;
            }
            if (cmdId == 4) {
                HelpCenterWindow.getInstance().setVisible(false);
                return true;
            }
            if (cmdId == HelpSystemConstants.INCREASE_FONT_SIZE_CMD_ID) {
                this.handleFontSize(true);
                return true;
            }
            if (cmdId == HelpSystemConstants.DECREASE_FONT_SIZE_CMD_ID) {
                this.handleFontSize(false);
                return true;
            }
            return false;
        }

        public final boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId == TOGGLE_WINDOW_ON_TOP_CMD_ID) {
                action.setEnabled(true);
                return true;
            }
            return false;
        }

        private void handleFontSize(boolean increase) {
            HelpContentPanel hcp;
            if (this._currentEditor != null && this._currentEditor instanceof HelpTopicEditor && (hcp = ((HelpTopicEditor)this._currentEditor).getHelpContentPanel()) != null) {
                hcp.changeFontSize(increase);
            }
        }

        private class HelpFocusTraversalPolicy
        extends FocusTraversalPolicy {
            private HelpFocusTraversalPolicy() {
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (aComponent == HelpCenterView.this.onTopBtn) {
                    return HelpCenterView.this.viewButton;
                }
                if (aComponent == HelpCenterView.this.viewButton) {
                    return HelpCenterView.this.toolButton;
                }
                if (aComponent == HelpCenterView.this.toolButton) {
                    return HelpCenterView.this._searchField.getTextField();
                }
                if (aComponent == HelpCenterView.this._searchField || aComponent instanceof PromptedTextField) {
                    if (this.getCurrentNavigator() != null) {
                        return _helpCenterView.getNavigatorCustomTab();
                    }
                    if (HelpCenterWindow.this.getCurrentEditor() != null) {
                        return _helpCenterView.getEditorCustomTab();
                    }
                    return HelpCenterView.this.onTopBtn;
                }
                if (aComponent instanceof CustomTab) {
                    CustomTabPage ctabPage;
                    CustomTab ctab = (CustomTab)aComponent;
                    int selPage = ctab.getSelectedPage();
                    if (selPage != -1 && (ctabPage = ctab.getPage(selPage)) instanceof DefaultCustomTabPage) {
                        Object userObj = ((DefaultCustomTabPage)ctabPage).getUserObject();
                        if (userObj instanceof HelpWindow.NavigatorHolder) {
                            return this.getNavigatorFirstComponent();
                        }
                        if (userObj instanceof HelpTopicEditor) {
                            FocusTraversalPolicy policy = ((HelpTopicEditor)((Object)userObj)).getFocusTraversalPolicy();
                            Component c = policy.getComponentAfter(aContainer, aComponent);
                            return c;
                        }
                    }
                    return null;
                }
                if (aComponent instanceof TopicTreeComponent || aComponent instanceof JTree) {
                    if (HelpCenterWindow.this.getCurrentEditor() == null || _helpCenterView == null) {
                        return HelpCenterView.this.onTopBtn;
                    }
                    return _helpCenterView.getEditorCustomTab();
                }
                if (aComponent.getClass().getName().indexOf("DocPanel") != -1) {
                    return HelpCenterView.this.onTopBtn;
                }
                if (this.getNavigator(aComponent) != null) {
                    FocusTraversalPolicy policy = this.getNavigator(aComponent).getFocusTraversalPolicy();
                    Component c = policy.getComponentAfter(aContainer, aComponent);
                    if (c != null) {
                        return c;
                    }
                    return HelpCenterView.this.onTopBtn;
                }
                if (aComponent.getParent() != null && aComponent.getParent() instanceof SearchOptionsPanel) {
                    SearchOptionsPanel sop = (SearchOptionsPanel)aComponent.getParent();
                    FocusTraversalPolicy policy = sop.getFocusTraversalPolicy();
                    if (policy != null) {
                        return policy.getComponentAfter(sop, aComponent);
                    }
                } else {
                    FocusTraversalPolicy policy = null;
                    if (HelpCenterView.this._currentEditor instanceof SearchResultsEditor) {
                        policy = ((SearchResultsEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                    } else if (HelpCenterView.this._currentEditor instanceof HelpTopicEditor) {
                        policy = ((HelpTopicEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                    }
                    if (policy != null) {
                        return policy.getComponentAfter(aContainer, aComponent);
                    }
                }
                return null;
            }

            private Component getNavigatorFirstComponent() {
                Navigator navigator = this.getCurrentNavigator();
                if (navigator == null) {
                    return HelpCenterView.this.onTopBtn;
                }
                if (navigator instanceof JDevNavigator) {
                    FocusTraversalPolicy policy = ((JDevNavigator)navigator).getFocusTraversalPolicy();
                    Component c = policy.getFirstComponent((Container)navigator);
                    return c;
                }
                return null;
            }

            private Navigator getNavigator(Component c) {
                Component comp = c;
                while (comp.getParent() != null) {
                    if (!((comp = comp.getParent()) instanceof Navigator)) continue;
                    return (Navigator)comp;
                }
                return null;
            }

            private Navigator getCurrentNavigator() {
                int selPage = _helpWindow.getCustomTab().getSelectedPage();
                if (selPage != -1) {
                    DefaultCustomTabPage page = (DefaultCustomTabPage)_helpWindow.getCustomTab().getPage(selPage);
                    HelpWindow.NavigatorHolder holder = (HelpWindow.NavigatorHolder)page.getUserObject();
                    Navigator navigator = holder.getNavigator();
                    return navigator;
                }
                return null;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                if (aComponent == HelpCenterView.this.onTopBtn) {
                    return HelpCenterView.this._searchField.getTextField();
                }
                if (aComponent == HelpCenterView.this.viewButton) {
                    return HelpCenterView.this.onTopBtn;
                }
                if (aComponent == HelpCenterView.this.toolButton) {
                    return HelpCenterView.this.viewButton;
                }
                if (aComponent == HelpCenterView.this._searchField || aComponent instanceof PromptedTextField) {
                    return HelpCenterView.this.toolButton;
                }
                if (aComponent instanceof TopicTreeComponent) {
                    Navigator nav = this.getNavigator(aComponent);
                    Object c = null;
                    if (nav != null && nav instanceof JDevNavigator) {
                        FocusTraversalPolicy policy = ((JDevNavigator)nav).getFocusTraversalPolicy();
                        c = policy.getComponentBefore(aContainer, aComponent);
                    }
                    c = c == null || c == aComponent ? _helpCenterView.getNavigatorCustomTab() : HelpCenterView.this._searchField.getTextField();
                    return c;
                }
                if (aComponent.getClass().getName().indexOf("DocPanel") != -1) {
                    HelpTopicEditor hte = (HelpTopicEditor)HelpCenterView.this._currentEditor;
                    FocusTraversalPolicy policy = hte.getFocusTraversalPolicy();
                    Component c = policy.getComponentBefore(aContainer, aComponent);
                    return c;
                }
                if (this.getNavigator(aComponent) != null) {
                    Navigator nav = this.getNavigator(aComponent);
                    FocusTraversalPolicy policy = nav.getFocusTraversalPolicy();
                    Component c = policy.getComponentBefore(aContainer, aComponent);
                    if (c instanceof TopicTreeComponent || c instanceof JTree) {
                        return _helpCenterView.getNavigatorCustomTab();
                    }
                    return c;
                }
                if (aComponent.getParent() != null && aComponent.getParent() instanceof SearchOptionsPanel) {
                    SearchOptionsPanel sop = (SearchOptionsPanel)aComponent.getParent();
                    FocusTraversalPolicy policy = sop.getFocusTraversalPolicy();
                    if (policy != null) {
                        return policy.getComponentBefore(sop, aComponent);
                    }
                } else {
                    FocusTraversalPolicy policy = null;
                    if (HelpCenterView.this._currentEditor != null) {
                        if (HelpCenterView.this._currentEditor instanceof SearchResultsEditor) {
                            policy = ((SearchResultsEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                        } else if (HelpCenterView.this._currentEditor instanceof HelpTopicEditor) {
                            policy = ((HelpTopicEditor)HelpCenterView.this._currentEditor).getFocusTraversalPolicy();
                        }
                        if (policy != null) {
                            return policy.getComponentBefore(aContainer, aComponent);
                        }
                    }
                }
                return null;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return HelpCenterView.this.onTopBtn;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return HelpCenterView.this._searchField.getTextField();
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return HelpCenterView.this.onTopBtn;
            }
        }

        private class HelpSearchListener
        implements SearchListener {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void searchPerformed(SearchEvent se) {
                if (!(ModelUtil.hasLength((String)se.getSearchText()) && this.containsNonWhitespace(se.getSearchText()) || se.getSearchProgress() == null)) {
                    se.getSearchProgress().finish();
                }
                if (HelpCenterView.this._optionPanel != null && HelpCenterView.this._optionPanel.isShowing()) {
                    HelpCenterView.this._optionPanel.dismiss(true);
                    HelpCenterView.this._optionPanel = null;
                }
                HelpCenterView helpCenterView = _helpCenterView;
                synchronized (helpCenterView) {
                    String searchText = se.getSearchText().trim();
                    if (searchText != null && searchText.length() > 0) {
                        DefaultCustomTabPage removePage = HelpCenterWindow.getSearchResultsPage();
                        SearchResultsEditor resultsEditor = new SearchResultsEditor(searchText, HelpCenterWindow.getSearchModel());
                        _helpCenterView.add(resultsEditor);
                        if (removePage != null) {
                            HelpCenterWindow.removeTabPage(removePage);
                        }
                        resultsEditor.startSearch(se);
                    }
                }
            }

            public void searchCategoryChanged(SearchEvent se) {
                this.searchPerformed(se);
            }

            private boolean containsNonWhitespace(String string) {
                boolean retval = false;
                for (int i = 0; i < string.length(); ++i) {
                    if (Character.isWhitespace(string.charAt(i))) continue;
                    retval = true;
                    break;
                }
                return retval;
            }
        }
    }

    private static class MyJFrame
    extends JFrame {
        public MyJFrame(GraphicsConfiguration gc) {
            super(gc);
            this.init(this);
            this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() {
            this.setFocusTraversalPolicy(null);
            super.dispose();
            MyJFrame myJFrame = this;
            synchronized (myJFrame) {
                Ide.getMainWindow().unregisterView((View)_helpCenterView);
                HelpCenterWindow.saveLayout();
                if (_helpWindow != null) {
                    _helpWindow.dispose();
                    _windowAdapter = null;
                    if (_instanceWindow != null) {
                        WindowUtils.unregisterWindow((Window)_instanceWindow);
                        _instanceWindow.removeWindowListener(_windowAdapter);
                        ((JFrame)_instanceWindow).getContentPane().removeAll();
                        this.setRootPane(new JRootPane());
                        _instanceWindow = null;
                    }
                    if (_helpCenterView != null) {
                        _helpCenterView.dispose();
                        _helpCenterView = null;
                    }
                    _helpWindow = null;
                }
                INSTANCE = null;
            }
        }

        private void init(Window window) {
            boolean alwaysOnTop;
            _helpWindow = new HelpWindow("HelpSystemAddin.HelpWindow");
            _helpWindow.setActive(true);
            _helpWindow.setSeparateWindow(true);
            HelpOptions helpOptions = HelpOptions.getInstance();
            _userAlwaysOnTopSetting = alwaysOnTop = helpOptions.getHelpCenterWindowOnTop();
            window.setAlwaysOnTop(alwaysOnTop);
            if (_windowXPos != -1) {
                window.setSize(helpOptions.getHelpCenterWidth(), helpOptions.getHelpCenterHeight());
                window.setLocation(_windowXPos, _windowYPos);
            } else {
                int mainWindowHeight = Ide.getMainWindow().getHeight();
                window.setSize(500, mainWindowHeight);
                HelpCenterWindow.positionWindow(window, 0, window.getSize());
            }
            INSTANCE.createHelpCenterView(alwaysOnTop);
            ThemedContentPanel tcp = new ThemedContentPanel();
            tcp.setLayout(new BorderLayout());
            tcp.setBorder(new EmptyBorder(0, 0, 0, 0));
            JFrame frame = (JFrame)window;
            frame.setIconImages(Ide.getMainWindow().getBrandingIcons());
            frame.setTitle(HelpArb.getString(22));
            frame.setDefaultCloseOperation(2);
            frame.setContentPane(tcp);
            frame.getContentPane().add(_helpCenterView.getGUI(), "Center");
            HelpCenterWindow.handleMapsForExit(frame.getRootPane());
            frame.setFocusTraversalPolicy(((JPanel)_helpCenterView.getGUI()).getFocusTraversalPolicy());
            HelpCenterWindow.recreateOpenDocuments(helpOptions);
            if (helpOptions.getSplitterPosition() != -1) {
                _helpCenterView.resetSplitterPosition(helpOptions.getSplitterPosition());
            }
            Ide.getMainWindow().registerView((View)_helpCenterView);
            _windowAdapter = new HelpCenterWindowAdapter();
            window.addWindowListener(_windowAdapter);
        }

        @Override
        protected JRootPane createRootPane() {
            final MyJFrame window = this;
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    window.setVisible(false);
                    window.dispatchEvent(new WindowEvent(window, 201));
                }
            };
            JRootPane rootPane = new JRootPane();
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            rootPane.registerKeyboardAction(actionListener, stroke, 2);
            return rootPane;
        }
    }

    private class TabMouseListener
    extends MouseAdapter {
        private TabMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._showContextMenu(e);
            }
        }

        private void _showContextMenu(MouseEvent e) {
            ContextMenu cm = new ContextMenu();
            cm.addContextMenuListener(new ContextMenuListener(){

                public void menuWillShow(ContextMenu contextMenu) {
                    String label = StringUtils.stripMnemonic((String)HelpArb.getString(82));
                    IdeAction action = IdeAction.get((int)CLOSE_ALL_TABS_CMD_ID, (String)HelpCenterWindow.CLOSE_ALL_TABS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
                    action.addController((Controller)_helpCenterView);
                    JMenuItem menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem);
                    label = StringUtils.stripMnemonic((String)HelpArb.getString(83));
                    action = IdeAction.get((int)CLOSE_OTHER_TABS_CMD_ID, (String)HelpCenterWindow.CLOSE_OTHER_TABS_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
                    action.addController((Controller)_helpCenterView);
                    menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem);
                    label = StringUtils.stripMnemonic((String)HelpArb.getString(84));
                    action = IdeAction.get((int)CLOSE_TAB_CMD_ID, (String)HelpCenterWindow.CLOSE_TAB_CMD, (String)StringUtils.stripMnemonic((String)label), null, (Integer)StringUtils.getMnemonicKeyCode((String)label), null, null, (boolean)true);
                    action.addController((Controller)_helpCenterView);
                    menuItem = contextMenu.createMenuItem((ToggleAction)action);
                    contextMenu.add((Component)menuItem);
                }

                public void menuWillHide(ContextMenu contextMenu) {
                }

                public boolean handleDefaultAction(Context context) {
                    return false;
                }
            });
            Context context = new Context((View)_helpCenterView, null, null, null);
            context.setEvent((EventObject)e);
            cm.show(context);
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int pageCount;
            Object obj;
            if (e.getClickCount() == 2 && (obj = e.getSource()) instanceof CustomTab && (pageCount = ((CustomTab)obj).getPageCount()) > 0) {
                _helpCenterView.maximizeOrMinimize((CustomTab)obj);
            }
        }
    }

    private static class ThemedContentPanel
    extends JPanel {
        private Painter _painter;

        private ThemedContentPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this._painter == null && Themes.isThemed()) {
                this._painter = Themes.getActiveTheme().getStateProperties("mainwindow", "normal").getPainter("bg");
            }
            if (this._painter != null) {
                this._painter.paint(g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }
    }

    private class MyAction
    extends AbstractAction {
        private char _type;

        public MyAction(char type) {
            this._type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this._type) {
                case 'A': {
                    _helpCenterView.whenAccept();
                    break;
                }
                case 'C': {
                    _helpCenterView.whenCancel();
                    break;
                }
                case 'O': {
                    _helpCenterView.showOptionPanel();
                    break;
                }
                case 'o': {
                    _helpCenterView.showOptionPanel();
                }
            }
        }
    }

    private static class TabCloseAction
    extends AbstractAction {
        HelpCenterView _hcv;

        public TabCloseAction(HelpCenterView hcv) {
            this._hcv = hcv;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultCustomTabPage tabPage = (DefaultCustomTabPage)e.getSource();
            this._hcv.removeTabPage(tabPage);
        }

        public void dispose() {
            this._hcv = null;
        }
    }

    private static class HelpCenterWindowAdapter
    extends WindowAdapter {
        private HelpCenterWindowAdapter() {
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (INSTANCE != null && _helpWindow != null) {
                _helpWindow.getCustomTab().setFocused(true);
                if (HelpCenterWindow._helpCenterView._scrollableTabBar != null) {
                    HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs().setFocused(true);
                }
                _helpWindow.setActive(true);
                HelpCenterWindow._helpCenterView._toolbar.setActiveToolbar(true);
                HelpCenterWindow._helpCenterView._mainPanel.repaint();
                HelpCenterWindow.handleEditorsBorder("active");
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (INSTANCE != null && _helpWindow != null) {
                _helpWindow.getCustomTab().setFocused(false);
                if (HelpCenterWindow._helpCenterView._scrollableTabBar != null) {
                    HelpCenterWindow._helpCenterView._scrollableTabBar.getTabs().setFocused(false);
                }
                _helpWindow.setActive(false);
                HelpCenterWindow._helpCenterView._toolbar.setActiveToolbar(false);
                HelpCenterWindow._helpCenterView._mainPanel.repaint();
                HelpCenterWindow.handleEditorsBorder("inactive");
            }
        }
    }
}

