/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.GraphicsUtils;
import oracle.jdevimpl.help.HelpSystemConstants;

public class ContextHelpCommand
extends Command {
    private boolean _debugMode = false;

    public ContextHelpCommand() {
        super(HelpSystemConstants.CHELP_TOPICS_ID);
        try {
            String sDocDebug = Ide.getProperty((String)"oracle.jdevimpl.help.Debug", (String)"false");
            this._debugMode = Boolean.valueOf(sDocDebug);
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
    }

    public int doit() {
        try {
            Context ctxt = this.getContext();
            Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            if (comp != null && comp instanceof JComponent) {
                boolean inNbView;
                boolean searchByComp = false;
                boolean inNbDialog = this.isInNbDialog(comp);
                if (ctxt == null) {
                    searchByComp = true;
                } else if (ctxt.getView() != null && ctxt.getView().getGUI() != null) {
                    if (ctxt.getView() == Ide.getMainWindow().getIdeMainWindowView()) {
                        searchByComp = true;
                    } else if (!GraphicsUtils.isAncestorOfFocusedComponent((Component)ctxt.getView().getGUI()) && (this.isInWindowContent(comp) || inNbDialog)) {
                        searchByComp = true;
                    }
                }
                boolean bl = inNbView = this.isInNbView(ctxt) && !inNbDialog;
                if (searchByComp && !inNbView) {
                    HelpSystem.getHelpSystem().showHelp((JComponent)comp);
                    return 0;
                }
            }
            if (ctxt != null) {
                if (this._debugMode) {
                    this._dumpViewInfo(ctxt);
                }
                HelpSystem.getHelpSystem().showHelp(ctxt);
            } else {
                Assert.println((String)"Context is NULL when trying to invoke Help");
            }
        }
        catch (Exception huEx) {
            huEx.printStackTrace();
        }
        return 0;
    }

    private boolean isInNbView(Context context) {
        return context.getView() != null && context.getView().getClass().getName().indexOf("NbView") != -1;
    }

    private boolean isInNbDialog(Component c) {
        Window w;
        return c != null && (w = SwingUtilities.windowForComponent(c)).getClass().getName().contains("NbDialog");
    }

    private boolean isInWindowContent(Component c) {
        Window w = SwingUtilities.windowForComponent(c);
        if (w instanceof RootPaneContainer) {
            while (c != null) {
                Container contentPane = ((RootPaneContainer)((Object)w)).getContentPane();
                if (c == contentPane) {
                    return false;
                }
                c = c.getParent();
            }
        }
        return true;
    }

    private void _dumpViewInfo(Context c) {
        Assert.println((String)"");
        Assert.println((String)"==============================================================================");
        Assert.println((String)("View = " + c.getView().getClass().toString()));
        Assert.println((String)("ID =  " + c.getView().getId()));
        Assert.println((String)("IdeLAV = " + Ide.getMainWindow().getLastActiveView().getClass().toString()));
        Assert.println((String)"==============================================================================");
        Assert.println((String)"");
        Assert.println((String)"");
    }
}

