/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import oracle.jdevimpl.xml.dtd.parser.XMLEntity;
import oracle.jdevimpl.xml.dtd.parser.XMLReader;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXException;

class XMLExternalReader
extends XMLReader {
    XMLReader prevReader;
    int prevAbsolutePos;
    int startInput;
    boolean reservedEntity;

    public XMLExternalReader(XMLReader xmlreader) {
        this.prevReader = xmlreader;
        this.parser = xmlreader.parser;
        this.input = xmlreader.input;
        this.currentBuffer = xmlreader.currentBuffer;
        this.currentPos = xmlreader.currentPos;
        this.inputArray = xmlreader.inputArray;
        this.currentInput = xmlreader.currentInput;
        this.startInput = xmlreader.currentInput;
        this.entResolver = xmlreader.entResolver;
        this.err = xmlreader.err;
        if (this.input != null) {
            this.input.setError(this.err);
        }
        this.reservedEntity = false;
        this.absolutePos = 0;
    }

    void checkEntityEnd() throws SAXException, IOException {
        if (!this.resolveInternalEntity) {
            return;
        }
        while (this.popEntityRef()) {
        }
    }

    void checkEntityStart() throws SAXException, IOException {
        if (!this.resolveInternalEntity) {
            return;
        }
        while (this.pushEntityRef()) {
        }
    }

    @Override
    public boolean checkParEntity() throws SAXException, IOException {
        try {
            if (this.currentBuffer[this.currentPos] == '%') {
                ++this.currentPos;
                if (this.skipWhiteSpace()) {
                    return true;
                }
                --this.currentPos;
                this.pushEntityRef();
                boolean flag = this.checkParEntity();
                this.checkEntityEnd();
                return flag;
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (this.fillBuffer()) {
                return this.checkParEntity();
            }
            return false;
        }
    }

    @Override
    XMLExternalReader getExternalReader() {
        return this;
    }

    @Override
    XMLReader getInternalReader() throws SAXException, IOException {
        this.popXMLReader();
        this.prevReader.input = this.input;
        this.prevReader.currentInput = this.currentInput;
        this.prevReader.currentPos = this.currentPos;
        this.prevReader.currentBuffer = this.currentBuffer;
        this.prevReader.externalReader = false;
        this.push(' ');
        this.prevReader.absolutePos = this.absolutePos;
        return this.prevReader;
    }

    boolean popEntityRef() throws SAXException, IOException {
        if (this.startInput == this.currentInput) {
            return false;
        }
        boolean flag = this.skipWhiteSpace();
        if (this.isEOF()) {
            this.popXMLReader();
            this.push(' ');
            this.reservedEntity = false;
            return true;
        }
        if (flag) {
            this.push(' ');
        }
        return false;
    }

    boolean pushEntityRef() throws SAXException, IOException {
        if (super.tryRead(37)) {
            XMLEntity xmlentity = this.parser.parseEntity(true);
            if (xmlentity == null) {
                return false;
            }
            boolean flag = this.pushEntityRef(xmlentity);
            if (!flag && xmlentity.getName().equals("reserved")) {
                this.reservedEntity = true;
            }
            this.skipWhiteSpace();
            return flag;
        }
        return false;
    }

    @Override
    public int read() throws SAXException, IOException {
        this.checkEntityStart();
        int i = super.read();
        this.checkEntityEnd();
        return i;
    }

    @Override
    public void requireWhiteSpace() throws SAXException, IOException {
        if (!this.skipWhiteSpace() && !this.pushEntityRef()) {
            this.err.error0(190, 0);
        }
    }

    @Override
    public char[] scanComment(int[] ai) throws SAXException, IOException {
        char[] ac = super.scanComment(ai);
        this.checkEntityEnd();
        return ac;
    }

    String scanEntityRefValue() throws XMLParseException, SAXException, IOException {
        String s = "";
        String s1 = super.scanQName();
        XMLEntity xmlentity = this.parser.findEntity(s1, true);
        if (!super.tryRead(59)) {
            this.err.error1(100, 0, ";");
        }
        if (xmlentity == null) {
            this.err.error1(151, 1, s1);
            return "";
        }
        if (xmlentity.isProcessed()) {
            return xmlentity.getValue();
        }
        if (!this.pushEntityRef(xmlentity)) {
            return "";
        }
        while (true) {
            s = s.concat(super.scanEntityString(65535));
            if (super.tryRead(37)) {
                s = s.concat(this.scanEntityRefValue());
                continue;
            }
            if (this.isEOF()) break;
        }
        this.popXMLReader();
        return s;
    }

    @Override
    String scanEntityString(int i) throws SAXException, IOException {
        String s = "";
        while (true) {
            s = s.concat(super.scanEntityString(i));
            if (super.peek() == i) break;
            if (super.tryRead(37)) {
                String refValue = this.scanEntityRefValue();
                Object hashRefValue = null;
                if (!s.equals("(") && refValue != null && refValue.length() > 0 && refValue.charAt(0) == '#') {
                    int index = refValue.indexOf(124);
                    if (index != -1) {
                        hashRefValue = refValue.substring(0, index + 1);
                        refValue = refValue.substring(index + 1);
                        s = ((String)hashRefValue).concat(s);
                        s = s.concat(refValue);
                        continue;
                    }
                    hashRefValue = refValue + "|";
                    s = ((String)hashRefValue).concat(s);
                    continue;
                }
                s = s.concat(refValue);
                continue;
            }
            if (this.isEOF()) break;
        }
        return s;
    }

    @Override
    public String scanName() throws SAXException, IOException {
        this.checkEntityStart();
        String s = super.scanName();
        this.checkEntityEnd();
        return s;
    }

    @Override
    public String scanNmToken() throws SAXException, IOException {
        this.checkEntityStart();
        String s = super.scanNmToken();
        this.checkEntityEnd();
        return s;
    }

    @Override
    public String scanPI() throws SAXException, IOException {
        String s = super.scanPI();
        this.checkEntityEnd();
        return s;
    }

    @Override
    public String scanQName() throws SAXException, IOException {
        String s = null;
        this.checkEntityStart();
        if (this.reservedEntity) {
            this.reservedEntity = false;
        } else {
            s = super.scanQName();
        }
        this.checkEntityEnd();
        return s;
    }

    @Override
    public String scanQName(String[] as) throws SAXException, IOException {
        this.checkEntityStart();
        String s = super.scanQName(as);
        this.checkEntityEnd();
        return s;
    }

    @Override
    public String scanQuotedString() throws SAXException, IOException {
        this.checkEntityStart();
        String s = super.scanQuotedString();
        this.checkEntityEnd();
        return s;
    }

    @Override
    public char[] scanWhiteSpace(int[] ai) throws SAXException, IOException {
        this.checkEntityStart();
        char[] ac = super.scanWhiteSpace(ai);
        this.checkEntityEnd();
        return ac;
    }

    @Override
    public void skipIgnoreSection() throws SAXException, IOException {
        while (!this.isEOF()) {
            if (super.tryRead(cCDATASTART, 0, 3)) {
                this.skipIgnoreSection();
                continue;
            }
            if (super.tryRead(cCDATAEND, 0, cCDATAEND.length)) {
                this.checkEntityEnd();
                return;
            }
            ++this.currentPos;
        }
        this.err.error0(115, 0);
        this.err.error0(193, 0);
        this.err.flushErrors();
        this.checkEntityEnd();
    }

    @Override
    public void skipQName() throws SAXException, IOException {
        super.skipQName();
        this.checkEntityEnd();
    }

    @Override
    void skipQuotedString() throws SAXException, IOException {
        super.skipQuotedString();
        this.checkEntityEnd();
    }

    @Override
    public void skipUntil(int i) throws SAXException, IOException {
        super.skipUntil(i);
        this.checkEntityEnd();
    }

    public void synchronize() {
        this.input = this.prevReader.input;
        this.currentBuffer = this.prevReader.currentBuffer;
        this.currentPos = this.prevReader.currentPos;
        this.currentInput = this.prevReader.currentInput;
        this.startInput = this.prevReader.currentInput;
    }

    @Override
    int peek() throws SAXException, IOException {
        this.checkEntityStart();
        return super.peek();
    }

    @Override
    public boolean tryRead(int i) throws SAXException, IOException {
        this.checkEntityStart();
        boolean flag = super.tryRead(i);
        this.checkEntityEnd();
        return flag;
    }

    @Override
    public boolean tryRead(char[] ac, int i, int j) throws SAXException, IOException {
        this.checkEntityStart();
        boolean flag = super.tryRead(ac, i, j);
        this.checkEntityEnd();
        return flag;
    }
}

