/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.SimpleType;
import oracle.jdeveloper.xml.dtd.grammar.DtdAttribute;
import oracle.jdeveloper.xml.dtd.grammar.DtdConstrainingFacet;
import oracle.jdeveloper.xml.dtd.grammar.DtdElement;
import oracle.jdeveloper.xml.dtd.grammar.DtdFactory;
import oracle.jdeveloper.xml.dtd.grammar.DtdLoader;
import oracle.jdeveloper.xml.dtd.grammar.DtdSimpleType;
import oracle.jdeveloper.xml.dtd.grammar.GrammarFactory;
import oracle.jdevimpl.xml.dtd.parser.AbstractDtdParser;
import oracle.jdevimpl.xml.dtd.parser.AbstractParser;
import oracle.jdevimpl.xml.dtd.parser.DtdElementContentParser;
import oracle.jdevimpl.xml.dtd.parser.XMLCharReader;
import oracle.jdevimpl.xml.dtd.parser.XMLEntity;
import oracle.jdevimpl.xml.dtd.parser.XMLReader;
import org.xml.sax.SAXException;

public class SgmlDtdParser
extends AbstractDtdParser {
    private Map<String, List<DtdAttribute>> entityAttributesMap = new HashMap<String, List<DtdAttribute>>();
    private DtdElementContentParser _contentParser;
    private static char[] cREF = new char[]{'R', 'E', 'F'};
    private static char[] cENTIT = new char[]{'E', 'N', 'T', 'I', 'T'};
    private static char[] cIES = new char[]{'I', 'E', 'S'};

    public SgmlDtdParser() {
    }

    protected SgmlDtdParser(SgmlDtdParser sgmlDtdParser) {
        super(sgmlDtdParser);
    }

    protected SgmlDtdParser(AbstractParser abstractParser, DtdLoader loader) {
        super(abstractParser, loader);
    }

    @Override
    protected void parseElementDecl() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
        boolean listOfElements = this.reader.tryRead(40);
        this.reader.skipWhiteSpace();
        String elemName = this.reader.scanQName();
        DtdElement element = this.dtdNamespaceLoader.findElement(elemName);
        if (element == null) {
            element = this.dtdNamespaceLoader.createElement(elemName);
        }
        ObjectArray<DtdElement> elements = new ObjectArray<DtdElement>();
        elements.add(element);
        this.reader.skipWhiteSpace();
        if (listOfElements) {
            while (this.reader.tryRead(124)) {
                this.reader.skipWhiteSpace();
                elemName = this.reader.scanQName();
                element = this.dtdNamespaceLoader.findElement(elemName);
                if (element == null) {
                    element = this.dtdNamespaceLoader.createElement(elemName);
                }
                elements.add(element);
                this.reader.skipWhiteSpace();
            }
            this.reader.tryRead(41);
            this.reader.skipWhiteSpace();
        }
        boolean startTagRequired = this.reader.read() == 45;
        this.reader.skipWhiteSpace();
        boolean endTagRequired = this.reader.read() == 45;
        this.reader.skipWhiteSpace();
        DtdElementContentParser.Content contentRV = this.getContentParser().parseContent(this.err, this.reader);
        ComplexType contentType = contentRV.type;
        this.reader.skipWhiteSpace();
        String elemCommentInfo = "";
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            elemCommentInfo = this.getParsedComment(true);
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            element = (DtdElement)elements.get(i);
            this.dtdNamespaceLoader.setElementDefinition(element, contentType, startTagRequired, endTagRequired);
            this.dtdNamespaceLoader.addElement(element);
            this.dtdNamespaceLoader.setDescription(element, elemCommentInfo);
        }
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            this.parseComment(true);
        }
        this.reader.skipWhiteSpace();
        if (!this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    @Override
    protected void parseWhiteSpace() throws SAXException, IOException {
        this.reader.skipWhiteSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseAttlistDecl() throws SAXException, IOException {
        this.reader.requireWhiteSpace();
        boolean elementList = this.reader.tryRead(40);
        ObjectArray<DtdElement> elements = new ObjectArray<DtdElement>();
        DtdElement element = this.parseAttlistElement();
        elements.add(element);
        if (elementList) {
            this.reader.skipWhiteSpace();
            while (!this.reader.isEOF() && this.reader.tryRead(124)) {
                elements.add(this.parseAttlistElement());
                this.parseWhiteSpace();
            }
            this.reader.tryRead(41);
        }
        boolean hadWhitespace = this.reader.skipWhiteSpace();
        LinkedList<DtdAttribute> attributes = new LinkedList<DtdAttribute>();
        this.reader.resolveInternalEntity(false);
        try {
            if (this.reader.peek() == 45) {
                hadWhitespace = this.skipToNextAttribute(hadWhitespace);
            }
            if (this.reader.peek() == 37) {
                this.reader.tryRead(37);
                XMLEntity entity = this.parseEntity(true);
                if (entity != null) {
                    if (!entity.isExternalEntity() && entity.isProcessed()) {
                        List<DtdAttribute> entityAttributes = this.entityAttributesMap.get(entity.getName());
                        if (entityAttributes == null) {
                            entityAttributes = new LinkedList<DtdAttribute>();
                            this.parseAttInList(entity.getValue(), entityAttributes);
                            this.entityAttributesMap.put(entity.getName(), entityAttributes);
                        }
                        attributes.addAll(entityAttributes);
                        hadWhitespace = this.reader.skipWhiteSpace();
                    } else {
                        this.reader.pushEntityRef(entity);
                    }
                }
            }
        }
        finally {
            this.reader.resolveInternalEntity(true);
        }
        boolean hasMoreAttributes = this.skipToNextAttribute(hadWhitespace);
        while (hasMoreAttributes) {
            this.parseAttInList(attributes);
            boolean skippedWhiteSpace = this.reader.skipWhiteSpace();
            if (!skippedWhiteSpace) {
                if (this.reader.isEOF()) {
                    this.reader.popXMLReader();
                }
                this.reader.skipWhiteSpace();
                if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
                    this.parseComment(true);
                    skippedWhiteSpace = this.reader.skipWhiteSpace();
                }
            } else if (this.reader.isEOF()) {
                this.reader.popXMLReader();
                skippedWhiteSpace = this.reader.skipWhiteSpace();
                if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
                    this.parseComment(true);
                }
                skippedWhiteSpace = this.reader.skipWhiteSpace();
            }
            hasMoreAttributes = skippedWhiteSpace && this.reader.peek() != 62;
        }
        for (int i = 0; i < elements.size(); ++i) {
            element = (DtdElement)elements.get(i);
            for (DtdAttribute attr : attributes) {
                this.dtdNamespaceLoader.addAttribute(element, attr);
            }
        }
        if (!hasMoreAttributes && !this.reader.tryRead(62)) {
            this.err.error1(100, 0, ">");
        }
    }

    private boolean skipToNextAttribute(boolean hadWhitespace) throws SAXException, IOException {
        boolean hasMoreAttributes;
        hadWhitespace = hadWhitespace || this.reader.skipWhiteSpace();
        boolean bl = hasMoreAttributes = hadWhitespace && this.reader.peek() != 62;
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            this.parseComment(true);
            hasMoreAttributes = this.reader.skipWhiteSpace() && this.reader.peek() != 62;
        }
        return hasMoreAttributes;
    }

    @Override
    protected String getNoQuotesAttrValue() throws SAXException, IOException {
        return this.parseAttrValueWithoutQuotes();
    }

    @Override
    protected int processParseEntityValue(int i) throws SAXException, IOException {
        while (i != 34 && i != 39) {
            i = this.reader.read();
        }
        return i;
    }

    private DtdElement parseAttlistElement() throws SAXException, IOException {
        this.parseWhiteSpace();
        String qName = this.reader.scanQName();
        DtdElement element = this.dtdNamespaceLoader.findElement(qName);
        if (element == null) {
            element = this.dtdNamespaceLoader.createElement(qName);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAttInList(String stringToParse, List<DtdAttribute> attributes) throws SAXException, IOException {
        XMLCharReader charreader = new XMLCharReader(stringToParse, "", "");
        XMLReader reader = new XMLReader(null, this.getError(), null);
        reader.pushXMLReader(charreader);
        XMLReader oldReader = this.getReader();
        try {
            this.setReader(reader);
            reader.skipWhiteSpace();
            do {
                this.parseAttInList(attributes);
            } while (this.skipToNextAttribute(false));
        }
        finally {
            this.setReader(oldReader);
        }
    }

    private void parseAttInList(List<DtdAttribute> attributes) throws SAXException, IOException {
        SimpleType simpleType;
        String attrName = this.reader.scanQName();
        if (attrName == null) {
            return;
        }
        AttrType attrType = this.parseAttrType();
        DtdConstrainingFacet enumFacet = null;
        if (attrType.hasEnumConstraint) {
            enumFacet = this.parseAttrEnumConstraint(attrType.attrType);
        }
        String attrValue = null;
        boolean isRequired = false;
        boolean isFixed = false;
        boolean isImplied = false;
        this.reader.skipWhiteSpace();
        if (this.reader.tryRead(35)) {
            if (this.reader.tryRead(cFIXED, 0, cFIXED.length)) {
                isFixed = true;
                this.reader.requireWhiteSpace();
            } else if (this.reader.tryRead(cREQUIRED, 0, cREQUIRED.length)) {
                isRequired = true;
            } else if (this.reader.tryRead(cIMPLIED, 0, cIMPLIED.length)) {
                isImplied = true;
            } else {
                this.err.error0(288, 0);
            }
        } else {
            attrValue = this.parseAttrValue();
        }
        if (this.isQuote()) {
            attrValue = this.parseAttrValue();
        }
        String attrDefaultValue = null;
        String attrFixedValue = null;
        if (isFixed) {
            if (attrValue == null) {
                this.err.error0(1, 0);
            }
            attrFixedValue = attrValue;
        } else {
            attrDefaultValue = attrValue;
        }
        char c = (char)this.reader.peek();
        this.reader.skipWhiteSpace();
        String attrCommentInfo = "";
        if (this.reader.tryRead(cCOMMENTSTART, 2, cCOMMENTSTART.length - 2)) {
            attrCommentInfo = this.getParsedComment(true);
        } else {
            this.reader.push(c);
        }
        if (enumFacet != null) {
            SimpleType baseType = GrammarFactory.getBuiltInType(attrType.attrType);
            DtdSimpleType dtdSimpleType = DtdFactory.getSimpleType(this.dtdNamespaceLoader, baseType);
            dtdSimpleType.addConstrainingFacet(enumFacet);
            simpleType = dtdSimpleType;
        } else {
            simpleType = GrammarFactory.getBuiltInType(attrType.attrType);
        }
        DtdAttribute attribute = this.dtdNamespaceLoader.createAttribute(attrName, isRequired, attrDefaultValue, attrFixedValue, simpleType);
        this.dtdNamespaceLoader.setDescription(attribute, attrCommentInfo);
        attributes.add(attribute);
    }

    private AttrType parseAttrType() throws SAXException, IOException {
        AttrType attrType = null;
        this.reader.requireWhiteSpace();
        switch (this.reader.peek()) {
            case 67: {
                if (!this.reader.tryRead(cCDATA, 0, cCDATA.length)) break;
                attrType = AttrType.TYPE_CDATA;
                break;
            }
            case 73: {
                if (!this.reader.tryRead(cID, 0, cID.length)) break;
                if (this.reader.tryRead(cREF, 0, 3)) {
                    if (this.reader.tryRead(83)) {
                        attrType = AttrType.TYPE_IDREFS;
                        break;
                    }
                    attrType = AttrType.TYPE_IDREF;
                    break;
                }
                attrType = AttrType.SGML_TYPE_ID;
                break;
            }
            case 69: {
                if (!this.reader.tryRead(cENTIT, 0, cENTIT.length)) break;
                if (this.reader.tryRead(89)) {
                    attrType = AttrType.TYPE_ENTITY;
                    break;
                }
                if (!this.reader.tryRead(cIES, 0, cIES.length)) break;
                attrType = AttrType.TYPE_ENTITIES;
                break;
            }
            case 78: {
                if (this.reader.tryRead(cNMTOKEN, 0, cNMTOKEN.length)) {
                    attrType = AttrType.TYPE_NMTOKENS;
                    if (this.reader.tryRead(83)) {
                        attrType = AttrType.TYPE_NMTOKENS;
                        break;
                    }
                    attrType = AttrType.TYPE_NMTOKEN;
                    break;
                }
                if (this.reader.tryRead(cNAME, 0, cNAME.length)) {
                    attrType = AttrType.TYPE_NAME;
                    this.reader.requireWhiteSpace();
                    break;
                }
                if (this.reader.tryRead(cNUMBER, 0, cNUMBER.length)) {
                    attrType = AttrType.TYPE_UNSIGNED_INT;
                    this.reader.requireWhiteSpace();
                    break;
                }
                if (!this.reader.tryRead(cNOTATION, 0, cNOTATION.length)) break;
                attrType = AttrType.TYPE_NOTATION;
                this.reader.requireWhiteSpace();
                break;
            }
            case 40: {
                this.reader.tryRead(40);
                attrType = AttrType.TYPE_LIST;
            }
        }
        if (attrType == null) {
            this.err.error0(133, 0);
            attrType = AttrType.TYPE_CDATA;
        }
        return attrType;
    }

    private DtdConstrainingFacet parseAttrEnumConstraint(int attrType) throws SAXException, IOException {
        DtdConstrainingFacet enumFacet = DtdFactory.getConstrainingFacet(this.dtdNamespaceLoader, 10);
        if (attrType == 9 && !this.reader.tryRead(40)) {
            this.err.error1(100, 0, "(");
        }
        while (!this.reader.isEOF()) {
            String listValue;
            this.reader.skipWhiteSpace();
            String string = listValue = attrType == 9 ? this.reader.scanQName() : this.reader.scanNmToken();
            if (listValue.isEmpty()) {
                char nextChar;
                boolean shouldContinue = false;
                do {
                    if ((nextChar = (char)this.reader.read()) != '|') continue;
                    shouldContinue = true;
                    break;
                } while (nextChar != ')' && !this.reader.isEOF());
                if (!shouldContinue) break;
                continue;
            }
            try {
                enumFacet.setValue(listValue);
            }
            catch (Exception e) {
                this.err.error0(1, 0);
            }
            this.reader.skipWhiteSpace();
            if (this.reader.tryRead(124)) continue;
            if (this.reader.tryRead(41)) break;
            this.err.error2(101, 0, ")", "|");
        }
        return enumFacet;
    }

    private DtdElementContentParser getContentParser() {
        if (this._contentParser == null) {
            this._contentParser = new DtdElementContentParser(this.dtdNamespaceLoader, false);
        }
        return this._contentParser;
    }

    private static String getContentString(ComplexType type) {
        switch (type.getDerivationMethod()) {
            case 2: {
                return SgmlDtdParser.getGroupString(type.getContentGroup());
            }
            case 0: {
                String baseGroup = SgmlDtdParser.getGroupString(((ComplexType)type.getBaseType()).getContentGroup());
                String inclusion = " +" + SgmlDtdParser.getGroupString(type.getContentGroup());
                return baseGroup + inclusion;
            }
            case 1: {
                String baseGroup = SgmlDtdParser.getGroupString(((ComplexType)type.getBaseType()).getContentGroup());
                String exclusion = " -" + SgmlDtdParser.getGroupString(type.getContentGroup());
                return baseGroup + exclusion;
            }
        }
        return "#ANY";
    }

    private static String getGroupString(ContentGroup group) {
        if (group != null) {
            return group.toString();
        }
        return "EMPTY";
    }

    private static class ObjectArray<T> {
        private Object[] array;
        private int curCount;

        public ObjectArray() {
            this(5);
        }

        public ObjectArray(int i) {
            this.array = new Object[i];
        }

        public void add(T obj) {
            int i = this.array.length;
            if (i <= this.curCount) {
                Object[] aobj = new Object[i * 2 + 1];
                System.arraycopy(this.array, 0, aobj, 0, i);
                this.array = aobj;
            }
            this.array[this.curCount++] = obj;
        }

        public T get(int i) {
            return (T)this.array[i];
        }

        public int size() {
            return this.curCount;
        }
    }

    private static enum AttrType {
        TYPE_CDATA(3),
        TYPE_IDREFS(6),
        TYPE_IDREF(1),
        SGML_TYPE_ID(0),
        TYPE_ENTITY(2),
        TYPE_ENTITIES(7),
        TYPE_NMTOKENS(8),
        TYPE_NMTOKEN(5),
        TYPE_NAME(4),
        TYPE_UNSIGNED_INT(10),
        TYPE_NOTATION(9, true),
        TYPE_LIST(3, true);

        int attrType;
        boolean hasEnumConstraint;

        private AttrType(int type) {
            this.attrType = type;
        }

        private AttrType(int type, boolean hasEnumConstraint) {
            this.attrType = type;
            this.hasEnumConstraint = hasEnumConstraint;
        }
    }
}

