/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.dtd.parser;

import java.io.PrintStream;
import java.io.PrintWriter;
import oracle.jdevimpl.xml.dtd.parser.BaseParserError;
import org.xml.sax.SAXParseException;

public class ParseException
extends SAXParseException {
    private BaseParserError error;
    private int type;
    public static final int ERROR = 1;
    public static final int FATAL_ERROR = 0;
    public static final int WARNING = 2;

    public ParseException(String message, String publicId, String systemId, int lineNumber, int columnNumber, int type) {
        super(message, publicId, systemId, lineNumber, columnNumber);
        this.type = type;
    }

    public ParseException(BaseParserError error, int errId) {
        super(error.formatErrorMesg(errId), error.getPublicId(errId), error.getSystemId(errId), error.getLineNumber(errId), error.getColumnNumber(errId), error.getException(errId));
        this.error = error;
    }

    public ParseException(BaseParserError error, int errId, Exception exception) {
        super(error.formatErrorMesg(errId), error.getPublicId(errId), error.getSystemId(errId), error.getLineNumber(errId), error.getColumnNumber(errId), exception);
        this.error = error;
    }

    public ParseException(BaseParserError error, Exception exception) {
        super(error.formatErrorMesg(0), error.getPublicId(0), error.getSystemId(0), error.getLineNumber(0), error.getColumnNumber(0), exception);
        this.error = error;
    }

    public String formatErrorMessage(int i) {
        if (this.error == null) {
            return this.getMessage();
        }
        return this.error.formatErrorMesg(i);
    }

    public int getColumnNumber(int i) {
        if (this.error == null) {
            return 0;
        }
        return this.error.col[i];
    }

    public Exception getException(int i) {
        if (this.error == null) {
            return this.getException();
        }
        return this.error.exp[i];
    }

    public int getLineNumber(int i) {
        if (this.error == null) {
            return 0;
        }
        return this.error.line[i];
    }

    public String getMessage(int i) {
        if (this.error == null) {
            return this.getMessage();
        }
        return this.error.mesg[i];
    }

    public int getMessageType(int i) {
        if (this.error == null) {
            return this.type;
        }
        return this.error.types[i];
    }

    public int getNumMessages() {
        if (this.error == null) {
            return 1;
        }
        return this.error.nerrors;
    }

    public String getPublicId(int i) {
        if (this.error == null) {
            return this.getPublicId();
        }
        return this.error.pubId[i];
    }

    public String getSystemId(int i) {
        if (this.error == null) {
            return null;
        }
        return this.error.sysId[i];
    }

    public BaseParserError getParserError() {
        return this.error;
    }

    @Override
    public void printStackTrace() {
        if (this.getException() != null) {
            this.getException().printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream printstream) {
        if (this.getException() != null) {
            this.getException().printStackTrace(printstream);
        } else {
            super.printStackTrace(printstream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter printwriter) {
        if (this.getException() != null) {
            this.getException().printStackTrace(printwriter);
        } else {
            super.printStackTrace(printwriter);
        }
    }

    @Override
    public String toString() {
        if (this.getException() != null) {
            return this.getException().toString();
        }
        return super.toString();
    }
}

