/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.xml.dtd.grammar;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bali.xml.grammar.ConstrainingFacet;
import oracle.jdeveloper.xml.dtd.grammar.DtdFactory;
import oracle.xml.parser.schema.XSDTypeConstants;

public class DtdConstrainingFacet
implements ConstrainingFacet {
    private int facetID;
    private String name;
    private int intValue;
    private String strValue;
    private boolean caseSensitive;
    private Collection enumeration;
    private Collection enumerationForCompare;

    DtdConstrainingFacet(int id) {
        this.facetID = id;
        this.name = XSDTypeConstants.sFacets[DtdFactory.schemaToParserFacetID(id)];
    }

    public void addEnumeration(String enumValue) throws Exception {
        if (this.facetID != 10) {
            throw new Exception("");
        }
        if (this.enumeration == null) {
            this.enumeration = new ArrayList();
            this.enumerationForCompare = new ArrayList();
        }
        this.enumeration.add(enumValue);
        this.enumerationForCompare.add(this.caseSensitive ? enumValue : enumValue.toLowerCase());
    }

    public void setValue(String value) throws Exception {
        switch (this.facetID) {
            case 10: {
                if (this.enumeration == null) {
                    this.enumeration = new ArrayList();
                    this.enumerationForCompare = new ArrayList();
                }
                this.enumeration.add(value);
                this.enumerationForCompare.add(this.caseSensitive ? value : value.toLowerCase());
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.strValue = value;
                this.intValue = Integer.parseInt(value);
                return;
            }
            case 7: 
            case 8: 
            case 9: {
                this.intValue = Integer.parseInt(value);
                return;
            }
            case 12: {
                String s1 = value.intern();
                if (s1 != "preserve" && s1 != "replace" && s1 != "collapse") {
                    throw new Exception("");
                }
                return;
            }
        }
        throw new Exception("");
    }

    void validateValue(String value) throws Exception {
        switch (this.facetID) {
            case 12: {
                return;
            }
            case 10: {
                if (this.enumerationForCompare == null || !this.enumerationForCompare.contains(this.caseSensitive ? value : value.toLowerCase())) {
                    throw new Exception("");
                }
                return;
            }
        }
    }

    void validateValue(int value) throws Exception {
        switch (this.facetID) {
            case 2: {
                if (value <= this.intValue) {
                    throw new Exception("");
                }
                return;
            }
            case 1: {
                if (value < this.intValue) {
                    throw new Exception("");
                }
                return;
            }
            case 4: {
                if (value >= this.intValue) {
                    throw new Exception("");
                }
                return;
            }
            case 3: {
                if (value <= this.intValue) break;
                throw new Exception("");
            }
        }
    }

    void validateLength(int length) throws Exception {
        switch (this.facetID) {
            case 7: {
                if (length != this.intValue) {
                    throw new Exception("");
                }
                return;
            }
            case 9: {
                if (length < this.intValue) {
                    throw new Exception("");
                }
                return;
            }
            case 8: {
                if (length > this.intValue) {
                    throw new Exception("");
                }
                return;
            }
        }
    }

    public int getIntConstraintValue() {
        return this.intValue;
    }

    boolean isMoreRestrictive(DtdConstrainingFacet otherFacet) {
        switch (this.facetID) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return this.intValue < otherFacet.intValue;
            }
            case 1: 
            case 2: 
            case 9: {
                return this.intValue > otherFacet.intValue;
            }
        }
        return false;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getFacetID() {
        return this.facetID;
    }

    @Override
    public String getConstraintValue() {
        return this.strValue;
    }

    @Override
    public Collection getEnumerationValues() {
        return this.enumeration;
    }
}

