/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationErrorLog
implements ErrorHandler {
    private ArrayList _errors;
    private ArrayList _fatalErrors;
    private ArrayList _warnings;

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        if (this._warnings == null) {
            this._warnings = new ArrayList();
        }
        this._warnings.add(exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        if (this._errors == null) {
            this._errors = new ArrayList();
        }
        this._errors.add(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        if (this._fatalErrors == null) {
            this._fatalErrors = new ArrayList();
        }
        this._fatalErrors.add(exception);
    }

    public void flushErrors() {
        this._errors = null;
        this._fatalErrors = null;
        this._warnings = null;
    }

    public boolean hasErrors() {
        return this._errors != null && !this._errors.isEmpty() || this._fatalErrors != null && !this._fatalErrors.isEmpty();
    }

    public boolean hasWarnings() {
        return this.hasErrors() || this._warnings != null && !this._warnings.isEmpty();
    }

    public List getErrors() {
        return this._immutable(this._errors);
    }

    public List getFatalErrors() {
        return this._immutable(this._fatalErrors);
    }

    public List getWarnings() {
        return this._immutable(this._warnings);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ValidationErrorLog other = (ValidationErrorLog)o;
        return !this.hasWarnings() && !other.hasWarnings();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.getFatalErrors());
        buf.append(",\n");
        buf.append(this.getErrors());
        buf.append(",\n");
        buf.append(this.getWarnings());
        buf.append("]");
        return buf.toString();
    }

    private List _immutable(List in) {
        if (in == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(in);
    }
}

