/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.validator.ValidationException;
import org.w3c.dom.Node;

public class UniqueException
extends ValidationException {
    public static final int TYPE_UNIQUE_IN_FILE = 100;
    public static final int TYPE_UNIQUE_IN_MULTIPLE_FILES = 101;
    public static final int TYPE_UNIQUE_XPATH_EXPRESSION = 102;
    public static final int TYPE_UNIQUE_COMBINATION_OF_CHILDREN = 103;
    public static final String XML_TYPE_UNIQUE_IN_FILE = "XML-TYPE-UNIQUE-IN-FILE";
    public static final String XML_TYPE_UNIQUE_IN_MULTIPLE_FILES = "XML-TYPE-UNIQUE-IN-MULTIPLE-FILES";
    public static final String XML_TYPE_UNIQUE_XPATH_EXPRESSION = "XML-TYPE-UNIQUE-XPATH-EXPRESSION";
    public static final String XML_TYPE_UNIQUE_COMBINATION_OF_CHILDREN = "XML-TYPE-UNIQUE-COMBINATION-OF-CHILDREN";
    private static final Map<Integer, String> _exceptionTypeMap = new HashMap<Integer, String>();

    public UniqueException(int type, String message, Node invalidNode) {
        this(type, message, invalidNode, null, null);
    }

    public UniqueException(int type, String message, Node invalidNode, Exception source) {
        this(type, message, invalidNode, source, null);
    }

    public UniqueException(int type, String message, Node invalidNode, List duplicateNodes) {
        this(type, message, invalidNode, null, duplicateNodes);
    }

    public UniqueException(int type, String message, Node invalidNode, Exception source, List duplicateNodes) {
        super(type, message, invalidNode, source);
        if (duplicateNodes != null) {
            this.setRelatedObject(Collections.unmodifiableList(duplicateNodes));
        }
    }

    public List getDuplicateNodes() {
        Object related = super.getRelatedObject();
        return related instanceof List ? (List)related : null;
    }

    @Override
    public String getTypeString() {
        return _exceptionTypeMap.get(this.getType());
    }

    static {
        _exceptionTypeMap.put(100, XML_TYPE_UNIQUE_IN_FILE);
        _exceptionTypeMap.put(101, XML_TYPE_UNIQUE_IN_MULTIPLE_FILES);
        _exceptionTypeMap.put(102, XML_TYPE_UNIQUE_XPATH_EXPRESSION);
        _exceptionTypeMap.put(103, XML_TYPE_UNIQUE_COMBINATION_OF_CHILDREN);
    }
}

