/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.validator;

import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.IdentityConstraint;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.util.xpath.XPathEvaluator;
import oracle.bali.xml.util.xpath.XPathUtils;
import oracle.bali.xml.validator.PerValidationState;
import oracle.bali.xml.validator.UniqueException;
import oracle.bali.xml.validator.ValidationContext;
import oracle.bali.xml.validator.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class IdentityConstraintValidation {
    public static void validateConstraints(Element element, ElementDef elementDef, ValidationContext validationContext, PerValidationState validationState) {
        XPathEvaluator xPathEvaluator = validationContext.getXPathEvaluator();
        for (IdentityConstraint identityConstraint : elementDef.getIdentityConstraints()) {
            xPathEvaluator.setPrefixNamespaceMap(identityConstraint.getPrefixNamespaceMap());
            if (identityConstraint.getType().equals((Object)IdentityConstraint.ConstraintType.UNIQUE)) {
                IdentityConstraintValidation.checkForDuplicateNodes(element, identityConstraint, xPathEvaluator, validationContext, validationState);
                continue;
            }
            if (identityConstraint.getType().equals((Object)IdentityConstraint.ConstraintType.KEY)) {
                IdentityConstraintValidation.checkForDuplicateNodes(element, identityConstraint, xPathEvaluator, validationContext, validationState);
                continue;
            }
            if (!identityConstraint.getType().equals((Object)IdentityConstraint.ConstraintType.KEYREF)) continue;
            IdentityConstraintValidation.keyRefValidation(element, identityConstraint, xPathEvaluator, validationContext, validationState);
        }
    }

    public static List<Node> checkForDuplicateNodes(Node contextNode, IdentityConstraint identityConstraint, XPathEvaluator xPathEvaluator, ValidationContext validationContext, PerValidationState validationState) {
        ArrayList<Node> duplicateNodes = new ArrayList<Node>();
        HashSet<CallSite> compositeKeySet = new HashSet<CallSite>();
        Collection<Node> selectedNodeCollection = XPathUtils.findNodes(identityConstraint.getSelector(), contextNode, null, xPathEvaluator);
        for (Node selectedNode : selectedNodeCollection) {
            String compositeKey = null;
            int keyNum = 0;
            List<Node> valueNodes = XPathUtils.getValueNodes(selectedNode, identityConstraint.getFields(), xPathEvaluator);
            Node firstValueNode = null;
            boolean errorReported = false;
            for (Node valueNode : valueNodes) {
                if (firstValueNode == null) {
                    firstValueNode = valueNode;
                }
                String nodeValue = null;
                if (valueNode != null) {
                    nodeValue = DomUtils.getTextNodeValue(valueNode);
                }
                if (nodeValue == null && identityConstraint.getType().equals((Object)IdentityConstraint.ConstraintType.UNIQUE)) continue;
                if ((nodeValue == null || nodeValue.isEmpty()) && identityConstraint.getType().equals((Object)IdentityConstraint.ConstraintType.KEY)) {
                    IdentityConstraintValidation._reportError(valueNode, selectedNode, contextNode, "KEYREF_KEY_IS_NULL_OR_BLANK", Collections.singletonList(selectedNode), identityConstraint, validationContext, validationState);
                    errorReported = true;
                    continue;
                }
                compositeKey = compositeKey == null ? "key" + keyNum + "[" + nodeValue + "]" : compositeKey + "key" + keyNum + "[" + nodeValue + "]";
                ++keyNum;
            }
            if (compositeKey == null || errorReported) continue;
            if (compositeKeySet.contains(compositeKey)) {
                duplicateNodes.add(selectedNode);
                IdentityConstraintValidation._reportError(firstValueNode, selectedNode, contextNode, "UNIQUE_IDENTITY_CONSTRAINT_VIOLATION", valueNodes, identityConstraint, validationContext, validationState);
            }
            compositeKeySet.add((CallSite)((Object)compositeKey));
        }
        return duplicateNodes;
    }

    public static List<Node> keyRefValidation(Node contextNode, IdentityConstraint keyRefIdentityConstraint, XPathEvaluator xPathEvaluator, ValidationContext validationContext, PerValidationState validationState) {
        ArrayList<Node> invalidNodes = new ArrayList<Node>();
        if (keyRefIdentityConstraint.getKeyIdentityConstraint() == null) {
            return Collections.emptyList();
        }
        Collection<Node> keyNodeCollection = IdentityConstraintValidation._getKeyNodeCollection(keyRefIdentityConstraint.getKeyIdentityConstraint(), contextNode, xPathEvaluator);
        Collection<Node> selectedNodesCollection = XPathUtils.findNodes(keyRefIdentityConstraint.getSelector(), contextNode, null, xPathEvaluator);
        if (selectedNodesCollection.isEmpty()) {
            return Collections.emptyList();
        }
        for (Node selectedNode : selectedNodesCollection) {
            if (XPathUtils.getNodeValues(selectedNode, keyRefIdentityConstraint.getFields(), xPathEvaluator).size() == 0) continue;
            boolean validKeyReference = false;
            for (Node keyNode : keyNodeCollection) {
                if (!XPathUtils.nodesHaveEqualValues(keyNode, keyRefIdentityConstraint.getKeyIdentityConstraint().getFields(), selectedNode, keyRefIdentityConstraint.getFields(), xPathEvaluator)) continue;
                validKeyReference = true;
                break;
            }
            if (validKeyReference) continue;
            invalidNodes.add(selectedNode);
            List<Node> valueNodeList = XPathUtils.getValueNodes(selectedNode, keyRefIdentityConstraint.getFields(), xPathEvaluator);
            IdentityConstraintValidation._reportError(valueNodeList.iterator().next(), selectedNode, contextNode, "KEYREF_IDENTITY_CONSTRAINT_VIOLATION", Collections.singletonList(selectedNode), keyRefIdentityConstraint, validationContext, validationState);
        }
        return invalidNodes;
    }

    private static Collection<Node> _getKeyNodeCollection(IdentityConstraint keyIdentityConstraint, Node contextNode, XPathEvaluator xPathEvaluator) {
        QualifiedName keyQualifiedName = keyIdentityConstraint.getParentElementDef().getQualifiedName();
        String selectorExpression = null;
        if (IdentityConstraintValidation._isRootNodeIdentityConstraint(keyIdentityConstraint, contextNode.getOwnerDocument())) {
            Collection<Node> keyNodeCollection = XPathUtils.findNodes(keyIdentityConstraint.getSelector(), contextNode.getOwnerDocument().getDocumentElement(), null, xPathEvaluator);
            return keyNodeCollection;
        }
        String namespace = keyQualifiedName.getNamespace();
        selectorExpression = "//" + keyQualifiedName.getName();
        if (namespace != null) {
            String namespacePrefix = null;
            Map<String, String> namespacePrefixMap = keyIdentityConstraint.getPrefixNamespaceMap();
            for (Map.Entry<String, String> entry : namespacePrefixMap.entrySet()) {
                if (!namespace.equalsIgnoreCase(entry.getValue())) continue;
                namespacePrefix = entry.getKey();
            }
            if (namespacePrefix != null) {
                selectorExpression = "//" + namespacePrefix + ":" + keyQualifiedName.getName();
            }
        }
        Collection<Node> identityConstraintParentNodeCollection = XPathUtils.findNodes(selectorExpression, contextNode, null, xPathEvaluator);
        ArrayList<Node> keyNodeCollection = new ArrayList<Node>();
        for (Node parentNode : identityConstraintParentNodeCollection) {
            Collection<Node> tempCollection = XPathUtils.findNodes(keyIdentityConstraint.getSelector(), parentNode, contextNode, xPathEvaluator);
            keyNodeCollection.addAll(tempCollection);
        }
        return keyNodeCollection;
    }

    private static boolean _isRootNodeIdentityConstraint(IdentityConstraint keyIdentityConstraint, Document document) {
        QualifiedName keyQualifiedName = keyIdentityConstraint.getParentElementDef().getQualifiedName();
        Element rootNode = document.getDocumentElement();
        boolean rootNodeIdentityConstraint = false;
        if (rootNode.getNamespaceURI() == null) {
            if (rootNode.getLocalName().equals(keyQualifiedName.getName())) {
                rootNodeIdentityConstraint = true;
            }
        } else if (rootNode.getNamespaceURI().equals(keyQualifiedName.getNamespace()) && rootNode.getLocalName().equals(keyQualifiedName.getName())) {
            rootNodeIdentityConstraint = true;
        }
        return rootNodeIdentityConstraint;
    }

    private static void _reportError(Node valueNode, Node invalidNode, Node contextNode, String errorCode, List<Node> invalidNodeList, IdentityConstraint identityConstraint, ValidationContext validationContext, PerValidationState validationState) {
        Object[] attrs = new String[]{valueNode == null ? "" : DomUtils.getTextNodeValue(valueNode), invalidNode == null ? "" : invalidNode.getLocalName(), valueNode == null ? "" : valueNode.getLocalName(), contextNode == null ? "" : contextNode.getLocalName(), identityConstraint.getSelector(), identityConstraint.getFields() == null ? "" : identityConstraint.getFields().toString(), identityConstraint.getRefer() == null ? "" : identityConstraint.getRefer().toString()};
        UniqueException ue = new UniqueException(102, MessageFormat.format(Validator.getTranslatedString(errorCode), attrs), valueNode == null ? invalidNode : valueNode, invalidNodeList);
        validationContext.reportError(validationState, ue);
    }
}

