/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NullKeyConcurrentHashMapDecorator<K, V>
implements ConcurrentMap<K, V> {
    private K _nullKeyReplacementValue;
    private ConcurrentHashMap<K, V> _concurrentHashMap;

    public NullKeyConcurrentHashMapDecorator(ConcurrentHashMap<K, V> concurrentHashMap, K nullKeyReplacementValue) {
        this._concurrentHashMap = concurrentHashMap;
        this._nullKeyReplacementValue = nullKeyReplacementValue;
    }

    @Override
    public V get(Object key) {
        return this.getConcurrentHashMap().get(this._getNullKeyReplacement(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getConcurrentHashMap().containsKey(this._getNullKeyReplacement(key));
    }

    @Override
    public V put(K key, V value) {
        return this.getConcurrentHashMap().put(this._getNullKeyReplacement(key), value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.getConcurrentHashMap().putIfAbsent(this._getNullKeyReplacement(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.getConcurrentHashMap().remove(this._getNullKeyReplacement(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.getConcurrentHashMap().remove(this._getNullKeyReplacement(key), value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.getConcurrentHashMap().replace(this._getNullKeyReplacement(key), oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.getConcurrentHashMap().replace(this._getNullKeyReplacement(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.getConcurrentHashMap().put(this._getNullKeyReplacement(e.getKey()), e.getValue());
        }
    }

    @Override
    public int size() {
        return this.getConcurrentHashMap().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getConcurrentHashMap().isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getConcurrentHashMap().containsValue(value);
    }

    @Override
    public void clear() {
        this.getConcurrentHashMap().clear();
    }

    @Override
    public Collection<V> values() {
        return this.getConcurrentHashMap().values();
    }

    @Override
    public Set<K> keySet() {
        return new KeySetDecorator(this.getConcurrentHashMap().keySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySetDecorator<Map.Entry<K, V>>(this.getConcurrentHashMap().entrySet());
    }

    protected ConcurrentHashMap<K, V> getConcurrentHashMap() {
        return this._concurrentHashMap;
    }

    private Object _getNullKeyReplacement(Object key) {
        if (key == null) {
            return this._nullKeyReplacementValue;
        }
        return key;
    }

    private class KeySetDecorator<E>
    extends AbstractSetDecorator<E> {
        public KeySetDecorator(Set<E> origSet) {
            super(origSet);
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return this.getOrigSet().contains(NullKeyConcurrentHashMapDecorator.this._nullKeyReplacementValue);
            }
            return this.getOrigSet().contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new KeySetIteratorDecorator(this.getOrigSet().iterator());
        }

        @Override
        public boolean add(E e) {
            return this.getOrigSet().add(NullKeyConcurrentHashMapDecorator.this._getNullKeyReplacement(e));
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return this.getOrigSet().remove(NullKeyConcurrentHashMapDecorator.this._nullKeyReplacementValue);
            }
            return this.getOrigSet().remove(o);
        }
    }

    private class EntrySetDecorator<E>
    extends AbstractSetDecorator<E> {
        public EntrySetDecorator(Set<E> origSet) {
            super(origSet);
        }

        @Override
        public Iterator<E> iterator() {
            return new EntrySetIteratorDecorator(this.getOrigSet().iterator());
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object key = ((Map.Entry)o).getKey();
            Object value = ((Map.Entry)o).getValue();
            EntryItem entryItem = new EntryItem(NullKeyConcurrentHashMapDecorator.this._getNullKeyReplacement(key), value);
            return this.getOrigSet().contains(entryItem);
        }

        @Override
        public boolean add(E e) {
            Map.Entry entry;
            Object key;
            if (e instanceof Map.Entry && (key = (entry = (Map.Entry)e).getKey()) == null) {
                EntryItem keyEntry = new EntryItem(NullKeyConcurrentHashMapDecorator.this._nullKeyReplacementValue, entry.getValue());
                return this.getOrigSet().add(keyEntry);
            }
            return this.getOrigSet().add(e);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object key = ((Map.Entry)o).getKey();
            Object value = ((Map.Entry)o).getValue();
            EntryItem entryItem = new EntryItem(NullKeyConcurrentHashMapDecorator.this._getNullKeyReplacement(key), value);
            return this.getOrigSet().remove(entryItem);
        }
    }

    private class EntryItem
    extends AbstractMap.SimpleEntry<K, V> {
        EntryItem(K k, V v) {
            super(k, v);
        }
    }

    private class EntrySetIteratorDecorator<E>
    implements Iterator<E> {
        private Iterator<E> _origEntrySetIterator;

        public EntrySetIteratorDecorator(Iterator<E> origEntrySetIterator) {
            this._origEntrySetIterator = origEntrySetIterator;
        }

        @Override
        public boolean hasNext() {
            return this._origEntrySetIterator.hasNext();
        }

        @Override
        public E next() {
            Map.Entry entry;
            Object key;
            E nextEntry = this._origEntrySetIterator.next();
            if (nextEntry instanceof Map.Entry && (key = (entry = (Map.Entry)nextEntry).getKey()).equals(NullKeyConcurrentHashMapDecorator.this._nullKeyReplacementValue)) {
                EntryItem nullKeyEntry = new EntryItem(null, entry.getValue());
                return (E)nullKeyEntry;
            }
            return nextEntry;
        }

        @Override
        public void remove() {
            this._origEntrySetIterator.remove();
        }
    }

    private class KeySetIteratorDecorator<E>
    implements Iterator<E> {
        private Iterator<E> _origKeySetIterator;

        public KeySetIteratorDecorator(Iterator<E> origKeySetIterator) {
            this._origKeySetIterator = origKeySetIterator;
        }

        @Override
        public boolean hasNext() {
            return this._origKeySetIterator.hasNext();
        }

        @Override
        public E next() {
            E nextKey = this._origKeySetIterator.next();
            if (nextKey.equals(NullKeyConcurrentHashMapDecorator.this._nullKeyReplacementValue)) {
                return null;
            }
            return nextKey;
        }

        @Override
        public void remove() {
            this._origKeySetIterator.remove();
        }
    }

    private abstract class AbstractSetDecorator<E>
    implements Set<E> {
        private Set<E> _origSet;

        public AbstractSetDecorator(Set<E> origSet) {
            this._origSet = origSet;
        }

        @Override
        public int size() {
            return this.getOrigSet().size();
        }

        @Override
        public boolean isEmpty() {
            return this.getOrigSet().isEmpty();
        }

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public Object[] toArray() {
            return this.getOrigSet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.getOrigSet().toArray(a);
        }

        @Override
        public abstract boolean add(E var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public boolean containsAll(Collection<?> c) {
            Iterator<?> e = c.iterator();
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            boolean modified = false;
            Iterator<E> e = c.iterator();
            while (e.hasNext()) {
                if (!this.add(e.next())) continue;
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean modified = false;
            Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                if (c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<E> e = this.iterator();
            while (e.hasNext()) {
                if (!c.contains(e.next())) continue;
                e.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public void clear() {
            this.getOrigSet().clear();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (E obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        protected Set<E> getOrigSet() {
            return this._origSet;
        }
    }
}

