/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXmlReader
implements XMLReader {
    private static final DefaultHandler _DEFAULT_HANDLER = new DefaultHandler();
    private EntityResolver _entityResolver = _DEFAULT_HANDLER;
    private DTDHandler _dtdHandler = _DEFAULT_HANDLER;
    private ContentHandler _contentHandler = _DEFAULT_HANDLER;
    private ErrorHandler _errorHandler = _DEFAULT_HANDLER;

    protected AbstractXmlReader() {
    }

    @Override
    public abstract void parse(InputSource var1) throws IOException, SAXException;

    @Override
    public abstract boolean getFeature(String var1) throws SAXNotRecognizedException, SAXNotSupportedException;

    @Override
    public abstract void setFeature(String var1, boolean var2) throws SAXNotRecognizedException, SAXNotSupportedException;

    @Override
    public abstract Object getProperty(String var1) throws SAXNotRecognizedException, SAXNotSupportedException;

    @Override
    public abstract void setProperty(String var1, Object var2) throws SAXNotRecognizedException, SAXNotSupportedException;

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver == null ? _DEFAULT_HANDLER : resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler == null ? _DEFAULT_HANDLER : handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler == null ? _DEFAULT_HANDLER : handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this._errorHandler = handler == null ? _DEFAULT_HANDLER : handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }
}

