/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;

public class MetadataFileGenerator {
    private GrammarResolver _gResolver;
    private MetadataProvider _mProvider;
    private Set<QualifiedName> _mdQNames;
    private final Map<String, String> _prefixMap = new HashMap<String, String>();

    public MetadataFileGenerator() {
        this(null, null, null);
    }

    public MetadataFileGenerator(GrammarResolver gResolver, MetadataProvider mProvider, Set<QualifiedName> mdQNames) {
        this._gResolver = gResolver;
        this._mProvider = mProvider;
        this._mdQNames = mdQNames;
        if (this._mdQNames == null) {
            this._mdQNames = Collections.emptySet();
        }
    }

    public void generate(StringBuffer buffer, Grammar g, String startingRoot) {
        this._prefixMap.put("http://xmlns.oracle.com/bali/xml/metadata", "md");
        this._prefixMap.put("http://xmlns.oracle.com/bali/xml/metadata/model", "mmd");
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<grammarMetadata xmlns=\"http://xmlns.oracle.com/bali/xml/metadata\"\n");
        buffer.append("                 xmlns:md=\"http://xmlns.oracle.com/bali/xml/metadata\"\n");
        buffer.append("                 xmlns:mmd=\"http://xmlns.oracle.com/bali/xml/metadata/model\"\n");
        if (g.getTargetNamespace() != null) {
            buffer.append("                 namespace=\"");
            buffer.append(g.getTargetNamespace());
            buffer.append("\">\n");
        } else {
            buffer.append(">\n");
        }
        String indent = "  ";
        this.generateGrammarMetadata(buffer, g, indent);
        this.generateSharedMetadata(buffer, g, indent);
        if (startingRoot != null) {
            ElementDef ed = g.getElementDefByName(startingRoot);
            if (ed == null) {
                System.err.println("Starting root " + startingRoot + " not found");
            } else {
                XmlKey key = ImmutableXmlKey.createElementKey(ed.getQualifiedName());
                this._generateElementMetadataTag(buffer, g, ed, key, indent);
            }
        } else {
            for (ElementDef ed : g.getElementDefs()) {
                XmlKey key = ImmutableXmlKey.createElementKey(ed.getQualifiedName());
                this._generateElementMetadataTag(buffer, g, ed, key, indent);
            }
        }
        buffer.append("</grammarMetadata>\n");
    }

    protected void generateGrammarMetadata(StringBuffer buffer, Grammar g, String indent) {
    }

    protected void generateSharedMetadata(StringBuffer buffer, Grammar g, String indent) {
    }

    protected boolean shouldGenerateElementMetadata(Grammar g, ElementDef ed) {
        return true;
    }

    protected boolean shouldGenerateAttributeMetadata(Grammar g, ElementDef ed, AttributeDef ad) {
        return true;
    }

    protected void generateElementMetadata(StringBuffer buffer, Grammar g, ElementDef ed, XmlKey key, String indent) {
        for (QualifiedName qName : this._mdQNames) {
            Object md = this._mProvider.getMetadataItem(key, qName);
            if (md == null) continue;
            buffer.append(indent + "<");
            if (this._prefixMap.containsKey(qName.getNamespace())) {
                String prefix = this._prefixMap.get(qName.getNamespace());
                buffer.append(prefix + ":" + qName.getName() + ">");
                buffer.append(md);
                buffer.append("</" + prefix + ":" + qName.getName() + ">\n");
                continue;
            }
            buffer.append(qName.getName() + " xmlns=\"" + qName.getNamespace() + "\">");
            buffer.append(md);
            buffer.append("</" + qName.getName() + ">\n");
        }
    }

    protected void generateAttributeMetadata(StringBuffer buffer, Grammar g, ElementDef ed, AttributeDef ad, XmlKey key, String indent) {
        for (QualifiedName qName : this._mdQNames) {
            Object md = this._mProvider.getMetadataItem(key, qName);
            if (md == null) continue;
            buffer.append(indent + "<");
            if (this._prefixMap.containsKey(qName.getNamespace())) {
                String prefix = this._prefixMap.get(qName.getNamespace());
                buffer.append(prefix + ":" + qName.getName() + ">");
                buffer.append(md);
                buffer.append("</" + prefix + ":" + qName.getName() + ">\n");
                continue;
            }
            buffer.append(qName.getName() + " xmlns=\"" + qName.getNamespace() + "\">");
            buffer.append(md);
            buffer.append("</" + qName.getName() + ">\n");
        }
    }

    private void _generateElementMetadataTag(StringBuffer buffer, Grammar g, ElementDef ed, XmlKey key, String indent) {
        if (!this._shouldGenerateElementMetadata(g, ed)) {
            return;
        }
        buffer.append(indent);
        buffer.append("<elementMetadata elementName=\"");
        buffer.append(ed.getName());
        buffer.append("\">\n");
        String nextIndent = indent + "  ";
        this.generateElementMetadata(buffer, g, ed, key, nextIndent);
        this._generateAttributeMetadata(buffer, g, ed, key, nextIndent);
        buffer.append("\n");
        if (this._generateChildElementMetadata(buffer, g, ed, key, nextIndent)) {
            buffer.append("\n");
        }
        buffer.append(indent);
        buffer.append("</elementMetadata>\n");
    }

    private void _generateAttributeMetadataTag(StringBuffer buffer, Grammar g, ElementDef ed, AttributeDef ad, XmlKey key, String indent) {
        if (!this.shouldGenerateAttributeMetadata(g, ed, ad)) {
            return;
        }
        buffer.append(indent);
        buffer.append("<attributeMetadata attributeName=\"");
        buffer.append(ad.getName());
        buffer.append("\">\n");
        String nextIndent = indent + "  ";
        this.generateAttributeMetadata(buffer, g, ed, ad, key, nextIndent);
        buffer.append(indent);
        buffer.append("</attributeMetadata>\n");
    }

    private boolean _shouldGenerateElementMetadata(Grammar g, ElementDef ed) {
        return !ed.isReference() && this.shouldGenerateElementMetadata(g, ed);
    }

    private boolean _generateAttributeMetadata(StringBuffer buffer, Grammar g, ElementDef ed, XmlKey key, String indent) {
        Collection attributes = ed.getAttributeDefs();
        if (attributes == null) {
            return false;
        }
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            AttributeDef ad = (AttributeDef)i.next();
            XmlKey attrKey = DerivedXmlKey.createAttributeKey(this._gResolver, key, ad.getQualifiedName());
            this._generateAttributeMetadataTag(buffer, g, ed, ad, attrKey, indent);
            if (!i.hasNext()) continue;
            buffer.append("\n");
        }
        return attributes.size() > 0;
    }

    private boolean _generateChildElementMetadata(StringBuffer buffer, Grammar g, ElementDef ed, XmlKey key, String indent) {
        HashSet<ElementDef> defs = new HashSet<ElementDef>();
        Type type = ed.getType();
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            this._gatherElementDefs(complexType.getContentGroup(), defs);
        }
        if (defs.isEmpty()) {
            return false;
        }
        boolean bHasChild = false;
        Iterator i = defs.iterator();
        while (i.hasNext()) {
            ElementDef child = (ElementDef)i.next();
            if (child.isReference()) continue;
            XmlKey childKey = DerivedXmlKey.createElementKey(this._gResolver, key, child);
            this._generateElementMetadataTag(buffer, g, child, childKey, indent);
            if (i.hasNext()) {
                buffer.append("\n");
            }
            bHasChild = true;
        }
        return bHasChild;
    }

    private void _gatherElementDefs(ContentGroup group, Set<ElementDef> defs) {
        for (Object part : group.getComponents()) {
            if (part instanceof ElementDef) {
                defs.add((ElementDef)part);
                continue;
            }
            if (!(part instanceof ContentGroup)) continue;
            this._gatherElementDefs((ContentGroup)part, defs);
        }
    }
}

