/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.MetadataComponent;
import oracle.bali.xml.metadata.util.MetadataProviderUtils;
import oracle.bali.xml.util.XmlNameUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeMetadata
implements MetadataComponent {
    private static final String _ATTRIBUTE_NAME_ATTR = "attributeName";
    private static final String _ATTRIBUTE_NAMESPACE_ATTR = "attributeNamespace";
    private String _targetNamespace;
    private GrammarMetadata _grammarMetadata;
    private String _attributeLocalName;
    private QualifiedName _attributeQualifiedName;
    private HashMap _metadataMap;
    private boolean _bGlobal;
    private static final Logger _LOGGER = Logger.getLogger("oracle.bali.xml.metadata");
    private static final String _ERROR_LOCAL_NAME = "error";
    public static final String ATTRIBUTE_METADATA_NAME = "attributeMetadata";

    public AttributeMetadata(String targetNamespace, Node attributeMetadataNode, GrammarMetadata grammarMetadata) {
        this(targetNamespace, attributeMetadataNode, grammarMetadata, false);
    }

    public AttributeMetadata(String targetNamespace, Node attributeMetadataNode, GrammarMetadata grammarMetadata, boolean global) {
        this._targetNamespace = targetNamespace;
        this._grammarMetadata = grammarMetadata;
        this._metadataMap = new HashMap(this._grammarMetadata.getSharedAttributeMetadata());
        this._bGlobal = global;
        this._buildMetadataMaps(attributeMetadataNode);
    }

    @Override
    public String getTargetNamespace() {
        return this._targetNamespace;
    }

    @Override
    public Map getMetadataMap() {
        return this._metadataMap;
    }

    public String getAttributeName() {
        return this._attributeLocalName;
    }

    public QualifiedName getAttributeQualifiedName() {
        return this._attributeQualifiedName;
    }

    private void _buildMetadataMaps(Node attributeMetadataNode) {
        Element attributeMetadataElement = (Element)attributeMetadataNode;
        this._attributeLocalName = attributeMetadataElement.getAttribute(_ATTRIBUTE_NAME_ATTR);
        try {
            XmlNameUtils.validateName(this._attributeLocalName);
        }
        catch (Exception e) {
            _LOGGER.log(Level.INFO, "Illegal attribute name " + this._attributeLocalName + " found in standalone metadata file for targetNamespace: " + this._targetNamespace);
            this._attributeLocalName = _ERROR_LOCAL_NAME;
        }
        String alternateNamespace = attributeMetadataElement.getAttributeNS(null, _ATTRIBUTE_NAMESPACE_ATTR);
        if (alternateNamespace != null && alternateNamespace.length() > 0) {
            try {
                XmlNameUtils.validateNamespace(alternateNamespace);
            }
            catch (Exception e) {
                _LOGGER.log(Level.INFO, "Illegal value for attributeNamespace attribute " + alternateNamespace + " found in standalone metadata file for targetNamespace: " + this._targetNamespace);
                alternateNamespace = "error:invalid-namespace";
            }
            this._attributeQualifiedName = QualifiedName.getQualifiedName(alternateNamespace, this._attributeLocalName);
        } else {
            String attributeNS = null;
            if (this._bGlobal) {
                attributeNS = this._targetNamespace;
            }
            this._attributeQualifiedName = QualifiedName.getQualifiedName(attributeNS, this._attributeLocalName);
        }
        for (Node currNode = attributeMetadataNode.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            if (currNode.getNodeType() != 1) continue;
            MetadataProviderUtils.addMetadataToMap(this._metadataMap, (Element)currNode);
        }
    }
}

