/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTBinaryOperator;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.Coercions;
import oracle.bali.xml.metadata.el.impl.PrimitiveTypes;
import oracle.bali.xml.metadata.el.impl.Relational;

final class ASTGreaterThanOrEquals
extends ASTBinaryOperator {
    private static final ASTGreaterThanOrEquals _sInstance = new ASTGreaterThanOrEquals();

    @Override
    public Object apply(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        Object lhs = left.getValue(vResolver);
        if (lhs == null) {
            return Boolean.FALSE;
        }
        Object rhs = right.getValue(vResolver);
        if (rhs == null) {
            return PrimitiveTypes.getBoolean(false);
        }
        if (Relational.shouldCoercetoDouble(lhs) || Relational.shouldCoercetoDouble(rhs)) {
            return PrimitiveTypes.getBoolean(Coercions.toDouble(lhs) >= Coercions.toDouble(rhs));
        }
        if (Relational.shouldCoercetoLong(lhs) || Relational.shouldCoercetoLong(rhs)) {
            return PrimitiveTypes.getBoolean(Coercions.toLong(lhs) >= Coercions.toLong(rhs));
        }
        if (Relational.shouldCoercetoString(lhs) || Relational.shouldCoercetoString(rhs)) {
            return PrimitiveTypes.getBoolean(Coercions.toString(lhs).compareTo(Coercions.toString(rhs)) >= 0);
        }
        if (lhs instanceof Comparable) {
            return PrimitiveTypes.getBoolean(((Comparable)lhs).compareTo(rhs) >= 0);
        }
        if (rhs instanceof Comparable) {
            return PrimitiveTypes.getBoolean(((Comparable)rhs).compareTo(lhs) <= 0);
        }
        throw new ELException(lhs + " >= " + rhs);
    }

    @Override
    public Class getType(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        return Boolean.class;
    }

    @Override
    public void toString(StringBuffer buffer, ASTOperand left, ASTOperand right) {
        buffer.append('(');
        left.toString(buffer);
        buffer.append(" >= ");
        right.toString(buffer);
        buffer.append(')');
    }

    public static ASTGreaterThanOrEquals sharedInstance() {
        return _sInstance;
    }

    private ASTGreaterThanOrEquals() {
    }
}

