/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;

public final class ImmutableXmlKey
extends XmlKey {
    private final String _namespace;
    private final List _elementQNamePath;
    private final QualifiedName _attributeQName;
    private final short _nodeType;

    @Override
    public final String getNamespace() {
        return this._namespace;
    }

    @Override
    public final List getElementQNamePath() {
        return this._elementQNamePath;
    }

    @Override
    public final QualifiedName getAttributeQName() {
        return this._attributeQName;
    }

    public static final XmlKey createNamespaceKey(String namespace) {
        return new ImmutableXmlKey(namespace, null, null);
    }

    public static final XmlKey createElementKey(String elementNamespace, String elementName) {
        return ImmutableXmlKey.createElementKey(QualifiedName.getQualifiedName(elementNamespace, elementName));
    }

    public static final XmlKey createElementKey(QualifiedName elementQName) {
        return new ImmutableXmlKey(null, Collections.singletonList(elementQName), null);
    }

    public static final XmlKey createElementKey(List elementNamePath) {
        return new ImmutableXmlKey(null, Collections.unmodifiableList(new ArrayList(elementNamePath)), null);
    }

    public static final XmlKey createElementKey(QualifiedName ... elementNamePath) {
        return ImmutableXmlKey.createElementKey(Arrays.asList(elementNamePath));
    }

    public static final XmlKey createAttributeKey(String attrNamespace, String attrLocalName) {
        return ImmutableXmlKey.createAttributeKey(QualifiedName.getQualifiedName(attrNamespace, attrLocalName));
    }

    public static final XmlKey createAttributeKey(QualifiedName attributeQName) {
        return new ImmutableXmlKey(null, null, attributeQName);
    }

    public static final XmlKey createAttributeKey(QualifiedName elementQName, String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name not specified");
        }
        return ImmutableXmlKey.createAttributeKey(elementQName, QualifiedName.getQualifiedName(null, attributeName));
    }

    public static final XmlKey createAttributeKey(QualifiedName elementQName, QualifiedName attributeQName) {
        return new ImmutableXmlKey(null, Collections.singletonList(elementQName), attributeQName);
    }

    public static final XmlKey createAttributeKey(List elementQNamePath, String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name not specified");
        }
        return ImmutableXmlKey.createAttributeKey(elementQNamePath, QualifiedName.getQualifiedName(null, attributeName));
    }

    public static final XmlKey createAttributeKey(List elementNamePath, QualifiedName attributeQName) {
        return new ImmutableXmlKey(null, Collections.unmodifiableList(new ArrayList(elementNamePath)), attributeQName);
    }

    public static final XmlKey createFixedAttributeElementKey(List elementPath, String attributeNamespace, String attributeName, String attributeValue) {
        ArrayList<QualifiedName> fixedAttrList = new ArrayList<QualifiedName>();
        fixedAttrList.addAll(elementPath);
        int lastIndex = fixedAttrList.size() - 1;
        QualifiedName baseQName = (QualifiedName)fixedAttrList.get(lastIndex);
        QualifiedName fixedAttrQName = QualifiedName.getQualifiedName(baseQName.getNamespace(), baseQName.getName(), attributeNamespace, attributeName, attributeValue);
        fixedAttrList.set(lastIndex, fixedAttrQName);
        return ImmutableXmlKey.createElementKey(fixedAttrList);
    }

    public static final XmlKey createPseudoElementKey(List elementPath, String identifier) {
        ArrayList<QualifiedName> pseudoKeyList = new ArrayList<QualifiedName>();
        pseudoKeyList.addAll(elementPath);
        int lastIndex = pseudoKeyList.size() - 1;
        QualifiedName baseQName = (QualifiedName)pseudoKeyList.get(lastIndex);
        QualifiedName pseudoQName = QualifiedName.getQualifiedName(baseQName.getNamespace(), baseQName.getName(), identifier);
        pseudoKeyList.set(lastIndex, pseudoQName);
        return ImmutableXmlKey.createElementKey(pseudoKeyList);
    }

    public static XmlKey getNamespaceKey(XmlKey key) {
        return ImmutableXmlKey.createNamespaceKey(key.getTargetNamespace());
    }

    @Override
    public final short getNodeType() {
        return this._nodeType;
    }

    private ImmutableXmlKey(String namespace, List elementNameList, QualifiedName attributeQName) {
        this._attributeQName = attributeQName;
        this._elementQNamePath = elementNameList;
        if (this._elementQNamePath != null && this._elementQNamePath.size() > 0) {
            for (int i = 0; i < this._elementQNamePath.size(); ++i) {
                if (this._elementQNamePath.get(i) != null) continue;
                throw new IllegalArgumentException("Cannot create a XmlKey with a null elementQName");
            }
        }
        this._nodeType = (short)(attributeQName != null ? 2 : (this._elementQNamePath != null ? 1 : 0));
        this._namespace = this._nodeType == 0 ? namespace : super.getNamespace();
    }
}

