/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.metadata.LayeredMetadataEvaluator;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataFunction;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.Expression;
import oracle.bali.xml.metadata.el.Function;
import oracle.bali.xml.metadata.el.PropertyResolver;
import oracle.bali.xml.metadata.el.PropertyResolverProxy;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.DefaultPropertyResolver;
import oracle.bali.xml.metadata.el.parser.ExpressionParser;
import oracle.bali.xml.metadata.el.parser.ExpressionParserFactory;
import oracle.bali.xml.metadata.el.parser.FunctionMapper;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BaliElEvaluator {
    private final MetadataProvider _provider;
    private final MetadataProvider _metadataLanguageProvider;
    private final ExpressionParser _parser;
    private final FunctionMapper _fmapper;
    private final PropertyResolver _presolver;
    private final ConcurrentHashMap<String, Expression> _exprMap = new ConcurrentHashMap(53, 0.75f, 5);
    private static final Logger _sLogger = Logger.getLogger("oracle.bali.xml.metadata");

    public BaliElEvaluator(MetadataProvider metadataProvider, MetadataProvider metadataLanguageProvider) {
        this._provider = metadataProvider;
        this._metadataLanguageProvider = metadataLanguageProvider;
        this._parser = ExpressionParserFactory.newInstance().newExpressionParser();
        this._fmapper = new MetadataFunctionMapper();
        this._presolver = new MetadataPropertyResolver();
    }

    public LayeredMetadataEvaluator.MetadataInfo evaluateValue(String value, Class expectedType, Map implicitObjects, Map additionalObjects) throws MetadataException {
        try {
            value = value.replace('$', '#');
            Expression expr = this._exprMap.get(value);
            HashMap evaluationObjects = new HashMap();
            if (implicitObjects != null) {
                evaluationObjects.putAll(implicitObjects);
            }
            if (additionalObjects != null) {
                evaluationObjects.putAll(additionalObjects);
            }
            MetadataVariableResolver vresolver = new MetadataVariableResolver(evaluationObjects);
            int cacheType = 0;
            if (expr == null) {
                expr = this._parser.parseExpression(value, expectedType, this._fmapper, this._presolver, vresolver);
                int n = cacheType = expr.isConstant() ? 1 : 0;
                if (cacheType == 0) {
                    this._exprMap.put(value, expr);
                }
            }
            Object metadataValue = expr.getValue(vresolver);
            return new LayeredMetadataEvaluator.MetadataInfo(metadataValue, cacheType);
        }
        catch (ELException e) {
            _sLogger.log(Level.WARNING, e.getMessage(), e);
            throw new MetadataException(e.getMessage(), e);
        }
    }

    private class MetadataFunctionMapper
    implements FunctionMapper {
        private Map<String, Function> _functionMap = new HashMap<String, Function>();

        private MetadataFunctionMapper() {
        }

        @Override
        public Function resolveFunction(String prefix, String name) {
            String qname = prefix + ":" + name;
            Function elFunction = this._functionMap.get(qname);
            if (elFunction == null) {
                Object metadataFunction = null;
                metadataFunction = BaliElEvaluator.this._provider.getFunction(prefix, name);
                if (!(metadataFunction instanceof MetadataFunction)) {
                    metadataFunction = BaliElEvaluator.this._metadataLanguageProvider.getFunction(prefix, name);
                }
                if (metadataFunction instanceof MetadataFunction) {
                    elFunction = new MetadataFunctionAdapter((MetadataFunction)metadataFunction);
                    this._functionMap.put(qname, elFunction);
                } else {
                    _sLogger.log(Level.WARNING, "function {0} not found or of wrong type. Got: {1}", new Object[]{qname, metadataFunction});
                }
            }
            return elFunction;
        }
    }

    private class MetadataPropertyResolver
    extends PropertyResolverProxy {
        private PropertyResolver _presolver = DefaultPropertyResolver.sharedInstance();

        private MetadataPropertyResolver() {
        }

        @Override
        protected PropertyResolver getPropertyResolver() {
            return this._presolver;
        }

        @Override
        public Object getValue(Object base, String name) throws ELException {
            if ("attr".equals(name) && base instanceof Node) {
                return new NamedNodeJavaMap(((Node)base).getAttributes());
            }
            return super.getValue(base, name);
        }
    }

    private class MetadataVariableResolver
    implements VariableResolver {
        private Map _evaluationObjects;

        public MetadataVariableResolver(Map evaluationObjects) {
            this._evaluationObjects = evaluationObjects;
        }

        @Override
        public Object resolveVariable(String name) {
            return this._evaluationObjects.get(name);
        }
    }

    private static class VariableResolverMap
    extends BaseMap {
        private final VariableResolver _resolver;

        public VariableResolverMap(VariableResolver resolver) {
            this._resolver = resolver;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        public Object get(Object key) {
            if (key instanceof String) {
                return this._resolver.resolveVariable((String)key);
            }
            return null;
        }
    }

    private static abstract class BaseMap
    implements Map {
        private BaseMap() {
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Set keySet() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Collection values() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static class NamedNodeJavaMap
    extends BaseMap {
        private final NamedNodeMap _nodeMap;

        public NamedNodeJavaMap(NamedNodeMap nodeMap) {
            this._nodeMap = nodeMap;
        }

        @Override
        public int size() {
            return this._nodeMap.getLength();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                return this._nodeMap.getNamedItem((String)key) != null;
            }
            return false;
        }

        public Object get(Object key) {
            Node node;
            if (key instanceof String && (node = this._nodeMap.getNamedItemNS(null, (String)key)) != null) {
                return node.getNodeValue();
            }
            return null;
        }
    }

    private class MetadataFunctionAdapter
    extends Function {
        private MetadataFunction _function;

        public MetadataFunctionAdapter(MetadataFunction function) {
            this._function = function;
        }

        @Override
        public Object evaluate(VariableResolver vresolver, Object[] args) {
            try {
                return this._function.evaluate(new VariableResolverMap(vresolver), args);
            }
            catch (MetadataException e) {
                _sLogger.log(Level.WARNING, e.getMessage());
                throw new ELException(e);
            }
        }

        @Override
        public Class[] getArgumentTypes() {
            return this._function.getArgumentTypes();
        }

        @Override
        public Class getReturnType() {
            return this._function.getReturnType();
        }

        @Override
        public boolean isMacro() {
            return this._function.isMacro();
        }
    }
}

