/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import org.w3c.dom.Node;

public abstract class AbstractMetadataEvaluator
implements MetadataEvaluator {
    private static final Logger _sLogger = Logger.getLogger("oracle.bali.xml.metadata");
    private WeakHashMap _masterXmlKeys = new WeakHashMap(37);

    @Override
    public final Object getMetadataItem(Object key, Object itemKey, Node node) {
        XmlKey originalKey;
        XmlKey fallbackKey;
        if (key == null) {
            StringBuffer message = new StringBuffer("Null key incorrectly passed to MetadataEvaluator.");
            if (itemKey != null) {
                message.append("\nitemKey=" + itemKey);
            }
            if (node != null) {
                message.append("\nnode=" + node);
            }
            this.getLogger().log(Level.WARNING, message.toString(), new RuntimeException());
            return null;
        }
        Object metadata = this.getMetadataItemImpl(key, itemKey, node);
        if (metadata == null && key instanceof XmlKey && (fallbackKey = this._getMasterXmlKey(originalKey = (XmlKey)key)) != null) {
            metadata = this.getMetadataItemImpl(fallbackKey, itemKey, node);
        }
        return metadata;
    }

    @Override
    public Collection getPseudoXmlKeys(Object masterKey) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<StructuredMetadataBean> getGlobalMetadata(QualifiedName globalItemName) {
        return Collections.emptyList();
    }

    protected abstract Object getMetadataItemImpl(Object var1, Object var2, Node var3);

    protected Logger getLogger() {
        return _sLogger;
    }

    private XmlKey _getMasterXmlKey(XmlKey variantKey) {
        QualifiedName variantName;
        XmlKey masterKey = null;
        if (variantKey.getNodeType() == 1 && (variantName = variantKey.getElementQName()).isVariation() && (masterKey = (XmlKey)this._masterXmlKeys.get(variantKey)) == null) {
            QualifiedName masterName = QualifiedName.getQualifiedName(variantName.getNamespace(), variantName.getName());
            ArrayList<QualifiedName> strippedPath = new ArrayList<QualifiedName>(variantKey.getElementQNamePath());
            strippedPath.set(strippedPath.size() - 1, masterName);
            masterKey = ImmutableXmlKey.createElementKey(strippedPath);
            this._masterXmlKeys.put(variantKey, masterKey);
        }
        return masterKey;
    }
}

