/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.util;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;

public class GrammarSetEvent
extends EventObject {
    private Set _grammarsAdded = new HashSet();
    private Set _grammarsRemoved = new HashSet();
    private Set _grammarsChanged = new HashSet();

    public GrammarSetEvent(Object source) {
        this(source, null, null, null);
    }

    public GrammarSetEvent(Object source, Set grammarsAdded, Set grammarsRemoved, Set grammarsChanged) {
        super(source);
        if (grammarsAdded != null) {
            this._grammarsAdded.addAll(grammarsAdded);
        }
        if (grammarsRemoved != null) {
            this._grammarsRemoved.addAll(grammarsRemoved);
        }
        if (grammarsChanged != null) {
            this._grammarsChanged.addAll(grammarsChanged);
        }
    }

    public Set getGrammarsAdded() {
        return this._grammarsAdded;
    }

    public Set getGrammarsRemoved() {
        return this._grammarsRemoved;
    }

    public Set getGrammarsChanged() {
        return this._grammarsChanged;
    }

    public boolean hasGrammarsAdded() {
        return !this._grammarsAdded.isEmpty();
    }

    public boolean hasGrammarsRemoved() {
        return !this._grammarsRemoved.isEmpty();
    }

    public boolean hasGrammarsChanged() {
        return !this._grammarsChanged.isEmpty();
    }

    public void notifyGrammarAdded(Grammar grammar) {
        this._grammarsAdded.add(grammar);
    }

    public void notifyGrammarRemoved(Grammar grammar) {
        this._grammarsRemoved.add(grammar);
    }

    public void notifyGrammarChanged(Grammar grammar) {
        this._grammarsChanged.add(grammar);
    }

    public void prepareForDelivery() {
        this._grammarsAdded = Collections.unmodifiableSet(this._grammarsAdded);
        this._grammarsRemoved = Collections.unmodifiableSet(this._grammarsRemoved);
        this._grammarsChanged = Collections.unmodifiableSet(this._grammarsChanged);
    }

    public boolean isEmpty() {
        return this._grammarsAdded.isEmpty() && this._grammarsRemoved.isEmpty() && this._grammarsChanged.isEmpty();
    }
}

