/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.AttributeGroup;
import oracle.bali.xml.grammar.ContentGroup;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarIdentifier;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleAttributeDef;
import oracle.bali.xml.grammar.schema.OracleAttributeGroup;
import oracle.bali.xml.grammar.schema.OracleContentGroup;
import oracle.bali.xml.grammar.schema.OracleElementDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;

public class OracleSchema
implements Grammar {
    private OracleSchemaFactory _factory = null;
    private XMLSchemaNode _schemaNode = null;
    private URL _schemaLocation = null;
    private volatile Map<String, ElementDef> _elementMap = null;
    private volatile Map<String, AttributeDef> _attributeMap = null;
    private volatile Map<String, Type> _typeMap = null;
    private volatile Map<String, ContentGroup> _contentGroupMap = null;
    private volatile Map<String, AttributeGroup> _attributeGroupMap = null;
    private volatile Annotation _annotation = null;
    private GrammarIdentifier _identifier = null;
    private static final Map<String, AttributeDef> _EMPTY_ATTRIBUTE_MAP = Collections.emptyMap();

    @Override
    public String getName() {
        return this._schemaNode.getName();
    }

    @Override
    public String getTargetNamespace() {
        return "".equals(this._schemaNode.getTargetNS()) ? null : this._schemaNode.getTargetNS();
    }

    @Override
    public Collection getElementDefs() {
        return this._getElementMap().values();
    }

    @Override
    public ElementDef getElementDefByName(String elementName) {
        return this._getElementMap().get(elementName);
    }

    @Override
    public Collection getAttributeDefs() {
        return this._getAttributeMap().values();
    }

    @Override
    public AttributeDef getAttributeDefByName(String attributeName) {
        return this._getAttributeMap().get(attributeName);
    }

    @Override
    public Collection getTypes() {
        return this._getTypeMap().values();
    }

    @Override
    public Type getTypeByName(String typeName) {
        return this._getTypeMap().get(typeName);
    }

    @Override
    public Collection getContentGroups() {
        return this._getContentGroupMap().values();
    }

    @Override
    public ContentGroup getContentGroupByName(String groupName) {
        return this._getContentGroupMap().get(groupName);
    }

    @Override
    public Collection getAttributeGroups() {
        return this._getAttributeGroupMap().values();
    }

    @Override
    public GrammarIdentifier getGrammarIdentifier() {
        return this._identifier;
    }

    @Override
    public int getGrammarVariety() {
        return 0;
    }

    @Override
    public URL getLocation() {
        return this._schemaLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getAnnotation() {
        if (this._annotation == null) {
            OracleSchema oracleSchema = this;
            synchronized (oracleSchema) {
                if (this._annotation == null) {
                    this._annotation = new OracleAnnotation((XSDNode)this._schemaNode);
                }
            }
        }
        return this._annotation;
    }

    public OracleSchemaFactory getFactory() {
        return this._factory;
    }

    OracleSchema(OracleSchemaFactory factory, XMLSchemaNode schemaNode, URL location) {
        this._factory = factory;
        this._schemaNode = schemaNode;
        this._schemaLocation = location;
        this._identifier = GrammarIdentifier.getGrammarIdentifier(this._schemaNode.getTargetNS(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ElementDef> _getElementMap() {
        if (this._elementMap == null) {
            OracleSchema oracleSchema = this;
            synchronized (oracleSchema) {
                if (this._elementMap == null) {
                    LinkedHashMap<String, ElementDef> newElementMap = new LinkedHashMap<String, ElementDef>();
                    XSDNode[] schemaElements = this._schemaNode.getElementSet();
                    if (schemaElements != null) {
                        for (int iter = 0; iter < schemaElements.length; ++iter) {
                            XSDElement xsdElement = (XSDElement)schemaElements[iter];
                            OracleElementDef elementWrapper = this._factory.getElementWrapper(xsdElement);
                            if (elementWrapper.getName() == null) continue;
                            newElementMap.put(elementWrapper.getName(), elementWrapper);
                        }
                    }
                    this._elementMap = newElementMap;
                }
            }
        }
        return this._elementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AttributeDef> _getAttributeMap() {
        if (this._attributeMap == null) {
            OracleSchema oracleSchema = this;
            synchronized (oracleSchema) {
                if (this._attributeMap == null) {
                    Map<String, AttributeDef> newAttributeMap = _EMPTY_ATTRIBUTE_MAP;
                    XSDAttribute[] globalAttributes = this._schemaNode.getAttributeDeclarations();
                    if (globalAttributes != null && globalAttributes.length > 0) {
                        newAttributeMap = new LinkedHashMap<String, AttributeDef>(8);
                        for (int i = 0; i < globalAttributes.length; ++i) {
                            OracleAttributeDef attributeWrapper;
                            String attributeName;
                            XSDAttribute anAttribute = globalAttributes[i];
                            if (anAttribute == null || (attributeName = (attributeWrapper = this._factory.getAttributeWrapper(anAttribute)).getName()) == null) continue;
                            newAttributeMap.put(attributeName, attributeWrapper);
                        }
                    }
                    this._attributeMap = newAttributeMap;
                }
            }
        }
        return this._attributeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Type> _getTypeMap() {
        if (this._typeMap == null) {
            OracleSchema oracleSchema = this;
            synchronized (oracleSchema) {
                if (this._typeMap == null) {
                    Collection xsdTypes;
                    LinkedHashMap<String, Type> newTypeMap = new LinkedHashMap<String, Type>(31);
                    Hashtable typeTable = this._schemaNode.getTypeDefinitionTable();
                    if (typeTable != null && (xsdTypes = typeTable.values()) != null) {
                        for (XSDNode xsdType : xsdTypes) {
                            String typeName;
                            Type wrapper = this._factory.getTypeWrapper(xsdType);
                            if (wrapper == null || (typeName = wrapper.getName()) == null) continue;
                            newTypeMap.put(typeName, wrapper);
                        }
                    }
                    this._typeMap = newTypeMap;
                }
            }
        }
        return this._typeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ContentGroup> _getContentGroupMap() {
        if (this._contentGroupMap == null) {
            OracleSchema oracleSchema = this;
            synchronized (oracleSchema) {
                if (this._contentGroupMap == null) {
                    LinkedHashMap<String, ContentGroup> newContentGroupMap = new LinkedHashMap<String, ContentGroup>();
                    XSDNode[] schemaGroups = this._schemaNode.getGroupSet();
                    if (schemaGroups != null) {
                        for (int iter = 0; iter < schemaGroups.length; ++iter) {
                            XSDGroup xsdGroup = (XSDGroup)schemaGroups[iter];
                            OracleContentGroup groupWrapper = this._factory.getContentGroupWrapper(xsdGroup);
                            if (groupWrapper.getName() == null) continue;
                            newContentGroupMap.put(groupWrapper.getName(), groupWrapper);
                        }
                    }
                    this._contentGroupMap = newContentGroupMap;
                }
            }
        }
        return this._contentGroupMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AttributeGroup> _getAttributeGroupMap() {
        if (this._attributeGroupMap == null) {
            OracleSchema oracleSchema = this;
            synchronized (oracleSchema) {
                if (this._attributeGroupMap == null) {
                    LinkedHashMap<String, AttributeGroup> newAttrGroupMap = new LinkedHashMap<String, AttributeGroup>();
                    XSDNode[] attributeGroups = this._schemaNode.getAttrGroupSet();
                    if (attributeGroups != null) {
                        for (int iter = 0; iter < attributeGroups.length; ++iter) {
                            XSDAttrGroup xsdAttrGroup = (XSDAttrGroup)attributeGroups[iter];
                            OracleAttributeGroup groupWrapper = this._factory.getAttributeGroupWrapper(xsdAttrGroup);
                            if (groupWrapper.getName() == null) continue;
                            newAttrGroupMap.put(groupWrapper.getName(), groupWrapper);
                        }
                    }
                    this._attributeGroupMap = newAttrGroupMap;
                }
            }
        }
        return this._attributeGroupMap;
    }
}

