/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeGroup;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.schema.OracleAnnotation;
import oracle.bali.xml.grammar.schema.OracleAttributeDef;
import oracle.bali.xml.grammar.schema.OracleSchemaFactory;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttrGroup;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDNode;

public class OracleAttributeGroup
implements AttributeGroup {
    private OracleSchemaFactory _factory = null;
    private XSDAttrGroup _xsdAttrGroup = null;
    private volatile List<GrammarComponent> _attributes = null;
    private volatile Annotation _annotation = null;
    private volatile Wildcard _attributeWildcard = null;
    private static final List<GrammarComponent> _EMPTY_ATTRIBUTE_LIST = Collections.emptyList();

    @Override
    public String getName() {
        return this._xsdAttrGroup.getName();
    }

    @Override
    public String getTargetNamespace() {
        String namespace = this._xsdAttrGroup.getTargetNS();
        if (namespace != null && namespace.length() == 0) {
            return null;
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Annotation getAnnotation() {
        if (this._annotation == null) {
            OracleAttributeGroup oracleAttributeGroup = this;
            synchronized (oracleAttributeGroup) {
                if (this._annotation == null) {
                    this._annotation = new OracleAnnotation((XSDNode)this._xsdAttrGroup);
                }
            }
        }
        return this._annotation;
    }

    @Override
    public Collection getComponents() {
        return this._getComponents();
    }

    @Override
    public Wildcard getAttributeWildcard() {
        return this._getAttributeWildcard();
    }

    OracleAttributeGroup(OracleSchemaFactory factory, XSDAttrGroup xsdAttrGroup) {
        this._factory = factory;
        this._xsdAttrGroup = xsdAttrGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<GrammarComponent> _getComponents() {
        if (this._attributes == null) {
            OracleAttributeGroup oracleAttributeGroup = this;
            synchronized (oracleAttributeGroup) {
                if (this._attributes == null) {
                    List<GrammarComponent> newAttributeList = _EMPTY_ATTRIBUTE_LIST;
                    Vector xsdAttrs = this._xsdAttrGroup.getNodeVector();
                    if (xsdAttrs != null && xsdAttrs.size() > 0) {
                        newAttributeList = new ArrayList<GrammarComponent>(xsdAttrs.size());
                        for (int i = 0; i < xsdAttrs.size(); ++i) {
                            Object obj = xsdAttrs.get(i);
                            if (obj == null) continue;
                            if (obj instanceof XSDAttribute) {
                                XSDAttribute attribute = (XSDAttribute)obj;
                                OracleAttributeDef attributeWrapper = this._factory.getAttributeWrapper(attribute);
                                newAttributeList.add(attributeWrapper);
                                continue;
                            }
                            if (!(obj instanceof XSDAttrGroup)) continue;
                            XSDAttrGroup attrGroup = (XSDAttrGroup)obj;
                            OracleAttributeGroup attrGroupWrapper = this._factory.getAttributeGroupWrapper(attrGroup);
                            newAttributeList.add(attrGroupWrapper);
                        }
                    }
                    this._attributes = newAttributeList;
                }
            }
        }
        return this._attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wildcard _getAttributeWildcard() {
        if (this._attributeWildcard == null) {
            OracleAttributeGroup oracleAttributeGroup = this;
            synchronized (oracleAttributeGroup) {
                XSDAny xsdAny;
                if (this._attributeWildcard == null && (xsdAny = this._xsdAttrGroup.getWildcard()) != null) {
                    this._attributeWildcard = this._factory.getWildcardWrapper(xsdAny);
                }
            }
        }
        return this._attributeWildcard;
    }
}

