/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.proxy;

import java.util.ArrayList;
import java.util.Collection;
import oracle.bali.xml.grammar.Annotation;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ComplexType;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.SubstitutionGroup;
import oracle.bali.xml.grammar.Type;
import oracle.bali.xml.grammar.common.AbstractElementDef;
import oracle.bali.xml.grammar.proxy.AttributeDefProxy;
import oracle.bali.xml.grammar.proxy.ComplexTypeProxy;

public class FixedAttributeElementDefProxy
extends AbstractElementDef
implements FixedAttributeElementDef {
    private final ElementDef _masterElementDef;
    private final QualifiedName _fixedAttrName;
    private final QualifiedName _variantName;
    private final ComplexType _variantType;
    private final String _value;

    public FixedAttributeElementDefProxy(ElementDef masterElementDef, QualifiedName fixedAttrName, String value) {
        this(masterElementDef, fixedAttrName, value, null);
    }

    public FixedAttributeElementDefProxy(ElementDef masterElementDef, QualifiedName fixedAttrName, String value, ComplexType replacementType) {
        this(masterElementDef, fixedAttrName, value, null, null);
    }

    public FixedAttributeElementDefProxy(ElementDef masterElementDef, QualifiedName fixedAttrName, String value, ComplexType replacementType, AttributeDef replacementAttributeDef) {
        if (masterElementDef == null) {
            throw new IllegalArgumentException("masterElementDef argument cannot be null");
        }
        if (fixedAttrName == null) {
            throw new IllegalArgumentException("fixedAttrName argument cannot be null");
        }
        this._masterElementDef = masterElementDef;
        this._fixedAttrName = fixedAttrName;
        this._value = value;
        this._variantName = QualifiedName.getQualifiedName(this._masterElementDef.getTargetNamespace(), this._masterElementDef.getName(), this._fixedAttrName.getNamespace(), this._fixedAttrName.getName(), this._value);
        if (replacementType != null) {
            this._variantType = new FixedAttributeComplexTypeProxy(replacementType, this._fixedAttrName, this._value, replacementAttributeDef);
        } else {
            Type masterElementType = this._masterElementDef.getType();
            if (masterElementType instanceof ComplexType) {
                this._variantType = new FixedAttributeComplexTypeProxy((ComplexType)masterElementType, this._fixedAttrName, this._value, replacementAttributeDef);
            } else {
                throw new IllegalArgumentException("masterElementDef argument must have a ComplexType");
            }
        }
    }

    @Override
    public String getTargetNamespace() {
        return this._variantName.getNamespace();
    }

    @Override
    public String getName() {
        return this._variantName.getName();
    }

    @Override
    public QualifiedName getQualifiedName() {
        return this._variantName;
    }

    @Override
    public Type getType() {
        return this._variantType;
    }

    @Override
    public String getDefaultValue() {
        return this._masterElementDef.getDefaultValue();
    }

    @Override
    public String getFixedValue() {
        return this._masterElementDef.getFixedValue();
    }

    @Override
    public boolean isAbstract() {
        return this._masterElementDef.isAbstract();
    }

    @Override
    public AttributeDef getFixedAttribute() {
        return this.getAttributeDefByName(this._fixedAttrName);
    }

    @Override
    public Annotation getAnnotation() {
        return this._masterElementDef.getAnnotation();
    }

    @Override
    public SubstitutionGroup getSubstitutionGroup() {
        return this._masterElementDef.getSubstitutionGroup();
    }

    @Override
    public int getMinOccurs() {
        return this._masterElementDef.getMinOccurs();
    }

    @Override
    public int getMaxOccurs() {
        return this._masterElementDef.getMaxOccurs();
    }

    private class FixedAttributeComplexTypeProxy
    extends ComplexTypeProxy {
        private final ArrayList<AttributeDef> _variantAttributeDefs;

        public FixedAttributeComplexTypeProxy(ComplexType masterComplexType, QualifiedName fixedAttrName, String fixedAttrValue) {
            this(masterComplexType, fixedAttrName, fixedAttrValue, null);
        }

        public FixedAttributeComplexTypeProxy(ComplexType masterComplexType, QualifiedName fixedAttrName, String fixedAttrValue, AttributeDef replacementAttributeDef) {
            super(masterComplexType);
            this._variantAttributeDefs = new ArrayList(masterComplexType.getAttributeDefs());
            boolean foundAttributeDef = false;
            int numAttr = this._variantAttributeDefs.size();
            for (int i = 0; i < numAttr; ++i) {
                AttributeDef attrDef = this._variantAttributeDefs.get(i);
                if (!fixedAttrName.equals(attrDef.getQualifiedName())) continue;
                foundAttributeDef = true;
                FixedAttributeDefProxy variant = new FixedAttributeDefProxy(attrDef, fixedAttrValue);
                this._variantAttributeDefs.set(i, variant);
                break;
            }
            if (!foundAttributeDef && replacementAttributeDef != null) {
                FixedAttributeDefProxy variant = new FixedAttributeDefProxy(replacementAttributeDef, fixedAttrValue);
                this._variantAttributeDefs.add(variant);
            }
        }

        @Override
        public Collection getAttributeDefs() {
            return this._variantAttributeDefs;
        }
    }

    private static class FixedAttributeDefProxy
    extends AttributeDefProxy {
        private final String _fixedValue;

        public FixedAttributeDefProxy(AttributeDef masterAttributeDef, String fixedValue) {
            super(masterAttributeDef);
            this._fixedValue = fixedValue;
        }

        @Override
        public String getFixedValue() {
            return this._fixedValue;
        }

        @Override
        public boolean isReference() {
            return false;
        }

        @Override
        public AttributeDef getReferencedAttributeDef() {
            return null;
        }
    }
}

