/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.GrammarProviderListener;

public abstract class LayeredGrammarProvider
extends GrammarProvider {
    private final GrammarProvider _base;
    private final GrammarProviderListener _eventPercolator = new GrammarEventPercolator();

    public LayeredGrammarProvider() {
        this(null);
    }

    public LayeredGrammarProvider(GrammarProvider base) {
        this._base = base;
    }

    @Override
    public final Map getGrammarMap() {
        LinkedHashMap combinedGrammars = new LinkedHashMap();
        if (this._base != null) {
            combinedGrammars.putAll(this._base.getGrammarMap());
        }
        combinedGrammars.putAll(this.getLayerGrammarMap());
        return Collections.unmodifiableMap(combinedGrammars);
    }

    @Override
    public final Grammar getGrammarForNamespace(String targetNamespace) {
        Grammar result = this.getLayerGrammarForNamespace(targetNamespace);
        if (result == null && this._base != null) {
            result = this._base.getGrammarForNamespace(targetNamespace);
        }
        return result;
    }

    @Override
    public final Collection getGrammars() {
        Collection grammars = this.getGrammarMap().values();
        return Collections.unmodifiableCollection(grammars);
    }

    @Override
    protected void firstListenerAttached() {
        if (this._base != null) {
            this._base.addGrammarProviderListener(this._eventPercolator);
        }
    }

    @Override
    protected void lastListenerDetached() {
        if (this._base != null) {
            this._base.removeGrammarProviderListener(this._eventPercolator);
        }
    }

    protected Grammar getLayerGrammarForNamespace(String targetNamespace) {
        return (Grammar)this.getLayerGrammarMap().get(targetNamespace);
    }

    protected abstract Map getLayerGrammarMap();

    protected final GrammarProvider getBaseGrammarProvider() {
        return this._base;
    }

    private class GrammarEventPercolator
    implements GrammarProviderListener {
        private GrammarEventPercolator() {
        }

        @Override
        public void grammarProviderChanged(GrammarProviderEvent e) {
            Set grammarsAdded = this._filterSet(e.getGrammarsAdded());
            Set grammarsRemoved = this._filterSet(e.getGrammarsRemoved());
            Set grammarsChanged = this._filterSet(e.getGrammarsChanged());
            LayeredGrammarProvider.this.fireEvent(grammarsAdded, grammarsRemoved, grammarsChanged);
        }

        private Set _filterSet(Set grammars) {
            Set<Grammar> filteredGrammars = grammars;
            if (!grammars.isEmpty()) {
                filteredGrammars = new HashSet();
                Iterator iter = grammars.iterator();
                Map layerMap = LayeredGrammarProvider.this.getLayerGrammarMap();
                while (iter.hasNext()) {
                    Grammar g = (Grammar)iter.next();
                    String targetNamespace = g.getTargetNamespace();
                    if (layerMap.containsKey(targetNamespace)) continue;
                    filteredGrammars.add(g);
                }
                if (filteredGrammars.isEmpty()) {
                    filteredGrammars = Collections.EMPTY_SET;
                }
            }
            return filteredGrammars;
        }
    }
}

