/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.traversal;

import java.util.Collections;
import oracle.bali.xml.dom.traversal.NodesIterable;
import org.w3c.dom.Node;

public abstract class TreeTraversal {
    public abstract Node getParentNode(Node var1);

    public abstract Node getFirstChild(Node var1);

    public abstract Node getLastChild(Node var1);

    public abstract Node getNextSibling(Node var1);

    public abstract Node getPreviousSibling(Node var1);

    public final Node getSibling(Node node, boolean previous) {
        return previous ? this.getPreviousSibling(node) : this.getNextSibling(node);
    }

    public Node getChild(Node parentNode, int childIndex) {
        Node currChild = this.getFirstChild(parentNode);
        while (childIndex > 0) {
            if (currChild == null) {
                return null;
            }
            currChild = this.getNextSibling(currChild);
            --childIndex;
        }
        return currChild;
    }

    public int getChildCount(Node parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException("No parent Node specified");
        }
        int childCount = 0;
        Node currSibling = this.getFirstChild(parentNode);
        while (currSibling != null) {
            ++childCount;
            currSibling = this.getNextSibling(currSibling);
        }
        return childCount;
    }

    public Node getPreviousNode(Node node) {
        Node prevNode = this.getPreviousSibling(node);
        if (prevNode != null) {
            Node nextPrevNode = prevNode;
            while ((nextPrevNode = this.getLastChild(prevNode = nextPrevNode)) != null) {
            }
        } else {
            prevNode = this.getParentNode(node);
        }
        return prevNode;
    }

    public Node getNextNode(Node node) {
        Node nextNode = this.getFirstChild(node);
        if (nextNode == null) {
            nextNode = this.getNextSibling(node);
            Node currNode = node;
            while (nextNode == null && currNode != null) {
                if ((currNode = this.getParentNode(currNode)) == null) continue;
                nextNode = this.getNextSibling(currNode);
            }
        }
        return nextNode;
    }

    public final Node getNode(Node node, boolean previous) {
        return previous ? this.getPreviousNode(node) : this.getNextNode(node);
    }

    public final Iterable<Node> allNodes(Node start) {
        if (start == null) {
            return Collections.emptyList();
        }
        return new NodesIterable(start, this);
    }

    protected TreeTraversal() {
    }
}

