/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.Utils;

public final class SHA
extends MessageDigest {
    private static final int b = 0;
    private static final int c = 1;
    private static final int d = 2;
    private static final int e = 3;
    private static final int[] f = new int[]{64, 64, 128, 128};
    private static final int[] g = new int[]{512, 512, 1024, 1024};
    private static final int[] h = new int[]{4, 4, 8, 8};
    private static final int[] i = new int[]{32, 32, 64, 64};
    private static final int[] j = new int[]{20, 32, 48, 64};
    private static final int[] k = new int[]{80, 64, 80, 80};
    private static final int[] l = new int[]{2, 2, 4, 4};
    private static final int[] m = new int[]{64, 64, 128, 128};
    private static final String[] n = new String[]{"SHA-1", "SHA-256", "SHA-384", "SHA-512"};
    private a o;
    private a p;
    private byte[] q;
    private boolean r;
    private int[] s;
    private long[] t;
    private static final AlgorithmIdentifier u = AlgID.sha_1;
    private static final int v = 1518500249;
    private static final int w = 1859775393;
    private static final int x = -1894007588;
    private static final int y = -899497514;
    private static final int[] z = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
    private static final int[] A = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] B = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final long[] C = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private static final long[] D = new long[]{-3766243637369397544L, 7105036623409894663L, -7973340178411365097L, 1526699215303891257L, 7436329637833083697L, -8163818279084223215L, -2662702644619276377L, 5167115440072839076L};
    private static final long[] E = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        int n;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1.getOID()) || algorithmIdentifier.getOID().equals(AlgID.sha1.getOID()) || algorithmIdentifier.getOID().equals(AlgID.sha.getOID())) {
            n = 0;
        } else if (algorithmIdentifier.getOID().equals(AlgID.sha_256.getOID())) {
            n = 1;
        } else if (algorithmIdentifier.getOID().equals(AlgID.sha_384.getOID())) {
            n = 2;
        } else if (algorithmIdentifier.getOID().equals(AlgID.sha_512.getOID())) {
            n = 3;
        } else {
            throw new AlgorithmIdentifierException("Algorithm unknown: " + algorithmIdentifier);
        }
        this.o = new a(n);
        this.p = new a(n);
        this.q = new byte[j[this.o.f]];
        switch (this.o.f) {
            case 0: 
            case 1: {
                this.s = new int[k[this.o.f]];
                break;
            }
            case 2: 
            case 3: {
                this.t = new long[k[this.o.f]];
            }
        }
        this.a = algorithmIdentifier;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return this.a;
    }

    @Override
    public String algName() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return n[this.o.f];
    }

    @Override
    public int blockSize() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return f[this.o.f];
    }

    @Override
    public int getDigestLength() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return j[this.o.f];
    }

    @Override
    public void init() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        this.o.init();
        this.r = false;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = Math.min(n2 - i, this.o.c.length - this.o.e);
            System.arraycopy(byArray, n, this.o.c, this.o.e, n3);
            n += n3;
            this.o.e += n3;
            if (this.o.e != this.o.c.length) continue;
            this.j();
        }
        this.o.a(n2);
        this.r = false;
    }

    @Override
    public void update(byte by) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        this.o.c[this.o.e++] = by;
        if (this.o.e == this.o.c.length) {
            this.j();
        }
        this.o.a(1);
        this.r = false;
    }

    @Override
    public byte[] getDigestBits() {
        return (byte[])this.a().clone();
    }

    @Override
    byte[] a() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.q;
    }

    @Override
    public boolean isValid() {
        return this.r;
    }

    @Override
    public void computeCurrent() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        this.o.copyTo(this.p);
        this.i();
        this.n();
        this.r = true;
        a a2 = this.o;
        this.o = this.p;
        this.p = a2;
    }

    @Override
    public Object clone() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        SHA sHA = new SHA();
        try {
            sHA.setAlgID(this.getAlgID());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            // empty catch block
        }
        this.o.copyTo(sHA.o);
        System.arraycopy(this.q, 0, sHA.q, 0, this.q.length);
        sHA.r = this.r;
        return sHA;
    }

    private void i() {
        int n;
        for (n = g[this.o.f] - m[this.o.f] - this.o.e * 8 - 1; n < 0; n += g[this.o.f]) {
        }
        this.o.c[this.o.e++] = -128;
        int n2 = 7;
        if (n + 1 > g[this.o.f] - m[this.o.f]) {
            Utils.setArray(this.o.c, this.o.e, f[this.o.f] - this.o.e, (byte)0);
            n2 += (f[this.o.f] - this.o.e) * 8;
            this.o.e = f[this.o.f];
            this.j();
        }
        int n3 = (n - n2) / 8;
        Utils.setArray(this.o.c, this.o.e, n3, (byte)0);
        this.o.e += n3;
        for (int i = 0; i < this.o.d.length; ++i) {
            Utils.wordsToBytes(this.o.d, i, this.o.c, this.o.e, 1);
            this.o.e += 4;
        }
        this.j();
    }

    private void j() {
        switch (this.o.f) {
            case 0: {
                this.k();
                break;
            }
            case 1: {
                this.l();
                break;
            }
            case 2: 
            case 3: {
                this.m();
            }
        }
    }

    private void k() {
        int n;
        int n2;
        int n3;
        Utils.bytesToWords(this.o.c, 0, this.s, 0, 16);
        int n4 = k[this.o.f];
        for (n3 = f[this.o.f] / h[this.o.f]; n3 < n4; ++n3) {
            this.s[n3] = this.b(1, this.s[n3 - 3] ^ this.s[n3 - 8] ^ this.s[n3 - 14] ^ this.s[n3 - 16]);
        }
        n3 = this.o.a[0];
        n4 = this.o.a[1];
        int n5 = this.o.a[2];
        int n6 = this.o.a[3];
        int n7 = this.o.a[4];
        for (n2 = 0; n2 < 20; ++n2) {
            n = this.b(5, n3) + SHA.a(n4, n5, n6) + n7 + 1518500249 + this.s[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.b(30, n4);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 < 40; ++n2) {
            n = this.b(5, n3) + SHA.b(n4, n5, n6) + n7 + 1859775393 + this.s[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.b(30, n4);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 < 60; ++n2) {
            n = this.b(5, n3) + SHA.c(n4, n5, n6) + n7 + -1894007588 + this.s[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.b(30, n4);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 < 80; ++n2) {
            n = this.b(5, n3) + SHA.d(n4, n5, n6) + n7 + -899497514 + this.s[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.b(30, n4);
            n4 = n3;
            n3 = n;
        }
        this.o.a[0] = this.o.a[0] + n3;
        this.o.a[1] = this.o.a[1] + n4;
        this.o.a[2] = this.o.a[2] + n5;
        this.o.a[3] = this.o.a[3] + n6;
        this.o.a[4] = this.o.a[4] + n7;
        this.o.e = 0;
    }

    private void l() {
        int n;
        Utils.bytesToWords(this.o.c, 0, this.s, 0, 16);
        int n2 = k[this.o.f];
        for (n = f[this.o.f] / h[this.o.f]; n < n2; ++n) {
            this.s[n] = this.d(this.s[n - 2]) + this.s[n - 7] + this.c(this.s[n - 15]) + this.s[n - 16];
        }
        n = this.o.a[0];
        n2 = this.o.a[1];
        int n3 = this.o.a[2];
        int n4 = this.o.a[3];
        int n5 = this.o.a[4];
        int n6 = this.o.a[5];
        int n7 = this.o.a[6];
        int n8 = this.o.a[7];
        int n9 = k[this.o.f];
        for (int i = 0; i < n9; ++i) {
            int n10 = n8 + this.b(n5) + SHA.e(n5, n6, n7) + A[i] + this.s[i];
            int n11 = this.a(n) + SHA.f(n, n2, n3);
            n8 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n4 + n10;
            n4 = n3;
            n3 = n2;
            n2 = n;
            n = n10 + n11;
        }
        this.o.a[0] = this.o.a[0] + n;
        this.o.a[1] = this.o.a[1] + n2;
        this.o.a[2] = this.o.a[2] + n3;
        this.o.a[3] = this.o.a[3] + n4;
        this.o.a[4] = this.o.a[4] + n5;
        this.o.a[5] = this.o.a[5] + n6;
        this.o.a[6] = this.o.a[6] + n7;
        this.o.a[7] = this.o.a[7] + n8;
        this.o.e = 0;
    }

    private void m() {
        Utils.bytesToLongs(this.o.c, 0, this.t, 0, 16);
        int n = k[this.o.f];
        for (int i = f[this.o.f] / h[this.o.f]; i < n; ++i) {
            this.t[i] = this.d(this.t[i - 2]) + this.t[i - 7] + this.c(this.t[i - 15]) + this.t[i - 16];
        }
        long l = this.o.b[0];
        long l2 = this.o.b[1];
        long l3 = this.o.b[2];
        long l4 = this.o.b[3];
        long l5 = this.o.b[4];
        long l6 = this.o.b[5];
        long l7 = this.o.b[6];
        long l8 = this.o.b[7];
        int n2 = k[this.o.f];
        for (int i = 0; i < n2; ++i) {
            long l9 = l8 + this.b(l5) + SHA.a(l5, l6, l7) + C[i] + this.t[i];
            long l10 = this.a(l) + SHA.b(l, l2, l3);
            l8 = l7;
            l7 = l6;
            l6 = l5;
            l5 = l4 + l9;
            l4 = l3;
            l3 = l2;
            l2 = l;
            l = l9 + l10;
        }
        this.o.b[0] = this.o.b[0] + l;
        this.o.b[1] = this.o.b[1] + l2;
        this.o.b[2] = this.o.b[2] + l3;
        this.o.b[3] = this.o.b[3] + l4;
        this.o.b[4] = this.o.b[4] + l5;
        this.o.b[5] = this.o.b[5] + l6;
        this.o.b[6] = this.o.b[6] + l7;
        this.o.b[7] = this.o.b[7] + l8;
        this.o.e = 0;
    }

    private void n() {
        switch (this.o.f) {
            case 0: 
            case 1: {
                Utils.wordsToBytes(this.o.a, this.q);
                break;
            }
            case 2: {
                Utils.longsToBytes(this.o.b, 0, this.q, 0, j[this.o.f] / h[this.o.f]);
                break;
            }
            case 3: {
                Utils.longsToBytes(this.o.b, 0, this.q, 0, j[this.o.f] / h[this.o.f]);
            }
        }
    }

    private int a(int n, int n2) {
        return n2 >>> n;
    }

    private int b(int n, int n2) {
        return n2 << n | n2 >>> i[this.o.f] - n;
    }

    private int c(int n, int n2) {
        return n2 >>> n | n2 << i[this.o.f] - n;
    }

    private long a(long l, long l2) {
        return l2 >>> (int)l;
    }

    private long b(long l, long l2) {
        return l2 << (int)l | l2 >>> (int)((long)i[this.o.f] - l);
    }

    private long c(long l, long l2) {
        return l2 >>> (int)l | l2 << (int)((long)i[this.o.f] - l);
    }

    private static int a(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static int b(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static int c(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private static int d(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int a(int n) {
        return this.c(2, n) ^ this.c(13, n) ^ this.c(22, n);
    }

    private int b(int n) {
        return this.c(6, n) ^ this.c(11, n) ^ this.c(25, n);
    }

    private int c(int n) {
        return this.c(7, n) ^ this.c(18, n) ^ this.a(3, n);
    }

    private int d(int n) {
        return this.c(17, n) ^ this.c(19, n) ^ this.a(10, n);
    }

    private static int e(int n, int n2, int n3) {
        return n & n2 ^ ~n & n3;
    }

    private static int f(int n, int n2, int n3) {
        return n & n2 ^ n & n3 ^ n2 & n3;
    }

    private long a(long l) {
        return this.c(28L, l) ^ this.c(34L, l) ^ this.c(39L, l);
    }

    private long b(long l) {
        return this.c(14L, l) ^ this.c(18L, l) ^ this.c(41L, l);
    }

    private long c(long l) {
        return this.c(1L, l) ^ this.c(8L, l) ^ this.a(7L, l);
    }

    private long d(long l) {
        return this.c(19L, l) ^ this.c(61L, l) ^ this.a(6L, l);
    }

    private static long a(long l, long l2, long l3) {
        return l & l2 ^ (l ^ 0xFFFFFFFFFFFFFFFFL) & l3;
    }

    private static long b(long l, long l2, long l3) {
        return l & l2 ^ l & l3 ^ l2 & l3;
    }

    @Override
    protected MessageDigest.MDState b() {
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return this.o;
    }

    @Override
    protected void a(MessageDigest.MDState mDState) {
        if (this.a == null) {
            try {
                this.setAlgID(u);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        mDState.copyTo(this.o);
        this.r = false;
    }

    final class a
    extends MessageDigest.MDState {
        int[] a;
        long[] b;
        byte[] c;
        int[] d;
        int e;
        int f;

        a() {
            super(SHA.this);
        }

        a(int n) {
            super(SHA.this);
            this.f = n;
            this.c = new byte[f[n]];
            this.d = new int[l[n]];
            switch (n) {
                case 0: {
                    this.a = (int[])z.clone();
                    break;
                }
                case 1: {
                    this.a = (int[])B.clone();
                    break;
                }
                case 2: {
                    this.b = (long[])D.clone();
                    break;
                }
                case 3: {
                    this.b = (long[])E.clone();
                }
            }
        }

        @Override
        public void init() {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            switch (this.f) {
                case 0: {
                    System.arraycopy(z, 0, this.a, 0, this.a.length);
                    break;
                }
                case 1: {
                    System.arraycopy(B, 0, this.a, 0, this.a.length);
                    break;
                }
                case 2: {
                    System.arraycopy(D, 0, this.b, 0, this.b.length);
                    break;
                }
                case 3: {
                    System.arraycopy(E, 0, this.b, 0, this.b.length);
                }
            }
            for (int i = 0; i < this.d.length; ++i) {
                this.d[i] = 0;
            }
            this.e = 0;
        }

        public void a(int n) {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            switch (this.f) {
                case 0: 
                case 1: {
                    int n2 = this.d[1];
                    this.d[1] = n2 + (n << 3);
                    if (this.d[1] < n2) {
                        this.d[0] = this.d[0] + 1;
                    }
                    this.d[0] = this.d[0] + (n >>> 29);
                    break;
                }
                case 2: 
                case 3: {
                    int n3 = this.d[3];
                    this.d[3] = n3 + (n << 3);
                    int n4 = this.d[3] < n3 ? n >>> 30 : n >>> 29;
                    n3 = this.d[2];
                    this.d[2] = this.d[2] + (n3 + n4);
                    n4 = this.d[2] < n3 ? 1 : 0;
                    n3 = this.d[1];
                    this.d[1] = this.d[1] + (n3 + n4);
                    n4 = this.d[1] < n3 ? 1 : 0;
                    this.d[0] = this.d[0] + n4;
                    break;
                }
            }
        }

        @Override
        public Object clone() {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            a a2 = new a();
            this.copyTo(a2);
            return a2;
        }

        @Override
        public void copyTo(MessageDigest.MDState mDState) {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("SHAState required");
            }
            a a2 = (a)mDState;
            a2.e = this.e;
            switch (this.f) {
                case 0: 
                case 1: {
                    a2.a = (int[])this.a.clone();
                    break;
                }
                case 2: 
                case 3: {
                    a2.b = (long[])this.b.clone();
                }
            }
            a2.c = (byte[])this.c.clone();
            a2.d = (int[])this.d.clone();
            a2.f = this.f;
        }
    }
}

