/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.build;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.compiler.BuildSystemConfiguration;
import oracle.jdeveloper.compiler.CompArb;

public final class BuildExcludesPanel
extends ProjectSettingsTraversablePanel
implements ActionListener {
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final DefaultListModel<URL> excludesListModel = new DefaultListModel();
    private final JList<URL> excludesList = new JList<URL>(this.excludesListModel);
    private final JScrollPane excludesScroller = new JScrollPane(this.excludesList);
    private URL projectUrl;

    public BuildExcludesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.excludesList.setCellRenderer(new ExcludesCellRenderer());
        this.excludesList.getSelectionModel().setSelectionMode(2);
        ResourceUtils.resButton((AbstractButton)this.addButton, (String)CompArb.getString(157));
        ResourceUtils.resButton((AbstractButton)this.removeButton, (String)CompArb.getString(158));
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        JLabel topLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)topLabel, (Component)this.excludesScroller, (String)CompArb.getString(156));
        this.add(topLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.excludesScroller, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.addButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 8, 5, 0), 0, 0));
        this.add(this.removeButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 12, 2, new Insets(0, 8, 0, 0), 0, 0));
        this.setHelpID("f1_excludeFiles_default_html");
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (tc != null && BuildExcludesPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_excludeFiles_default_html");
        } else {
            this.setHelpID("f1_excludeFiles_nonDefault_html");
        }
        Project project = BuildExcludesPanel.getProject((Namespace)tc, (boolean)false);
        if (project != null) {
            this.projectUrl = project.getURL();
            this.excludesListModel.removeAllElements();
            BuildSystemConfiguration config = BuildSystemConfiguration.getInstance((PropertyStorage)BuildExcludesPanel.getPropertyData((Namespace)tc));
            List excludedUrls = config.getExcludedUrls(project);
            for (URL url : excludedUrls) {
                this.excludesListModel.addElement(url);
            }
            if (excludedUrls.size() > 0) {
                this.removeButton.setEnabled(true);
                this.excludesList.setSelectedIndex(0);
            }
        }
        if (this.excludesListModel.size() <= 0) {
            this.removeButton.setEnabled(false);
        }
    }

    public void onExit(TraversableContext tc) {
        BuildSystemConfiguration config = BuildSystemConfiguration.getInstance((PropertyStorage)BuildExcludesPanel.getPropertyData((Namespace)tc));
        Project project = BuildExcludesPanel.getProject((Namespace)tc, (boolean)false);
        if (project != null) {
            boolean update;
            List currentExcluded = config.getExcludedUrls(project);
            ArrayList<URL> newExcluded = new ArrayList<URL>(this.excludesListModel.size());
            for (int x = 0; x < this.excludesListModel.size(); ++x) {
                newExcluded.add(this.excludesListModel.get(x));
            }
            boolean bl = update = currentExcluded.size() != newExcluded.size();
            if (!update) {
                int count = 0;
                for (URL url : newExcluded) {
                    if (!url.equals(currentExcluded.get(count))) {
                        update = true;
                        break;
                    }
                    ++count;
                }
            }
            if (update) {
                config.setExcludedUrls(project, newExcluded);
            }
        }
    }

    public String getDataKey() {
        return BuildExcludesPanel.class.getName();
    }

    public String[] getPropertyKeys() {
        int size = this.excludesListModel.size();
        String[] keys = new String[size];
        for (int x = 0; x < size; ++x) {
            keys[x] = this.excludesListModel.get(x).toString();
        }
        return keys;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.addButton) {
            URL[] selection;
            URLChooser chooser = DialogUtil.newURLChooser((Context)new Context(), (URL)this.projectUrl);
            chooser.setShowJarsAsDirs(false);
            chooser.setSelectionScope(2);
            int result = chooser.showOpenDialog((Component)((Object)this), CompArb.getString(159));
            if (result == 0 && (selection = chooser.getSelectedURLs()) != null && selection.length > 0) {
                for (URL url : selection) {
                    if (this.excludesListModel.contains(url)) continue;
                    this.excludesListModel.addElement(url);
                }
                if (!this.removeButton.isEnabled()) {
                    this.removeButton.setEnabled(true);
                    this.excludesList.setSelectedIndex(0);
                }
            }
        } else if (src == this.removeButton) {
            int selectedIndex = this.excludesList.getSelectedIndex();
            int[] list = this.excludesList.getSelectedIndices();
            Arrays.sort(list);
            for (int x = list.length - 1; x >= 0; --x) {
                this.excludesListModel.remove(list[x]);
            }
            int length = this.excludesListModel.size();
            if (length > 0) {
                if (selectedIndex >= length) {
                    selectedIndex = length - 1;
                }
                this.excludesList.setSelectedIndex(selectedIndex);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private class ExcludesCellRenderer
    extends DefaultListCellRenderer {
        private transient Icon folderIcon = OracleIcons.getIcon((String)"folder.png");
        private transient Icon fileIcon = OracleIcons.getIcon((String)"file.png");

        ExcludesCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            URL url = (URL)value;
            String relativeSpec = URLFileSystem.toRelativeSpec((URL)url, (URL)BuildExcludesPanel.this.projectUrl);
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, relativeSpec, index, isSelected, cellHasFocus);
            if (value.toString().endsWith("/")) {
                label.setIcon(this.folderIcon);
            } else {
                label.setIcon(this.fileIcon);
            }
            label.setToolTipText(value.toString());
            return label;
        }
    }
}

