/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler.ant;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public class AntConfiguration
extends HashStructureAdapter {
    public static final String DATA_KEY = AntConfiguration.class.getName();
    public static final String PROJECT_BUILDFILE = "projectBuildfile";
    public static final String MAKE_TARGET = "makeTarget";
    public static final String REBUILD_TARGET = "rebuildTarget";
    public static final String ARGUMENTS = "arguments";
    public static final String SHOW_OUTPUT = "showOutput";
    public static final String TARGET_LIST = "targetList";

    private AntConfiguration(HashStructure hash) {
        super(hash);
    }

    public static AntConfiguration getAntConfiguration(PropertyStorage propertyData) {
        HashStructure projectProperties = propertyData.getProperties();
        HashStructure hash = projectProperties.getOrCreateHashStructure(DATA_KEY);
        return new AntConfiguration(hash);
    }

    public URL getProjectBuildfile() {
        return this._hash.getURL(PROJECT_BUILDFILE);
    }

    public void setProjectBuildfile(URL projectBuildfile) {
        this._hash.putURL(PROJECT_BUILDFILE, projectBuildfile, true);
    }

    public String getMakeTarget() {
        return this._hash.getString(MAKE_TARGET);
    }

    public void setMakeTarget(String makeTarget) {
        this._hash.putString(MAKE_TARGET, makeTarget, true);
    }

    public String getRebuildTarget() {
        return this._hash.getString(REBUILD_TARGET);
    }

    public void setRebuildTarget(String rebuildTarget) {
        this._hash.putString(REBUILD_TARGET, rebuildTarget, true);
    }

    public String getArguments() {
        return this._hash.getString(ARGUMENTS);
    }

    public void setArguments(String arguments) {
        this._hash.putString(ARGUMENTS, arguments, true);
    }

    public boolean isShowOutput() {
        return this._hash.getBoolean(SHOW_OUTPUT, true);
    }

    public void setShowOutput(boolean showOutput) {
        this._hash.putBoolean(SHOW_OUTPUT, showOutput);
    }

    public List getTargetList() {
        ListStructure list = this._hash.getListStructure(TARGET_LIST);
        ArrayList copy = new ArrayList();
        if (list != null) {
            copy.addAll(list);
        }
        return copy;
    }

    public void setTargetList(List targets) {
        if (targets == null) {
            this._hash.remove(TARGET_LIST);
        } else {
            ListStructure list = this._hash.getOrCreateListStructure(TARGET_LIST);
            list.mirror(targets);
        }
    }

    public static boolean hasBuildfile(Project project) {
        boolean hasBuildfile = false;
        if (project != null && project instanceof Project) {
            AntConfiguration ac = AntConfiguration.getAntConfiguration((PropertyStorage)project);
            hasBuildfile = ac != null && ac.getProjectBuildfile() != null;
        }
        return hasBuildfile;
    }
}

