/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.ide.marshal.xml.HashStructureIO;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class GenRspFile {
    private static final boolean COMPILE_BY_FILE = false;
    private static final String BASE_NAMESPACE_URI = "http://xmlns.oracle.com/jdeveloper/10130/";
    private static final String ROOT_QNAME = "jpr:project";
    private static final String NAMESPACE_URI = GenRspFile.toNamespaceURI("project");

    private GenRspFile() {
    }

    private static String toNamespaceURI(String documentID) {
        StringBuffer buf = new StringBuffer(BASE_NAMESPACE_URI);
        buf.append(documentID);
        return buf.toString();
    }

    private static String[] retrievePathList(XMLDocument doc, String classpathPath, NSResolver nsResolver, String rootPath) {
        try {
            NodeList pathElems = doc.selectNodes(classpathPath);
            int numPathElems = pathElems.getLength();
            String[] paths = new String[numPathElems];
            for (int i = 0; i < numPathElems; ++i) {
                XMLNode pathElemText = (XMLNode)pathElems.item(i);
                String pathName = pathElemText.getNodeValue();
                if (!new File(pathName).isAbsolute()) {
                    File file = new File(rootPath, pathName);
                    paths[i] = file.getPath();
                    continue;
                }
                paths[i] = pathName;
            }
            return paths;
        }
        catch (XSLException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] processLibrary(URL libraryURL, String nodeName, String pathListPath) {
        FileInputStream fileInputStream = null;
        try {
            File libraryFile = new File(libraryURL.getPath());
            DOMParser domParser = new DOMParser();
            String canonicalLibraryPath = libraryFile.getParentFile().getPath();
            fileInputStream = new FileInputStream(libraryFile);
            domParser.parse((InputStream)fileInputStream);
            XMLDocument doc = domParser.getDocument();
            String[] stringArray = GenRspFile.retrievePathList(doc, pathListPath, null, canonicalLibraryPath);
            return stringArray;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLParseException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                    fileInputStream = null;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    private static void processJpr(Arguments args, CompilerInfo ci, List rtsList) throws IOException {
        ListStructure ls;
        File jprFile = args.getProjectFile();
        HashStructureIO hsIO = new HashStructureIO(NAMESPACE_URI, ROOT_QNAME);
        HashStructure hs = HashStructure.newInstance();
        hsIO.open(URLFactory.newFileURL((String)jprFile.getPath()), (Object)hs);
        ci.sourcePaths = new HashMap();
        ci.packages = new HashMap();
        ProjectContent projectContent = ProjectContent.getInstance((HashStructure)hs);
        ListStructure csList = projectContent.getContentSetList();
        if (csList.size() == 0) {
            csList.add((Object)"oracle.jdeveloper.model.PathsConfiguration/javaContentSet");
        }
        ContentSet composite = projectContent.getAllContents();
        URL[] urls = composite.getAllRootDirs().getEntries();
        for (int i = 0; urls != null && i < urls.length; ++i) {
            File dir = new File(urls[i].getPath());
            if (!dir.isDirectory()) continue;
            String path = dir.getPath();
            ci.sourcePaths.put(path, path);
        }
        Iterator urlIter = composite.urlIterator("");
        while (urlIter.hasNext()) {
            String pkgName;
            URL url = (URL)urlIter.next();
            String relPath = composite.toRelativePath(url);
            int idx = relPath.lastIndexOf(47);
            String string = pkgName = idx > 0 ? relPath.substring(0, idx) : null;
            if (pkgName != null && pkgName.indexOf(46) < 0) {
                ci.packages.put(pkgName, pkgName);
            }
            if (rtsList == null || !(relPath = composite.toRelativePath(url)).toLowerCase().endsWith(".rts")) continue;
            rtsList.add(relPath);
        }
        HashStructure jpl = hs.getHashStructure("oracle.jdevimpl.config.JProjectLibraries");
        if (jpl != null) {
            Object obj;
            ci.jdkRefUrl = jpl.getURL("jdkReference/id");
            ci.librariesRefUrl = new ArrayList();
            ci.librariesRefMap = new HashMap();
            ls = jpl.getListStructure("libraryReferences");
            if (ls != null) {
                for (int i = 0; i < ls.size(); ++i) {
                    HashStructure libRef = (HashStructure)ls.get(i);
                    obj = libRef.getObject("id");
                    if (obj instanceof URL) {
                        ci.librariesRefUrl.add(obj);
                        continue;
                    }
                    if (obj instanceof String) {
                        ci.librariesRefMap.put(obj, obj);
                        continue;
                    }
                    System.out.println("libraryReferences: unknown reference type --> " + obj.getClass().toString());
                }
            }
            if ((ls = jpl.getListStructure("internalDefinitions/libraryDefinitions")) != null) {
                for (int i = 0; i < ls.size(); ++i) {
                    HashStructure libDef = (HashStructure)ls.get(i);
                    obj = libDef.getObject("id");
                    if (obj instanceof String && ci.librariesRefMap.get(obj) != null && ci.librariesRefMap.get(obj).equals(obj)) {
                        int j;
                        ListStructure sp = libDef.getListStructure("sourcePath");
                        ListStructure cp = libDef.getListStructure("classPath");
                        String[] list = new String[(sp == null ? 0 : sp.size()) + (cp == null ? 0 : cp.size())];
                        if (sp != null) {
                            for (j = 0; j < sp.size(); ++j) {
                                list[j] = new File(((URL)sp.get(j)).getPath()).getPath();
                            }
                        }
                        if (cp != null) {
                            for (j = 0; j < cp.size(); ++j) {
                                list[j] = new File(((URL)cp.get(j)).getPath()).getPath();
                            }
                        }
                        ci.librariesRefMap.put(obj, list);
                        continue;
                    }
                    System.out.println("internalDefinitions/libraryDefinitions: unknown id type --> " + obj.getClass().toString());
                }
            }
        }
        HashStructure compilerOptions = hs.getHashStructure("oracle.jdeveloper.compiler.OjcConfiguration");
        assert (compilerOptions != null);
        String compilerName = compilerOptions.getString("compiler.name", "Javac");
        String compilerOptionsAsString = compilerName + ".commandline.options";
        String compilerOptionsAsList = compilerName + ".commandline.optionlist";
        if (compilerOptions.containsKey(compilerOptionsAsList)) {
            List options = compilerOptions.getAsList(compilerOptionsAsList);
            StringBuffer optionBuf = new StringBuffer();
            for (int i = 0; i < options.size(); ++i) {
                optionBuf.append(options.get(i).toString());
                optionBuf.append(' ');
            }
            ci.compilerOptions = optionBuf.toString();
        } else if (compilerOptions.containsKey(compilerOptionsAsString)) {
            ci.compilerOptions = compilerOptions.getString(compilerOptionsAsString, "-g -warn");
        } else {
            ci.compilerOptions = null;
            ci.debugInfo = compilerOptions.getBoolean("debugInformation", true);
            ci.showWarnings = compilerOptions.getBoolean("showWarnings", true);
            ci.showPartialImportWarnings = compilerOptions.getBoolean("showPartialImportWarnings", false);
            ci.showUnusedImportWarnings = compilerOptions.getBoolean("showUnusedImportWarnings", false);
            ci.showObjectDotStaticWarnings = compilerOptions.getBoolean("showObjectDotStaticWarnings", false);
            ci.showDeprecations = compilerOptions.getBoolean("showDeprecations", true);
            ci.showSelfDeprecations = compilerOptions.getBoolean("showSelfDeprecations", true);
        }
        ci.source = compilerOptions.getString("source");
        ci.target = compilerOptions.getString("target");
        ci.internalEncoding = compilerOptions.getString("internalEncoding");
        ls = compilerOptions.getListStructure("copyRes");
        ci.copyRes = new String[ls != null ? ls.size() : 0];
        if (ls != null) {
            ls.toArray((Object[])ci.copyRes);
        }
        HashStructure jpp = hs.getHashStructure("oracle.jdevimpl.config.JProjectPaths");
        assert (jpp != null);
        ci.outputDirectory = new File(jpp.getURL("outputDirectory").getPath()).getPath();
        ListStructure dependencies = hs.getListStructure("oracle.ide.model.DependencyConfiguration/dependencyList");
        if (dependencies != null && dependencies.size() > 0) {
            ci.dependentProjectsOutputDirs = new ArrayList();
            for (HashStructure depHash : dependencies) {
                String outputDirStr;
                URL depURL = depHash.getURL("sourceURL");
                if (depURL == null || (outputDirStr = GenRspFile.getOutputDirectoryStr(depURL)) == null) continue;
                ci.dependentProjectsOutputDirs.add(outputDirStr);
            }
        }
        ci.additionalClassPath = new URL[(ls = jpp.getListStructure("additionalClassPath")) != null ? ls.size() : 0];
        if (ls != null) {
            ls.toArray((Object[])ci.additionalClassPath);
        }
    }

    private static String getOutputDirectoryStr(URL projectURL) {
        HashStructureIO hsIO = new HashStructureIO(NAMESPACE_URI, ROOT_QNAME);
        try {
            HashStructure hs = HashStructure.newInstance();
            hsIO.open(projectURL, (Object)hs);
            URL outputDirURL = hs.getURL("oracle.jdevimpl.config.JProjectPaths/outputDirectory");
            if (outputDirURL != null) {
                return new File(outputDirURL.getPath()).getPath();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void appendCharSepList(StringBuffer cp, String[] cpElem) {
        for (int i = 0; i < cpElem.length; ++i) {
            cp.append(cpElem[i]);
            cp.append(File.pathSeparator);
        }
    }

    private static String[] getJdkPaths(URL libraryURL) {
        return GenRspFile.processLibrary(libraryURL, "jdknode", "/*[local-name()='JDKNode']/*[local-name()='classPath']/*[local-name()='entries']/*[local-name()='Item']/@path");
    }

    private static String[] getLibraryPaths(URL libraryURL) {
        return GenRspFile.processLibrary(libraryURL, "jlibrarynode", "/*[local-name()='JLibraryNode']/*[local-name()='classPath']/*[local-name()='entries']/*[local-name()='Item']/@path");
    }

    private static String cleanPaths(StringBuffer sb) {
        int dd;
        String doubleDots = File.separator + ".." + File.separator;
        int idx = 0;
        int len = sb.length();
        while ((dd = sb.indexOf(doubleDots, idx)) >= 0 && (dd != idx || sb.length() != len)) {
            int i;
            len = sb.length();
            for (i = dd - 1; i >= 0 && sb.charAt(i) == File.separatorChar; --i) {
            }
            while (i >= 0 && sb.charAt(i) != File.separatorChar) {
                --i;
            }
            if (i >= 0 && i < dd) {
                sb.delete(i, dd + 3);
            }
            idx = i;
        }
        return sb.toString();
    }

    private static void buildResponseFile(PrintStream ps, CompilerInfo ci) {
        ps.println("-msglimit:-1");
        if (ci.compilerOptions != null) {
            ps.println(ci.compilerOptions);
        } else {
            if (ci.debugInfo) {
                ps.println("-g");
            }
            if (ci.showDeprecations) {
                ps.println("-deprecation" + (ci.showSelfDeprecations ? ":self" : ""));
            }
            if (ci.showWarnings) {
                ps.println("-warn");
                if (!ci.showObjectDotStaticWarnings) {
                    ps.println("-nowarn:320");
                }
                if (!ci.showUnusedImportWarnings) {
                    ps.println("-nowarn:486");
                }
                if (!ci.showPartialImportWarnings) {
                    ps.println("-nowarn:487");
                }
                ps.println("-nowarn:376");
                ps.println("-nowarn:412");
                ps.println("-nowarn:414");
                ps.println("-nowarn:415");
                ps.println("-nowarn:558");
                ps.println("-nowarn:560");
            } else {
                ps.println("-nowarn");
            }
        }
        if (ci.source != null && ci.source.length() > 0) {
            ps.println("-source " + ci.source);
        }
        if (ci.target != null && ci.target.length() > 0) {
            ps.println("-target " + ci.target);
        }
        if (ci.internalEncoding != null && ci.internalEncoding.length() > 0) {
            ps.println("-encoding " + ci.internalEncoding);
        }
        if (ci.copyRes != null && ci.copyRes.length > 0) {
            StringBuffer sb = new StringBuffer("-deploy " + ci.copyRes[0]);
            for (int i = 1; i < ci.copyRes.length; ++i) {
                sb.append(File.pathSeparator);
                sb.append(ci.copyRes[i]);
            }
            ps.println(sb.toString());
        }
        StringBuffer cp = new StringBuffer("-classpath ");
        ArrayList<String> outputDirs = new ArrayList<String>();
        if (ci.outputDirectory != null) {
            outputDirs.add(ci.outputDirectory);
            ps.println("-d " + ci.outputDirectory);
            GenRspFile.appendCharSepList(cp, new String[]{ci.outputDirectory});
        }
        if (ci.dependentProjectsOutputDirs != null) {
            for (String dir : ci.dependentProjectsOutputDirs) {
                if (dir == null || outputDirs.contains(dir)) continue;
                outputDirs.add(dir);
                GenRspFile.appendCharSepList(cp, new String[]{dir});
            }
        }
        if (ci.jdkRefUrl != null) {
            String[] list = GenRspFile.getJdkPaths(ci.jdkRefUrl);
            if (list != null) {
                GenRspFile.appendCharSepList(cp, list);
            } else {
                System.err.println("warning: " + ci.jdkRefUrl.getPath() + " not found in libraries.xml");
            }
        }
        if (ci.librariesRefUrl != null) {
            for (int i = 0; i < ci.librariesRefUrl.size(); ++i) {
                URL url = (URL)ci.librariesRefUrl.get(i);
                String[] list = GenRspFile.getLibraryPaths(url);
                if (list != null) {
                    GenRspFile.appendCharSepList(cp, list);
                    continue;
                }
                System.err.println("warning: " + url.getPath() + " not found");
            }
        }
        if (ci.librariesRefMap != null) {
            for (Object obj : ci.librariesRefMap.values()) {
                if (obj instanceof String[]) {
                    GenRspFile.appendCharSepList(cp, (String[])obj);
                    continue;
                }
                System.out.println("warning: reference library " + obj + " not defined");
            }
        }
        if (ci.additionalClassPath != null) {
            for (int i = 0; i < ci.additionalClassPath.length; ++i) {
                cp.append(new File(ci.additionalClassPath[i].getPath()).getPath());
                cp.append(File.pathSeparator);
            }
        }
        if (cp.charAt(cp.length() - 1) == File.pathSeparatorChar) {
            cp.setLength(cp.length() - 1);
        }
        ps.println(GenRspFile.cleanPaths(cp));
        String[] spArray = new String[ci.sourcePaths.size()];
        ci.sourcePaths.values().toArray(spArray);
        if (spArray.length > 0) {
            StringBuffer sp = new StringBuffer("-sourcepath " + spArray[0]);
            for (int j = 1; j < spArray.length; ++j) {
                sp.append(File.pathSeparator);
                sp.append(spArray[j]);
            }
            ps.println(GenRspFile.cleanPaths(sp));
        }
        Object[] pkArray = new String[ci.packages.size()];
        ci.packages.values().toArray(pkArray);
        if (pkArray.length > 0) {
            Arrays.sort(pkArray);
            ps.println("-p");
            for (int i = 0; i < pkArray.length; ++i) {
                ps.println(((String)pkArray[i]).replace('/', '.'));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            String outFileName;
            if (args.length < 1 || args.length > 3) {
                System.err.println("usage: GenRspFile <projectFile> [-ideproperties:<IdePropertiesPathName>] [<responseFile>]");
                System.out.println();
                System.out.println("\tIdePropertiesPathName is the full qualified pathname to the file ide.properties");
                System.out.println("\twhich is used to get the value of Ide.GlobalIgnoreListFilters");
                System.exit(1);
            }
            Arguments arguments = new Arguments();
            arguments.setProjectFile(new File(args[0]));
            Object idePropsPathName = null;
            int nextArg = 1;
            if (args.length > nextArg && (args[nextArg].startsWith("-dir:") || args[nextArg].startsWith("-ideproperties:"))) {
                int pathPos = args[nextArg].indexOf(58) + 1;
                if (pathPos == 5) {
                    System.out.println("Warning: -dir argument is obsolete, use -ideproperties to specify the location of ide.properties");
                    idePropsPathName = new File(args[nextArg].substring(pathPos)).getParentFile().getParent() + "/java/oracle/jdeveloper/ide.properties";
                } else {
                    idePropsPathName = args[nextArg].substring(pathPos);
                }
                ++nextArg;
            }
            if (idePropsPathName != null) {
                arguments.setIdePropsFile(new File((String)idePropsPathName));
            }
            String string = outFileName = args.length > nextArg ? args[nextArg] : null;
            if (outFileName != null) {
                arguments.setOutputFile(new File(outFileName));
            }
            GenRspFile.generateRSPFile(arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            throw e;
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateRSPFile(Arguments args) throws IOException {
        long startTime = System.currentTimeMillis();
        if (!args.getProjectFile().exists() || !args.getProjectFile().canRead()) {
            throw new FileNotFoundException("Project file " + args.getProjectFile() + " does not exist, or could not be read.");
        }
        if (args.getOutputFile() != null) {
            System.out.println("Generating .rsp file: " + args.getOutputFile());
        }
        Properties ideProps = new Properties();
        InputStream is = null;
        try {
            if (args.getIdePropsFile() == null) {
                is = GenRspFile.class.getResourceAsStream("/oracle/jdeveloper/ide.properties");
                if (is == null) {
                    is = new FileInputStream(new File(args.getProjectFile().getParentFile().getParentFile(), "jdeveloper/oracle/jdeveloper/ide.properties"));
                }
            } else {
                is = new FileInputStream(args.getIdePropsFile());
            }
            ideProps.load(is);
            System.setProperty("Ide.GlobalIgnoreListFilters", ideProps.getProperty("Ide.GlobalIgnoreListFilters"));
        }
        catch (FileNotFoundException e) {
            System.setProperty("Ide.GlobalIgnoreListFilters", "**/.ade_path/**;**/.ade_path");
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
        CompilerInfo ci = new CompilerInfo();
        ArrayList rtsList = null;
        if (args.getRtsListFile() != null) {
            rtsList = new ArrayList();
        }
        GenRspFile.processJpr(args, ci, rtsList);
        PrintStream ps = null;
        FileOutputStream fos = null;
        try {
            if (args.getOutputFile() != null) {
                args.getOutputFile().getParentFile().mkdirs();
                fos = new FileOutputStream(args.getOutputFile());
                ps = new PrintStream(fos);
                GenRspFile.buildResponseFile(ps, ci);
            } else {
                GenRspFile.buildResponseFile(System.out, ci);
            }
            if (ci.outputDirectory != null) {
                System.out.println("Output directory is " + ci.outputDirectory);
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            } else if (fos != null) {
                fos.close();
            }
            ps = null;
            fos = null;
        }
        if (rtsList != null) {
            args.getRtsListFile().getParentFile().mkdirs();
            PrintWriter pw = null;
            FileWriter fw = null;
            try {
                fw = new FileWriter(args.getRtsListFile());
                pw = new PrintWriter(fw);
                Iterator i = rtsList.iterator();
                while (i.hasNext()) {
                    pw.println(i.next());
                }
                System.out.println("Generated " + args.getRtsListFile());
            }
            finally {
                if (pw != null) {
                    pw.close();
                } else if (fw != null) {
                    fw.close();
                }
                pw = null;
                fw = null;
            }
        }
        long stopTime = System.currentTimeMillis();
        if (args.getOutputFile() != null) {
            System.out.println("Finished generating rsp (" + (stopTime - startTime) + " ms)");
        }
    }

    public static class Arguments {
        private File _projectFile;
        private File _idePropsFile;
        private File _outputFile;
        private File _rtsListFile;

        public File getRtsListFile() {
            return this._rtsListFile;
        }

        public void setRtsListFile(File rtsListFile) {
            this._rtsListFile = rtsListFile;
        }

        public File getProjectFile() {
            return this._projectFile;
        }

        public void setProjectFile(File projectFile) {
            this._projectFile = projectFile;
        }

        public File getIdePropsFile() {
            return this._idePropsFile;
        }

        public void setIdePropsFile(File idePropsFile) {
            this._idePropsFile = idePropsFile;
        }

        public File getOutputFile() {
            return this._outputFile;
        }

        public void setOutputFile(File outputFile) {
            this._outputFile = outputFile;
        }
    }

    private static class CompilerInfo {
        boolean debugInfo;
        boolean showWarnings;
        boolean showPartialImportWarnings;
        boolean showUnusedImportWarnings;
        boolean showObjectDotStaticWarnings;
        boolean showDeprecations;
        boolean showSelfDeprecations;
        String compilerOptions;
        String source;
        String target;
        String internalEncoding;
        String[] copyRes;
        HashMap sourcePaths;
        HashMap packages;
        String outputDirectory;
        ArrayList dependentProjectsOutputDirs;
        URL[] additionalClassPath;
        ArrayList librariesRefUrl;
        HashMap librariesRefMap;
        URL jdkRefUrl;

        private CompilerInfo() {
        }
    }
}

