/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.ide.natives.NativeHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.jdeveloper.compiler.InputReadTextBuffer;

@Deprecated
public class DependencyProvider {
    private ArrayList data = new ArrayList();
    private HashMap classMap = new HashMap();
    private HashMap urlMap = new HashMap();
    private static final int MAGIC_HEADER_10_1_3 = 0x10010300;
    private long tickHolder;

    public void reinit() {
        this.data.clear();
        this.classMap.clear();
        this.urlMap.clear();
    }

    private Long getLastModified(URL url) throws IOException {
        long lastModified = new File(url.getPath()).lastModified();
        if (lastModified == 0L) {
            lastModified = url.openConnection().getLastModified();
        }
        return lastModified;
    }

    private void collectSourceFile(SourceFile sf, URL path, boolean dependant, int dataIndex) throws IOException {
        if (dataIndex == -1) {
            this.data.ensureCapacity(this.data.size() + 7);
            dataIndex = this.data.size();
            for (int i = 0; i < 7; ++i) {
                this.data.add(null);
            }
        }
        this.data.set(dataIndex, path);
        this.data.set(dataIndex + 1, this.getLastModified(path));
        String pkgName = sf.getPackageName();
        this.data.set(dataIndex + 2, pkgName);
        List typeList = sf.getPossibleTypes();
        String[] typeArray = new String[typeList.size()];
        typeList.toArray(typeArray);
        this.data.set(dataIndex + 3, typeArray);
        List classList = sf.getSourceClasses();
        Iterator it = classList.iterator();
        String[] classArray = new String[classList.size()];
        int i = 0;
        while (it.hasNext()) {
            classArray[i] = ((SourceClass)it.next()).getName();
            ++i;
        }
        this.data.set(dataIndex + 4, classArray);
        List imports = sf.getSourceImports();
        it = imports.iterator();
        String[] importArray = new String[imports.size()];
        int i2 = 0;
        while (it.hasNext()) {
            importArray[i2] = ((SourceImport)it.next()).getName();
            ++i2;
        }
        this.data.set(dataIndex + 5, importArray);
        this.data.set(dataIndex + 6, dependant ? Boolean.TRUE : Boolean.FALSE);
    }

    private static String[] resolveTypes(String pkgName, String[] types, String[] imports, HashMap pkgs, HashMap classMap) {
        int i;
        HashMap<String, String> importSuffixes = new HashMap<String, String>();
        ArrayList<String> wideImports = new ArrayList<String>();
        boolean javaLangFound = false;
        for (i = 0; i < imports.length; ++i) {
            String imp = imports[i];
            int lastDot = imp.lastIndexOf(46);
            if (lastDot < 0) continue;
            if (imp.endsWith("*")) {
                String wideImport = imp.substring(0, lastDot);
                if (pkgs.get(wideImport) != null) {
                    wideImports.add(wideImport);
                }
                javaLangFound = wideImport.equals("java.lang");
                continue;
            }
            importSuffixes.put(imp.substring(lastDot + 1), imp);
        }
        if (!javaLangFound && pkgs.get("java.lang") != null) {
            wideImports.add("java.lang");
        }
        for (i = 0; i < types.length; ++i) {
            String clsName;
            String match;
            String type = types[i];
            int dot = type.indexOf(46);
            if (dot >= 0) {
                if (classMap.get(type) != null) continue;
                type = type.substring(0, dot);
            }
            if ((match = (String)importSuffixes.get(type)) != null) {
                types[i] = match;
                continue;
            }
            boolean found = false;
            for (int j = 0; j < wideImports.size(); ++j) {
                String qName = (String)wideImports.get(j) + type;
                if (classMap.get(qName) == null) continue;
                types[i] = qName;
                found = true;
                break;
            }
            if (found || classMap.get(clsName = pkgName + "." + type) == null) continue;
            types[i] = clsName;
        }
        return types;
    }

    public void computeDependencies() {
        URL url;
        int i;
        this.classMap.clear();
        HashMap<String, String> pkgs = new HashMap<String, String>();
        for (i = 0; i < this.data.size(); i += 7) {
            String pkgName = (String)this.data.get(i + 2);
            if (pkgs.get(pkgName) == null) {
                pkgs.put(pkgName, pkgName);
            }
            URL url2 = (URL)this.data.get(i);
            String[] classes = (String[])this.data.get(i + 4);
            for (int j = 0; j < classes.length; ++j) {
                String className = pkgName + "." + classes[j];
                if (this.classMap.get(className) == null) {
                    HashMap<String, URL> usedBy = new HashMap<String, URL>();
                    usedBy.put(" sourcefile ", url2);
                    this.classMap.put(className, usedBy);
                    continue;
                }
                URL otherSource = (URL)((HashMap)this.classMap.get(className)).get(" sourcefile ");
                System.out.println("DependencyProvider Error: class " + className + " from source " + new File(url2.getPath()).getPath() + " already defined in source " + new File(otherSource.getPath()).getPath());
            }
        }
        for (i = 0; i < this.data.size(); i += 7) {
            url = (URL)this.data.get(i);
            String pkgName = (String)this.data.get(i + 2);
            String[] typeList = (String[])this.data.get(i + 3);
            String[] imports = (String[])this.data.get(i + 5);
            this.data.set(i + 3, DependencyProvider.resolveTypes(pkgName, typeList, imports, pkgs, this.classMap));
        }
        for (i = 0; i < this.data.size(); i += 7) {
            url = (URL)this.data.get(i);
            String[] types = (String[])this.data.get(i + 3);
            for (int j = 0; j < types.length; ++j) {
                HashMap usedBy = (HashMap)this.classMap.get(types[j]);
                if (usedBy == null || usedBy.get(url) != null) continue;
                usedBy.put(url, url);
            }
        }
    }

    private static String[] readStringArray(DataInputStream is, ArrayList strArray) throws IOException {
        String[] a = new String[is.readInt()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (String)strArray.get(is.readInt());
        }
        return a;
    }

    public void load(InputStream in, boolean dependant) throws IOException {
        DataInputStream is = new DataInputStream(in);
        if (is.readInt() != 0x10010300) {
            throw new IOException("invalid magic signature");
        }
        int strCount = is.readInt();
        ArrayList<String> strArray = new ArrayList<String>(strCount);
        for (int i = 0; i < strCount; ++i) {
            strArray.add(is.readUTF());
        }
        byte[] ba = new byte[is.readInt()];
        is.read(ba);
        is.close();
        in.close();
        is = new DataInputStream(new ByteArrayInputStream(ba));
        int dataCount = is.readInt();
        assert (dataCount % 7 == 0);
        for (int i = 0; i < dataCount; i += 7) {
            this.data.add(new URL((String)strArray.get(is.readInt())));
            this.data.add(is.readLong());
            this.data.add((String)strArray.get(is.readInt()));
            this.data.add(DependencyProvider.readStringArray(is, strArray));
            this.data.add(DependencyProvider.readStringArray(is, strArray));
            this.data.add(DependencyProvider.readStringArray(is, strArray));
            boolean dep = is.readBoolean();
            this.data.add(dependant || dep ? Boolean.TRUE : Boolean.FALSE);
        }
        is.close();
    }

    private static int indexedStr(String str, HashMap strMap, ArrayList strArray) {
        Integer I = (Integer)strMap.get(str);
        if (I != null) {
            return I;
        }
        int i = strArray.size();
        strArray.add(str);
        strMap.put(str, i);
        return i;
    }

    private static void writeStringArray(String[] strs, DataOutputStream os, HashMap strMap, ArrayList strArray) throws IOException {
        os.writeInt(strs.length);
        for (int i = 0; i < strs.length; ++i) {
            os.writeInt(DependencyProvider.indexedStr(strs[i], strMap, strArray));
        }
    }

    public void save(OutputStream out, boolean everything) throws IOException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(this.data.size() / 6 * 32);
        DataOutputStream os = new DataOutputStream(byteArray);
        HashMap strMap = new HashMap();
        ArrayList strArray = new ArrayList();
        os.writeInt(this.data.size());
        for (int i = 0; i < this.data.size(); i += 7) {
            os.writeInt(DependencyProvider.indexedStr(((URL)this.data.get(i)).toString(), strMap, strArray));
            os.writeLong((Long)this.data.get(i + 1));
            os.writeInt(DependencyProvider.indexedStr((String)this.data.get(i + 2), strMap, strArray));
            DependencyProvider.writeStringArray((String[])this.data.get(i + 3), os, strMap, strArray);
            DependencyProvider.writeStringArray((String[])this.data.get(i + 4), os, strMap, strArray);
            DependencyProvider.writeStringArray((String[])this.data.get(i + 5), os, strMap, strArray);
            os.writeBoolean((Boolean)this.data.get(i + 6));
        }
        os.close();
        byteArray.close();
        os = new DataOutputStream(out);
        os.writeInt(0x10010300);
        os.writeInt(strArray.size());
        for (int j = 0; j < strMap.size(); ++j) {
            os.writeUTF((String)strArray.get(j));
        }
        os.writeInt(byteArray.size());
        os.write(byteArray.toByteArray());
        os.close();
        out.close();
    }

    public ArrayList updateData(ArrayList urlList, boolean rebuild, boolean synch, HashMap sourceMap) throws IOException {
        ArrayList<URL> newParses = new ArrayList<URL>();
        this.urlMap.clear();
        for (int i = 0; i < this.data.size(); i += 7) {
            this.urlMap.put(this.data.get(i), i);
        }
        int filesParsed = 0;
        this.startTiming();
        for (int i = 0; i < urlList.size(); ++i) {
            InputReadTextBuffer buffer;
            URL url = (URL)urlList.get(i);
            Integer I = (Integer)this.urlMap.get(urlList.get(i));
            if (I != null) {
                Long d1 = (Long)this.data.get(I + 1);
                Long d2 = this.getLastModified(url);
                if (d1 >= d2 && (!rebuild || sourceMap != null && sourceMap.get(url) == null)) continue;
            }
            if ((buffer = InputReadTextBuffer.init(url)) != null) {
                SourceFile sf = JavaParser.parse((ReadTextBuffer)buffer);
                if (sf != null) {
                    this.collectSourceFile(sf, url, false, I != null ? I : -1);
                    newParses.add(url);
                    ++filesParsed;
                    continue;
                }
                Assert.println((String)("error: unable to parse: " + new File(url.getPath()).getPath()));
                continue;
            }
            Assert.println((String)("error: unable to open: " + new File(url.getPath()).getPath()));
        }
        Assert.println((String)("Time to parse and collect " + filesParsed + " files " + this.elapsedTimeMs() + "ms"));
        if (synch) {
            this.startTiming();
            HashMap inputMap = new HashMap();
            for (int i = 0; i < urlList.size(); ++i) {
                inputMap.put(urlList.get(i), urlList.get(i));
            }
            int emptyCount = 0;
            for (int i = 0; i < this.data.size(); i += 7) {
                if (((Boolean)this.data.get(i + 6)).booleanValue() || inputMap.get(this.data.get(i)) != null) continue;
                for (int j = 0; j < 7; ++j) {
                    this.data.set(i + j, null);
                }
                emptyCount += 7;
            }
            if (emptyCount > 0) {
                ArrayList newData = new ArrayList(this.data.size() - emptyCount);
                for (int i = 0; i < this.data.size(); ++i) {
                    Object o = this.data.get(i);
                    if (o == null) continue;
                    newData.add(o);
                }
                this.data = newData;
            }
            this.urlMap.clear();
            for (int i = 0; i < this.data.size(); i += 7) {
                this.urlMap.put(this.data.get(i), i);
            }
            Assert.println((String)("Time to synchronize " + this.data.size() / 7 + " files " + this.elapsedTimeMs() + "ms"));
        }
        this.startTiming();
        this.computeDependencies();
        Assert.println((String)("Time to computer dependencies on " + this.data.size() / 7 + " files " + this.elapsedTimeMs() + "ms"));
        return newParses;
    }

    public Collection getDependants(ArrayList urlList, boolean includeSelf) {
        int i;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (includeSelf) {
            for (i = 0; i < urlList.size(); ++i) {
                Object o = urlList.get(i);
                map.put(o, o);
            }
        }
        for (i = 0; i < urlList.size(); ++i) {
            URL url = (URL)urlList.get(i);
            Integer I = (Integer)this.urlMap.get(url);
            if (I == null) {
                throw new IllegalArgumentException(url.getPath() + " not found in table");
            }
            int iVal = I;
            String[] classes = (String[])this.data.get(iVal + 4);
            for (int j = 0; j < classes.length; ++j) {
                String className = (String)this.data.get(iVal + 2) + "." + classes[j];
                HashMap usedBy = (HashMap)this.classMap.get(className);
                Collection urls = usedBy.values();
                for (Object o : urls) {
                    if (map.get(o) != null) continue;
                    map.put(o, o);
                }
            }
        }
        return map.values();
    }

    private void startTiming() {
        this.tickHolder = NativeHandler.getHiPerfTick();
    }

    private long elapsedTimeMs() {
        return (NativeHandler.getHiPerfTick() - this.tickHolder) * 1000L / NativeHandler.getHiPerfFreq();
    }

    private static void recurse(File dir, ArrayList sources) throws IOException {
        File[] list = dir.listFiles();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if (list[i].isDirectory()) {
                    DependencyProvider.recurse(list[i], sources);
                    continue;
                }
                if (!list[i].getName().endsWith(".java")) continue;
                sources.add(URLFactory.newFileURL((String)list[i].getPath()));
            }
        }
    }

    public static void test1() throws MalformedURLException, IOException {
        String fName = "d:\\oracle\\T.java";
        File file = new File(fName);
        URL url = URLFactory.newFileURL((String)fName);
        long ms = NativeHandler.getHiPerfTick();
        long total = 0L;
        for (int i = 0; i < 100000; ++i) {
            long fModified = file.lastModified();
            long fTime = fModified != 0L ? fModified : url.openConnection().getLastModified();
            total += fTime;
        }
        System.out.println(NativeHandler.getHiPerfTick() - ms + "ms for " + total);
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        ArrayList<URL> sources = new ArrayList<URL>();
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                DependencyProvider.recurse(f, sources);
                continue;
            }
            if (f.getName().endsWith(".java")) {
                sources.add(URLFactory.newFileURL((String)args[i]));
                continue;
            }
            System.out.println("error: " + args[i] + " doesn't exist");
        }
        DependencyProvider dp = new DependencyProvider();
        ArrayList outOfDate = dp.updateData(sources, false, false, null);
        dp.save(new FileOutputStream("c:\\test.compilerdepinfo"), false);
        URL javaCompiler = URLFactory.newFileURL((String)"L:/ferrari/ojc/java/oracle/ojc/frontend/JavaCompiler.java");
        File javaCompilerFile = new File(javaCompiler.getPath());
        javaCompilerFile.setLastModified(new Date().getTime());
        ArrayList<URL> newSources = new ArrayList<URL>();
        newSources.add(javaCompiler);
        outOfDate = dp.updateData(newSources, false, false, null);
        Collection c = dp.getDependants(outOfDate, true);
        long ms = NativeHandler.getHiPerfTick();
        dp.reinit();
        System.out.println("Reinit = " + (NativeHandler.getHiPerfTick() - ms) * 1000L / NativeHandler.getHiPerfFreq());
        ms = NativeHandler.getHiPerfTick();
        dp.load(new FileInputStream("c:\\test.compilerdepinfo"), false);
        System.out.println("Loading = " + (NativeHandler.getHiPerfTick() - ms) * 1000L / NativeHandler.getHiPerfFreq());
        ms = NativeHandler.getHiPerfTick();
        dp.save(new FileOutputStream("c:\\test2.compilerdepinfo"), false);
        System.out.println("Saving = " + (NativeHandler.getHiPerfTick() - ms) * 1000L / NativeHandler.getHiPerfFreq());
        ms = NativeHandler.getHiPerfTick();
        System.out.println("Total and average number of lines are: " + InputReadTextBuffer.totalLineCount + "," + InputReadTextBuffer.averageLineCount);
        System.in.read();
    }
}

