/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sybase;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sybase.Messages;
import oracle.dbtools.thirdparty.sybase.SybaseConnectionPanel;
import oracle.ide.util.ResourceUtils;

public class BasicPanel
extends JPanel
implements CDComponentView {
    private static final long serialVersionUID = 428751755326227573L;
    private SybaseConnectionPanel _connPanel;
    private JLabel _hostLbl = new JLabel();
    protected JTextField tfdHost = new JTextField(15);
    private JLabel _portLbl = new JLabel();
    protected JTextField tfdPort = new JTextField(15);
    private JComboBox<String> _SybaseDbComboBox = new JComboBox();
    private JButton _retrieveDatabaseButton = new JButton();

    protected BasicPanel() {
    }

    protected final void init(SybaseConnectionPanel sybaseConnectionPanel) {
        this._connPanel = sybaseConnectionPanel;
        this.jbInit();
    }

    protected String getBasicURL(String string, String string2) {
        return "jdbc:jtds:sybase://" + string + ":" + string2;
    }

    public void clear() {
        this.tfdHost.setText("");
        this.tfdPort.setText("");
        this._SybaseDbComboBox.removeAllItems();
    }

    public void generateProperties(Properties properties) {
        Object object = "";
        String string = "";
        properties.setProperty("hostname", this.tfdHost.getText().trim());
        properties.setProperty("port", this.tfdPort.getText().trim());
        Object object2 = this._SybaseDbComboBox.getSelectedItem();
        if (object2 != null) {
            string = object2.toString();
        }
        object = string.length() < 1 ? this.getBasicURL(this.tfdHost.getText().trim(), this.tfdPort.getText().trim()) + "/;maxStatements=0" : this.getBasicURL(this.tfdHost.getText().trim(), this.tfdPort.getText().trim()) + "/" + string + ";maxStatements=0";
        properties.setProperty("customUrl", (String)object);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this._hostLbl, (Component)this.tfdHost, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_HOST"));
        ResourceUtils.resLabel((JLabel)this._portLbl, (Component)this.tfdPort, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_PORT"));
        this.add((Component)this._hostLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this._portLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdPort, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.tfdHost.setText(this.getDefaultHostname());
        this.tfdPort.setText(this.getDefaultPort());
        ResourceUtils.resButton((AbstractButton)this._retrieveDatabaseButton, (String)Messages.getString("BasicPanel.1"));
        this._retrieveDatabaseButton.addActionListener(actionEvent -> {
            try {
                Properties properties = this._connPanel.getAuthenticationProperties();
                boolean bl = Boolean.parseBoolean(properties.getProperty(SybaseConnectionPanel.SYBASE_WINDOWS_AUTHENTICATION));
                boolean bl2 = Boolean.parseBoolean(properties.getProperty(SybaseConnectionPanel.SYBASE_DEFAULT_PASSWORD));
                String string = properties.getProperty(SybaseConnectionPanel.SYBASE_DOMAIN);
                if (this._connPanel.getConnectionName().length() < 1) {
                    this._connPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + Messages.getString("BasicPanel.2"));
                    return;
                }
                if (!ModelUtil.hasLength((String)this._connPanel.getUserName()) && (!bl || bl && !SybaseConnectionPanel.OS_WINDOWS)) {
                    this._connPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + Messages.getString("BasicPanel.3"));
                    return;
                }
                if (bl && !SybaseConnectionPanel.OS_WINDOWS && !ModelUtil.hasLength((String)string)) {
                    this._connPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + Messages.getString("BasicPanel.4"));
                    return;
                }
                this._connPanel.setStatus("");
                ClassLoader classLoader = RaptorClassLoader.findClassLoader((String)"net.sourceforge.jtds.jdbc.Driver");
                Class<Driver> clazz = (classLoader != null ? classLoader.loadClass("net.sourceforge.jtds.jdbc.Driver") : Class.forName("net.sourceforge.jtds.jdbc.Driver")).asSubclass(Driver.class);
                Driver driver = clazz.newInstance();
                Properties properties2 = new Properties();
                String string2 = this._connPanel.getUserName();
                String string3 = this._connPanel.getPassword();
                String string4 = this.tfdHost.getText().trim();
                Object object = this.getBasicURL(string4, this.tfdPort.getText().trim());
                if (bl && !SybaseConnectionPanel.OS_WINDOWS) {
                    object = (String)object + ";domain=" + string;
                }
                if (null != string2) {
                    properties2.setProperty("user", string2);
                }
                if (bl2) {
                    properties2.put("password", "");
                } else if (null != string3) {
                    properties2.setProperty("password", string3);
                }
                Connection connection = driver.connect((String)object, properties2);
                PreparedStatement preparedStatement = connection.prepareStatement(this.getListDatabasesQuery());
                ResultSet resultSet = preparedStatement.executeQuery();
                this._SybaseDbComboBox.removeAllItems();
                while (resultSet.next()) {
                    String string5 = resultSet.getString("name");
                    if (string5 == null) continue;
                    this._SybaseDbComboBox.addItem(string5);
                }
                connection.close();
            }
            catch (SQLException sQLException) {
                this._connPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + this.getFetchDatabaseErrorMessage(sQLException));
            }
            catch (InstantiationException instantiationException) {
                this._connPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                this._connPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + illegalAccessException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._connPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + classNotFoundException.getMessage());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.gridy = 5;
        gridBagConstraints2.gridx = 0;
        this.add((Component)this._retrieveDatabaseButton, gridBagConstraints2);
        this.add(this._SybaseDbComboBox, gridBagConstraints);
    }

    protected String getFetchDatabaseErrorMessage(SQLException sQLException) {
        return sQLException.getMessage();
    }

    protected String getListDatabasesQuery() {
        return "select name from master..sysdatabases ORDER by name";
    }

    protected void retrieveDatabase(Properties properties) {
        String string;
        this._SybaseDbComboBox.removeAllItems();
        String string2 = properties.getProperty("customUrl");
        if (string2 != null && (string = string2.substring(string2.lastIndexOf(47) + 1)) != null) {
            if (string.indexOf(";maxStatements=") != -1) {
                string = string.substring(0, string.indexOf(";maxStatements="));
            }
            this._SybaseDbComboBox.addItem(string);
            this._SybaseDbComboBox.setSelectedItem(string);
        }
    }

    public void setDefaultPrompts() {
        this.tfdHost.setText(this.getDefaultHostname());
        this.tfdPort.setText(this.getDefaultPort());
        this._SybaseDbComboBox.removeAllItems();
    }

    protected String getDefaultPort() {
        return "5000";
    }

    protected String getDefaultHostname() {
        return "localhost";
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        this.tfdHost.setText(string);
        String string2 = properties.getProperty("port");
        this.tfdPort.setText(string2 != null ? string2 : this.getDefaultPort());
    }
}

