/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sqlserver;

import java.net.ConnectException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.connections.db.CustomConnectionCreator;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sqlserver.SQLServerConnectionPanel;

public class SQLServerConnectionCreator
extends CustomConnectionCreator {
    private static boolean canHaveNullPassword = false;

    protected boolean allowNullPassword() {
        return canHaveNullPassword;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        properties.setProperty("NoPasswordConnection", "TRUE");
        canHaveNullPassword = true;
        try {
            return super.getConnection(properties);
        }
        catch (SQLException sQLException) {
            if (sQLException.getCause() instanceof ConnectException) {
                throw new SQLException(ConnectionDialogArb.format((String)"SQL_SERVER_CONNECTION_ERROR", (Object[])new Object[]{properties.getProperty("hostname")}), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            throw sQLException;
        }
    }

    protected void setCustomProperties(Properties properties, Properties properties2) {
        super.setCustomProperties(properties, properties2);
        String string = properties.getProperty(SQLServerConnectionPanel.SQLSERVER_DEFAULT_PASSWORD);
        if (string != null && string.equals(Boolean.TRUE.toString())) {
            properties2.setProperty("password", "");
        }
    }
}

