/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.postgresql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.postgresql.PostgreSQLConnectionPanel;
import oracle.dbtools.thirdparty.postgresql.PostgreSQLNavigatorResource;
import oracle.ide.util.ResourceUtils;

class PostgreSQLBasicPanel
extends JPanel
implements CDComponentView {
    String dbquery = "select distinct pg_database.datname as \"Database\" from pg_database;";
    private static final long serialVersionUID = 1L;
    private JButton m_chooseDatabaseButton = new JButton();
    private JComboBox m_postgreSQLDbComboBox = new JComboBox();
    private final PostgreSQLConnectionPanel m_basicPanel;
    private JLabel m_hostLbl = new JLabel();
    protected JTextField m_tfdHost = new JTextField(15);
    private JLabel m_portLbl = new JLabel();
    protected JTextField m_tfdPort = new JTextField(15);
    protected ButtonGroup m_group = new ButtonGroup();
    private JLabel m_zeroDataLbl = new JLabel();
    private JRadioButton m_optionNull = new JRadioButton();
    private JRadioButton m_optionRound = new JRadioButton();

    public PostgreSQLBasicPanel(PostgreSQLConnectionPanel postgreSQLConnectionPanel) {
        this.m_basicPanel = postgreSQLConnectionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void clear() {
        this.m_tfdHost.setText("");
        this.m_tfdPort.setText("");
        this.m_postgreSQLDbComboBox.removeAllItems();
    }

    public void generateProperties(Properties properties) {
        String string = "";
        Object object = "";
        Object object2 = this.m_postgreSQLDbComboBox.getSelectedItem();
        properties.setProperty("hostname", this.m_tfdHost.getText().trim());
        properties.put("port", this.m_tfdPort.getText().trim());
        if (object2 != null) {
            string = object2.toString();
        }
        object = string.length() < 1 ? "jdbc:postgresql://" + this.m_tfdHost.getText().trim() + ":" + this.m_tfdPort.getText().trim() + "/" : "jdbc:postgresql://" + this.m_tfdHost.getText().trim() + ":" + this.m_tfdPort.getText().trim() + "/" + string;
        properties.setProperty("customUrl", (String)object);
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.m_chooseDatabaseButton, (String)PostgreSQLNavigatorResource.getString("LABEL_CHOOSEDATABASE"));
        ResourceUtils.resButton((AbstractButton)this.m_optionNull, (String)PostgreSQLNavigatorResource.getString("LABEL_OPTIONNULL"));
        ResourceUtils.resButton((AbstractButton)this.m_optionRound, (String)PostgreSQLNavigatorResource.getString("LABEL_OPTIONROUND"));
        this.m_group.add(this.m_optionNull);
        this.m_group.add(this.m_optionRound);
        ResourceUtils.resLabel((JLabel)this.m_zeroDataLbl, (Component)this.m_optionNull, (String)PostgreSQLNavigatorResource.getString("LABEL_ZERODATEBEHAVIOUR"));
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("5432");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_hostLbl, (Component)this.m_tfdHost, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_HOST"));
        ResourceUtils.resLabel((JLabel)this.m_portLbl, (Component)this.m_tfdPort, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_PORT"));
        this.add((Component)this.m_hostLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdHost, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_portLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdPort, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_chooseDatabaseButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_postgreSQLDbComboBox, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.m_chooseDatabaseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (PostgreSQLBasicPanel.this.m_basicPanel.getUserName().length() < 1 || PostgreSQLBasicPanel.this.m_basicPanel.getUserName().length() < 1 || PostgreSQLBasicPanel.this.m_basicPanel.getConnectionName().length() < 1) {
                        PostgreSQLBasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + PostgreSQLNavigatorResource.getString("BasicPanel.0"));
                        return;
                    }
                    PostgreSQLBasicPanel.this.m_basicPanel.setStatus("");
                    ClassLoader classLoader = RaptorClassLoader.findClassLoader((String)"org.postgresql.Driver");
                    Class<Driver> clazz = null;
                    clazz = classLoader != null ? classLoader.loadClass("org.postgresql.Driver").asSubclass(Driver.class) : Class.forName("org.postgresql.Driver").asSubclass(Driver.class);
                    Driver driver = clazz.newInstance();
                    Properties properties = new Properties();
                    String string = PostgreSQLBasicPanel.this.m_basicPanel.getUserName();
                    String string2 = PostgreSQLBasicPanel.this.m_basicPanel.getPassword();
                    String string3 = "jdbc:postgresql://" + PostgreSQLBasicPanel.this.m_tfdHost.getText().trim() + ":" + PostgreSQLBasicPanel.this.m_tfdPort.getText().trim() + "/";
                    if (null != string) {
                        properties.setProperty("user", string);
                    }
                    if (null != string2) {
                        properties.setProperty("password", string2);
                    }
                    Connection connection = driver.connect(string3, properties);
                    PreparedStatement preparedStatement = connection.prepareStatement(PostgreSQLBasicPanel.this.dbquery);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    PostgreSQLBasicPanel.this.m_postgreSQLDbComboBox.removeAllItems();
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        if (string4 == null) continue;
                        PostgreSQLBasicPanel.this.m_postgreSQLDbComboBox.addItem(string4);
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {
                    PostgreSQLBasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + sQLException.getLocalizedMessage());
                }
                catch (InstantiationException instantiationException) {
                    PostgreSQLBasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    PostgreSQLBasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + illegalAccessException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    PostgreSQLBasicPanel.this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + classNotFoundException.getMessage());
                }
            }
        });
    }

    protected void retrieveDatabase(Properties properties) {
        String string;
        this.m_postgreSQLDbComboBox.removeAllItems();
        String string2 = properties.getProperty("customUrl");
        if (string2 != null && (string = string2.substring(string2.lastIndexOf(47) + 1)) != null) {
            this.m_postgreSQLDbComboBox.addItem(string);
            this.m_postgreSQLDbComboBox.setSelectedItem(string);
        }
    }

    public void setDefaultPrompts() {
        this.m_tfdHost.setText("localhost");
        this.m_tfdPort.setText("5432");
        this.m_postgreSQLDbComboBox.removeAllItems();
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        this.m_tfdHost.setText(string);
        String string2 = properties.getProperty("port");
        this.m_tfdPort.setText(string2 != null ? string2 : "5432");
    }
}

