/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.ceditor.tint.BlockType;
import oracle.ide.ceditor.tint.TintBlock;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;

public class DefaultTintBlock
implements TintBlock {
    private List<DefaultTintBlock> children = new ArrayList<DefaultTintBlock>();
    private OffsetMark startOff;
    private OffsetMark endOff;
    private boolean visible = true;
    private TextBuffer textBuffer;
    private BlockType blockType;

    public DefaultTintBlock(TextBuffer textBuffer, int startOffset, int endOffset) {
        this.textBuffer = textBuffer;
        this.startOff = textBuffer.addOffsetMark(startOffset);
        this.endOff = textBuffer.addOffsetMark(endOffset);
    }

    void dispose() {
        if (this.textBuffer != null) {
            this.textBuffer.removeOffsetMark(this.startOff);
            this.textBuffer.removeOffsetMark(this.endOff);
        }
        this.textBuffer = null;
        this.startOff = null;
        this.endOff = null;
        for (DefaultTintBlock child : this.children) {
            child.dispose();
        }
        this.children.clear();
        this.blockType = null;
    }

    public List<TintBlock> getChildren() {
        return new ArrayList<TintBlock>(this.children);
    }

    public void addChild(DefaultTintBlock childBlock) {
        this.children.add(childBlock);
    }

    @Override
    public int getStartOffset() {
        return this.startOff.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this.endOff.getOffset();
    }

    public void setVisible(boolean doNotColor) {
        this.visible = doNotColor;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setBlockType(BlockType blockType) {
        this.blockType = blockType;
    }

    @Override
    public BlockType getBlockType() {
        return this.blockType;
    }
}

