/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class ThreadsPanelSettings
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "ThreadsPanelOptions";
    private static final String COLUMN_VISIBLE = "threadPanelColumnVisible";
    private static final String COLUMN_WIDTH = "threadPanelColumnWidth";
    private static final String COLUMN_NAMES = "threadColumnNames";
    private static final String COLUMN_NAMES_PREFS = "threadColumnNamesInPrefPane";
    private static final String COLUMN_NUMERIC = "threadsColumnNumeric";

    @Deprecated
    public ThreadsPanelSettings() {
        super(HashStructure.newInstance());
    }

    private ThreadsPanelSettings(HashStructure hs) {
        super(hs);
    }

    public static ThreadsPanelSettings getInstance(PropertyStorage ps) {
        return new ThreadsPanelSettings(ThreadsPanelSettings.findOrCreate((PropertyStorage)ps, (String)KEY_SETTINGS));
    }

    public static ThreadsPanelSettings getInstance(HashStructure hs) {
        return new ThreadsPanelSettings(hs);
    }

    public HashStructure getHash() {
        return this._hash;
    }

    @Deprecated
    public boolean[] getColumnVisible() {
        boolean[] columnVisible = new boolean[5];
        for (int x = 0; x < 5; ++x) {
            columnVisible[x] = this.getColumnVisible("", x);
        }
        return columnVisible;
    }

    @Deprecated
    public void setColumnVisible(boolean[] columnVisible) {
        for (int x = 0; x < columnVisible.length; ++x) {
            this.setColumnVisible("", x, columnVisible[x]);
        }
    }

    public Boolean getPreShermanMigratedColumnVisibility(int columnIndex) {
        if (this._hash.containsKey(COLUMN_VISIBLE + columnIndex)) {
            return this._hash.getBoolean(COLUMN_VISIBLE + columnIndex);
        }
        return null;
    }

    boolean getColumnVisible(String vm, int columnIndex) {
        boolean defaultValue = columnIndex == 0 || columnIndex == 1;
        return this._hash.getBoolean(COLUMN_VISIBLE + vm + columnIndex, defaultValue);
    }

    void setColumnVisible(String vm, int columnIndex, boolean columnVisible) {
        this._hash.putBoolean(COLUMN_VISIBLE + vm + columnIndex, columnVisible);
    }

    @Deprecated
    public int[] getColumnWidth() {
        int[] columnWidth = new int[5];
        for (int x = 0; x < 5; ++x) {
            columnWidth[x] = this.getColumnWidth("", x);
        }
        return columnWidth;
    }

    @Deprecated
    public void setColumnWidth(int[] columnWidth) {
        for (int x = 0; x < columnWidth.length; ++x) {
            this.setColumnWidth("", x, columnWidth[x]);
        }
    }

    int getColumnWidth(String vm, int columnIndex) {
        return this._hash.getInt(COLUMN_WIDTH + vm + columnIndex, 0);
    }

    void setColumnWidth(String vm, int columnIndex, int columnWidth) {
        this._hash.putInt(COLUMN_WIDTH + vm + columnIndex, columnWidth);
    }

    public String getColumnOrder(String vm) {
        return this._hash.getString("threadsColumnOrder" + vm);
    }

    public void setColumnOrder(String vm, String columnOrder) {
        this._hash.putString("threadsColumnOrder" + vm, columnOrder);
    }

    public List<String> getColumnNames(String VMName) {
        ListStructure names = this._hash.getListStructure(COLUMN_NAMES + VMName);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i) == null ? null : names.get(i).toString());
        }
        return stringList;
    }

    public void setColumnNames(String VMName, List<String> columnNames) {
        ListStructure names = ListStructure.newInstance();
        for (String name : columnNames) {
            names.add((Object)name);
        }
        this._hash.putListStructure(COLUMN_NAMES + VMName, names);
    }

    public List<String> getColumnNamesInPreferences(String VMName) {
        ListStructure names = this._hash.getListStructure(COLUMN_NAMES_PREFS + VMName);
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        for (int i = 0; i < names.size(); ++i) {
            stringList.add(names.get(i) == null ? null : names.get(i).toString());
        }
        return stringList;
    }

    public void setColumnNamesInPreferences(String VMName, List<String> columnNames) {
        ListStructure names = ListStructure.newInstance();
        for (String name : columnNames) {
            names.add((Object)name);
        }
        this._hash.putListStructure(COLUMN_NAMES_PREFS + VMName, names);
    }

    public boolean getColumnNumeric(String VMName, int column) {
        return this._hash.getBoolean(COLUMN_NUMERIC + VMName + column);
    }

    public void setColumnNumeric(String VMName, int column, boolean numeric) {
        this._hash.putBoolean(COLUMN_NUMERIC + VMName + column, numeric);
    }
}

