/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.javatools.util.Log;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugLocationUtils;

public class StepIntoLocationKey {
    public static final Log SIOLogger = new Log("SIOLogger");
    String pkg;
    String file;
    int line = -1;
    int depth;
    int byteCodeOffset = -1;

    public StepIntoLocationKey(DebugLocation stoppedAtLocation, int stackDepth, boolean adjustLineToStatementBeginning) {
        this.depth = stackDepth;
        if (stoppedAtLocation != null) {
            this.line = adjustLineToStatementBeginning ? DebugLocationUtils.getFirstLineOfStatementEncompassingLocation(stoppedAtLocation) : stoppedAtLocation.getLine();
            this.byteCodeOffset = stoppedAtLocation.getBytecodeOffset();
            this.file = stoppedAtLocation.getFilename();
            this.pkg = stoppedAtLocation.getClassInfo().getPackage();
        }
    }

    public int getLine() {
        return this.line;
    }

    public int hashCode() {
        return this.file.hashCode() << 6 + this.depth * 37 + this.line;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StepIntoLocationKey)) {
            return false;
        }
        StepIntoLocationKey other = (StepIntoLocationKey)o;
        if (other.line != this.line || other.depth != this.depth) {
            return false;
        }
        if (!other.pkg.equals(this.pkg)) {
            return false;
        }
        return other.file.equals(this.file);
    }

    public String toString() {
        return String.format("%s.%s(depth %d line %d)", this.pkg, this.file, this.depth, this.line);
    }
}

