/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.runner.DataValueToStringBehavior;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.runner.debug.ClassesPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ObjectPreferences;

public final class ObjectPreferencesPanel
extends ClassesPanel {
    private final ObjectPreferences objectPreferences;
    private String selectedScope;
    private final Map<String, String> valueExpressions;
    private final Map<String, DataValueToStringBehavior> toStringBehavior;
    private final List<String> valueExpressionSuggestions;
    private final JLabel expandLabel;
    private final Map<String, String> expandExpressions;
    private final List<String> expandExpressionSuggestions;
    private final Set<String> hideAllFields;
    private final Map<String, String[]> hiddenFields;
    private final boolean sortFields;
    private final Map<String, DebugFieldInfo> declaredFields;
    private final List<String> hiddenFieldsList;
    private final JLabel scopeLabel;
    private final DefaultComboBoxModel<ScopeComboBoxItem> scopeModel;
    private final JComboBox<ScopeComboBoxItem> scopeComboBox;
    private final JRadioButton radioValueToString;
    private final JCheckBox checkValueToStringOnlyWhenOverridden;
    private final JCheckBox checkValueToStringOnlyWhenNoExpression;
    private final JRadioButton radioValueExpression;
    private final DefaultComboBoxModel<String> valueExpressionModel;
    private final JComboBox<String> valueExpressionComboBox;
    private final JTextField valueExpressionComboBoxEditor;
    private final JTextField valueExpressionTextField;
    private final JCheckBox checkExpandExpression;
    private final DefaultComboBoxModel<String> expandExpressionModel;
    private final JComboBox<String> expandExpressionComboBox;
    private final JTextField expandExpressionComboBoxEditor;
    private final JTextField expandExpressionTextField;
    private final JCheckBox checkExpandFields;
    private final JLabel fieldsLabel;
    private final Shuttle shuttle;
    private final JLabel fromLabel;
    private final DefaultListModel<String> fromModel;
    private final JList<String> fromList;
    private final JLabel fromFieldDescriptionLabel;
    private final JLabel toLabel;
    private final DefaultListModel<String> toModel;
    private final JList<String> toList;
    private final JLabel toFieldDescriptionLabel;
    private static boolean useFilters = false;
    private static final String toStringExpression = "toString()";
    private static final String fieldDescriptionLabelBlank = " ";
    private static Font boldFont = UIManager.getFont("Label.font").deriveFont(1);

    public static boolean showObjectPreferencesDialog(DebugClassInfo clazz, boolean sortFields) {
        JDebugger jdebugger = JDebugger.getInstance();
        ObjectPreferences objectPreferences = jdebugger.getObjectPreferences();
        Map<String, String> cloneValueExpressions = objectPreferences.deepCloneValueExpressions();
        Map<String, DataValueToStringBehavior> useToStringBehavior = objectPreferences.deepCloneToStringBehaviorMap();
        Map<String, String> cloneExpandExpressions = objectPreferences.deepCloneExpandExpressions();
        Set<String> cloneHideAllFields = objectPreferences.deepCloneHideAllFields();
        Map<String, String[]> cloneHiddenFields = objectPreferences.deepCloneHiddenFields();
        boolean hiddenFieldsBefore = !cloneHiddenFields.isEmpty();
        ObjectPreferencesPanel panel = new ObjectPreferencesPanel(clazz, objectPreferences, cloneValueExpressions, useToStringBehavior, cloneExpandExpressions, cloneHideAllFields, cloneHiddenFields, sortFields);
        String title = DbgArb.getString(726);
        JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getInitialFocus(), (String)title);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_deb_edit_filters_html");
        if (WizardLauncher.runDialog((JDialog)dlg)) {
            boolean hiddenFieldsAfter;
            DebugClassInfo currentClass = panel.getCurrentClass();
            if (currentClass != null) {
                panel.saveBody(currentClass);
            }
            objectPreferences.setChangedValueExpressions(cloneValueExpressions);
            objectPreferences.setUseToStringBehaviorMap(useToStringBehavior);
            objectPreferences.setChangedExpandExpressions(cloneExpandExpressions);
            objectPreferences.setChangedHideAllFields(cloneHideAllFields);
            objectPreferences.setChangedHiddenFields(cloneHiddenFields);
            boolean bl = hiddenFieldsAfter = !cloneHiddenFields.isEmpty();
            if (hiddenFieldsBefore != hiddenFieldsAfter) {
                jdebugger.setUseFilters(hiddenFieldsAfter);
                useFilters = true;
            } else {
                jdebugger.updateDataWindows();
            }
            return true;
        }
        return false;
    }

    static boolean getUseFilters() {
        return useFilters;
    }

    private ObjectPreferencesPanel(DebugClassInfo clazz, ObjectPreferences objectPreferences, Map<String, String> valueExpressions, Map<String, DataValueToStringBehavior> toStringBehaviors, Map<String, String> expandExpressions, Set<String> hideAllFields, Map<String, String[]> hiddenFields, boolean sortFields) {
        this.objectPreferences = objectPreferences;
        this.valueExpressions = valueExpressions;
        this.toStringBehavior = toStringBehaviors;
        this.valueExpressionSuggestions = new ArrayList<String>();
        this.expandExpressions = expandExpressions;
        this.expandExpressionSuggestions = new ArrayList<String>();
        this.hideAllFields = hideAllFields;
        this.hiddenFields = hiddenFields;
        this.sortFields = sortFields;
        this.declaredFields = new HashMap<String, DebugFieldInfo>();
        this.hiddenFieldsList = new ArrayList<String>();
        this.scopeLabel = new JLabel();
        this.scopeModel = new DefaultComboBoxModel();
        this.scopeComboBox = new JComboBox<ScopeComboBoxItem>(this.scopeModel);
        this.scopeComboBox.setEditable(false);
        this.scopeComboBox.setRenderer(new ScopeComboBoxRenderer());
        this.radioValueToString = new JRadioButton();
        this.checkValueToStringOnlyWhenOverridden = new JCheckBox();
        this.checkValueToStringOnlyWhenNoExpression = new JCheckBox();
        this.radioValueExpression = new JRadioButton();
        this.valueExpressionModel = new DefaultComboBoxModel();
        this.valueExpressionComboBox = new JComboBox<String>(this.valueExpressionModel);
        this.valueExpressionComboBox.setEditable(true);
        this.valueExpressionComboBoxEditor = (JTextField)this.valueExpressionComboBox.getEditor().getEditorComponent();
        this.valueExpressionTextField = new JTextField();
        this.valueExpressionTextField.setVisible(false);
        this.expandLabel = new JLabel(DbgArb.getString(737));
        this.checkExpandExpression = new JCheckBox();
        this.expandExpressionModel = new DefaultComboBoxModel();
        this.expandExpressionComboBox = new JComboBox<String>(this.expandExpressionModel);
        this.expandExpressionComboBox.setEditable(true);
        this.expandExpressionComboBoxEditor = (JTextField)this.expandExpressionComboBox.getEditor().getEditorComponent();
        this.expandExpressionTextField = new JTextField();
        this.expandExpressionTextField.setVisible(false);
        this.checkExpandFields = new JCheckBox();
        this.fieldsLabel = new JLabel(DbgArb.getString(740));
        this.shuttle = new Shuttle();
        this.fromLabel = new JLabel();
        this.fromModel = new DefaultListModel();
        this.fromList = new JList();
        this.toLabel = new JLabel();
        this.toModel = new DefaultListModel();
        this.toList = new JList();
        this.fromFieldDescriptionLabel = new JLabel(fieldDescriptionLabelBlank);
        this.toFieldDescriptionLabel = new JLabel(fieldDescriptionLabelBlank);
        this.createPanel(clazz);
    }

    @Override
    protected void setSelectedClass(ComboBoxModel classModel) {
        int size = classModel.getSize();
        for (int i = 0; i < size; ++i) {
            ClassesPanel.ClassComboBoxItem item = (ClassesPanel.ClassComboBoxItem)classModel.getElementAt(i);
            if (!item.isSpecial()) continue;
            classModel.setSelectedItem(item);
            return;
        }
        super.setSelectedClass(classModel);
    }

    @Override
    protected ClassesPanel.ClassComboBoxItem createClassComboBoxItem(DebugClassInfo clazz, int row) {
        final String className = clazz.getName();
        return new ClassesPanel.ClassComboBoxItem(clazz, row){

            @Override
            protected boolean isSpecial() {
                if (ObjectPreferencesPanel.this.valueExpressions.containsKey(className)) {
                    return true;
                }
                if (ObjectPreferencesPanel.this.expandExpressions.containsKey(className)) {
                    return true;
                }
                if (ObjectPreferencesPanel.this.hideAllFields.contains(className)) {
                    return true;
                }
                return ObjectPreferencesPanel.this.hiddenFields.containsKey(className);
            }
        };
    }

    @Override
    JPanel createBody() {
        JLabel infoLabel = new JLabel(DbgArb.getString(727));
        ResourceUtils.resLabel((JLabel)this.scopeLabel, this.scopeComboBox, (String)DbgArb.getString(735));
        JLabel valueLabel = new JLabel(DbgArb.getString(728));
        ResourceUtils.resButton((AbstractButton)this.radioValueToString, (String)DbgArb.getString(729));
        ResourceUtils.resButton((AbstractButton)this.radioValueExpression, (String)DbgArb.getString(736));
        ResourceUtils.resButton((AbstractButton)this.checkValueToStringOnlyWhenOverridden, (String)DbgArb.getString(730));
        ResourceUtils.resButton((AbstractButton)this.checkValueToStringOnlyWhenNoExpression, (String)DbgArb.getString(731));
        ButtonGroup buttonGroupValue = new ButtonGroup();
        buttonGroupValue.add(this.radioValueToString);
        buttonGroupValue.add(this.radioValueExpression);
        this.valueExpressionComboBoxEditor.getAccessibleContext().setAccessibleName(this.radioValueExpression.getText());
        this.valueExpressionTextField.getAccessibleContext().setAccessibleName(this.radioValueExpression.getText());
        ResourceUtils.resButton((AbstractButton)this.checkExpandExpression, (String)DbgArb.getString(738));
        this.expandExpressionComboBoxEditor.getAccessibleContext().setAccessibleName(this.checkExpandExpression.getText());
        this.expandExpressionTextField.getAccessibleContext().setAccessibleName(this.checkExpandExpression.getText());
        ResourceUtils.resButton((AbstractButton)this.checkExpandFields, (String)DbgArb.getString(739));
        ResourceUtils.resLabel((JLabel)this.fromLabel, this.fromList, (String)DbgArb.getString(741));
        this.shuttle.add((Component)this.fromLabel, (Object)"FromHeader");
        this.fromList.setModel(this.fromModel);
        ListPicker fromPicker = new ListPicker(this.fromList);
        fromPicker.setItemsSorted(this.sortFields);
        this.shuttle.setFromPicker((ItemPicker)fromPicker);
        this.shuttle.add((Component)this.fromFieldDescriptionLabel, (Object)"FromFooter");
        ResourceUtils.resLabel((JLabel)this.toLabel, this.toList, (String)DbgArb.getString(742));
        this.shuttle.add((Component)this.toLabel, (Object)"ToHeader");
        this.toList.setModel(this.toModel);
        ListPicker toPicker = new ListPicker(this.toList);
        toPicker.setItemsSorted(this.sortFields);
        this.shuttle.setToPicker((ItemPicker)toPicker);
        this.shuttle.add((Component)this.toFieldDescriptionLabel, (Object)"ToFooter");
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int y = 0;
        panel.add((Component)this.scopeLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add(this.scopeComboBox, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)infoLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)valueLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.radioValueToString, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.checkValueToStringOnlyWhenOverridden, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 35, 0, 0), 0, 0));
        panel.add((Component)this.checkValueToStringOnlyWhenNoExpression, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 35, 0, 0), 0, 0));
        panel.add((Component)this.radioValueExpression, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add(this.valueExpressionComboBox, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.valueExpressionTextField, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.expandLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.checkExpandExpression, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add(this.expandExpressionComboBox, new GridBagConstraints(1, y, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.expandExpressionTextField, new GridBagConstraints(1, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.checkExpandFields, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.fieldsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(15, 30, 0, 0), 0, 0));
        panel.add((Component)this.shuttle, new GridBagConstraints(0, y++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 30, 0, 0), 0, 0));
        ActionListener actionListenerScopeSelection = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScopeComboBoxItem item = (ScopeComboBoxItem)ObjectPreferencesPanel.this.scopeComboBox.getSelectedItem();
                ObjectPreferencesPanel.this.toggleExpansionAndFieldsVisibility(item.clazz != null);
                ObjectPreferencesPanel.this.selectedScope = item.clazz != null ? item.clazz.getName() : item.packageName;
                DataValueToStringBehavior behaviorForScope = ObjectPreferencesPanel.this.toStringBehavior.get(ObjectPreferencesPanel.this.selectedScope);
                if (behaviorForScope == null) {
                    behaviorForScope = ObjectPreferencesPanel.this.objectPreferences.getInheritedToStringBehaviorSetting(ObjectPreferencesPanel.this.selectedScope, true);
                }
                ObjectPreferencesPanel.this.configureToStringControlsFromBehavior(behaviorForScope);
            }
        };
        this.scopeComboBox.addActionListener(actionListenerScopeSelection);
        ActionListener actionListenerRadioValue = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPreferencesPanel.this.enableValueSection();
                ObjectPreferencesPanel.this.checkValueToStringOnlyWhenOverridden.setEnabled(ObjectPreferencesPanel.this.radioValueToString.isSelected());
                ObjectPreferencesPanel.this.checkValueToStringOnlyWhenNoExpression.setEnabled(ObjectPreferencesPanel.this.radioValueToString.isSelected());
            }
        };
        this.radioValueToString.addActionListener(actionListenerRadioValue);
        this.radioValueExpression.addActionListener(actionListenerRadioValue);
        this.valueExpressionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = (String)ObjectPreferencesPanel.this.valueExpressionComboBox.getSelectedItem();
                ObjectPreferencesPanel.this.valueExpressionComboBoxEditor.setText(s);
                ObjectPreferencesPanel.this.valueExpressionTextField.setText(s);
            }
        });
        this.checkExpandExpression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPreferencesPanel.this.enableExpandSection();
            }
        });
        this.expandExpressionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = (String)ObjectPreferencesPanel.this.expandExpressionComboBox.getSelectedItem();
                ObjectPreferencesPanel.this.expandExpressionComboBoxEditor.setText(s);
                ObjectPreferencesPanel.this.expandExpressionTextField.setText(s);
            }
        });
        this.checkExpandFields.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectPreferencesPanel.this.enableHiddenFieldsSection();
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ObjectPreferencesPanel.this.updateFieldDescriptionLabel((JList)e.getSource());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        this.fromList.addFocusListener(focusListener);
        this.toList.addFocusListener(focusListener);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ObjectPreferencesPanel.this.updateFieldDescriptionLabel((JList)e.getSource());
            }
        };
        this.fromList.addListSelectionListener(listSelectionListener);
        this.toList.addListSelectionListener(listSelectionListener);
        return panel;
    }

    private void toggleExpansionAndFieldsVisibility(boolean visible) {
        this.checkExpandExpression.setVisible(visible);
        this.expandExpressionComboBox.setVisible(visible);
        this.expandExpressionTextField.setVisible(visible);
        this.expandLabel.setVisible(visible);
        this.checkExpandFields.setVisible(visible);
        this.fieldsLabel.setVisible(visible);
        this.shuttle.setVisible(visible);
        this.fromLabel.setVisible(visible);
        this.fromList.setVisible(visible);
        this.toLabel.setVisible(visible);
        this.toList.setVisible(visible);
    }

    void addToScopeModel(DebugClassInfo clazz) {
        int row = 0;
        ScopeComboBoxItem item = new ScopeComboBoxItem(clazz, row++);
        this.scopeModel.addElement(item);
        String packageName = clazz.getPackage();
        if (packageName != null) {
            int dotIndex = -1;
            do {
                item = new ScopeComboBoxItem(packageName + ".*", row++);
                this.scopeModel.addElement(item);
                dotIndex = packageName.lastIndexOf(46);
                if (dotIndex == -1) continue;
                packageName = packageName.substring(0, dotIndex);
            } while (dotIndex != -1);
        }
        item = new ScopeComboBoxItem("*", row++);
        this.scopeModel.addElement(item);
    }

    @Override
    Dimension getAppropriateSize() {
        return new Dimension(575, 450);
    }

    @Override
    void saveBody(DebugClassInfo currentClass) {
        boolean scopeIsPackage = false;
        String className = currentClass.getName();
        if (this.selectedScope.endsWith(".*")) {
            scopeIsPackage = true;
        }
        DataValueToStringBehavior inheritedSetting = scopeIsPackage ? this.objectPreferences.getInheritedToStringBehaviorSetting(this.selectedScope.replace(".*", ""), false) : this.objectPreferences.getInheritedToStringBehaviorSetting(this.selectedScope, false);
        DataValueToStringBehavior scopedSetting = this.toStringBehavior.get(this.selectedScope);
        if (scopedSetting == null) {
            scopedSetting = new DataValueToStringBehavior();
        }
        scopedSetting.setUseToString(this.radioValueToString.isSelected());
        scopedSetting.setUseToStringOnlyWhenOverridden(this.checkValueToStringOnlyWhenOverridden.isSelected());
        scopedSetting.setUseToStringOnlyWhenNoExpressionSpecified(this.checkValueToStringOnlyWhenOverridden.isSelected());
        if (scopedSetting.equals((Object)inheritedSetting)) {
            this.toStringBehavior.remove(this.selectedScope);
        } else {
            this.toStringBehavior.put(this.selectedScope, scopedSetting);
        }
        this.objectPreferences.setUseToStringBehaviorMap(this.toStringBehavior);
        if (scopeIsPackage) {
            return;
        }
        String valueExpression = this.valueExpressionTextField.getText();
        if (valueExpression.length() > 0) {
            this.valueExpressions.put(className, valueExpression);
            this.objectPreferences.addChangedValueExpressionSuggestion(className, valueExpression);
        } else {
            this.valueExpressions.remove(className);
        }
        if (this.checkExpandExpression.isSelected()) {
            String expandExpression = this.expandExpressionTextField.getText();
            if (expandExpression.length() > 0) {
                this.expandExpressions.put(className, expandExpression);
                this.objectPreferences.addChangedExpandExpressionSuggestion(className, expandExpression);
            } else {
                this.expandExpressions.remove(className);
            }
        } else {
            this.expandExpressions.remove(className);
        }
        if (this.checkExpandFields.isSelected()) {
            this.hideAllFields.remove(className);
        } else {
            this.hideAllFields.add(className);
        }
        int count = this.toModel.size();
        if (count > 0) {
            String[] fieldNames = new String[count];
            for (int i = 0; i < count; ++i) {
                fieldNames[i] = this.toModel.elementAt(i);
            }
            this.hiddenFields.put(className, fieldNames);
        } else {
            this.hiddenFields.remove(className);
        }
    }

    @Override
    void clearBody() {
        DataValueToStringBehavior defaultBehavior = this.objectPreferences.getUseToStringBehavior("*");
        this.radioValueToString.setSelected(defaultBehavior.isUseToString());
        this.checkValueToStringOnlyWhenOverridden.setSelected(defaultBehavior.isUseToStringOnlyWhenOverridden());
        this.checkValueToStringOnlyWhenOverridden.setEnabled(this.radioValueToString.isSelected());
        this.checkValueToStringOnlyWhenNoExpression.setSelected(defaultBehavior.isUseToStringOnlyWhenNoExpressionSpecified());
        this.checkValueToStringOnlyWhenNoExpression.setEnabled(this.radioValueToString.isSelected());
        this.valueExpressionSuggestions.clear();
        this.valueExpressionSuggestions.add("");
        this.valueExpressionModel.removeAllElements();
        this.valueExpressionModel.addElement("");
        this.valueExpressionModel.setSelectedItem("");
        this.valueExpressionTextField.setText("");
        this.enableValueSection();
        this.checkExpandExpression.setSelected(false);
        this.expandExpressionSuggestions.clear();
        this.expandExpressionSuggestions.add("");
        this.expandExpressionModel.removeAllElements();
        this.expandExpressionModel.addElement("");
        this.expandExpressionModel.setSelectedItem("");
        this.expandExpressionTextField.setText("");
        this.enableExpandSection();
        this.checkExpandFields.setSelected(true);
        this.fromModel.clear();
        this.toModel.clear();
        this.declaredFields.clear();
        this.hiddenFieldsList.clear();
        this.fromFieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        this.toFieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        this.enableHiddenFieldsSection();
    }

    @Override
    void loadBody(DebugClassInfo currentClass) {
        ArrayList<String> temp;
        String expandExpression;
        String valueExpression;
        String className = currentClass.getName();
        this.addToScopeModel(currentClass);
        DataValueToStringBehavior defaultBehavior = this.objectPreferences.getInheritedToStringBehaviorSetting(className, false);
        List<String> valueSuggestions = this.objectPreferences.getValueExpressionSuggestions(className);
        for (String suggestion : valueSuggestions) {
            this.valueExpressionSuggestions.add(suggestion);
            this.valueExpressionModel.addElement(suggestion);
        }
        DataValueToStringBehavior classToStringBehavior = this.toStringBehavior.get(className);
        if (classToStringBehavior == null) {
            classToStringBehavior = defaultBehavior;
        }
        if ((valueExpression = this.valueExpressions.get(className)) != null) {
            if (valueExpression.equals(toStringExpression)) {
                this.radioValueToString.setSelected(true);
            } else {
                if (!this.valueExpressionSuggestions.contains(valueExpression)) {
                    this.valueExpressionSuggestions.add(valueExpression);
                    this.valueExpressionModel.addElement(valueExpression);
                }
                this.valueExpressionModel.setSelectedItem(valueExpression);
            }
        }
        this.configureToStringControlsFromBehavior(classToStringBehavior);
        boolean useComboBoxForValueExpression = this.valueExpressionSuggestions.size() > 1;
        this.valueExpressionComboBox.setVisible(useComboBoxForValueExpression);
        this.valueExpressionTextField.setVisible(!useComboBoxForValueExpression);
        this.enableValueSection();
        List<String> expandSuggestions = this.objectPreferences.getExpandExpressionSuggestions(className);
        if (expandSuggestions != null) {
            for (String suggestion : expandSuggestions) {
                this.expandExpressionSuggestions.add(suggestion);
                this.expandExpressionModel.addElement(suggestion);
            }
        }
        if ((expandExpression = this.expandExpressions.get(className)) != null && expandExpression.length() > 0) {
            this.checkExpandExpression.setSelected(true);
            if (!this.expandExpressionSuggestions.contains(expandExpression)) {
                this.expandExpressionSuggestions.add(expandExpression);
                this.expandExpressionModel.addElement(expandExpression);
            }
            this.expandExpressionModel.setSelectedItem(expandExpression);
        } else {
            this.checkExpandExpression.setSelected(false);
        }
        boolean useComboBoxForExpandExpression = this.expandExpressionSuggestions.size() > 1;
        this.expandExpressionComboBox.setVisible(useComboBoxForExpandExpression);
        this.expandExpressionTextField.setVisible(!useComboBoxForExpandExpression);
        this.enableExpandSection();
        boolean expandFields = !this.hideAllFields.contains(className);
        this.checkExpandFields.setSelected(expandFields);
        String[] fieldNames = this.hiddenFields.get(className);
        if (fieldNames != null) {
            temp = new ArrayList<String>();
            for (String fieldName : fieldNames) {
                this.hiddenFieldsList.add(fieldName);
                temp.add(fieldName);
            }
            if (this.sortFields) {
                Collections.sort(temp);
            }
            int size = temp.size();
            for (int i = 0; i < size; ++i) {
                this.toModel.addElement((String)temp.get(i));
            }
        }
        temp = new ArrayList();
        for (DebugFieldInfo field : currentClass.getFields(0, false, true)) {
            String fieldName = field.getName();
            this.declaredFields.put(fieldName, field);
            if (this.hiddenFieldsList.contains(fieldName)) continue;
            temp.add(fieldName);
        }
        if (this.sortFields) {
            Collections.sort(temp);
        }
        int size = temp.size();
        for (int i = 0; i < size; ++i) {
            this.fromModel.addElement((String)temp.get(i));
        }
    }

    private void configureToStringControlsFromBehavior(DataValueToStringBehavior classToStringBehavior) {
        boolean useToString = classToStringBehavior.isUseToString();
        this.radioValueToString.setSelected(useToString);
        this.radioValueExpression.setSelected(!useToString);
        this.checkValueToStringOnlyWhenOverridden.setSelected(classToStringBehavior.isUseToStringOnlyWhenOverridden());
        this.checkValueToStringOnlyWhenOverridden.setEnabled(useToString);
        this.checkValueToStringOnlyWhenNoExpression.setSelected(classToStringBehavior.isUseToStringOnlyWhenNoExpressionSpecified());
        this.checkValueToStringOnlyWhenNoExpression.setEnabled(useToString);
    }

    private void enableValueSection() {
        boolean expressionIsSelected = this.radioValueExpression.isSelected();
        this.valueExpressionComboBox.setEnabled(expressionIsSelected);
        this.valueExpressionTextField.setEnabled(expressionIsSelected);
    }

    private void enableExpandSection() {
        boolean expressionIsSelected = this.checkExpandExpression.isSelected();
        this.expandExpressionComboBox.setEnabled(expressionIsSelected);
        this.expandExpressionTextField.setEnabled(expressionIsSelected);
    }

    private void enableHiddenFieldsSection() {
        boolean fieldsIsSelected = this.checkExpandFields.isSelected();
        this.fieldsLabel.setEnabled(fieldsIsSelected);
        this.shuttle.setEnabled(fieldsIsSelected);
        this.fromLabel.setEnabled(fieldsIsSelected);
        this.fromList.setEnabled(fieldsIsSelected);
        this.toLabel.setEnabled(fieldsIsSelected);
        this.toList.setEnabled(fieldsIsSelected);
        this.fromFieldDescriptionLabel.setEnabled(fieldsIsSelected);
        this.toFieldDescriptionLabel.setEnabled(fieldsIsSelected);
    }

    private void updateFieldDescriptionLabel(JList list) {
        JLabel fieldDescriptionLabel = list == this.fromList ? this.fromFieldDescriptionLabel : this.toFieldDescriptionLabel;
        String fieldName = (String)list.getSelectedValue();
        DebugFieldInfo field = this.declaredFields.get(fieldName);
        if (field != null) {
            fieldDescriptionLabel.setText(field.getClassInfo().getName() + fieldDescriptionLabelBlank + fieldName);
        } else {
            fieldDescriptionLabel.setText(fieldDescriptionLabelBlank);
        }
    }

    protected static class ScopeComboBoxRenderer<ObjectPreferencesPanel$ScopeComboBoxItem>
    extends BasicComboBoxRenderer {
        protected ScopeComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ScopeComboBoxItem item = (ScopeComboBoxItem)list.getModel().getElementAt(index);
            if (item != null && item.isBold() && this.getFont() != null) {
                this.setFont(boldFont);
            }
            return component;
        }
    }

    protected class ScopeComboBoxItem {
        private final DebugClassInfo clazz;
        private final int row;
        private final String toString;
        private final String packageName;

        protected ScopeComboBoxItem(DebugClassInfo clazz, int row) {
            this.clazz = clazz;
            this.row = row;
            this.toString = DbgArb.format(732, clazz.getName());
            this.packageName = null;
        }

        protected ScopeComboBoxItem(String packageName, int row) {
            this.clazz = null;
            this.row = row;
            this.toString = packageName.equals("*") ? DbgArb.getString(734) : DbgArb.format(733, packageName);
            this.packageName = packageName;
        }

        public boolean isBold() {
            if (this.clazz != null) {
                return ObjectPreferencesPanel.this.toStringBehavior.containsKey(this.clazz.getName());
            }
            return ObjectPreferencesPanel.this.toStringBehavior.containsKey(this.packageName);
        }

        public String toString() {
            return this.toString;
        }
    }
}

