/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.docking.Dockable;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.jdeveloper.debugger.support.DebuggerWindowOptions;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.DebuggerMonitorsWindowOptions;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggerWindow;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorsPanel;
import oracle.jdevimpl.runner.debug.MonitorsThreadsPanel;
import oracle.jdevimpl.runner.debug.MonitorsWindowSettings;
import oracle.jdevimpl.runner.debug.Utils;

final class MonitorsWindow
extends DebuggerWindow {
    private String title;
    private MonitorsPanel monitorsPanel;
    private MonitorsThreadsPanel owningThreadPanel;
    private MonitorsThreadsPanel waitingThreadsPanel;
    private MonitorsThreadsPanel blockedThreadsPanel;
    private JSplitPane splitPane;
    static final String MONITORS_WINDOW_ID = "Debugger.MonitorsWindow";
    static final int OWNING_THREAD_PANEL_ID = 1;
    static final int WAITING_THREADS_PANEL_ID = 2;
    static final int BLOCKED_THREADS_PANEL_ID = 3;
    private MonitorsWindowSettings monitorsWindowSettings = MonitorsWindowSettings.getInstance();
    private Boolean useFilters;
    DebuggerMonitorsWindowOptions windowOptions;

    MonitorsWindow() {
        super(MONITORS_WINDOW_ID);
        this.title = DbgArb.getString(593);
    }

    public void stateChange(int newState) {
        super.stateChange(newState);
        if (this.monitorsPanel != null) {
            boolean isShowing = newState == 1;
            this.monitorsPanel.setShowing(isShowing);
            if (isShowing) {
                this.everythingChanged();
            }
        }
    }

    public int getDefaultVisibility(Layout layout) {
        if (this.windowOptions != null && this.windowOptions.isInitiallyVisible()) {
            return 1;
        }
        return 0;
    }

    public Icon getTabIcon() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTabIcon();
        }
        return OracleIcons.getIcon((String)"debugger/monitors.png");
    }

    @Override
    public DebuggerWindowProvider.DebuggerWindowPosition getPosition() {
        return DebuggerWindowProvider.DebuggerWindowPosition.FLOATING;
    }

    @Override
    public Rectangle getFloatingPosition() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension d = toolkit.getScreenSize();
        Point centerOfScreen = new Point(d.width / 2, d.height / 2);
        int width = 400;
        int height = 300;
        if ((double)d.width * 0.4 >= 600.0) {
            width = 600;
            height = 400;
        } else if ((double)d.width * 0.4 >= 500.0) {
            width = 500;
            height = 350;
        }
        return new Rectangle(centerOfScreen.x - width / 2, centerOfScreen.y - height / 2, width, height);
    }

    @Override
    public void refresh() {
        this.everythingChanged();
    }

    public boolean installByDefault() {
        return true;
    }

    public void shutDown() {
        this.setNewVm(null);
    }

    private void makeSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setLeftComponent(this.makeLeftPanel());
            this.splitPane.setRightComponent(this.makeRightPanel());
            this.splitPane.setResizeWeight(0.5);
        }
    }

    private JPanel makeLeftPanel() {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JLabel monitorsLabel = new JLabel();
        Component monitorsComponent = this.monitorsPanel.getGUI();
        String monitorsLabelText = DbgArb.getString(594);
        if (this.windowOptions != null) {
            monitorsLabelText = this.windowOptions.getMainWindowOptions().getTitleName();
        }
        ResourceUtils.resLabel((JLabel)monitorsLabel, (Component)monitorsComponent, (String)monitorsLabelText);
        int y = 0;
        leftPanel.add((Component)monitorsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        leftPanel.add(monitorsComponent, new GridBagConstraints(0, y, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return leftPanel;
    }

    private JPanel makeRightPanel() {
        JPanel rightPanel = new JPanel(new GridBagLayout());
        JLabel owningThreadLabel = new JLabel();
        JLabel waitingThreadsLabel = new JLabel();
        JLabel blockedThreadsLabel = new JLabel();
        Component owningThreadComponent = this.owningThreadPanel.getGUI();
        Component waitingThreadsComponent = this.waitingThreadsPanel.getGUI();
        Component blockedThreadsComponent = this.blockedThreadsPanel.getGUI();
        String owningThreadText = DbgArb.getString(595);
        String waitingThreadsText = DbgArb.getString(597);
        String blockedThreadsText = DbgArb.getString(599);
        if (this.windowOptions != null) {
            owningThreadText = this.windowOptions.getOwningThreadPanelOptions().getTitleName();
            waitingThreadsText = this.windowOptions.getWaitingThreadsPanelOptions().getTitleName();
            blockedThreadsText = this.windowOptions.getBlockedThreadsPanelOptions().getTitleName();
        }
        ResourceUtils.resLabel((JLabel)owningThreadLabel, (Component)owningThreadComponent, (String)owningThreadText);
        ResourceUtils.resLabel((JLabel)waitingThreadsLabel, (Component)waitingThreadsComponent, (String)waitingThreadsText);
        ResourceUtils.resLabel((JLabel)blockedThreadsLabel, (Component)blockedThreadsComponent, (String)blockedThreadsText);
        int y = 0;
        rightPanel.add((Component)owningThreadLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add(owningThreadComponent, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.2, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        rightPanel.add((Component)waitingThreadsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add(waitingThreadsComponent, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.4, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        rightPanel.add((Component)blockedThreadsLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        rightPanel.add(blockedThreadsComponent, new GridBagConstraints(0, y, 0, 1, 1.0, 0.4, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        return rightPanel;
    }

    private void setWindowOptionsFromVM(DebugVirtualMachine vm) {
        DebuggerWindowOptions options = vm.getDebuggerWindowOptions(DebuggerWindowOptions.WindowId.MonitorsWindow);
        if (options == DebuggerWindowOptions.DEFAULT) {
            this.windowOptions = new DebuggerMonitorsWindowOptions(this.monitorsWindowSettings.getDataPanelSettings());
        } else if (options instanceof DebuggerMonitorsWindowOptions) {
            this.windowOptions = (DebuggerMonitorsWindowOptions)options;
        } else {
            Log.error((String)"MonitorsWindow options is not a subclass of DebuggerMonitorsWindowOptions");
            this.windowOptions = null;
        }
    }

    private void setNewVm(DebugVirtualMachine newVM) {
        this.windowOptions = null;
        if (newVM != null) {
            this.setWindowOptionsFromVM(newVM);
        }
        this.debugWindowSettingsChanged(DebugWindowSettings.getInstance());
        if (this.monitorsPanel != null) {
            this.monitorsPanel.setNewVm(newVM, this.windowOptions);
        }
    }

    private void debugWindowSettingsChanged(DebugWindowSettings dbgSettings) {
        if (this.monitorsPanel != null) {
            this.monitorsPanel.debugWindowSettingsChanged(dbgSettings);
        }
    }

    void setUseFilters(boolean useFilters) {
        if (this.monitorsPanel != null) {
            this.monitorsPanel.setUseFilters(useFilters);
        } else {
            this.useFilters = useFilters;
        }
    }

    public String getMenuTitle() {
        if (!JDebugger.getInstance().canShowMonitorsWindow()) {
            return null;
        }
        return this.title;
    }

    public Component getGUI() {
        if (!JDebugger.getInstance().canShowMonitorsWindow()) {
            return null;
        }
        if (this.splitPane == null) {
            DebugVirtualMachine vm;
            DebuggingProcess currentDP = JDebugger.getInstance().getActiveDebuggingProcess();
            DebugVirtualMachine debugVirtualMachine = vm = currentDP == null ? null : currentDP.getVM();
            if (vm != null) {
                this.setWindowOptionsFromVM(vm);
            }
            String otTitle = this.windowOptions != null ? this.windowOptions.getOwningThreadPanelOptions().getTitleName() : DbgArb.getString(596);
            String wtTitle = this.windowOptions != null ? this.windowOptions.getWaitingThreadsPanelOptions().getTitleName() : DbgArb.getString(598);
            String btTitle = this.windowOptions != null ? this.windowOptions.getBlockedThreadsPanelOptions().getTitleName() : DbgArb.getString(600);
            this.owningThreadPanel = new MonitorsThreadsPanel(this, 1, otTitle, 1, this.monitorsWindowSettings);
            this.waitingThreadsPanel = new MonitorsThreadsPanel(this, 2, wtTitle, 2, this.monitorsWindowSettings);
            this.blockedThreadsPanel = new MonitorsThreadsPanel(this, 3, btTitle, 2, this.monitorsWindowSettings);
            this.monitorsPanel = new MonitorsPanel(this, this.owningThreadPanel, this.waitingThreadsPanel, this.blockedThreadsPanel, this.monitorsWindowSettings);
            if (this.useFilters != null) {
                this.monitorsPanel.setUseFilters(this.useFilters);
            }
            final DebugWindowSettings dbgSettings = DebugWindowSettings.getInstance();
            this.makeSplitPane();
            this.monitorsPanel.dataPanelSettingsChanged();
            this.setNewVm(vm);
            this.debugWindowSettingsChanged(dbgSettings);
            this.monitorsPanel.dataPanelSettingsChanged();
            this.owningThreadPanel.threadsPanelSettingsChanged(false);
            this.waitingThreadsPanel.threadsPanelSettingsChanged(false);
            this.blockedThreadsPanel.threadsPanelSettingsChanged(false);
            this.splitPane.resetToPreferredSizes();
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            dbgSettings.addStructureChangeListener(new StructureChangeListener(){

                public void structureValuesChanged(StructureChangeEvent e) {
                    if (Utils.structureReallyChanged(e)) {
                        MonitorsWindow.this.debugWindowSettingsChanged(dbgSettings);
                    }
                }
            });
        }
        return this.splitPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_monitorswindow_html");
    }

    public Controller getController() {
        Object f = this.findFocus();
        if (f instanceof Controller) {
            return (Controller)f;
        }
        return this.monitorsPanel.getController();
    }

    public Context getContext(EventObject event) {
        try {
            Object f = this.findFocus();
            if (f == this.monitorsPanel) {
                return this.monitorsPanel.getController().getContext(event);
            }
            if (f == this.owningThreadPanel) {
                return this.owningThreadPanel.getContext(event);
            }
            if (f == this.waitingThreadsPanel) {
                return this.waitingThreadsPanel.getContext(event);
            }
            if (f == this.blockedThreadsPanel) {
                return this.blockedThreadsPanel.getContext(event);
            }
            return this.monitorsPanel.getController().getContext(event);
        }
        catch (Exception e) {
            return super.getContext(event);
        }
    }

    public String getTabName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTabName();
        }
        return this.title;
    }

    public String getTitleName() {
        if (this.windowOptions != null) {
            return this.windowOptions.getTitleName();
        }
        return this.title;
    }

    private Object findFocus() {
        Window w;
        Component focus;
        Component c;
        for (c = this.splitPane; c != null && !(c instanceof Window); c = c.getParent()) {
        }
        if (c != null && (focus = (w = (Window)c).getFocusOwner()) != null) {
            Component monitorsPanelGUI = this.monitorsPanel.getGUI();
            Component owningThreadPanelGUI = this.owningThreadPanel.getGUI();
            Component waitingThreadsPanelGUI = this.waitingThreadsPanel.getGUI();
            Component blockedThreadsPanelGUI = this.blockedThreadsPanel.getGUI();
            for (c = focus; c != null; c = c.getParent()) {
                if (c == monitorsPanelGUI) {
                    return this.monitorsPanel;
                }
                if (c == owningThreadPanelGUI) {
                    return this.owningThreadPanel;
                }
                if (c == waitingThreadsPanelGUI) {
                    return this.waitingThreadsPanel;
                }
                if (c != blockedThreadsPanelGUI) continue;
                return this.blockedThreadsPanel;
            }
        }
        return null;
    }

    void everythingChanged() {
        if (this.monitorsPanel != null) {
            this.monitorsPanel.getController().everythingChanged();
        }
    }

    void updateMonitors(DebuggingProcess debuggingProcess, DebugVirtualMachine vm) {
        if (this.monitorsPanel == null) {
            this.getGUI();
        }
        if (this.monitorsPanel != null) {
            this.monitorsPanel.updateData(debuggingProcess, vm, null, null);
        }
        this.setNewVm(vm);
    }

    void clearMonitors() {
        if (this.monitorsPanel != null) {
            this.monitorsPanel.clearData();
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.monitorsPanel != null) {
            this.monitorsPanel.processFinished(debuggingProcess);
        }
    }
}

