/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.ui.treetable.JFastTreeTable;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdeveloper.debugger.support.DebuggerWindowColumnOptions;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.AbstractDataTreeTable;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataNameCellEditor;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelExpansionTracker;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTableCellRenderer;
import oracle.jdevimpl.runner.debug.DataTableMouseAdapter;
import oracle.jdevimpl.runner.debug.DataTableUtils;
import oracle.jdevimpl.runner.debug.DataTreeCellRenderer;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DataValueCellEditor;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.JTreeTableForChangeTracking;
import oracle.jdevimpl.runner.debug.MultiViewPanel;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

final class DataTreeTable
extends AbstractDataTreeTable {
    private DataPanelExpansionTracker expansionTracker;
    private TableColumn[] column;
    private int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private boolean[] columnNumeric;
    private DataPanelSettings dataPanelSettings;
    private String whereAreWe;
    private DebugVirtualMachine vm;
    private boolean adjustColumnsAlreadyDone = false;

    DataTreeTable(DataPanel dataPanel) {
        super(dataPanel);
        this.whereAreWe = dataPanel.getTitle();
    }

    @Override
    protected JComponent createGUI(DataPanel dataPanel) {
        this.hookupTreeTable(dataPanel);
        this.hookupScrollPane(dataPanel);
        DataTableUtils.hookupDragAndDrop(dataPanel, (JTable)this.getTreeTable(), this.getScrollPane());
        return this.getScrollPane();
    }

    private void hookupTreeTable(final DataPanel dataPanel) {
        final JFastTreeTable treeTable = this.getTreeTable();
        this.createColumns(treeTable.getColumnModel());
        treeTable.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                dataPanel.selectionChanged();
            }
        });
        treeTable.getTree().addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                dataPanel.getController().updateInstanceCounts(DataTreeTable.this.vm);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        treeTable.addMouseMotionListener((MouseMotionListener)new DataTableMouseAdapter((JTable)treeTable, dataPanel));
        treeTable.addMouseListener((MouseListener)new DataTableMouseAdapter((JTable)treeTable, dataPanel){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (dataPanel.getDebuggingProcess() == null || !dataPanel.getDebuggingProcess().isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, dataPanel.getTitle()));
                }
                if (DataTreeTable.this.isDoubleClickInTreeTable(e)) {
                    DataItem dataItem;
                    int columnAtX = treeTable.getColumnModel().getColumnIndexAtX(e.getX());
                    int column = treeTable.convertColumnIndexToModel(columnAtX);
                    boolean ignoreDoubleClick = false;
                    if (column == 1 && (dataItem = dataPanel.getSelectedDataItem()) != null && dataItem.shouldShowArrayNavigationButtons()) {
                        int row = treeTable.rowAtPoint(e.getPoint());
                        int col = treeTable.columnAtPoint(e.getPoint());
                        Rectangle r = treeTable.getCellRect(row, col, true);
                        if (e.getPoint().getX() > (double)(r.x + r.width - 80)) {
                            ignoreDoubleClick = true;
                        }
                    }
                    if (!ignoreDoubleClick) {
                        dataPanel.getController().handleDoubleClickOrEnter(e, column);
                    }
                }
            }
        });
        DataTableUtils.hookupTable(dataPanel, (JTable)this.getTreeTable());
        this.hookupRenderers(dataPanel);
    }

    private void hookupRenderers(DataPanel dataPanel) {
        DataTableCellRenderer dataTableCellRenderer = new DataTableCellRenderer(dataPanel);
        for (Class renderClass : DataTableCellRenderer.rendererForClasses) {
            this.getTable().setDefaultRenderer(renderClass, dataTableCellRenderer);
        }
        this.getTable().getColumnModel().getColumn(1).setCellEditor((TableCellEditor)((Object)new DataValueCellEditor(dataPanel)));
        this.getTable().getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new DataNameCellEditor(dataPanel)));
    }

    private void hookupScrollPane(final DataPanel dataPanel) {
        JFastTreeTable treeTable = this.getTreeTable();
        JScrollPane scrollPane = this.getScrollPane();
        Color background = treeTable.getBackground();
        scrollPane.setBackground(background);
        scrollPane.getViewport().setBackground(background);
        scrollPane.setViewportView((Component)treeTable);
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DataTreeTable.this.adjustColumnsAfterResize();
            }
        });
        scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    dataPanel.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    dataPanel.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (dataPanel.getDebuggingProcess() == null || !dataPanel.getDebuggingProcess().isStopped()) {
                    Toolkit.getDefaultToolkit().beep();
                    DebuggingProcess.showStatus(DbgArb.format(309, dataPanel.getTitle()));
                }
            }
        });
    }

    @Override
    protected JScrollPane createScrollPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    @Override
    protected JFastTreeTable createTreeTable(DataTreeTableModel model) {
        JFastTreeTable treeTable = DebugWindowSettings.getInstance().isChangeTrackingEnabled() ? new JTreeTableForChangeTracking((TreeTableModel)model, this.dataPanel) : new JFastTreeTable((TreeTableModel)model);
        treeTable.setKeySearchNavigable(true);
        treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set emptySet = Collections.emptySet();
        treeTable.setFocusTraversalKeys(0, emptySet);
        treeTable.setFocusTraversalKeys(1, emptySet);
        ListSelectionModel listSelectionModel = treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree tree = treeTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeSelectionModel treeSelectionModel = tree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.expansionTracker = new DataPanelExpansionTracker(tree, model);
        tree.addTreeExpansionListener(this.expansionTracker);
        tree.setCellRenderer(new DataTreeCellRenderer());
        DataTableUtils.setHeaderRenderer(treeTable.getTableHeader());
        return treeTable;
    }

    private boolean isDoubleClickInTreeTable(MouseEvent e) {
        if ((e.getModifiers() & 0x10) != 0 && e.getClickCount() == 2) {
            int columnAtX;
            JFastTreeTable treeTable = this.getTreeTable();
            int column = treeTable.convertColumnIndexToModel(columnAtX = treeTable.getColumnModel().getColumnIndexAtX(e.getX()));
            if (column == 0) {
                Rectangle r;
                JTree tree = treeTable.getTree();
                TreePath treePath = tree.getSelectionPath();
                if (treePath != null && (r = tree.getPathBounds(treePath)) != null) {
                    r.width = 1000;
                    Point p = e.getPoint();
                    if (r.contains(p)) {
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeAll(DebuggingProcess debuggingProcess) {
        this.expansionTracker.removeAll(debuggingProcess);
    }

    @Override
    public void collapseAll() {
        this.expansionTracker.collapseAll();
    }

    @Override
    public void dataPanelSettingsChanged(DataPanel dataPanel, DataPanelSettings dataPanelSettings) {
        this.dataPanelSettings = dataPanelSettings;
        HashStructure hash = dataPanelSettings.getHash();
        if (this.vm == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            boolean show = WindowSettingsColumnManager.getColumnVisible(hash, this.vm.getID(), i);
            if (this.columnShowing[i] == show) continue;
            this.columnShowing[i] = show;
            if (show) {
                this.getTable().addColumn(this.column[i]);
                continue;
            }
            this.getTable().removeColumn(this.column[i]);
        }
        DataTableUtils.setColumnOrder(this.getTable(), WindowSettingsColumnManager.getColumnOrder(hash, this.vm.getID()));
    }

    private void createColumns(TableColumnModel tableColumnModel) {
        this.column = new TableColumn[8];
        this.columnDefaultWidth = new int[8];
        this.columnShowing = new boolean[8];
        this.columnNumeric = new boolean[8];
        for (int i = 0; i < 8; ++i) {
            this.column[i] = tableColumnModel.getColumn(i);
            this.columnDefaultWidth[i] = this.column[i].getPreferredWidth();
            this.columnShowing[i] = true;
            this.columnNumeric[i] = false;
        }
        boolean[] showColumnInMenu = new boolean[8];
        Arrays.fill(showColumnInMenu, true);
        showColumnInMenu[0] = false;
        JDebugger.addColumnsMenu(this.getTable(), new ColumnMenuL(), showColumnInMenu);
        this.columnDefaultWidth[0] = this.columnDefaultWidth[0] * 2;
        this.column[0].setPreferredWidth(this.columnDefaultWidth[0]);
        this.columnDefaultWidth[1] = this.columnDefaultWidth[1] * 2;
        this.column[1].setPreferredWidth(this.columnDefaultWidth[1]);
    }

    void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.getScrollPane(), this.getTable());
    }

    @Override
    public void setNewVm(DebugVirtualMachine newVM, DataPanel dataPanel, DebuggerDataWindowOptions windowOptions) {
        List<String> columnNames;
        String vmID;
        if (this.vm != null) {
            this.storeVmSettings(this.vm);
        }
        this.vm = newVM;
        HashStructure hash = this.dataPanelSettings.getHash();
        int numColumnsWithStoredSettings = 0;
        if (newVM != null && WindowSettingsColumnManager.getVMNames(hash).contains(newVM.getID())) {
            vmID = newVM.getID();
            numColumnsWithStoredSettings = WindowSettingsColumnManager.getColumnNames(hash, vmID).size();
        }
        if (windowOptions != null && windowOptions.getNumberOfColumns() > numColumnsWithStoredSettings) {
            vmID = newVM.getID();
            if (numColumnsWithStoredSettings == 0) {
                WindowSettingsColumnManager.addVMName(hash, vmID);
                if (dataPanel instanceof MultiViewPanel) {
                    String windowId = ((MultiViewPanel)dataPanel).getWindowId();
                    if (windowOptions.getDefaultView() == DebuggerDataWindowOptions.View.TREE) {
                        WindowSettingsColumnManager.setActiveDataView(hash, vmID, windowId, "TREE_TABLE");
                    } else {
                        WindowSettingsColumnManager.setActiveDataView(hash, vmID, windowId, "TABLE_TABLE");
                    }
                }
            }
            columnNames = new ArrayList<String>();
            ArrayList<String> ppColumnNames = new ArrayList<String>();
            boolean alteredTreeOrder = false;
            boolean alteredTableOrder = false;
            ArrayList<DebuggerWindowColumnOptions> colsInTreeOrder = new ArrayList<DebuggerWindowColumnOptions>();
            ArrayList<DebuggerWindowColumnOptions> colsInTableOrder = new ArrayList<DebuggerWindowColumnOptions>();
            for (int i = 0; i < windowOptions.getNumberOfColumns(); ++i) {
                DebuggerWindowColumnOptions column = windowOptions.getColumnInfo(i);
                if (i >= numColumnsWithStoredSettings) {
                    WindowSettingsColumnManager.setColumnVisible(hash, vmID, i, column.isVisibleInTreeViewByDefault());
                    WindowSettingsColumnManager.setColumnBreadcrumbVisible(hash, vmID, i, column.isVisibleByDefault());
                    WindowSettingsColumnManager.setColumnNumeric(hash, vmID, i, column.isNumeric());
                }
                columnNames.add(column.getColumnName());
                ppColumnNames.add(column.getColumnNameInPrefencePane());
                if (column.getOrderInTree() != -1) {
                    alteredTreeOrder = true;
                    colsInTreeOrder.set(column.getOrderInTree(), column);
                } else {
                    colsInTreeOrder.add(column);
                }
                if (column.getOrderInTable() != -1) {
                    alteredTableOrder = true;
                    colsInTableOrder.set(column.getOrderInTable(), column);
                    continue;
                }
                colsInTableOrder.add(column);
            }
            WindowSettingsColumnManager.setColumnNames(hash, vmID, columnNames);
            WindowSettingsColumnManager.setColumnNamesInPreferences(hash, vmID, ppColumnNames);
            if (alteredTreeOrder) {
                StringBuilder sb = new StringBuilder();
                for (DebuggerWindowColumnOptions col : colsInTreeOrder) {
                    sb.append(col.getColumnName());
                    sb.append(",");
                }
                WindowSettingsColumnManager.setColumnOrder(hash, vmID, sb.toString());
            }
            if (alteredTableOrder) {
                StringBuilder sb = new StringBuilder();
                for (DebuggerWindowColumnOptions col : colsInTableOrder) {
                    sb.append(col.getColumnName());
                    sb.append(",");
                }
                WindowSettingsColumnManager.setColumnBreadcrumbOrder(hash, vmID, sb.toString());
            }
        }
        if (newVM != null) {
            int i;
            vmID = newVM.getID();
            columnNames = WindowSettingsColumnManager.getColumnNames(hash, vmID);
            for (i = 0; i < 8 && columnNames.size() > i; ++i) {
                String columnName = columnNames.get(i);
                this.columnNumeric[i] = columnName != null ? WindowSettingsColumnManager.getColumnNumeric(hash, vmID, i) : false;
            }
            WindowSettingsColumnManager.setColumnNames(hash, vmID, columnNames);
            for (i = 0; i < columnNames.size(); ++i) {
                String columnName = columnNames.get(i);
                columnNames.set(i, StringUtils.stripMnemonic((String)columnName));
            }
            for (i = 0; i < windowOptions.getNumberOfColumns() && i < this.column.length && i < columnNames.size(); ++i) {
                this.column[i].setHeaderValue(columnNames.get(i));
            }
            this.getTable().getTableHeader().repaint();
            this.dataPanelSettingsChanged(dataPanel, this.dataPanelSettings);
            for (i = 0; i < windowOptions.getNumberOfColumns(); ++i) {
                int width = WindowSettingsColumnManager.getColumnWidth(hash, vmID, i);
                if (width > 0) {
                    this.adjustColumnsAlreadyDone = true;
                    this.column[i].setPreferredWidth(width);
                    continue;
                }
                this.column[i].setPreferredWidth(this.columnNumeric[i] ? 37 : 75);
            }
            TableColumnModel tableColumnModel = this.getTable().getColumnModel();
            String order = WindowSettingsColumnManager.getColumnOrder(hash, vmID);
            if (order != null) {
                for (int i2 = 0; i2 < windowOptions.getNumberOfColumns(); ++i2) {
                    String identifier;
                    int comma = order.indexOf(44);
                    if (comma != -1) {
                        identifier = order.substring(0, comma);
                        order = order.substring(comma + 1);
                    } else {
                        identifier = order;
                    }
                    if (identifier.length() == 0) break;
                    try {
                        int from = tableColumnModel.getColumnIndex(identifier);
                        if (from == i2) continue;
                        this.getTable().moveColumn(from, i2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void storeVmSettings(DebugVirtualMachine vm) {
        HashStructure hash = this.dataPanelSettings.getHash();
        for (int i = 0; i < 8; ++i) {
            WindowSettingsColumnManager.setColumnWidth(hash, vm.getID(), i, this.column[i].getWidth());
            WindowSettingsColumnManager.setColumnVisible(hash, vm.getID(), i, this.columnShowing[i]);
            WindowSettingsColumnManager.setColumnNumeric(hash, vm.getID(), i, this.columnNumeric[i]);
        }
        TableColumnModel tcModel = this.getTable().getColumnModel();
        StringBuilder buf = new StringBuilder();
        Enumeration<TableColumn> e = tcModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            buf.append(column.getIdentifier());
            buf.append(',');
        }
        WindowSettingsColumnManager.setColumnOrder(hash, vm.getID(), buf.toString());
    }

    private class ColumnMenuL
    implements ColumnMenuListener {
        private ColumnMenuL() {
        }

        @Override
        public void showColumn(int modelIndex) {
            if (modelIndex != 0) {
                DataTreeTable.this.columnShowing[modelIndex] = true;
                if (DataTreeTable.this.dataPanelSettings != null) {
                    WindowSettingsColumnManager.setColumnVisible(DataTreeTable.this.dataPanelSettings.getHash(), DataTreeTable.this.vm.getID(), modelIndex, true);
                }
                DataTreeTable.this.getTable().addColumn(DataTreeTable.this.column[modelIndex]);
                DataTableUtils.setColumnOrder(DataTreeTable.this.getTable(), WindowSettingsColumnManager.getColumnOrder(DataTreeTable.this.dataPanelSettings.getHash(), DataTreeTable.this.vm.getID()));
            }
        }

        @Override
        public void hideColumn(int modelIndex) {
            if (modelIndex != 0) {
                DataTreeTable.this.columnShowing[modelIndex] = false;
                if (DataTreeTable.this.dataPanelSettings != null) {
                    WindowSettingsColumnManager.setColumnVisible(DataTreeTable.this.dataPanelSettings.getHash(), DataTreeTable.this.vm.getID(), modelIndex, false);
                }
                DataTreeTable.this.getTable().getTableHeader().setDraggedColumn(null);
                DataTreeTable.this.getTable().removeColumn(DataTreeTable.this.column[modelIndex]);
            }
        }
    }
}

