/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataInfoPath;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

final class DataTableSwitcher
implements DataTable {
    private final Map<Object, DataTable> dataTableMap;
    private SelectionL selectionL = new SelectionL();
    private List<ListSelectionListener> selListeners = new ArrayList<ListSelectionListener>();
    private Object key;
    private JPanel gui = new JPanel(new BorderLayout());

    DataTableSwitcher(Map<Object, DataTable> dataTableMap) {
        this.gui.setOpaque(true);
        this.gui.setBackground(UIManager.getColor("Desktop.background"));
        this.dataTableMap = dataTableMap;
    }

    void setCurrentDataTable(Object key) {
        if (key == this.key) {
            return;
        }
        DataTable removed = null;
        if (this.gui.getComponentCount() > 0) {
            removed = this.getCurrentDataTable();
            removed.removeSelectionListener(this.selectionL);
            this.gui.remove(removed.getGUI());
        }
        this.key = key;
        DataTable added = this.getCurrentDataTable();
        added.addSelectionListener(this.selectionL);
        int row = added.getTable().getSelectedRow();
        this.selectionL.valueChanged(new ListSelectionEvent(this, row, row, false));
        this.gui.add(added.getGUI(), "Center");
        if (removed instanceof Switched) {
            ((Switched)((Object)removed)).switched(false);
        }
        if (added instanceof Switched) {
            ((Switched)((Object)added)).switched(true);
        }
    }

    private DataTable getCurrentDataTable() {
        return this.dataTableMap.get(this.key);
    }

    @Override
    public Component getGUI() {
        return this.gui;
    }

    @Override
    public JTable getTable() {
        return this.getCurrentDataTable().getTable();
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.getCurrentDataTable().getScrollPane();
    }

    @Override
    public TreePath makeVisible(DataTreeTableModel model, DataInfoPath dataInfoPath) {
        return this.getCurrentDataTable().makeVisible(model, dataInfoPath);
    }

    @Override
    public void makeVisible(TreePath treePath) {
        this.getCurrentDataTable().makeVisible(treePath);
    }

    @Override
    public TreePath getPathForRow(int row) {
        return this.getCurrentDataTable().getPathForRow(row);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        this.getCurrentDataTable().setSelectionPath(path);
    }

    @Override
    public TreePath getSelectionPath() {
        return this.getCurrentDataTable().getSelectionPath();
    }

    @Override
    public boolean isVisible(TreePath treePath) {
        return this.getCurrentDataTable().isVisible(treePath);
    }

    @Override
    public boolean isExpanded(TreePath treePath) {
        return this.getCurrentDataTable().isExpanded(treePath);
    }

    @Override
    public void expandPath(TreePath treePath) {
        this.getCurrentDataTable().expandPath(treePath);
    }

    @Override
    public void collapsePath(TreePath treePath) {
        this.getCurrentDataTable().collapsePath(treePath);
    }

    @Override
    public void removeAll(DebuggingProcess debuggingProcess) {
        this.getCurrentDataTable().removeAll(debuggingProcess);
    }

    @Override
    public void collapseAll() {
        this.getCurrentDataTable().collapseAll();
    }

    @Override
    public void dataPanelSettingsChanged(DataPanel dataPanel, DataPanelSettings dataPanelSettings) {
        for (DataTable table : this.dataTableMap.values()) {
            table.dataPanelSettingsChanged(dataPanel, dataPanelSettings);
        }
    }

    @Override
    public void setNewVm(DebugVirtualMachine vm, DataPanel dataPanel, DebuggerDataWindowOptions options) {
        for (DataTable table : this.dataTableMap.values()) {
            table.setNewVm(vm, dataPanel, options);
        }
    }

    @Override
    public void storeVmSettings(DebugVirtualMachine vm) {
        for (DataTable table : this.dataTableMap.values()) {
            table.storeVmSettings(vm);
        }
    }

    public void addKeyListener(KeyAdapter listener) {
        for (DataTable table : this.dataTableMap.values()) {
            table.getTable().addKeyListener(listener);
        }
    }

    @Override
    public void addSelectionListener(ListSelectionListener l) {
        if (!this.selListeners.contains(l)) {
            this.selListeners.add(l);
        }
    }

    @Override
    public void removeSelectionListener(ListSelectionListener l) {
        this.selListeners.remove(l);
    }

    public class SelectionL
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            for (int i = DataTableSwitcher.this.selListeners.size() - 1; i >= 0; --i) {
                ListSelectionListener l = DataTableSwitcher.this.selListeners.get(i);
                l.valueChanged(e);
            }
        }
    }

    public static interface Switched {
        public void switched(boolean var1);
    }
}

