/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.ObjectCollectedException;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.runner.DataValueToStringBehavior;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;
import oracle.jdevimpl.debugger.BaseElement;
import oracle.jdevimpl.debugger.DebugObjectFactory;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.plugin.CommonHelperFunctions;
import oracle.jdevimpl.debugger.plugin.evaluator.CommonEvaluationInfoBase;
import oracle.jdevimpl.debugger.plugin.evaluator.ExpressionEvaluationException;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerHelperHook;
import oracle.jdevimpl.debugger.plugin.hooks.DebuggerLanguageHelper;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugAnnotationInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugDataPrimitiveInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHasAnnotations;
import oracle.jdevimpl.debugger.support.DebugHasExpired;
import oracle.jdevimpl.debugger.support.DebugHeapAncestor;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInPinTable;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInRegister;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInStack;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInStatic;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorInsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapAncestorOutsideHeap;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugHeapObjectInfo;
import oracle.jdevimpl.debugger.support.DebugHeapSubset;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetAncestors;
import oracle.jdevimpl.debugger.support.DebugHeapSubsetClasses;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugMonitorInfo;
import oracle.jdevimpl.debugger.support.DebugRegisterInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugStackSlotInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.AdjustRangeDialog;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataArrayRange;
import oracle.jdevimpl.runner.debug.DataController;
import oracle.jdevimpl.runner.debug.DataItemAfterEvaluationCallback;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataTableUtils;
import oracle.jdevimpl.runner.debug.DataValueHelper;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorDataItem;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MemoViewDialog;
import oracle.jdevimpl.runner.debug.ModifyValueDialog;
import oracle.jdevimpl.runner.debug.ObjectPreferences;
import oracle.jdevimpl.runner.debug.UnmodifiableObjectDialog;

public class DataItem
extends BaseElement
implements Transferable {
    protected Object info;
    protected DebugDataInfo data;
    protected DebugClassInfo actualClassInfo;
    private DebugClassInfo declaredClassInfo;
    protected DebugHeapInfo ancestorHeapInfo;
    protected int ancestorDepth;
    protected boolean ancestorShortestDepth;
    protected boolean displayNameOverridden;
    protected String displayName;
    protected String expressionPart;
    protected String displayType;
    protected String displayValue;
    private DataItem[] children;
    private DataArrayRange arrayRange;
    private Expression expressionSaved;
    private Boolean cachedMayHaveChildren;
    private String cachedDisplayName;
    private String cachedActualType;
    private String cachedFullyQualifiedActualType;
    private String cachedDeclaredType;
    private String cachedFullyQualifiedDeclaredType;
    private String cachedValue;
    private String cachedValueExpressionUsed;
    private String cachedHexValue;
    private String cachedAddress;
    private String cachedID;
    private long cachedInstanceCount;
    private List<DataItem> cachedFields;
    private List<DataItem> cachedDeclaredFields;
    private DataItem parentDataItem;
    private boolean isExpanded;
    private String reasonValueIsNotAvailable;
    protected DataPanel dataPanel;
    private static Icon arrayIconGray = null;
    private static Icon staticFolderIcon = null;
    private static Icon heapFolderIcon = null;
    private static Icon primitiveIconGray = null;
    private static Icon objectIconGray = null;
    private static Icon arrayIcon = null;
    private static DataFlavor expressionFlavor = null;
    private static DataFlavor heapObjectFlavor = null;
    private static final String NOT_AVAILABLE = "";
    private static DataFlavor[] transferFlavors;
    public static boolean LOAD_VALUES_IN_BACKGROUND;
    public static boolean TRACE_BACKGROUND_LOADS;
    public static final String LOADING_IN_BACKGROUND;
    DataItemAfterEvaluationCallback callback = new DataItemAfterEvaluationCallback(){

        @Override
        public void afterEvaluation(DataItem item, long stopcount) {
            DataItem.this.getValue();
        }
    };

    DataItem(DataPanel dataPanel, Object info) {
        this(dataPanel, info, null, null);
    }

    public DataItem(DataPanel dataPanel, Object info, String displayNameOverride, String expressionPartOverride) {
        this.dataPanel = dataPanel;
        this.ancestorHeapInfo = null;
        this.ancestorDepth = -1;
        this.ancestorShortestDepth = false;
        this.setInfo(info, displayNameOverride, expressionPartOverride);
    }

    DataItem(DataPanel dataPanel, Object info, String displayNameOverride, DebugHeapInfo ancestorHeapInfo, int ancestorDepth, boolean ancestorShortestDepth) {
        this.dataPanel = dataPanel;
        this.ancestorHeapInfo = ancestorHeapInfo;
        this.ancestorDepth = ancestorDepth;
        this.ancestorShortestDepth = ancestorShortestDepth;
        this.setInfo(info, displayNameOverride, null);
    }

    void modifyInfo(Object info, String displayNameOverride, String expressionPartOverride, TreePath treePath) {
        boolean expanded = this.dataPanel.getDataTable().isExpanded(treePath);
        if (expanded) {
            this.dataPanel.getDataTable().collapsePath(treePath);
        }
        this.setInfo(info, displayNameOverride, expressionPartOverride);
        this.clearChildren(treePath);
        if (expanded) {
            this.dataPanel.getDataTable().expandPath(treePath);
        }
    }

    protected void setInfo(Object info, String displayNameOverride, String expressionPartOverride) {
        this.clearCacheForColumn(-1);
        this.setIcon(null);
        this.info = info;
        this.displayNameOverridden = displayNameOverride != null;
        this.children = null;
        this.arrayRange = null;
        this.expressionSaved = null;
        this.reasonValueIsNotAvailable = null;
        if (info instanceof EvaluatorDataItem) {
            info = ((EvaluatorDataItem)info).getInfo();
        }
        if (info instanceof DebugVariableInfo) {
            DebugVariableInfo var = (DebugVariableInfo)info;
            if (var.hasExpired()) {
                return;
            }
            this.data = var.getDataInfo();
            this.declaredClassInfo = var.getClassInfo();
            this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
            name = var.getName();
            String string = this.expressionPart = expressionPartOverride != null ? expressionPartOverride : name;
            this.displayName = var.isReturned() ? (name != null && ((String)name).length() > 0 ? DbgArb.format(540, name) : DbgArb.getString(541)) : (var.isReturn() ? DbgArb.getString(542) : DataItem.prepareDisplayName(info, displayNameOverride, this.expressionPart));
        } else if (info instanceof DebugStackSlotInfo) {
            DebugStackSlotInfo slot = (DebugStackSlotInfo)info;
            if (slot.hasExpired()) {
                return;
            }
            this.data = slot.getDataInfo();
            this.declaredClassInfo = null;
            this.actualClassInfo = this.data != null ? this.data.getClassInfo() : null;
            this.expressionPart = expressionPartOverride;
            this.displayName = displayNameOverride;
        } else if (info instanceof DebugFieldInfo) {
            DebugFieldInfo field = (DebugFieldInfo)info;
            if (field.hasExpired()) {
                return;
            }
            try {
                this.data = field.getDataInfo();
            }
            catch (ObjectCollectedException oce) {
                return;
            }
            this.declaredClassInfo = field.getClassInfo();
            this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
            this.expressionPart = expressionPartOverride != null ? expressionPartOverride : field.getName();
            this.displayName = DataItem.prepareDisplayName(info, displayNameOverride, this.expressionPart);
        } else if (info instanceof DebugArrayElementInfo) {
            DebugArrayElementInfo arrayElement = (DebugArrayElementInfo)info;
            if (arrayElement.hasExpired()) {
                return;
            }
            this.data = arrayElement.getDataInfo();
            this.declaredClassInfo = arrayElement.getClassInfo();
            this.actualClassInfo = this.data != null ? this.data.getClassInfo() : this.declaredClassInfo;
            this.expressionPart = expressionPartOverride != null ? expressionPartOverride : arrayElement.getName();
            this.displayName = DataItem.prepareDisplayName(info, displayNameOverride, this.expressionPart);
        } else if (info instanceof DebugDataInfo) {
            this.data = (DebugDataInfo)info;
            this.declaredClassInfo = null;
            this.actualClassInfo = this.data.getClassInfo();
            this.expressionPart = expressionPartOverride;
            this.displayName = DataItem.prepareDisplayName(info, displayNameOverride, this.expressionPart);
        } else if (info instanceof DebugClassInfo) {
            this.data = null;
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.expressionPart = ((DebugClassInfo)info).getName();
            this.displayName = null;
            this.setIcon(DataItem.getStaticFolderIcon());
        } else if (info instanceof DebugHeapSubset) {
            this.data = null;
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.expressionPart = expressionPartOverride;
            this.displayName = ((DebugHeapSubset)info).getName();
            this.setIcon(DataItem.getHeapFolderIcon());
        } else if (info instanceof DebugHeapInfo) {
            DebugHeapInfo heap = (DebugHeapInfo)info;
            DebugHeapSubset subset = heap.getHeapSubset();
            this.data = null;
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.expressionPart = expressionPartOverride;
            if (subset instanceof DebugHeapSubsetClasses) {
                this.displayName = subset.getName() + " " + heap.countHeapObjects();
            } else if (subset instanceof DebugHeapSubsetAncestors) {
                DebugHeapObjectInfo heapObject;
                long address = ((DebugHeapSubsetAncestors)subset).getAddress();
                if (address != 0L && (heapObject = this.dataPanel.getController().getVm().getHeapObjectAtAddress(address)) != null) {
                    this.actualClassInfo = heapObject.getClassInfo();
                }
                this.displayName = subset.getName();
            }
            this.setIcon(DataItem.getHeapFolderIcon());
        } else if (info instanceof CommonEvaluationInfoBase) {
            CommonEvaluationInfoBase eval = (CommonEvaluationInfoBase)info;
            this.data = null;
            this.declaredClassInfo = null;
            this.actualClassInfo = (DebugClassInfo)eval.getClassInfo();
            this.expressionPart = expressionPartOverride;
            this.displayName = DataItem.prepareDisplayName(info, displayNameOverride, this.expressionPart);
            this.cachedValue = this.displayValue = eval.getValue();
        } else if (info instanceof EvaluatorItem) {
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.data = null;
            this.expressionPart = expressionPartOverride;
            this.displayName = DataItem.prepareDisplayName(info, displayNameOverride, this.expressionPart);
            this.cachedMayHaveChildren = Boolean.FALSE;
            this.cachedActualType = "?";
            this.cachedDeclaredType = "?";
            this.cachedValue = "?";
            this.cachedHexValue = "?";
            this.cachedAddress = NOT_AVAILABLE;
            this.cachedID = NOT_AVAILABLE;
        } else if (info instanceof ExpressionEvaluationException) {
            ExpressionEvaluationException eee = (ExpressionEvaluationException)info;
            this.reasonValueIsNotAvailable = eee.toString();
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.data = null;
            this.expressionPart = expressionPartOverride;
            this.displayName = eee.getExpression();
            this.displayValue = "?";
            this.cachedMayHaveChildren = Boolean.FALSE;
            this.cachedActualType = "?";
            this.cachedDeclaredType = "?";
            this.cachedValue = "?";
            this.cachedHexValue = "?";
            this.cachedAddress = NOT_AVAILABLE;
            this.cachedID = NOT_AVAILABLE;
        } else if (info instanceof DebugMonitorInfo) {
            DebugMonitorInfo monitor = (DebugMonitorInfo)info;
            this.data = monitor.getAssociatedObject();
            this.declaredClassInfo = null;
            this.actualClassInfo = this.data.getClassInfo();
            this.expressionPart = expressionPartOverride;
            name = null;
            long number = CommonHelperFunctions.getObjectNumber((DebugDataCompositeInfo)this.data);
            name = "@" + Long.toHexString(number).toUpperCase();
            this.displayName = DataItem.prepareDisplayName(info, displayNameOverride, (String)name);
        } else if (info instanceof DebugHeapAncestor) {
            this.data = null;
            this.declaredClassInfo = null;
            this.actualClassInfo = null;
            this.expressionPart = expressionPartOverride;
            int depth = ((DebugHeapAncestor)info).getDepth();
            this.displayValue = DbgArb.format(619, Integer.toString(depth));
            if (info instanceof DebugHeapAncestorInsideHeap) {
                DebugHeapAncestorInsideHeap ancestorInsideHeap = (DebugHeapAncestorInsideHeap)info;
                if (ancestorInsideHeap.hasExpired()) {
                    return;
                }
                this.data = ancestorInsideHeap.getDataInfo();
                this.declaredClassInfo = null;
                this.actualClassInfo = this.data.getClassInfo();
                long address = ancestorInsideHeap.getAddress();
                this.displayName = this.actualClassInfo.isArray() ? DbgArb.format(608, "@" + Long.toHexString(address).toUpperCase()) : DbgArb.format(607, "@" + Long.toHexString(address).toUpperCase());
            } else if (info instanceof DebugHeapAncestorInPinTable) {
                DebugHeapAncestorInPinTable ancestorInPinTable = (DebugHeapAncestorInPinTable)info;
                if (ancestorInPinTable.hasExpired()) {
                    return;
                }
                DebugDataCompositeInfo d = ancestorInPinTable.getDataInfo();
                DebugClassInfo c = d.getClassInfo();
                long pinnedAddress = ancestorInPinTable.getPinnedAddress();
                this.displayName = c.isArray() ? DbgArb.format(609, "@" + Long.toHexString(pinnedAddress).toUpperCase()) : DbgArb.format(610, "@" + Long.toHexString(pinnedAddress).toUpperCase());
                this.displayType = DataItem.makeType((DebugDataInfo)d, c, this.dataPanel.dataPanelSettings.isShowPackages());
            } else if (info instanceof DebugHeapAncestorInRegister) {
                DebugHeapAncestorInRegister ancestorInRegister = (DebugHeapAncestorInRegister)info;
                DebugRegisterInfo regInfo = ancestorInRegister.getRegister();
                DebugThreadInfo thread = ancestorInRegister.getThread();
                this.displayName = DbgArb.format(611, regInfo.getName());
                this.displayType = DbgArb.format(612, thread.getName());
            } else if (info instanceof DebugHeapAncestorInStack) {
                DebugHeapAncestorInStack ancestorInStack = (DebugHeapAncestorInStack)info;
                if (ancestorInStack.getVariableInfo() != null) {
                    DebugMethodInfo method = ancestorInStack.getStackFrame().getLocation().getMethod();
                    this.displayName = DbgArb.getString(613);
                    this.displayType = DbgArb.format(614, DebugShared.makeCourtesyMethodName(method, true, false, null));
                } else {
                    DebugThreadInfo thread = ancestorInStack.getThread();
                    this.displayName = DbgArb.getString(615);
                    this.displayType = DbgArb.format(616, thread.getName());
                }
            } else if (info instanceof DebugHeapAncestorInStatic) {
                DebugHeapAncestorInStatic ancestorInStatic = (DebugHeapAncestorInStatic)info;
                DebugClassInfo clazz = ancestorInStatic.getClassInfo();
                this.displayName = DbgArb.getString(617);
                this.displayType = DbgArb.format(618, DebugShared.makeCourtesyClassName(clazz, true));
            }
        } else if (info instanceof DebugAnnotationInfo) {
            DebugAnnotationInfo annotation = (DebugAnnotationInfo)info;
            this.actualClassInfo = annotation.getClassInfo();
            this.declaredClassInfo = annotation.getClassInfo();
            this.data = null;
            this.expressionPart = expressionPartOverride;
            this.displayName = DataItem.prepareDisplayName(info, displayNameOverride, this.expressionPart);
        } else if (info == null) {
            Assert.println((String)"DataItem.setInfo: info is null");
        } else {
            Assert.println((String)("DataItem.setInfo: info is not recognized: " + info.getClass().getName()));
        }
        if (this.actualClassInfo != null && this.actualClassInfo.isEnum()) {
            this.displayValue = this.getEnumValueDisplayName(this.data);
        }
        if (this.getIcon() == null) {
            if (this.data == null && info instanceof DebugVariableInfo) {
                if (this.declaredClassInfo != null) {
                    if (this.declaredClassInfo.isPrimitive()) {
                        this.setIcon(DataItem.getPrimitiveIconGray());
                    } else if (this.declaredClassInfo.isArray()) {
                        this.setIcon(DataItem.getArrayIconGray());
                    } else {
                        this.setIcon(DataItem.getObjectIconGray());
                    }
                } else {
                    this.setIcon(DataItem.getObjectIconGray());
                }
            } else if (this.actualClassInfo != null && !(info instanceof DebugHeapAncestor)) {
                if (this.actualClassInfo.isPrimitive()) {
                    this.setIcon(DataItem.getPrimitiveIcon());
                } else if (this.actualClassInfo.isArray()) {
                    this.setIcon(DataItem.getArrayIcon());
                } else {
                    ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();
                    Icon objectIcon = objectPreferences.getIcon(this.actualClassInfo.getName());
                    if (objectIcon != null) {
                        this.setIcon(objectIcon);
                    } else {
                        this.setIcon(DataItem.getObjectIcon());
                    }
                }
            }
        }
        if (this.data instanceof DebugDataArrayInfo) {
            this.arrayRange = this.dataPanel.getModel().getArrayRange(this.dataPanel.getDebuggingProcess(), (DebugDataArrayInfo)this.data, NOT_AVAILABLE + this.data.hashCode());
        }
        if (this.data instanceof DebugDataObjectInfo) {
            ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();
            List<String> expressions = objectPreferences.getExpandExpressions((DebugDataObjectInfo)this.data);
            for (String expression : expressions) {
                if (!expression.endsWith("toArray()")) continue;
                this.makeDataItemsForObjectExpandExpression((DebugDataObjectInfo)this.data, expression);
                break;
            }
        }
    }

    void clearDataForItem() {
        this.info = null;
        this.data = null;
        this.declaredClassInfo = null;
        this.actualClassInfo = null;
        this.ancestorHeapInfo = null;
        this.arrayRange = null;
        if (this.dataPanel.getModel() != null) {
            this.dataPanel.getModel().cancelPendingLoad(this);
        }
    }

    void clearCacheForColumn(int column) {
        switch (column) {
            case -1: {
                this.cachedMayHaveChildren = null;
                this.cachedDisplayName = null;
                this.cachedActualType = null;
                this.cachedDeclaredType = null;
                this.cachedValue = null;
                this.cachedHexValue = null;
                this.cachedAddress = null;
                this.cachedID = null;
                this.cachedInstanceCount = -1L;
                break;
            }
            case 0: {
                this.cachedMayHaveChildren = null;
                this.cachedDisplayName = null;
                break;
            }
            case 2: {
                this.cachedActualType = null;
                break;
            }
            case 3: {
                this.cachedDeclaredType = null;
                break;
            }
            case 1: {
                this.cachedValue = null;
                break;
            }
            case 4: {
                this.cachedHexValue = null;
                break;
            }
            case 5: {
                this.cachedAddress = null;
                break;
            }
            case 6: {
                this.cachedID = null;
                break;
            }
            case 7: {
                this.cachedInstanceCount = -1L;
            }
        }
    }

    public Object getInfo() {
        return this.info;
    }

    public DebugDataInfo getDataInfo() {
        return this.data;
    }

    protected Font getFont(int column) {
        return DataTableUtils.getNormalFont();
    }

    protected boolean isUnrelated() {
        return this.ancestorHeapInfo != null && this.ancestorDepth == -1;
    }

    String getToolTip(int column, TreePath treePath) {
        String tooltip = null;
        switch (column) {
            default: {
                tooltip = (String)this.getValueOfColumn(column);
                break;
            }
            case 0: {
                tooltip = this.makeNameToolTip(treePath);
                if (tooltip != null && tooltip.length() != 0) break;
                tooltip = this.displayName;
                break;
            }
            case 1: {
                if (this.info instanceof ExpressionEvaluationException) {
                    tooltip = ((ExpressionEvaluationException)this.info).toString();
                    break;
                }
                tooltip = (String)this.getValueOfColumn(column);
                String valueExpressionUsed = this.getValueExpressionUsed();
                if (valueExpressionUsed == null) break;
                tooltip = DbgArb.format(751, valueExpressionUsed, tooltip);
                break;
            }
            case 2: {
                tooltip = this.getActualType(true, true);
                break;
            }
            case 3: {
                if (this.declaredClassInfo == null) break;
                tooltip = DataItem.makeType(null, this.declaredClassInfo, true, this.info);
            }
        }
        if (tooltip != null && tooltip.length() > 0) {
            return tooltip;
        }
        return null;
    }

    public String getShortLabel() {
        return this.getDisplayName();
    }

    public Object getData() {
        return this;
    }

    boolean hasExpired() {
        if (this.data != null) {
            return this.data.hasExpired();
        }
        if (this.info instanceof DebugHasExpired) {
            return ((DebugHasExpired)this.info).hasExpired();
        }
        return false;
    }

    public boolean mayHaveChildren() {
        if (this.hasExpired()) {
            return false;
        }
        if (this.cachedMayHaveChildren == null && this.dataPanel.canUpdateData) {
            this.cachedMayHaveChildren = this.ancestorDepth == 0 && !(this.info instanceof DebugHeapAncestor) && this.dataPanel.dataPanelSettings.isHideUnrelated() ? Boolean.FALSE : (this.data instanceof DebugDataCompositeInfo ? (((DebugDataCompositeInfo)this.data).isNull() ? Boolean.FALSE : (Product.isRaptor() && this.actualClassInfo != null && this.actualClassInfo.getName().startsWith("$Oracle.Builtin.") ? Boolean.FALSE : Boolean.TRUE)) : (this.info instanceof DebugClassInfo ? Boolean.TRUE : (this.info instanceof DebugHeapSubset ? Boolean.FALSE : (this.info instanceof DebugHeapInfo ? Boolean.TRUE : (this.info instanceof DebugHeapAncestor ? Boolean.TRUE : (this.info instanceof DebugAnnotationInfo ? Boolean.TRUE : Boolean.FALSE))))));
        }
        if (this.cachedMayHaveChildren != null) {
            return this.cachedMayHaveChildren;
        }
        return false;
    }

    public Iterator getChildren() {
        List<DataItem> items = Arrays.asList(this.getChildNodes(false));
        return items.iterator();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return transferFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int length = transferFlavors.length;
        for (int i = 0; i < length; ++i) {
            if (!flavor.equals(transferFlavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(DataItem.getExpressionFlavor())) {
            Expression expression = this.makeExpression(null);
            if (expression != null) {
                return expression;
            }
        } else if (flavor.equals(DataItem.getHeapObjectFlavor()) && this.getAddressOfObject() != 0L) {
            return this.data;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.getShortLabel();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected Object getValueOfColumn(int column) {
        switch (column) {
            case 0: {
                return this.getDisplayName();
            }
            case 2: {
                return this.getActualType();
            }
            case 3: {
                return this.getDeclaredType();
            }
            case 1: {
                return this.getValue();
            }
            case 4: {
                return this.getHexValue();
            }
            case 5: {
                return this.getAddress();
            }
            case 6: {
                return this.getID();
            }
            case 7: {
                return this.getInstanceCount();
            }
        }
        return NOT_AVAILABLE;
    }

    String getExpressionPart() {
        return this.expressionPart;
    }

    public String getDisplayName() {
        if (this.cachedDisplayName == null && this.dataPanel.canUpdateData) {
            this.cachedDisplayName = this.displayName != null ? this.displayName : DataItem.makeDisplayName(this.info, this.dataPanel.dataPanelSettings.isShowPackages());
        }
        if (this.cachedDisplayName != null) {
            return this.cachedDisplayName;
        }
        return NOT_AVAILABLE;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.cachedDisplayName = null;
    }

    public DebugClassInfo getActualClassInfo() {
        return this.actualClassInfo;
    }

    public String getActualType() {
        return this.getActualType(false, false);
    }

    String getActualType(boolean ignoreCached, boolean showPackage) {
        if (ignoreCached) {
            return this.getTheActualType(showPackage);
        }
        if (this.cachedActualType == null && this.dataPanel.canUpdateData) {
            this.cachedActualType = this.displayType != null ? this.displayType : this.getTheActualType(showPackage);
        }
        if (this.cachedActualType != null) {
            return this.cachedActualType;
        }
        return NOT_AVAILABLE;
    }

    public String getFullyQualifiedActualType() {
        if (this.cachedFullyQualifiedActualType == null && this.dataPanel.canUpdateData) {
            this.cachedFullyQualifiedActualType = this.getTheActualType(true);
        }
        if (this.cachedFullyQualifiedActualType != null) {
            return this.cachedFullyQualifiedActualType;
        }
        return NOT_AVAILABLE;
    }

    private String getTheActualType(boolean showPackage) {
        DebuggerLanguageHelper sigHelper = null;
        List<DebuggerLanguageHelper> helpers = DebuggerHelperHook.getLanguageSpecificHelpers(Ide.getActiveProject());
        for (DebuggerLanguageHelper helper : helpers) {
            if (!helper.canProcessGenericSignature()) continue;
            sigHelper = helper;
            break;
        }
        String actualType = null;
        if (sigHelper != null) {
            String fullType;
            if (this.info != null && this.info instanceof DebugVariableInfo && ((DebugVariableInfo)this.info).getGenericSignature() != null) {
                fullType = sigHelper.processGenericSignature(((DebugVariableInfo)this.info).getGenericSignature(), true);
                if (fullType != null) {
                    String typeParams = null;
                    int lessIndex = fullType.indexOf(60);
                    if (lessIndex != -1) {
                        typeParams = fullType.substring(lessIndex);
                    }
                    actualType = DataItem.makeType(((DebugVariableInfo)this.info).getDataInfo(), this.actualClassInfo, showPackage || this.dataPanel.dataPanelSettings.isShowPackages(), typeParams);
                }
            } else if (this.info != null && this.info instanceof DebugFieldInfo && ((DebugFieldInfo)this.info).getGenericSignature() != null && (fullType = sigHelper.processGenericSignature(((DebugFieldInfo)this.info).getGenericSignature(), showPackage || this.dataPanel.dataPanelSettings.isShowPackages())) != null) {
                String typeParams = null;
                int lessIndex = fullType.indexOf(60);
                if (lessIndex != -1) {
                    typeParams = fullType.substring(lessIndex);
                }
                actualType = DataItem.makeType(((DebugFieldInfo)this.info).getDataInfo(), this.actualClassInfo, showPackage || this.dataPanel.dataPanelSettings.isShowPackages(), typeParams);
            }
        }
        if (actualType == null) {
            actualType = DataItem.makeType(this.data, this.actualClassInfo, showPackage || this.dataPanel.dataPanelSettings.isShowPackages());
        }
        return actualType;
    }

    public String getDeclaredType() {
        if (this.cachedDeclaredType == null && this.dataPanel.canUpdateData) {
            this.cachedDeclaredType = DataItem.makeType(null, this.declaredClassInfo, this.dataPanel.dataPanelSettings.isShowPackages(), this.info);
        }
        if (this.cachedDeclaredType != null) {
            return this.cachedDeclaredType;
        }
        return NOT_AVAILABLE;
    }

    public String getFullyQualifiedDeclaredType() {
        if (this.cachedFullyQualifiedDeclaredType == null && this.dataPanel.canUpdateData) {
            this.cachedFullyQualifiedDeclaredType = DataItem.makeType(null, this.declaredClassInfo, true, this.info);
        }
        if (this.cachedFullyQualifiedDeclaredType != null) {
            return this.cachedFullyQualifiedDeclaredType;
        }
        return NOT_AVAILABLE;
    }

    public String getValue() {
        return this.getValue(true, true);
    }

    String getValue(boolean useCached, boolean getExtendedValue) {
        return this.getValue(useCached, getExtendedValue, true);
    }

    String getValue(boolean useCached, boolean getExtendedValue, boolean addQuotes) {
        if (this.isNull()) {
            return "null";
        }
        if (!useCached) {
            String[] expressionUsed = new String[1];
            String[] reason = new String[1];
            String value = DataValueHelper.makeDataValue(this.info, this.data, new HashSet(), expressionUsed, getExtendedValue, addQuotes, reason);
            this.reasonValueIsNotAvailable = reason[0];
            return value;
        }
        if (this.cachedValue == null && this.dataPanel.canUpdateData) {
            this.cachedValueExpressionUsed = null;
            if (this.displayValue != null) {
                this.cachedValue = this.displayValue;
            } else {
                String[] expressionUsed = new String[1];
                String[] error = new String[1];
                this.cachedValue = DataValueHelper.makeDataValue(this.info, this.data, new HashSet(), expressionUsed, getExtendedValue, addQuotes, error);
                if (expressionUsed[0] != null) {
                    this.cachedValueExpressionUsed = expressionUsed[0];
                }
                this.reasonValueIsNotAvailable = error[0];
            }
        }
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        return NOT_AVAILABLE;
    }

    DataItemAfterEvaluationCallback getDataItemAfterEvaluationCallback() {
        return this.callback;
    }

    boolean isNull() {
        boolean verbose = false;
        if (this.data == null) {
            if (this.info instanceof DebugClassInfo) {
                return ((DebugClassInfo)this.info).getClassObject() == null;
            }
            if (this.info instanceof EvaluatorDataItem || this.info instanceof CommonEvaluationInfoBase) {
                return false;
            }
            if (verbose) {
                JDebugger.logger.trace("DataItem.isNull(): " + this.getDisplayName() + " data=null, info=" + this.info);
            }
            if (verbose) {
                JDebugger.logger.trace("                   suspected null but unsure so isNull returns false");
            }
            return false;
        }
        if (this.data instanceof DebugDataPrimitiveInfo) {
            return false;
        }
        if (this.data instanceof DebugDataCompositeInfo) {
            try {
                return ((DebugDataCompositeInfo)this.data).isNullNoThrow();
            }
            catch (DataExpiredException dee) {
                if (verbose) {
                    JDebugger.logger.trace(this.getDisplayName() + " had DataExpiredException on isNull call");
                }
                return false;
            }
        }
        if (verbose) {
            JDebugger.logger.trace(this.getDisplayName() + " no handler for " + this.data);
        }
        return false;
    }

    String getValueExpressionUsed() {
        return this.cachedValueExpressionUsed;
    }

    public String getHexValue() {
        if (this.cachedHexValue == null && this.dataPanel.canUpdateData) {
            this.cachedHexValue = DataItem.makeHexValue(this.info, this.data);
        }
        if (this.cachedHexValue != null) {
            return this.cachedHexValue;
        }
        return NOT_AVAILABLE;
    }

    public String getAddress() {
        if (this.cachedAddress == null && this.dataPanel.canUpdateData) {
            this.cachedAddress = NOT_AVAILABLE;
            long address = this.getAddressOfObject();
            if (address != 0L) {
                this.cachedAddress = "0x" + Long.toHexString(address).toUpperCase();
            }
        }
        if (this.cachedAddress != null) {
            return this.cachedAddress;
        }
        return NOT_AVAILABLE;
    }

    public String getID() {
        if (this.cachedID == null && this.dataPanel.canUpdateData) {
            long id;
            this.cachedID = NOT_AVAILABLE;
            if (this.data instanceof DebugDataCompositeInfo && (id = ((DebugDataCompositeInfo)this.data).getUniqueID()) != 0L) {
                this.cachedID = Long.toString(id);
            }
        }
        if (this.cachedID != null) {
            return this.cachedID;
        }
        return NOT_AVAILABLE;
    }

    public String getInstanceCount() {
        if (this.cachedInstanceCount > 0L) {
            return NOT_AVAILABLE + this.cachedInstanceCount;
        }
        return NOT_AVAILABLE;
    }

    public void setInstanceCount(long count) {
        this.cachedInstanceCount = count;
    }

    public Iterator<DataItem> getLazyChildren() {
        DataItem[] currentChildren = this.children;
        if (currentChildren != null) {
            ArrayList<DataItem> childList = new ArrayList<DataItem>(currentChildren.length);
            for (DataItem child : currentChildren) {
                childList.add(child);
            }
            return childList.iterator();
        }
        return Arrays.asList(new DataItem[0]).iterator();
    }

    int countChildNodes() {
        return this.getChildNodes(false).length;
    }

    DataItem[] getChildNodes(boolean skipExpandedCheck) {
        if (this.hasExpired()) {
            return new DataItem[0];
        }
        if (this.children == null) {
            if (!skipExpandedCheck && this.parentDataItem != null && !this.parentDataItem.isExpanded) {
                return new DataItem[0];
            }
            if (this.data instanceof DebugDataObjectInfo) {
                this.children = this.makeDataItemsForObject(this, (DebugDataObjectInfo)this.data);
            } else if (this.data instanceof DebugDataArrayInfo) {
                this.children = this.makeDataItemsForArray(this, (DebugDataArrayInfo)this.data, this.arrayRange);
            } else if (this.info instanceof DebugClassInfo) {
                this.children = this.makeDataItemsForClass((DebugClassInfo)this.info);
            } else if (this.info instanceof DebugHeapSubset) {
                this.children = new DataItem[0];
            } else if (this.info instanceof DebugHeapInfo) {
                this.children = this.makeDataItemsForHeapInfo(this, (DebugHeapInfo)this.info);
            } else if (this.info instanceof DebugHeapAncestor) {
                this.children = this.makeDataItemsForHeapAncestor(this, (DebugHeapAncestor)this.info);
            } else if (this.info instanceof DebugAnnotationInfo) {
                this.children = this.makeDataItemsForAnnotation((DebugAnnotationInfo)this.info);
            }
            if (this.children == null) {
                this.children = new DataItem[0];
            }
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].parentDataItem = this;
            }
        }
        return this.children;
    }

    public DataItem getField(String name) {
        DebugFieldInfo field;
        if (this.data instanceof DebugDataObjectInfo && (field = ((DebugDataObjectInfo)this.data).getField(name)) != null) {
            return new DataItem(this.dataPanel, field);
        }
        return null;
    }

    public List<DataItem> getFields() {
        if (this.cachedFields == null) {
            this.cachedFields = this.getFields(-1);
        }
        return this.cachedFields;
    }

    public List<DataItem> getDeclaredFields() {
        if (this.cachedDeclaredFields == null) {
            this.cachedDeclaredFields = this.getFields(0);
        }
        return this.cachedDeclaredFields;
    }

    private List<DataItem> getFields(int level) {
        if (this.data instanceof DebugDataObjectInfo) {
            DebugFieldInfo[] fields = ((DebugDataObjectInfo)this.data).getFields(level);
            ArrayList<DataItem> list = new ArrayList<DataItem>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                list.add(new DataItem(this.dataPanel, fields[i]));
            }
            return list;
        }
        return null;
    }

    void clearChildren(TreePath treePath) {
        if (this.dataPanel.getModel() != null) {
            this.dataPanel.saveSelection();
            this.children = null;
            this.dataPanel.getModel().fireChanged(treePath);
            this.dataPanel.restoreSelection(false);
        } else {
            this.children = null;
        }
    }

    public boolean canViewWhole() {
        if (this.canUseToStringForValue() == 1 || "toString()".equals(this.cachedValueExpressionUsed)) {
            return true;
        }
        return this.data instanceof DebugDataCompositeInfo && ((DebugDataCompositeInfo)this.data).canGetWholeThing();
    }

    public void viewWhole() {
        String dlgTitle = DbgArb.getString(303);
        if (this.canUseToStringForValue() == 1 || "toString()".equals(this.cachedValueExpressionUsed)) {
            MemoViewDialog.showMemoViewDialog(dlgTitle, this.getValue());
        } else if (this.data instanceof DebugDataCompositeInfo) {
            DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
            MemoViewDialog.showMemoViewDialog(dlgTitle, this.getActualType(), this.getDisplayName(), dci);
        }
    }

    int canUseToStringForValue() {
        if (this.data instanceof DebugDataObjectInfo) {
            DebugDataObjectInfo debugDataObjectInfo = (DebugDataObjectInfo)this.data;
            DebugClassInfo clazz = debugDataObjectInfo.getClassInfo();
            if ("java.lang.String".equals(clazz.getName()) || "java.lang.StringBuffer".equals(clazz.getName()) || "java.lang.StringBuilder".equals(clazz.getName())) {
                return -1;
            }
            ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();
            DataValueToStringBehavior toStringBehavior = objectPreferences.getUseToStringBehavior(clazz.getName());
            if (toStringBehavior.useToStringAlways()) {
                return 1;
            }
            if (toStringBehavior.useExpressionAlways()) {
                return 0;
            }
            String expression = objectPreferences.getValueExpression(clazz, debugDataObjectInfo);
            if (expression == null || expression.length() <= 0) {
                return 0;
            }
            if ("toString()".equals(expression)) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    void toggleUseToString() {
        String className;
        DebugClassInfo clazz;
        if (this.data instanceof DebugDataObjectInfo && (clazz = this.data.getClassInfo()) != null && (className = clazz.getName()) != null) {
            int state = this.canUseToStringForValue();
            switch (state) {
                case 0: {
                    ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();
                    DataValueToStringBehavior behavior = objectPreferences.getUseToStringBehavior(className);
                    behavior.setUseToString(true);
                    behavior.setUseToStringOnlyWhenNoExpressionSpecified(false);
                    behavior.setUseToStringOnlyWhenOverridden(false);
                    objectPreferences.setUseToStringBehavior(className, behavior);
                    break;
                }
                case 1: {
                    ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();
                    DataValueToStringBehavior behavior = objectPreferences.getUseToStringBehavior(className);
                    behavior.setUseToString(false);
                    objectPreferences.setUseToStringBehavior(className, behavior);
                }
            }
            this.cachedValue = null;
            this.cachedValueExpressionUsed = null;
            JDebugger.getInstance().dataHasBeenModified();
        }
    }

    boolean canAdjustObjectPreferences() {
        return this.data instanceof DebugDataObjectInfo && this.actualClassInfo != null;
    }

    public String canViewAnnotations() {
        if (this.info instanceof DebugHasAnnotations && ((DebugHasAnnotations)this.info).countAnnotations() > 0) {
            if (this.info instanceof DebugFieldInfo) {
                return DbgArb.getString(264);
            }
            if (this.info instanceof DebugVariableInfo) {
                return DbgArb.getString(265);
            }
        }
        return null;
    }

    public void viewAnnotations(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if ((this.info instanceof DebugFieldInfo || this.info instanceof DebugVariableInfo) && this.info instanceof DebugHasAnnotations) {
            DebugAnnotationInfo[] annotations = ((DebugHasAnnotations)this.info).getAnnotations();
            String type = this.getDeclaredType();
            String name = this.getDisplayName();
            String dlgTitle = this.info instanceof DebugFieldInfo ? DbgArb.format(813, type, name) : DbgArb.format(816, type, name);
            DataController.showAnnotationsDialog(dlgTitle, this.dataPanel.dataPanelSettings, debuggingProcess, vm, thread, frame, annotations);
        }
    }

    public boolean canViewAnnotationsForClass() {
        return this.actualClassInfo instanceof DebugHasAnnotations && ((DebugHasAnnotations)((Object)this.actualClassInfo)).countAnnotations() > 0;
    }

    public void viewAnnotationsForClass(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        if (this.actualClassInfo instanceof DebugHasAnnotations) {
            DebugAnnotationInfo[] annotations = ((DebugHasAnnotations)((Object)this.actualClassInfo)).getAnnotations();
            String className = this.actualClassInfo.getName();
            String dlgTitle = DbgArb.format(814, className);
            DataController.showAnnotationsDialog(dlgTitle, this.dataPanel.dataPanelSettings, debuggingProcess, vm, thread, frame, annotations);
        }
    }

    public boolean canAdjustRange() {
        return this.ancestorHeapInfo == null && this.arrayRange != null;
    }

    int numberOfCachedChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    boolean isEmpty() {
        return this.arrayRange.getCount() == 0;
    }

    public void adjustRange(TreePath treePath) {
        DebugDataArrayInfo array = this.arrayRange.getArray();
        int start = array.getArrayStart();
        int count = array.getArrayCount();
        AdjustRangeDialog dialog = AdjustRangeDialog.showAdjustRangeDialog(this.getActualType(), this.getDisplayName(), start, count, this.arrayRange.getStart(), this.arrayRange.getCount());
        if (dialog != null) {
            this.arrayRange.setStart(dialog.getStart());
            this.arrayRange.setCount(dialog.getCount());
            this.dataPanel.getModel().addArrayRange(this.arrayRange);
            this.clearChildren(treePath);
        }
    }

    public boolean adjustRange(TreePath treePath, int start, int count) {
        if (this.arrayRange == null) {
            return false;
        }
        if (start + count > this.arrayRange.getLength()) {
            return false;
        }
        this.arrayRange.setStart(start);
        this.arrayRange.setCount(count);
        this.dataPanel.getModel().addArrayRange(this.arrayRange);
        this.clearChildren(treePath);
        return true;
    }

    public int getRangeStart() {
        return this.arrayRange == null ? -1 : this.arrayRange.getStart();
    }

    public int getRangeCount() {
        return this.arrayRange == null ? -1 : this.arrayRange.getCount();
    }

    public int getRangeLength() {
        return this.arrayRange == null ? -1 : this.arrayRange.getLength();
    }

    boolean shouldShowArrayNavigationButtons() {
        if (this.isExpanded && this.canAdjustRange()) {
            return this.arrayRange.getLength() > this.arrayRange.getCount();
        }
        return false;
    }

    boolean canAdjustRangePrevious() {
        if (!this.canAdjustRange() || this.arrayRange.getStart() == 0) {
            return false;
        }
        if (this.dataPanel.dataPanelSettings.isHideNullArrayElements()) {
            DebugArrayElementInfo[] elements = this.arrayRange.getArray().getArrayElements(0, 1, true);
            if (elements.length == 0) {
                return false;
            }
            return elements[0].getIndex() < this.arrayRange.getStart();
        }
        return true;
    }

    boolean canAdjustRangeNext(boolean optimizeBySkippingScan) {
        if (this.canAdjustRange()) {
            if (this.arrayRange.getScanStatusAboveRange() == DataArrayRange.ScanStatus.AT_END) {
                return false;
            }
            if (this.arrayRange.getScanStatusAboveRange() == DataArrayRange.ScanStatus.HAS_MORE) {
                return true;
            }
            if (this.dataPanel.dataPanelSettings.isHideNullArrayElements() && !optimizeBySkippingScan) {
                int scanStart = this.arrayRange.getEnd() + 1;
                if (this.arrayRange.getStart() > this.arrayRange.getEnd()) {
                    scanStart = this.arrayRange.getStart() + 1;
                }
                try {
                    for (int i = scanStart; i < this.arrayRange.getLength(); ++i) {
                        if (this.arrayRange.getArray().getArrayElements(i, 1, true).length <= 0) continue;
                        this.arrayRange.setScanStatusAboveRange(DataArrayRange.ScanStatus.HAS_MORE);
                        return true;
                    }
                }
                catch (ObjectCollectedException oce) {
                    JDebugger.logger.trace("ERROR: ObjectCollectedException scanning array to enable pagination");
                }
                this.arrayRange.setScanStatusAboveRange(DataArrayRange.ScanStatus.AT_END);
                return false;
            }
            this.arrayRange.setScanStatusAboveRange(DataArrayRange.ScanStatus.NOT_SCANNED);
            return this.arrayRange.getStart() + this.arrayRange.getCount() < this.arrayRange.getLength();
        }
        return false;
    }

    boolean canAdjustRangeFirst() {
        return this.canAdjustRangePrevious();
    }

    boolean canAdjustRangeLast(boolean optimize) {
        return this.canAdjustRangeNext(optimize);
    }

    void adjustRangeFirst(TreePath treePath) {
        if (this.canAdjustRange() && treePath != null) {
            this.arrayRange.setStart(0);
            this.arrayRange.setDirection(DataArrayRange.Direction.FORWARD);
            this.dataPanel.getModel().addArrayRange(this.arrayRange);
            this.clearChildren(treePath);
        }
    }

    void adjustRangeLast(TreePath treePath) {
        if (this.canAdjustRange() && treePath != null) {
            DebugDataArrayInfo array = this.arrayRange.getArray();
            this.arrayRange.setEnd(array.getArrayCount() - 1);
            this.arrayRange.setDirection(DataArrayRange.Direction.BACKWARD);
            this.dataPanel.getModel().addArrayRange(this.arrayRange);
            this.clearChildren(treePath);
        }
    }

    void adjustRangePrevious(TreePath treePath) {
        if (this.canAdjustRange() && treePath != null) {
            int end = this.arrayRange.getStart() - 1;
            if (end < 0) {
                end = 0;
            }
            this.arrayRange.setEnd(end);
            this.arrayRange.setDirection(DataArrayRange.Direction.BACKWARD);
            this.dataPanel.getModel().addArrayRange(this.arrayRange);
            this.clearChildren(treePath);
        }
    }

    void adjustRangeNext(TreePath treePath) {
        if (this.canAdjustRange()) {
            if (this.arrayRange.getScanStatusAboveRange() == DataArrayRange.ScanStatus.NOT_SCANNED) {
                this.canAdjustRangeNext(false);
                if (this.arrayRange.getScanStatusAboveRange() == DataArrayRange.ScanStatus.AT_END) {
                    this.dataPanel.getModel().fireChanged();
                    return;
                }
            }
            if (treePath != null) {
                DebugDataArrayInfo array = this.arrayRange.getArray();
                int start = -1;
                start = this.arrayRange.getEnd() != -1 ? this.arrayRange.getEnd() + 1 : this.arrayRange.getStart() + this.arrayRange.getCount();
                if (start + this.arrayRange.getCount() > array.getArrayCount()) {
                    start = array.getArrayCount() - this.arrayRange.getCount();
                }
                this.arrayRange.setStart(start);
                this.arrayRange.setDirection(DataArrayRange.Direction.FORWARD);
                this.dataPanel.getModel().addArrayRange(this.arrayRange);
                this.clearChildren(treePath);
            }
        }
    }

    public boolean canToggleValue() {
        return this.data != null && this.actualClassInfo.isPrimitive() && this.actualClassInfo.getName().equals("boolean") && this.data.canModifyDataWithString();
    }

    public void toggleValue() {
        String currentValue = this.getValue();
        String newValue = Boolean.valueOf(Boolean.valueOf(currentValue) == false).toString();
        if (ModifyValueDialog.toggleValue(this.data, newValue)) {
            JDebugger.getInstance().dataHasBeenModified();
        }
    }

    public boolean canModifyValue() {
        if (!this.canToggleValue() && this.data != null) {
            boolean canModifyDataWithString = this.data.canModifyDataWithString();
            boolean canSetAddressOfObject = false;
            boolean canSetAddressOfObjectToNull = false;
            if (this.data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
                canSetAddressOfObject = dci.canSetAddressOfObject();
                canSetAddressOfObjectToNull = dci.canSetAddressOfObjectToNull();
            }
            if (canModifyDataWithString || canSetAddressOfObject || canSetAddressOfObjectToNull) {
                return true;
            }
        }
        return false;
    }

    public void modifyValue(DebugVirtualMachine vm) {
        if (this.data != null) {
            boolean canModifyDataWithString = this.data.canModifyDataWithString();
            boolean canSetAddressOfObject = false;
            boolean canSetAddressOfObjectToNull = false;
            if (this.data instanceof DebugDataCompositeInfo) {
                DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
                canSetAddressOfObject = dci.canSetAddressOfObject();
                canSetAddressOfObjectToNull = dci.canSetAddressOfObjectToNull();
            }
            if (canModifyDataWithString || canSetAddressOfObject || canSetAddressOfObjectToNull) {
                String hex;
                Object currentValue = this.getValue(false, false, false);
                if (this.dataPanel.getColumnByModelIndex(4) != null && (hex = this.getHexValue()) != null && hex.length() > 0) {
                    currentValue = (String)currentValue + "    " + hex;
                }
                String currentAddress = null;
                if (vm != null && vm.getCapabilities().canGetAddresses()) {
                    currentAddress = this.getAddress();
                }
                boolean ok = false;
                ok = !canModifyDataWithString && !canSetAddressOfObject && canSetAddressOfObjectToNull ? UnmodifiableObjectDialog.showUnmodifiableObjectDialog(this.getDeclaredType(), this.getDisplayName(), (String)currentValue, currentAddress, this.actualClassInfo, this.data) : ModifyValueDialog.showModifyValueDialog(this.getDeclaredType(), this.getDisplayName(), (String)currentValue, currentAddress, this.actualClassInfo, this.data, canModifyDataWithString, canSetAddressOfObject, canSetAddressOfObjectToNull);
                if (ok) {
                    JDebugger.getInstance().dataHasBeenModified();
                }
            }
        }
    }

    DataFlavor[] canDrag(TreePath treePath) {
        ArrayList<DataFlavor> temp = new ArrayList<DataFlavor>();
        if (this.canWatchAndInspect(treePath)) {
            temp.add(DataItem.getExpressionFlavor());
        }
        if (this.getAddressOfObject() != 0L) {
            temp.add(DataItem.getHeapObjectFlavor());
        }
        if (temp.size() > 0) {
            temp.add(DataFlavor.stringFlavor);
            transferFlavors = temp.toArray(new DataFlavor[temp.size()]);
            return transferFlavors;
        }
        return null;
    }

    boolean canDiagram(TreePath treePath) {
        return this.data instanceof DebugDataCompositeInfo;
    }

    public boolean canWatchAndInspect(TreePath treePath) {
        if (this.data == null && this.info instanceof DebugVariableInfo) {
            return false;
        }
        return this.makeExpression(treePath) != null;
    }

    private String makeNameToolTip(TreePath treePath) {
        if (treePath != null) {
            Object expression = NOT_AVAILABLE;
            Object[] path = treePath.getPath();
            int pathLength = path.length;
            for (int i = 0; i < pathLength; ++i) {
                Object node = path[i];
                if (!(node instanceof DataItem)) continue;
                DataItem dataItem = (DataItem)node;
                Object dataItemInfo = dataItem.getInfo();
                if (dataItemInfo instanceof DebugVariableInfo || dataItemInfo instanceof DebugStackSlotInfo) {
                    expression = (String)expression + dataItem.getExpressionPart();
                    continue;
                }
                if (dataItemInfo instanceof DebugClassInfo) {
                    expression = (String)expression + DebugShared.makeCourtesyClassName((DebugClassInfo)dataItemInfo, true);
                    continue;
                }
                if (dataItemInfo instanceof DebugArrayElementInfo) {
                    if (this.displayNameOverridden) {
                        expression = (String)expression + dataItem.getDisplayName();
                        continue;
                    }
                    expression = (String)expression + dataItem.getExpressionPart();
                    continue;
                }
                if (dataItemInfo instanceof DebugFieldInfo) {
                    if (((String)expression).length() > 0) {
                        expression = (String)expression + ".";
                    }
                    if (this.displayNameOverridden) {
                        expression = (String)expression + dataItem.getDisplayName();
                        continue;
                    }
                    expression = (String)expression + dataItem.getExpressionPart();
                    continue;
                }
                if (dataItemInfo instanceof DebugDataInfo) {
                    String s = dataItem.getExpressionPart();
                    if (s != null) {
                        expression = (String)expression + s;
                        continue;
                    }
                    return null;
                }
                if (dataItemInfo instanceof CommonEvaluationInfoBase) {
                    if (pathLength != 2 || i != 1) continue;
                    expression = dataItem.getExpressionPart();
                    continue;
                }
                return null;
            }
            if (expression != null && ((String)expression).length() > 0) {
                return expression;
            }
        }
        return null;
    }

    private Expression makeExpression(TreePath treePath) {
        if (this.expressionSaved == null && treePath != null) {
            Expression expression = new Expression(NOT_AVAILABLE);
            Object[] path = treePath.getPath();
            int pathLength = path.length;
            for (int i = 0; i < pathLength; ++i) {
                DataItem dataItem;
                Object node = path[i];
                if (!(node instanceof DataItem) || (dataItem = (DataItem)node).prepareExpression(path, i, expression)) continue;
                return null;
            }
            if (expression != null && expression.getExpression().length() > 0) {
                this.expressionSaved = expression;
            }
        }
        return this.expressionSaved;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean prepareExpression(Object[] path, int i, Expression expression) {
        String exp = expression.getExpression();
        String name = expression.getName();
        Object add = null;
        String addName = null;
        if (this.info instanceof DebugVariableInfo || this.info instanceof DebugStackSlotInfo || this.info instanceof DebugArrayElementInfo) {
            add = this.getExpressionPart();
        } else if (this.info instanceof DebugClassInfo) {
            add = this.getExpressionPart();
            addName = DebugShared.makeCourtesyClassName((DebugClassInfo)this.info, true);
        } else if (this.info instanceof DebugDataInfo) {
            String s = this.getExpressionPart();
            if (s == null) return false;
            add = s;
        } else if (this.info instanceof DebugFieldInfo) {
            add = exp.length() > 0 ? "." + this.getExpressionPart() : this.getExpressionPart();
        } else {
            if (!(this.info instanceof CommonEvaluationInfoBase) && !(this.info instanceof EvaluatorItem) && !(this.info instanceof EvaluatorDataItem)) return false;
            if (path.length == 2 && i == 1) {
                add = this.getExpressionPart();
            }
        }
        if (add == null) return true;
        expression.setExpression(exp + (String)add);
        if (name != null) {
            if (addName != null) {
                expression.setName(name + addName);
                return true;
            } else {
                expression.setName(name + (String)add);
            }
            return true;
        } else {
            if (addName == null) return true;
            expression.setName(addName);
        }
        return true;
    }

    void watch(TreePath treePath) {
        this.watch(treePath, null);
    }

    public void watch(TreePath treePath, String displayName) {
        Expression expression = this.makeExpression(treePath);
        if (expression != null) {
            if (displayName != null) {
                expression.setName(displayName);
            }
            EvaluatorItem ei = new EvaluatorItem(expression);
            JDebugger.getInstance().addWatch(ei);
        }
    }

    void inspect(TreePath treePath) {
        this.inspect(treePath, null);
    }

    public void inspect(TreePath treePath, String displayName) {
        Expression expression = this.makeExpression(treePath);
        if (expression != null) {
            if (displayName != null) {
                expression.setName(displayName);
            }
            EvaluatorItem ei = new EvaluatorItem(expression);
            JDebugger.getInstance().inspect(ei);
        }
    }

    public boolean canWatchInspectClassLoader() {
        DebugDataObjectInfo classLoaderObject;
        DebugClassLoaderInfo classLoader;
        return this.actualClassInfo != null && (classLoader = this.actualClassInfo.getClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull();
    }

    public void watchClassLoader(DebuggingProcess debuggingProcess) {
        DebugDataObjectInfo classLoaderObject;
        DebugClassLoaderInfo classLoader;
        if (this.actualClassInfo != null && (classLoader = this.actualClassInfo.getClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
            String name = ClassesWindow.makeClassLoaderName(classLoader);
            EvaluatorItem ei = debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
            JDebugger.getInstance().addWatch(ei);
        }
    }

    public void inspectClassLoader(DebuggingProcess debuggingProcess) {
        DebugDataObjectInfo classLoaderObject;
        DebugClassLoaderInfo classLoader;
        if (this.actualClassInfo != null && (classLoader = this.actualClassInfo.getClassLoader()) != null && (classLoaderObject = classLoader.getClassLoaderObject()) != null && !classLoaderObject.isNull()) {
            String name = ClassesWindow.makeClassLoaderName(classLoader);
            EvaluatorItem ei = debuggingProcess.makeTemporaryEvaluatorItem(name, classLoaderObject);
            JDebugger.getInstance().inspect(ei);
        }
    }

    public String canShowSource(int cmdId) {
        String sourceFilename;
        DebugClassInfo clazz = null;
        String name = null;
        if (cmdId == this.dataPanel.getController()._GOTO_CMD_ID) {
            if (this.actualClassInfo != null) {
                clazz = this.actualClassInfo;
                name = DbgArb.format(284, this.getActualType());
            }
        } else if (cmdId == this.dataPanel.getController()._GOTO_DECLARED_CMD_ID) {
            if (this.dataPanel.getColumnByModelIndex(3) != null && this.declaredClassInfo != null && this.declaredClassInfo != this.actualClassInfo) {
                clazz = this.declaredClassInfo;
                name = DbgArb.format(287, this.getDeclaredType());
            }
        } else if (cmdId == this.dataPanel.getController()._GOTO_FIELD_CMD_ID) {
            DebugFieldInfo field = null;
            if (this.info instanceof DebugFieldInfo) {
                field = (DebugFieldInfo)this.info;
            } else if (this.info instanceof DebugHeapAncestorInStatic) {
                field = ((DebugHeapAncestorInStatic)this.info).getFieldInfo();
            }
            if (field != null) {
                clazz = field.getDeclaringClassInfo();
                String className = DataItem.makeType(null, clazz, this.dataPanel.dataPanelSettings.isShowPackages());
                name = DbgArb.format(290, className + "." + field.getName());
            }
        }
        if (clazz != null && (sourceFilename = clazz.getPrimarySourceFilename()) != null && sourceFilename.length() > 0) {
            return name;
        }
        return null;
    }

    public void showSource(int cmdId, DebuggingProcess debuggingProcess) {
        if (cmdId == this.dataPanel.getController()._GOTO_CMD_ID || cmdId == this.dataPanel.getController()._GOTO_DECLARED_CMD_ID) {
            DebugClassInfo clazz = null;
            if (cmdId == this.dataPanel.getController()._GOTO_CMD_ID) {
                clazz = this.actualClassInfo;
            } else if (cmdId == this.dataPanel.getController()._GOTO_DECLARED_CMD_ID) {
                clazz = this.declaredClassInfo;
            }
            if (clazz != null) {
                debuggingProcess.showSourceFile(clazz);
            }
        } else if (cmdId == this.dataPanel.getController()._GOTO_FIELD_CMD_ID) {
            DebugFieldInfo field = null;
            if (this.info instanceof DebugFieldInfo) {
                field = (DebugFieldInfo)this.info;
            } else if (this.info instanceof DebugHeapAncestorInStatic) {
                field = ((DebugHeapAncestorInStatic)this.info).getFieldInfo();
            }
            if (field != null) {
                debuggingProcess.showSourceFile(field);
            }
        }
    }

    long getAddressOfObject() {
        if (this.data instanceof DebugDataCompositeInfo) {
            DebugDataCompositeInfo dci = (DebugDataCompositeInfo)this.data;
            return dci.getAddressOfObject();
        }
        return 0L;
    }

    private String getEnumValueDisplayName(DebugDataInfo data) {
        if (data == null) {
            return this.displayValue;
        }
        DebugFieldInfo[] fields = this.actualClassInfo.getEnumConstants();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                DebugDataInfo ddi;
                if (fields[i] == null || (ddi = fields[i].getDataInfo()) == null || ddi.hashCode() != data.hashCode()) continue;
                return fields[i].getName();
            }
        }
        return this.displayValue;
    }

    private static String prepareDisplayName(Object info, String override, String def) {
        String courtesyName = DebugShared.makeCourtesyName(info);
        if (courtesyName != null) {
            return courtesyName;
        }
        if (override != null) {
            return override;
        }
        return def;
    }

    private boolean derivedFromThrowable(DebugDataObjectInfo dataObject) {
        for (DebugClassInfo clazz = dataObject.getClassInfo(); clazz != null; clazz = clazz.getSuperClass(1)) {
            if (!"java.lang.Exception".equals(clazz.getName()) && !"java.lang.Throwable".equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private List<DataItem> makeDataItemsForObjectExpandExpression(DebugDataObjectInfo dataObject, String expression) {
        try {
            ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
            EvaluatorProxy evaluator = DebugObjectFactory.create(EvaluatorProxy.class);
            evaluator.setAllowMethodInvocation(true);
            evaluator.setDebugContext(dataObject);
            String[] tokens = ObjectPreferences.tokenizeExpandExpression(expression);
            int tokensLength = tokens.length;
            for (int itoken = 0; itoken < tokensLength; ++itoken) {
                String token = tokens[itoken];
                DebugDataInfo data = EvaluatorProxy.getDataInfo(evaluator.evaluate(token));
                if (data == null) continue;
                Object expressionPartOverride = token.startsWith(".") ? token : (token.startsWith("this.") ? token.substring(4) : "." + token);
                if (data instanceof DebugDataArrayInfo && itoken == 0 && tokensLength == 1) {
                    DebugArrayElementInfo[] elements;
                    DebugClassInfo clazz;
                    DebugDataArrayInfo arrayInfo = (DebugDataArrayInfo)data;
                    String key = dataObject.hashCode() + token;
                    this.arrayRange = this.dataPanel.getModel().getArrayRange(this.dataPanel.getDebuggingProcess(), arrayInfo, key);
                    boolean nonNullOnly = false;
                    if (this.dataPanel.dataPanelSettings.isHideNullArrayElements() && (clazz = arrayInfo.getArrayElementClassInfo()) != null && !clazz.isPrimitive()) {
                        nonNullOnly = true;
                    }
                    if (this.arrayRange.getDirection() == DataArrayRange.Direction.FORWARD) {
                        elements = arrayInfo.getArrayElements(this.arrayRange.getStart(), this.arrayRange.getCount(), nonNullOnly);
                        if (elements.length == 0) {
                            this.arrayRange.setEnd(-1);
                        } else {
                            this.arrayRange.setStart(elements[0].getIndex());
                            this.arrayRange.setEnd(elements[elements.length - 1].getIndex());
                        }
                    } else {
                        elements = arrayInfo.getPreviousArrayElements(this.arrayRange.getEnd(), this.arrayRange.getCount(), nonNullOnly);
                        if (elements.length == 0) {
                            this.arrayRange.setStart(-1);
                        } else {
                            this.arrayRange.setStart(elements[0].getIndex());
                            this.arrayRange.setEnd(elements[elements.length - 1].getIndex());
                        }
                    }
                    for (DebugArrayElementInfo arrayElement : elements) {
                        String displayNameOverride = "[" + arrayElement.getIndex() + "]";
                        DataItem dataItem = new DataItem(this.dataPanel, arrayElement, displayNameOverride, (String)expressionPartOverride + displayNameOverride);
                        dataItems.add(dataItem);
                    }
                    continue;
                }
                String displayNameOverride = token;
                dataItems.add(new DataItem(this.dataPanel, data, displayNameOverride, (String)expressionPartOverride));
            }
            return dataItems;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<DataItem> makeDataItemsForObjectFields(DebugDataObjectInfo dataObject, Set<String> typesWhereAllFieldsShouldBeHidden) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        DebugFieldInfo[] fields = dataObject.getFields(-1, this.dataPanel.dataPanelSettings.isHideFinalFields(), this.dataPanel.dataPanelSettings.isHideStaticFields());
        if (this.dataPanel.dataPanelSettings.isSortFieldsByName(this.dataPanel.getController().getVm().getID())) {
            Arrays.sort(fields, DataItem.getComparatorForFields());
        }
        int fieldsLength = fields.length;
        ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();
        for (int i = 0; i < fieldsLength; ++i) {
            String fieldName;
            List<String> hiddenFields;
            DebugFieldInfo field = fields[i];
            String className = field.getDeclaringClassInfo().getName();
            if (typesWhereAllFieldsShouldBeHidden.contains(className) || this.dataPanel.useFilters && (hiddenFields = objectPreferences.getHiddenFields(className)) != null && hiddenFields.contains(fieldName = field.getName()) || this.shouldSkipField(field)) continue;
            dataItems.add(new DataItem(this.dataPanel, field));
        }
        return dataItems;
    }

    private DataItem[] makeDataItemsForArray(DataItem parent, DebugDataArrayInfo array, DataArrayRange arrayRange) {
        DebugArrayElementInfo[] elements;
        DebugClassInfo clazz;
        if (parent.ancestorHeapInfo != null) {
            DebugClassInfo clazz2;
            DebugHeapInfo heap = parent.ancestorHeapInfo;
            boolean nonNullOnly = false;
            if (this.dataPanel.dataPanelSettings.isHideUnrelated()) {
                nonNullOnly = true;
            } else if (this.dataPanel.dataPanelSettings.isHideNullArrayElements() && (clazz2 = array.getArrayElementClassInfo()) != null && !clazz2.isPrimitive()) {
                nonNullOnly = true;
            }
            DebugArrayElementInfo[] arrayElements = array.getArrayElements(array.getArrayStart(), -1, nonNullOnly);
            int length = arrayElements.length;
            int[] depths = new int[length];
            Arrays.fill(depths, -1);
            int shortestDepth = -1;
            for (int i = 0; i < length; ++i) {
                int depth;
                DebugArrayElementInfo arrayElement = arrayElements[i];
                DebugDataInfo data = arrayElement.getDataInfo();
                if (!(data instanceof DebugDataCompositeInfo) || 0 > (depth = (depths[i] = heap.getDepth((DebugDataCompositeInfo)data))) || shortestDepth != -1 && depth >= shortestDepth) continue;
                shortestDepth = depth;
            }
            ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
            for (int i = 0; i < length; ++i) {
                int depth = depths[i];
                if (this.dataPanel.dataPanelSettings.isHideUnrelated() && depth < 0) continue;
                dataItems.add(new DataItem(this.dataPanel, arrayElements[i], null, heap, depth, depth == shortestDepth));
            }
            return dataItems.toArray(new DataItem[dataItems.size()]);
        }
        boolean nonNullOnly = false;
        if (this.dataPanel.dataPanelSettings.isHideNullArrayElements() && (clazz = array.getArrayElementClassInfo()) != null && !clazz.isPrimitive()) {
            nonNullOnly = true;
        }
        ArrayList<DebugArrayElementInfo> arrayElements = new ArrayList<DebugArrayElementInfo>();
        if (arrayRange.getDirection() == DataArrayRange.Direction.FORWARD) {
            elements = array.getArrayElements(arrayRange.getStart(), arrayRange.getCount(), nonNullOnly);
            if (elements.length == 0) {
                arrayRange.setEnd(-1);
            } else {
                arrayRange.setStart(elements[0].getIndex());
                arrayRange.setEnd(elements[elements.length - 1].getIndex());
            }
        } else {
            elements = array.getPreviousArrayElements(arrayRange.getEnd(), arrayRange.getCount(), nonNullOnly);
            if (elements.length == 0) {
                arrayRange.setStart(-1);
            } else {
                arrayRange.setStart(elements[0].getIndex());
                arrayRange.setEnd(elements[elements.length - 1].getIndex());
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            arrayElements.add(elements[i]);
        }
        int length = arrayElements.size();
        DataItem[] dataItems = new DataItem[length];
        for (int i = 0; i < length; ++i) {
            dataItems[i] = new DataItem(this.dataPanel, arrayElements.get(i));
        }
        return dataItems;
    }

    private DataItem[] makeDataItemsForClass(DebugClassInfo clazz) {
        DebugFieldInfo[] fields = clazz.getStaticFields(-1, this.dataPanel.dataPanelSettings.isHideFinalFields());
        if (this.dataPanel.dataPanelSettings.isSortFieldsByName(this.dataPanel.getController().getVm().getID())) {
            Arrays.sort(fields, DataItem.getComparatorForFields());
        }
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        int fieldsLength = fields.length;
        for (int i = 0; i < fieldsLength; ++i) {
            DebugFieldInfo field = fields[i];
            if (this.shouldSkipField(field)) continue;
            dataItems.add(new DataItem(this.dataPanel, fields[i]));
        }
        return dataItems.toArray(new DataItem[dataItems.size()]);
    }

    private DataItem[] makeDataItemsForHeapAncestor(DataItem parent, DebugHeapAncestor ancestor) {
        DebugHeapInfo heap = parent.ancestorHeapInfo;
        DebugDataCompositeInfo data = ancestor.getDataInfo();
        if (data != null) {
            DebugHeapAncestorInStatic ancestorInStatic;
            DebugFieldInfo field;
            long address = data.getAddressOfObject();
            Object name = "@" + Long.toHexString(address).toUpperCase();
            if (ancestor instanceof DebugHeapAncestorInStack) {
                DebugHeapAncestorInStack ancestorInStack = (DebugHeapAncestorInStack)ancestor;
                DebugVariableInfo var = ancestorInStack.getVariableInfo();
                if (var != null) {
                    name = var.getName();
                }
            } else if (ancestor instanceof DebugHeapAncestorInStatic && (field = (ancestorInStatic = (DebugHeapAncestorInStatic)ancestor).getFieldInfo()) != null) {
                name = field.getName();
            }
            int depth = heap.getDepth(data);
            DataItem[] dataItems = new DataItem[]{new DataItem(this.dataPanel, data, (String)name, heap, depth, true)};
            return dataItems;
        }
        return new DataItem[0];
    }

    private DataItem[] makeDataItemsForAnnotation(DebugAnnotationInfo annotation) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        Map<String, DebugDataInfo> properties = annotation.getProperties();
        for (Map.Entry<String, DebugDataInfo> entry : properties.entrySet()) {
            String name = entry.getKey();
            DebugDataInfo propertyData = entry.getValue();
            dataItems.add(new DataItem(this.dataPanel, propertyData, name, null));
        }
        return dataItems.toArray(new DataItem[dataItems.size()]);
    }

    private DataItem[] makeDataItemsForObject(DataItem parent, DebugDataObjectInfo dataObject) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        if (parent.ancestorHeapInfo != null) {
            int i;
            DebugHeapInfo heap = parent.ancestorHeapInfo;
            DebugFieldInfo[] fields = dataObject.getFields(-1, false, true);
            if (this.dataPanel.dataPanelSettings.isSortFieldsByName(this.dataPanel.getController().getVm().getID())) {
                Arrays.sort(fields, DataItem.getComparatorForFields());
            }
            int length = fields.length;
            int[] depths = new int[length];
            Arrays.fill(depths, -1);
            int shortestDepth = -1;
            for (i = 0; i < length; ++i) {
                int depth;
                DebugFieldInfo field = fields[i];
                DebugDataInfo data = field.getDataInfo();
                if (!(data instanceof DebugDataCompositeInfo) || 0 > (depth = (depths[i] = heap.getDepth((DebugDataCompositeInfo)data))) || shortestDepth != -1 && depth >= shortestDepth) continue;
                shortestDepth = depth;
            }
            for (i = 0; i < length; ++i) {
                int depth = depths[i];
                if (this.dataPanel.dataPanelSettings.isHideUnrelated() && depth < 0) continue;
                dataItems.add(new DataItem(this.dataPanel, fields[i], null, heap, depth, depth == shortestDepth));
            }
        } else {
            List<DataItem> dataItemsForFields;
            String doClassName;
            if (this.derivedFromThrowable(dataObject)) {
                EvaluatorProxy evaluator = DebugObjectFactory.create(EvaluatorProxy.class);
                evaluator.setAllowMethodInvocation(true);
                evaluator.setDebugContext(dataObject);
                evaluator.evaluate("getStackTrace()");
            }
            ObjectPreferences objectPreferences = JDebugger.getInstance().getObjectPreferences();
            List<String> expressions = objectPreferences.getExpandExpressions(dataObject);
            for (String expression : expressions) {
                List<DataItem> dataItemsForExpandExpression = this.makeDataItemsForObjectExpandExpression(dataObject, expression);
                if (dataItemsForExpandExpression == null) continue;
                dataItems.addAll(dataItemsForExpandExpression);
            }
            Set<String> typesWhereAllFieldsShouldBeHidden = objectPreferences.getTypesWhereAllFieldsShouldBeHidden(dataObject);
            String string = doClassName = dataObject.getClassInfo() != null ? dataObject.getClassInfo().getName() : null;
            if (!(doClassName != null && typesWhereAllFieldsShouldBeHidden.contains(doClassName) || (dataItemsForFields = this.makeDataItemsForObjectFields(dataObject, typesWhereAllFieldsShouldBeHidden)) == null)) {
                dataItems.addAll(dataItemsForFields);
            }
        }
        return dataItems.toArray(new DataItem[dataItems.size()]);
    }

    private DataItem[] makeDataItemsForHeapInfo(DataItem parent, DebugHeapInfo heap) {
        DebugHeapSubset subset = heap.getHeapSubset();
        if (subset instanceof DebugHeapSubsetClasses) {
            DebugHeapObjectInfo[] objects = heap.getHeapObjects(0, heap.countHeapObjects());
            int objectsLength = objects.length;
            DataItem[] dataItems = new DataItem[objectsLength];
            for (int i = 0; i < objectsLength; ++i) {
                DebugDataCompositeInfo info = objects[i].getDataInfo();
                long address = info.getAddressOfObject();
                if (address != 0L) {
                    String name = "@" + Long.toHexString(address).toUpperCase();
                    dataItems[i] = new DataItem(this.dataPanel, info, name, null);
                    continue;
                }
                dataItems[i] = new DataItem(this.dataPanel, info);
            }
            return dataItems;
        }
        if (subset instanceof DebugHeapSubsetAncestors) {
            DebugHeapAncestor[] insideHeap = this.dataPanel.dataPanelSettings.isShowOnlyRootAncestors() ? new DebugHeapAncestor[]{} : heap.getAncestorsInsideHeap();
            DebugHeapAncestorOutsideHeap[] outsideHeap = heap.getAncestorsOutsideHeap();
            int length = insideHeap.length + outsideHeap.length;
            DebugHeapAncestor[] ancestors = new DebugHeapAncestor[length];
            System.arraycopy(insideHeap, 0, ancestors, 0, insideHeap.length);
            System.arraycopy(outsideHeap, 0, ancestors, insideHeap.length, outsideHeap.length);
            if (length > 0) {
                Arrays.sort(ancestors, new Comparator<DebugHeapAncestor>(){

                    @Override
                    public int compare(DebugHeapAncestor a1, DebugHeapAncestor a2) {
                        return a1.getDepth() - a2.getDepth();
                    }
                });
                DataItem[] dataItems = new DataItem[length];
                for (int i = 0; i < length; ++i) {
                    DebugHeapAncestor ancestor = ancestors[i];
                    int depth = ancestor.getDepth();
                    dataItems[i] = new DataItem(this.dataPanel, ancestor, null, heap, depth, true);
                }
                return dataItems;
            }
        }
        return new DataItem[0];
    }

    private static Icon getArrayIconGray() {
        if (arrayIconGray == null) {
            arrayIconGray = IdeUtil.grayIcon((Icon)DataItem.getArrayIcon());
        }
        return arrayIconGray;
    }

    private static Icon getStaticFolderIcon() {
        if (staticFolderIcon == null) {
            staticFolderIcon = OracleIcons.getIcon((String)"debugger/staticfolder.gif");
        }
        return staticFolderIcon;
    }

    private static Icon getHeapFolderIcon() {
        if (heapFolderIcon == null) {
            heapFolderIcon = OracleIcons.getIcon((String)"debugger/staticfolder.gif");
        }
        return heapFolderIcon;
    }

    static Icon getPrimitiveIcon() {
        return OracleIcons.getIcon((String)"field.png");
    }

    private static Icon getPrimitiveIconGray() {
        if (primitiveIconGray == null) {
            primitiveIconGray = IdeUtil.grayIcon((Icon)DataItem.getPrimitiveIcon());
        }
        return primitiveIconGray;
    }

    static Icon getObjectIcon() {
        return OracleIcons.getIcon((String)"class.png");
    }

    private static Icon getObjectIconGray() {
        if (objectIconGray == null) {
            objectIconGray = IdeUtil.grayIcon((Icon)DataItem.getObjectIcon());
        }
        return objectIconGray;
    }

    static Icon getArrayIcon() {
        if (arrayIcon == null) {
            arrayIcon = OracleIcons.getIcon((String)"debugger/array.gif");
        }
        return arrayIcon;
    }

    protected static DataFlavor getExpressionFlavor() {
        if (expressionFlavor == null) {
            expressionFlavor = new DataFlavor(Expression.class, "Expression");
        }
        return expressionFlavor;
    }

    protected static DataFlavor getHeapObjectFlavor() {
        if (heapObjectFlavor == null) {
            heapObjectFlavor = new DataFlavor(DebugDataCompositeInfo.class, "HeapObject");
        }
        return heapObjectFlavor;
    }

    static Comparator<DebugFieldInfo> getComparatorForFields() {
        return new Comparator<DebugFieldInfo>(){

            @Override
            public int compare(DebugFieldInfo field1, DebugFieldInfo field2) {
                return field1.getName().compareToIgnoreCase(field2.getName());
            }
        };
    }

    protected boolean shouldSkipField(DebugFieldInfo field) {
        int access = field.getAccess();
        if ((access & 0x1000) != 0) {
            String name = field.getName();
            if (!(name.startsWith("this$") || name.startsWith("val$") || name.startsWith("v$"))) {
                return true;
            }
            return this.dataPanel.dataPanelSettings.isHideSyntheticFields();
        }
        return false;
    }

    static String makeHexValue(Object info, DebugDataInfo data) {
        if (data != null) {
            String hex = data.getHexValue();
            if (hex != null && hex.length() > 0) {
                return "0x" + hex.toUpperCase();
            }
        } else {
            if (info instanceof CommonEvaluationInfoBase) {
                return "0x" + ((CommonEvaluationInfoBase)info).getHexValue().toUpperCase();
            }
            if (info instanceof DebugVariableInfo) {
                return DbgArb.getString(256);
            }
            if (info instanceof DebugStackSlotInfo) {
                return "0x" + ((DebugStackSlotInfo)info).getHexValue().toUpperCase();
            }
        }
        return NOT_AVAILABLE;
    }

    static String makeType(DebugDataInfo data, boolean showPackage) {
        return DataItem.makeType(data, data.getClassInfo(), showPackage, null);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage) {
        return DataItem.makeType(data, clazz, showPackage, null, null);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, Object fieldOrVariable) {
        return DataItem.makeType(data, clazz, showPackage, fieldOrVariable, null);
    }

    static String makeType(DebugDataInfo data, boolean showPackage, String typeParams) {
        return DataItem.makeType(data, data.getClassInfo(), showPackage, typeParams);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, String typeParams) {
        return DataItem.makeType(data, clazz, showPackage, null, typeParams);
    }

    static String makeType(DebugDataInfo data, DebugClassInfo clazz, boolean showPackage, Object fieldOrVariable, String typeParams) {
        String t;
        if (clazz != null && (t = DebugShared.makeCourtesyType(data, clazz, showPackage, fieldOrVariable, typeParams)) != null) {
            return t;
        }
        return NOT_AVAILABLE;
    }

    static String makeDisplayName(Object info, boolean showPackage) {
        if (info instanceof DebugClassInfo) {
            DebugClassInfo clazz = (DebugClassInfo)info;
            String fullClassName = clazz.getName();
            int index = 257;
            if (fullClassName.startsWith("$Oracle.")) {
                if (fullClassName.startsWith("$Oracle.Package.")) {
                    index = 258;
                } else if (fullClassName.startsWith("$Oracle.PackageBody.")) {
                    index = 259;
                } else if (fullClassName.startsWith("$Oracle.Type.")) {
                    index = 259;
                } else if (fullClassName.startsWith("$Oracle.TypeBody.")) {
                    index = 259;
                }
            } else if (fullClassName.startsWith(CommonHelperFunctions.getXSLTPackage())) {
                index = 262;
            }
            String c = DebugShared.makeCourtesyClassName(clazz, showPackage);
            return DbgArb.format(index, c);
        }
        return NOT_AVAILABLE;
    }

    public void setIsExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    boolean isExpanded() {
        return this.isExpanded;
    }

    public String getReasonValueIsNotAvailable() {
        return this.reasonValueIsNotAvailable;
    }

    boolean canGuaranteeFastEvaluation() {
        if (this.cachedValue != null) {
            return !this.cachedValue.equals(LOADING_IN_BACKGROUND);
        }
        if (this.data == null || !(this.data instanceof DebugDataPrimitiveInfo) && this.getAddressOfObject() == 0L) {
            return true;
        }
        if (this.getDataInfo() instanceof DebugDataPrimitiveInfo) {
            return true;
        }
        return this.getDataInfo() instanceof DebugDataArrayInfo;
    }

    static {
        LOAD_VALUES_IN_BACKGROUND = true;
        TRACE_BACKGROUND_LOADS = true;
        LOADING_IN_BACKGROUND = DbgArb.getString(876);
        String load = System.getProperty("DataItem.loadValuesInBackground");
        String trace = System.getProperty("DataItem.traceBackgroundLoads");
        if (load != null) {
            if (load.toLowerCase().startsWith("yes") || load.toLowerCase().startsWith("true")) {
                JDebugger.logger.trace("DataItem: Background loads enabled via system property");
                LOAD_VALUES_IN_BACKGROUND = true;
            } else {
                JDebugger.logger.trace("DataItem: Background loads disabled via system property");
                LOAD_VALUES_IN_BACKGROUND = false;
            }
        }
        if (trace != null) {
            if (trace.toLowerCase().startsWith("yes") || trace.toLowerCase().startsWith("true")) {
                JDebugger.logger.trace("DataItem: Background load tracing enabled via system property");
                TRACE_BACKGROUND_LOADS = true;
            } else {
                JDebugger.logger.trace("DataItem: Background load tracing disabled via system property");
                TRACE_BACKGROUND_LOADS = false;
            }
        }
    }
}

