/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.DefaultRowSorter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.Toolbar;
import oracle.javatools.data.HashStructure;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModel;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsModelListener;
import oracle.javatools.ui.breadcrumbs.PopupHandler;
import oracle.javatools.ui.breadcrumbs.PopupItem;
import oracle.javatools.ui.breadcrumbs.PopupProvider;
import oracle.javatools.ui.builders.BreadcrumbsTableBuilder;
import oracle.javatools.ui.builders.BuiltBreadcrumbsTable;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.treetable.NodeTableModelAdapter;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.jdeveloper.debugger.support.DebuggerDataWindowOptions;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.DataArrayNavigationPanel;
import oracle.jdevimpl.runner.debug.DataBreadcrumbMaker;
import oracle.jdevimpl.runner.debug.DataBreadcrumbTableModel;
import oracle.jdevimpl.runner.debug.DataInfoPath;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataNameCellEditor;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.DataTable;
import oracle.jdevimpl.runner.debug.DataTableCellRenderer;
import oracle.jdevimpl.runner.debug.DataTableMouseAdapter;
import oracle.jdevimpl.runner.debug.DataTableSwitcher;
import oracle.jdevimpl.runner.debug.DataTableUtils;
import oracle.jdevimpl.runner.debug.DataTreeCellRenderer;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DataValueCellEditor;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.VersionedDataItem;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

final class DataBreadcrumbsTable
implements DataTable,
DataTableSwitcher.Switched {
    private BuiltBreadcrumbsTable builtTable;
    private JComponent gui;
    private DataBreadcrumbTableModel model;
    private SearchField searchField;
    private DataFilter filter = new DataFilter();
    private Map<DebuggingProcess, List<String>> expanded = Collections.synchronizedMap(new HashMap());
    private DataPanel dataPanel;
    private DataArrayNavigationPanel arrayNavigationPanel = new DataArrayNavigationPanel();
    private DataPanelSettings dataPanelSettings;
    private DebugVirtualMachine vm;
    private ColumnListener columnListener = new ColumnListener();
    private DataBreadcrumbMaker breadcrumbMaker;
    private boolean adjustColumnsAlreadyDone = false;

    DataBreadcrumbsTable(DataPanel dataPanel) {
        this.dataPanel = dataPanel;
        this.model = new DataBreadcrumbTableModel(dataPanel.getModel());
        BreadcrumbsTableBuilder builder = new BreadcrumbsTableBuilder();
        if (dataPanel.getWindowIdEnum() != null && "Debugger.MonitorsWindow".contains(dataPanel.getWindowIdEnum().name())) {
            builder.setShowColumnSelector(false);
        }
        builder.setModel((TreeTableModel)this.model);
        this.arrayNavigationPanel.setObjectPreferencesPermitted(false);
        builder.setTrailingComponent((JComponent)this.arrayNavigationPanel);
        this.breadcrumbMaker = new DataBreadcrumbMaker(dataPanel);
        builder.setBreadcrumbMaker((BreadcrumbsTableBuilder.BreadcrumbMaker)this.breadcrumbMaker);
        this.builtTable = builder.build();
        this.gui = this.createGUI(dataPanel);
        this.builtTable.addBreadcrumbsModelListener(new BreadcrumbsModelListener(){

            public void breadcrumbsUpdated() {
                DataBreadcrumbsTable.this.filter.setFilter("");
                DataBreadcrumbsTable.this.searchField.setText("", true);
                TreePath path = DataBreadcrumbsTable.this.builtTable.getBreadcrumbPath();
                DataItem dataItem = DataPanel.getDataItemForTreePath(path);
                if (dataItem != null) {
                    dataItem.setIsExpanded(true);
                }
                DataBreadcrumbsTable.this.arrayNavigationPanel.updatePanel(dataItem);
                DebuggingProcess dbg = DataBreadcrumbsTable.this.dataPanel.getDebuggingProcess();
                List<String> pathList = DataBreadcrumbsTable.this.expanded.get(dbg);
                if (pathList == null) {
                    pathList = new ArrayList<String>();
                    DataBreadcrumbsTable.this.expanded.put(dbg, pathList);
                } else {
                    pathList.clear();
                }
                while (path != null) {
                    Object object = path.getLastPathComponent();
                    pathList.add(0, object.toString());
                    path = path.getParentPath();
                }
                DataBreadcrumbsTable.this.dataPanel.getController().updateInstanceCounts(DataBreadcrumbsTable.this.vm);
            }
        });
        dataPanel.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(final TreeModelEvent e) {
                DataBreadcrumbsTable.this.model.resetLeafCache();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (e.getSource() instanceof DataItem) {
                            DataBreadcrumbsTable.this.restoreExpanded(false);
                        } else {
                            DataBreadcrumbsTable.this.restoreExpanded(true);
                        }
                    }
                });
            }
        });
        this.initArrayButtons();
    }

    private void restoreExpanded(boolean scrollToVisible) {
        TreePath currentPath = new TreePath(this.model.getRoot());
        DebuggingProcess dbg = this.dataPanel.getDebuggingProcess();
        if (this.expanded.containsKey(dbg)) {
            ArrayList currentExpanded = new ArrayList(this.expanded.get(dbg));
            this.makeVisible(currentPath, scrollToVisible);
            block0: for (int p = 1; p < currentExpanded.size(); ++p) {
                String expandedPath = (String)currentExpanded.get(p);
                Object node = currentPath.getLastPathComponent();
                if (node != null) {
                    Object child;
                    for (int i = 0; i < this.model.getChildCount(node) && (child = this.model.getChild(node, i)) != null; ++i) {
                        TreePath childTreePath = currentPath.pathByAddingChild(child);
                        String path = childTreePath.getLastPathComponent().toString();
                        if (!expandedPath.equals(path)) {
                            continue;
                        }
                        this.expandPath(childTreePath, scrollToVisible);
                        currentPath = childTreePath;
                        continue block0;
                    }
                }
                break;
            }
        } else {
            this.makeVisible(currentPath, scrollToVisible);
        }
        if (this.arrayNavigationPanel != null && currentPath.getLastPathComponent() instanceof DataItem) {
            this.arrayNavigationPanel.enableNavigationButtons((DataItem)currentPath.getLastPathComponent());
        }
    }

    private JComponent createGUI(final DataPanel dataPanel) {
        JTable table = this.builtTable.getTable();
        DataTableUtils.hookupTable(dataPanel, table);
        DataTableUtils.hookupDragAndDrop(dataPanel, table, this.builtTable.getScrollPane());
        DataTableUtils.setHeaderRenderer(table.getTableHeader());
        DataValueCellEditor dataValueCellEditor = new DataValueCellEditor(dataPanel);
        dataValueCellEditor.setNavigationButtonsPermitted(false);
        DataTableCellRenderer dataValueCellRenderer = new DataTableCellRenderer(dataPanel);
        dataValueCellRenderer.setNavigationButtonsPermitted(false);
        table.setDefaultRenderer(String.class, dataValueCellRenderer);
        TableColumnModel tcm = table.getColumnModel();
        tcm.getColumn(1).setCellEditor((TableCellEditor)((Object)dataValueCellEditor));
        tcm.getColumn(1).setCellRenderer(dataValueCellRenderer);
        tcm.getColumn(0).setCellRenderer(new NameRenderer());
        tcm.getColumn(0).setCellEditor((TableCellEditor)((Object)new DataNameCellEditor(dataPanel)));
        tcm.addColumnModelListener(this.columnListener);
        DataTableMouseAdapter mouseAdapter = new DataTableMouseAdapter(this.builtTable.getTable(), dataPanel);
        table.addMouseMotionListener(mouseAdapter);
        table.addMouseListener(mouseAdapter);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                dataPanel.selectionChanged();
            }
        });
        this.createToolbarItems(dataPanel);
        ((DefaultRowSorter)table.getRowSorter()).setRowFilter(this.filter);
        PopupHandler popupHandler = new PopupHandler();
        popupHandler.attach(this.builtTable.getBreadcrumbs(), (PopupProvider)new DataPopupProvider());
        return this.builtTable.getGUI();
    }

    @Override
    public Component getGUI() {
        return this.gui;
    }

    @Override
    public JTable getTable() {
        return this.builtTable.getTable();
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.builtTable.getScrollPane();
    }

    @Override
    public TreePath makeVisible(DataTreeTableModel model, DataInfoPath dataInfoPath) {
        TreePath tp = DataTableUtils.convertDataInfoPathToTreePath((TreeTableModel)model, dataInfoPath);
        this.makeVisible(tp);
        return tp;
    }

    @Override
    public void makeVisible(TreePath treePath) {
        this.makeVisible(treePath, true);
    }

    private void makeVisible(TreePath treePath, boolean scrollToVisible) {
        if (treePath == null) {
            return;
        }
        TreePath parentPath = treePath.getParentPath();
        if (parentPath == null) {
            this.builtTable.setSelectedNode(treePath.getLastPathComponent(), scrollToVisible);
        } else {
            this.builtTable.setBreadcrumbPath(parentPath);
            if (scrollToVisible) {
                Object rowObject = treePath.getLastPathComponent();
                int row = this.builtTable.indexOf(rowObject);
                Rectangle cellRect = this.builtTable.getTable().getCellRect(row, 0, true);
                this.builtTable.getTable().scrollRectToVisible(cellRect);
            }
        }
    }

    @Override
    public TreePath getPathForRow(int row) {
        TreePath tp = this.builtTable.getBreadcrumbPath();
        try {
            Object parent = tp.getLastPathComponent();
            int modelIndex = this.builtTable.getTable().convertRowIndexToModel(row);
            Object rowNode = this.model.getChild(parent, modelIndex);
            if (tp != null && rowNode != null) {
                tp = tp.pathByAddingChild(rowNode);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return tp;
    }

    @Override
    public void setSelectionPath(TreePath treePath) {
        TreePath parentPath = treePath.getParentPath();
        if (parentPath == null) {
            this.builtTable.setSelectedNode(treePath.getLastPathComponent());
        } else {
            this.builtTable.setBreadcrumbPath(parentPath);
            Object rowObject = treePath.getLastPathComponent();
            int row = this.builtTable.indexOf(rowObject);
            if (row < 0 || row >= this.builtTable.getTable().getRowCount()) {
                this.builtTable.getTable().clearSelection();
            } else {
                this.builtTable.getTable().setRowSelectionInterval(row, row);
                Rectangle cellRect = this.builtTable.getTable().getCellRect(row, 0, true);
                this.builtTable.getTable().scrollRectToVisible(cellRect);
            }
        }
    }

    @Override
    public TreePath getSelectionPath() {
        int row = this.builtTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        TreePath breadcrumbPath = this.getPathForRow(row);
        return breadcrumbPath;
    }

    @Override
    public boolean isVisible(TreePath treePath) {
        if (treePath != null) {
            TreePath parentPath = treePath.getParentPath();
            if (parentPath != null) {
                return this.isExpanded(parentPath);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpanded(TreePath treePath) {
        TreePath tp = this.builtTable.getBreadcrumbPath();
        return tp.equals(treePath);
    }

    @Override
    public void expandPath(TreePath treePath) {
        this.expandPath(treePath, true);
    }

    public void expandPath(TreePath treePath, boolean scrollToVisible) {
        this.builtTable.setBreadcrumbPath(treePath, scrollToVisible);
    }

    @Override
    public void collapsePath(TreePath treePath) {
        TreePath existingPath = this.builtTable.getBreadcrumbPath();
        TreePath parentPath = existingPath.getParentPath();
        if (parentPath != null && treePath != null && parentPath.equals(treePath)) {
            this.builtTable.setBreadcrumbPath(treePath, true);
        }
    }

    @Override
    public void removeAll(DebuggingProcess debuggingProcess) {
        DebuggingProcess dbg = this.dataPanel.getDebuggingProcess();
        this.expanded.remove(dbg);
        Object root = this.model.getRoot();
        this.builtTable.setBreadcrumbPath(new TreePath(root));
    }

    @Override
    public void collapseAll() {
        Object node = this.builtTable.getModel().getRoot();
        this.builtTable.setSelectedNode(node);
    }

    @Override
    public void switched(boolean switchedIn) {
        if (this.searchField != null) {
            this.searchField.setVisible(switchedIn);
        }
    }

    private void createToolbarItems(DataPanel dataPanel) {
        Toolbar toolbar = dataPanel.getToolbar();
        if (toolbar != null) {
            this.searchField = new SearchField(SearchField.Style.FILTER);
            this.searchField.setMaximumSize(new Dimension(200, 20));
            this.searchField.getTextField().setColumns(14);
            this.searchField.getAccessibleContext().setAccessibleName(DbgArb.getString(855));
            this.searchField.getTextField().getAccessibleContext().setAccessibleName(DbgArb.getString(855));
            toolbar.add((Component)this.searchField, 0);
            toolbar.add(Box.createHorizontalStrut(6));
            this.searchField.addSearchListener(new SearchListener(){

                public void searchPerformed(SearchEvent se) {
                    DataBreadcrumbsTable.this.filter.setFilter(se.getSearchText());
                    ((DefaultRowSorter)DataBreadcrumbsTable.this.getTable().getRowSorter()).sort();
                }

                public void searchCategoryChanged(SearchEvent se) {
                }
            });
        }
    }

    void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.getScrollPane(), this.getTable());
    }

    @Override
    public void setNewVm(DebugVirtualMachine vm, DataPanel dataPanel, DebuggerDataWindowOptions windowOptions) {
        String vmID;
        if (this.vm != null) {
            this.storeVmSettings(this.vm);
        }
        this.vm = vm;
        if (vm == null || windowOptions == null) {
            return;
        }
        HashStructure hash = this.dataPanelSettings.getHash();
        List<String> columnNames = WindowSettingsColumnManager.getColumnNames(hash, vmID = vm.getID());
        if (columnNames.size() == 0) {
            return;
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            String columnName = columnNames.get(i);
            columnNames.set(i, StringUtils.stripMnemonic((String)columnName));
        }
        TableColumnModel tcm = this.getTable().getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            TableColumn column = tcm.getColumn(i);
            int modelColumn = this.getTable().convertColumnIndexToModel(i);
            if (modelColumn >= columnNames.size()) break;
            column.setHeaderValue(columnNames.get(modelColumn));
            int width = WindowSettingsColumnManager.getColumnBreadcrumbWidth(hash, vmID, modelColumn);
            if (width > 0) {
                this.adjustColumnsAlreadyDone = true;
                column.setPreferredWidth(width);
                continue;
            }
            column.setPreferredWidth(WindowSettingsColumnManager.getColumnNumeric(hash, vmID, i) ? 37 : 75);
        }
        this.getTable().getTableHeader().repaint();
        this.dataPanelSettingsChanged(dataPanel, this.dataPanelSettings);
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        String order = WindowSettingsColumnManager.getColumnBreadcrumbOrder(hash, vmID);
        if (order != null) {
            for (int i = 0; i < windowOptions.getNumberOfColumns(); ++i) {
                String identifier;
                int comma = order.indexOf(44);
                if (comma != -1) {
                    identifier = order.substring(0, comma);
                    order = order.substring(comma + 1);
                } else {
                    identifier = order;
                }
                if (identifier.length() == 0) break;
                try {
                    int from = tableColumnModel.getColumnIndex(identifier);
                    if (from == i) continue;
                    this.getTable().moveColumn(from, i);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void storeVmSettings(DebugVirtualMachine vm) {
        HashStructure hash = this.dataPanelSettings.getHash();
        StringBuilder buf = new StringBuilder();
        TableColumnModel tcModel = this.getTable().getColumnModel();
        Enumeration<TableColumn> e = tcModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            buf.append(column.getIdentifier());
            buf.append(',');
            WindowSettingsColumnManager.setColumnBreadcrumbWidth(hash, vm.getID(), column.getModelIndex(), column.getWidth());
        }
        WindowSettingsColumnManager.setColumnBreadcrumbOrder(hash, vm.getID(), buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveColumnVisibilities() {
        if (this.getTable() == null || this.dataPanelSettings == null) {
            return;
        }
        this.columnListener.enabled = false;
        try {
            int highestIndexSeen = -1;
            for (int hiddenIndex : this.builtTable.getHiddenColumns()) {
                if (hiddenIndex > highestIndexSeen) {
                    highestIndexSeen = hiddenIndex;
                }
                WindowSettingsColumnManager.setColumnBreadcrumbVisible(this.dataPanelSettings.getHash(), this.vm.getID(), hiddenIndex, false);
            }
            TableColumnModel tableColumnModel = this.getTable().getColumnModel();
            Enumeration<TableColumn> e = tableColumnModel.getColumns();
            while (e.hasMoreElements()) {
                TableColumn column = e.nextElement();
                if (column.getModelIndex() > highestIndexSeen) {
                    highestIndexSeen = column.getModelIndex();
                }
                WindowSettingsColumnManager.setColumnBreadcrumbVisible(this.dataPanelSettings.getHash(), this.vm.getID(), column.getModelIndex(), true);
            }
            for (int i = highestIndexSeen + 1; i < 8; ++i) {
                WindowSettingsColumnManager.setColumnBreadcrumbVisible(this.dataPanelSettings.getHash(), this.vm.getID(), i, false);
            }
        }
        finally {
            this.columnListener.enabled = true;
        }
    }

    private void initArrayButtons() {
        this.arrayNavigationPanel.addFirstButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = DataBreadcrumbsTable.this.builtTable.getBreadcrumbPath();
                DataItem dataItem = DataPanel.getDataItemForTreePath(path);
                if (dataItem != null) {
                    dataItem.adjustRangeFirst(path);
                }
            }
        });
        this.arrayNavigationPanel.addLastButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = DataBreadcrumbsTable.this.builtTable.getBreadcrumbPath();
                DataItem dataItem = DataPanel.getDataItemForTreePath(path);
                if (dataItem != null) {
                    dataItem.adjustRangeLast(path);
                }
            }
        });
        this.arrayNavigationPanel.addPreviousButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = DataBreadcrumbsTable.this.builtTable.getBreadcrumbPath();
                DataItem dataItem = DataPanel.getDataItemForTreePath(path);
                if (dataItem != null) {
                    dataItem.adjustRangePrevious(path);
                }
            }
        });
        this.arrayNavigationPanel.addNextButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = DataBreadcrumbsTable.this.builtTable.getBreadcrumbPath();
                DataItem dataItem = DataPanel.getDataItemForTreePath(path);
                if (dataItem != null) {
                    dataItem.adjustRangeNext(path);
                }
            }
        });
    }

    @Override
    public void addSelectionListener(ListSelectionListener l) {
        this.builtTable.getTable().getSelectionModel().addListSelectionListener(l);
    }

    @Override
    public void removeSelectionListener(ListSelectionListener l) {
        this.builtTable.getTable().getSelectionModel().removeListSelectionListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataPanelSettingsChanged(DataPanel dataPanel, DataPanelSettings dataPanelSettings) {
        this.columnListener.enabled = false;
        try {
            this.dataPanelSettings = dataPanelSettings;
            if (this.vm == null) {
                return;
            }
            ArrayList<Integer> shouldBeHidden = new ArrayList<Integer>();
            ArrayList<Integer> shouldBeVisible = new ArrayList<Integer>();
            for (int i = 0; i < 8; ++i) {
                if (WindowSettingsColumnManager.getColumnBreadcrumbVisible(dataPanelSettings.getHash(), this.vm.getID(), i)) {
                    shouldBeVisible.add(i);
                    continue;
                }
                shouldBeHidden.add(i);
            }
            if (shouldBeHidden.size() > 0) {
                int[] columns = new int[shouldBeHidden.size()];
                for (int i = 0; i < shouldBeHidden.size(); ++i) {
                    int columnIndex;
                    columns[i] = columnIndex = ((Integer)shouldBeHidden.get(i)).intValue();
                }
                try {
                    this.builtTable.setHiddenColumns(columns);
                }
                catch (ArrayIndexOutOfBoundsException i) {
                    // empty catch block
                }
            }
            if (shouldBeVisible.size() > 0) {
                int[] columns = new int[shouldBeVisible.size()];
                for (int i = 0; i < shouldBeVisible.size(); ++i) {
                    columns[i] = (Integer)shouldBeVisible.get(i);
                }
                this.builtTable.setHiddenColumnsVisible(columns);
            }
            DataTableUtils.setColumnOrder(this.getTable(), WindowSettingsColumnManager.getColumnBreadcrumbOrder(dataPanelSettings.getHash(), this.vm.getID()));
        }
        finally {
            this.columnListener.enabled = true;
        }
    }

    private class DataFilter
    extends RowFilter<Object, Object> {
        private String filter = "";

        private DataFilter() {
        }

        public void setFilter(String filterText) {
            this.filter = filterText.toLowerCase();
        }

        @Override
        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
            if (this.filter.equals("")) {
                return true;
            }
            for (int i = entry.getValueCount() - 1; i >= 0; --i) {
                if (!entry.getStringValue(i).toLowerCase().startsWith(this.filter)) continue;
                return true;
            }
            return false;
        }
    }

    private class ColumnListener
    implements TableColumnModelListener {
        boolean enabled = true;

        private ColumnListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            if (this.enabled) {
                DataBreadcrumbsTable.this.saveColumnVisibilities();
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            if (this.enabled) {
                DataBreadcrumbsTable.this.saveColumnVisibilities();
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private NameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelRow = table.convertRowIndexToModel(row);
            value = ((NodeTableModelAdapter)table.getModel()).getChildNodeAtRow(modelRow);
            label.setBackground(isSelected ? table.getSelectionBackground() : JDebugger.tableCellBackground);
            if (value instanceof DataItem) {
                int modelColumn;
                DataItem dataItem = (DataItem)value;
                label.setIcon(dataItem.getIcon());
                label.setFont(dataItem.getFont(0));
                label.setEnabled(!dataItem.isUnrelated());
                label.setToolTipText(dataItem.getToolTipText());
                if (dataItem instanceof VersionedDataItem) {
                    VersionedDataItem vitem = (VersionedDataItem)dataItem;
                    if (vitem.getChange() == VersionedDataItem.Change.ADDED) {
                        label.setBackground(isSelected ? JDebugger.changedCellSelectedBackground : JDebugger.changedCellBackground);
                        label.setForeground(isSelected ? JDebugger.changedCellSelectedForeground : JDebugger.changedCellForeground);
                    } else {
                        label.setBackground(isSelected ? table.getSelectionBackground() : JDebugger.tableCellBackground);
                        label.setForeground(isSelected ? table.getSelectionForeground() : JDebugger.tableCellForeground);
                    }
                }
                AccessibleContext ac = label.getAccessibleContext();
                DataTreeTableModel model = DataBreadcrumbsTable.this.dataPanel.getModel();
                String accessibleName = DataTreeCellRenderer.getAccessibleNameAt((TreeTableModel)model, dataItem, modelColumn = table.convertColumnIndexToModel(column));
                if (accessibleName != null) {
                    ac.setAccessibleName(accessibleName);
                }
            }
            return label;
        }
    }

    class DataPopupProvider
    implements PopupProvider {
        Pattern arrayElementLabel = Pattern.compile("\\[\\d+\\]");

        DataPopupProvider() {
        }

        public List<PopupItem> getPopupItems(Breadcrumb breadcrumb) {
            List<PopupItem> itemList = ((DataBreadcrumbMaker.DataTableBreadcrumb)breadcrumb).getChildren();
            return itemList;
        }

        public void itemSelected(PopupItem popupItem) {
            Breadcrumb breadcrumb = popupItem.getBreadcrumb();
            BreadcrumbsModel breadcrumbsModel = DataBreadcrumbsTable.this.builtTable.getBreadcrumbs().getModel();
            TreePath path = new TreePath(DataBreadcrumbsTable.this.model.getRoot());
            BreadcrumbsTableBuilder.TableBreadcrumb alteredBreadcrumb = null;
            for (int i = 0; i < breadcrumbsModel.getBreadcrumbCount(); ++i) {
                Breadcrumb modelCrumb = breadcrumbsModel.getBreadcrumb(i);
                if (i > 0) {
                    if (alteredBreadcrumb != null) {
                        List<PopupItem> alteredBCChildren = ((DataBreadcrumbMaker.DataTableBreadcrumb)alteredBreadcrumb).getChildren();
                        String oldChildLabel = modelCrumb.getUserObject().toString();
                        for (PopupItem potentialNextChild : alteredBCChildren) {
                            if (!potentialNextChild.getUserObject().toString().equals(oldChildLabel)) continue;
                            DataItem item = (DataItem)potentialNextChild.getUserObject();
                            path = path.pathByAddingChild(item);
                            alteredBreadcrumb = DataBreadcrumbsTable.this.breadcrumbMaker.createBreadcrumb(item);
                            break;
                        }
                    } else {
                        path = path.pathByAddingChild(modelCrumb.getUserObject());
                    }
                }
                if (modelCrumb != breadcrumb) continue;
                String popupLabel = popupItem.getUserObject().toString();
                path = path.pathByAddingChild(popupItem.getUserObject());
                if (this.arrayElementLabel.matcher(popupLabel).matches()) {
                    DataItem item = (DataItem)popupItem.getUserObject();
                    alteredBreadcrumb = DataBreadcrumbsTable.this.breadcrumbMaker.createBreadcrumb(item);
                    ++i;
                    continue;
                }
                DataBreadcrumbsTable.this.expandPath(path);
                return;
            }
            DataBreadcrumbsTable.this.expandPath(path);
        }
    }
}

