/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Log;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.res.RunConfigModuleSupportArb;

public class RunConfigurationModuleOptionsPanel
extends DefaultTraversablePanel {
    private ModuleOptionsModel moduleOptionsModel;
    private JTable moduleOptionsTable;
    private static final int COLUMN_SELECT_CATEGORY = 0;
    private static final int COLUMN_SELECT_CONTENT = 1;
    private static final int COLUMN_CONTENT = 2;
    private static final int COLUMN_HELP = 3;
    private static final int COLUMN_EDIT = 4;
    private static final int COLUMN_DELETE = 5;
    private static final int COLUMN_ADD = 6;
    private transient RunConfiguration runConfiguration;
    private transient List<RowData> tableContent = new ArrayList<RowData>();
    private static transient Log logger = new Log("ModuleOptionsLogger");
    private ContentRenderer contentRenderer = new ContentRenderer();

    public RunConfigurationModuleOptionsPanel() {
        this.moduleOptionsModel = new ModuleOptionsModel();
        this.moduleOptionsModel.setColumnCount(7);
        TableColumnModel moduleOptionsColumnModel = this.getTableColumnModel();
        this.moduleOptionsTable = new ModuleOptionsTable(this.moduleOptionsModel, moduleOptionsColumnModel);
        this.moduleOptionsTable.setTableHeader(null);
        this.moduleOptionsTable.setRowSelectionAllowed(false);
        this.moduleOptionsTable.setColumnSelectionAllowed(false);
        this.moduleOptionsTable.setCellSelectionEnabled(false);
        this.moduleOptionsTable.setShowGrid(false);
        this.moduleOptionsTable.setRowHeight(18);
        this.moduleOptionsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int row = RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.rowAtPoint(event.getPoint());
                if (row >= 0 && row < RunConfigurationModuleOptionsPanel.this.tableContent.size()) {
                    int column = RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.columnAtPoint(event.getPoint());
                    RowData rowdata = RunConfigurationModuleOptionsPanel.this.tableContent.get(row);
                    if (!rowdata.isEnabled()) {
                        if (column == 2 && event.getClickCount() > 1 && !rowdata.allowEdit()) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        return;
                    }
                    if (column == 0 || column == 1 || column == 3) {
                        return;
                    }
                    if (column == 2 && event.getClickCount() > 1 && !rowdata.allowEdit()) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (column >= 4 && column <= 6) {
                        switch (column) {
                            case 6: {
                                rowdata.handleAdd();
                                return;
                            }
                            case 4: {
                                rowdata.handleEdit();
                                return;
                            }
                            case 5: {
                                rowdata.handleDelete();
                                return;
                            }
                        }
                    }
                }
            }
        });
        JScrollPane moduleOptionsScrollPane = new JScrollPane(this.moduleOptionsTable);
        JViewport viewport = moduleOptionsScrollPane.getViewport();
        moduleOptionsScrollPane.setOpaque(true);
        viewport.setOpaque(true);
        moduleOptionsScrollPane.setBackground(this.moduleOptionsTable.getBackground());
        viewport.setBackground(this.moduleOptionsTable.getBackground());
        this.add(moduleOptionsScrollPane);
    }

    public static Log getLogger() {
        return logger;
    }

    private RowData getModulePathCategoryData(RunConfiguration runConfiguration) {
        String rowName = "--module-path category";
        Boolean categorySelected = runConfiguration.isUseModulePath();
        Boolean contentSelected = null;
        String text = "--module-path";
        String helpText = RunConfigModuleSupportArb.getString(56);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData modulePathCategory = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUseModulePath((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        modulePathCategory.setAccessibleRowName(RunConfigModuleSupportArb.getString(77));
        return modulePathCategory;
    }

    private RowData getModulePathFromCPHeader(RunConfiguration runConfiguration) {
        String rowName = "--module-path content header - PathsConfig";
        Boolean contentSelected = runConfiguration.isUsePathsConfigModulePath();
        Boolean categorySelected = null;
        String text = RunConfigModuleSupportArb.getString(10);
        String helpText = null;
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData modulePathFromCP = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUsePathsConfigModulePath((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 1));
            }
        };
        modulePathFromCP.setAccessibleRowName(RunConfigModuleSupportArb.getString(78));
        return modulePathFromCP;
    }

    private RowData getModulePathFromCPDetail(RunConfiguration runConfiguration) {
        String rowName = "--module-path content detail - PathsConfig";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = runConfiguration.getModulePathFromPathsConfig();
        boolean nodatafound = false;
        if (text == null) {
            text = RunConfigModuleSupportArb.getString(54);
            nodatafound = true;
        }
        String helpText = RunConfigModuleSupportArb.getString(55);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData modulePathFromCP = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete);
        if (nodatafound) {
            modulePathFromCP.setFontAttributes(2);
        }
        modulePathFromCP.setAccessibleRowName(RunConfigModuleSupportArb.getString(80));
        return modulePathFromCP;
    }

    private RowData getModulePathFromUserHeader(RunConfiguration runConfiguration) {
        String rowName = "--module-path content header - User";
        Boolean contentSelected = runConfiguration.isUseUserSuppliedModulePath();
        Boolean categorySelected = null;
        String text = RunConfigModuleSupportArb.getString(11);
        String helpText = null;
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData modulePathFromUser = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUseUserSuppliedModulePath((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 1));
            }
        };
        modulePathFromUser.setAccessibleRowName(RunConfigModuleSupportArb.getString(79));
        return modulePathFromUser;
    }

    private RowData getModulePathFromUserDetail(RunConfiguration runConfiguration) {
        String rowName = "--module-path content detail - user";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = runConfiguration.getUserSuppliedModulePath();
        String placeholderText = RunConfigModuleSupportArb.getString(12);
        String helpText = RunConfigModuleSupportArb.getString(57);
        boolean allowAdd = false;
        boolean allowEdit = true;
        boolean allowDelete = false;
        RowData modulePathFromUser = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUserSuppliedModulePath((String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 2));
            }

            @Override
            public void handleEdit() {
                EditUserModulePathDialog dialog = new EditUserModulePathDialog(this.getText());
                String newModulePath = dialog.showDialog();
                if (newModulePath != null) {
                    this.setText(newModulePath);
                    RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newModulePath, this.getRow(), 2);
                }
                RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
            }
        };
        modulePathFromUser.setPlaceholderText(placeholderText);
        modulePathFromUser.setAccessibleRowName(RunConfigModuleSupportArb.getString(81));
        return modulePathFromUser;
    }

    private RowData getAddModulesCategoryData(RunConfiguration runConfiguration) {
        String rowName = "--add-modules category";
        Boolean categorySelected = runConfiguration.isUseModulePath();
        Boolean contentSelected = null;
        String text = "--add-modules";
        String helpText = RunConfigModuleSupportArb.getString(58);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData addModulesCategory = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasAddModulesOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        addModulesCategory.setAccessibleRowName(RunConfigModuleSupportArb.getString(82));
        return addModulesCategory;
    }

    private RowData getAddModulesFromCPHeader(RunConfiguration runConfiguration) {
        String rowName = "--add-modules from PathsConfig content header";
        Boolean contentSelected = runConfiguration.isUsePathsConfigAddModules();
        Boolean categorySelected = null;
        String text = RunConfigModuleSupportArb.getString(13);
        String helpText = null;
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData addModulesFromCP = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUsePathsConfigAddModules((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 1));
            }
        };
        addModulesFromCP.setAccessibleRowName(RunConfigModuleSupportArb.getString(83));
        return addModulesFromCP;
    }

    private RowData getAddModulesFromCPDetail(RunConfiguration runConfiguration) {
        String rowName = "--add-modules from PathsConfig content detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        List<String> moduleList = runConfiguration.getPathsConfigModules();
        StringBuilder modules = new StringBuilder();
        for (String module : moduleList) {
            modules.append(module);
            modules.append(',');
        }
        String text = modules.toString();
        if (text.indexOf(",") != -1) {
            text = text.substring(0, modules.length() - 1);
        }
        boolean nodatafound = false;
        if (text == null) {
            text = RunConfigModuleSupportArb.getString(54);
            nodatafound = true;
        }
        String helpText = RunConfigModuleSupportArb.getString(55);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData addModulesFromCP = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete);
        if (nodatafound) {
            addModulesFromCP.setFontAttributes(2);
        }
        addModulesFromCP.setAccessibleRowName(RunConfigModuleSupportArb.getString(85));
        return addModulesFromCP;
    }

    private RowData getAddModulesFromUserHeader(RunConfiguration runConfiguration) {
        String rowName = "--add-modules user content header";
        Boolean contentSelected = runConfiguration.isUseUserSuppliedAddModules();
        Boolean categorySelected = null;
        String text = RunConfigModuleSupportArb.getString(14);
        String helpText = null;
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData addModulesFromUser = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUseUserSuppliedAddModules((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 1));
            }
        };
        addModulesFromUser.setAccessibleRowName(RunConfigModuleSupportArb.getString(84));
        return addModulesFromUser;
    }

    private RowData getAddModulesFromUserDetail(RunConfiguration runConfiguration) {
        String rowName = "--add-modules user content detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = runConfiguration.getUserSuppliedAddModules();
        String placeholderText = RunConfigModuleSupportArb.getString(18);
        String helpText = RunConfigModuleSupportArb.getString(59);
        boolean allowAdd = false;
        boolean allowEdit = true;
        boolean allowDelete = false;
        RowData addModulesFromUser = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUserSuppliedAddModules((String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 2));
            }

            @Override
            public void handleEdit() {
                EditUserAddModulesDialog dialog = new EditUserAddModulesDialog(this.getText());
                String newAddModules = dialog.showDialog();
                if (newAddModules != null) {
                    this.setText(newAddModules);
                    RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newAddModules, this.getRow(), 2);
                }
                RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
            }
        };
        addModulesFromUser.setPlaceholderText(placeholderText);
        addModulesFromUser.setAccessibleRowName(RunConfigModuleSupportArb.getString(86));
        return addModulesFromUser;
    }

    private RowData getModuleHeader(RunConfiguration runConfiguration) {
        String rowName = "--module header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasModuleOption();
        String text = "--module";
        String helpText = RunConfigModuleSupportArb.getString(60);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData moduleHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasModuleOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        moduleHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(87));
        return moduleHeader;
    }

    private RowData getModuleDetail(RunConfiguration runConfiguration) {
        String rowName = "--module detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = runConfiguration.getModuleOptionData();
        String placeholderText = RunConfigModuleSupportArb.getString(19);
        boolean allowAdd = false;
        boolean allowEdit = true;
        boolean allowDelete = false;
        RowData moduleDetail = new RowData(rowName, categorySelected, contentSelected, text, null, allowAdd, allowEdit, allowDelete){

            @Override
            public void handleEdit() {
                EditModuleDialog dialog = new EditModuleDialog(this.getText());
                String newModule = dialog.showDialog();
                if (newModule != null) {
                    this.setText(newModule);
                    RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newModule, this.getRow(), 2);
                }
                RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
            }

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setModuleOptionData((String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 2));
            }
        };
        moduleDetail.setPlaceholderText(placeholderText);
        moduleDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(88));
        return moduleDetail;
    }

    private RowData getAddReadsHeader(RunConfiguration runConfiguration) {
        String rowName = "--add-reads header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasAddReadsOption();
        String text = "--add-reads";
        String helpText = RunConfigModuleSupportArb.getString(61);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData addReadsHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasAddReadsOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        addReadsHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(89));
        return addReadsHeader;
    }

    private List<RowData> getAddReadsDetail(RunConfiguration runConfiguration) {
        ArrayList<RowData> options = new ArrayList<RowData>();
        String placeholderText = RunConfigModuleSupportArb.getString(20);
        List<String> addReadsOptions = runConfiguration.getAddReadsOptionData();
        List<Boolean> addReadsSelections = runConfiguration.getAddReadsDetailsSelected();
        if (addReadsOptions == null) {
            addReadsOptions = new ArrayList<String>();
            addReadsSelections = new ArrayList<Boolean>();
        }
        if (addReadsOptions.isEmpty()) {
            addReadsOptions.add("");
            addReadsSelections.add(Boolean.FALSE);
        }
        for (int i = 0; i < addReadsOptions.size(); ++i) {
            String addReadsOption = addReadsOptions.get(i);
            boolean selected = addReadsSelections.get(i);
            AddReadsDetailRowData addReadsDetail = new AddReadsDetailRowData(addReadsOption, selected);
            addReadsDetail.setPlaceholderText(placeholderText);
            addReadsDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(90));
            options.add(addReadsDetail);
        }
        return options;
    }

    private RowData getAddExportsHeader(RunConfiguration runConfiguration) {
        String rowName = "--add-exports  header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasAddExportsOption();
        String text = "--add-exports";
        String helpText = RunConfigModuleSupportArb.getString(62);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData addExportsHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasAddExportsOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        addExportsHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(91));
        return addExportsHeader;
    }

    private List<RowData> getAddExportsDetail(RunConfiguration runConfiguration) {
        ArrayList<RowData> options = new ArrayList<RowData>();
        String placeholderText = RunConfigModuleSupportArb.getString(21);
        List<String> addExportsOptions = runConfiguration.getAddExportsOptionData();
        List<Boolean> addExportsSelections = runConfiguration.getAddExportsDetailsSelected();
        if (addExportsOptions == null) {
            addExportsOptions = new ArrayList<String>();
            addExportsSelections = new ArrayList<Boolean>();
        }
        if (addExportsOptions.isEmpty()) {
            addExportsOptions.add("");
            addExportsSelections.add(false);
        }
        for (int i = 0; i < addExportsOptions.size(); ++i) {
            String addExportsOption = addExportsOptions.get(i);
            boolean selected = addExportsSelections.get(i);
            AddExportsDetailRowData addExportsDetail = new AddExportsDetailRowData(addExportsOption, selected);
            addExportsDetail.setPlaceholderText(placeholderText);
            addExportsDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(92));
            options.add(addExportsDetail);
        }
        return options;
    }

    private RowData getUpgradeModulePathHeader(RunConfiguration runConfiguration) {
        String rowName = "--upgrade-module-path header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasUpgradeModulePathOption();
        String text = "--upgrade-module-path";
        String helpText = RunConfigModuleSupportArb.getString(63);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData upgradeModulePath = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasUpgradeModulePathOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        upgradeModulePath.setAccessibleRowName(RunConfigModuleSupportArb.getString(93));
        return upgradeModulePath;
    }

    private RowData getUpgradeModulePathDetail(RunConfiguration runConfiguration) {
        String rowName = "--upgrade-module-path detai";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = runConfiguration.getUpgradeModulePathOptionData();
        String placeholderText = RunConfigModuleSupportArb.getString(22);
        String helpText = null;
        boolean allowAdd = false;
        boolean allowEdit = true;
        boolean allowDelete = false;
        RowData upgradeModulePath = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setUpgradeModulePathOptionData((String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 2));
            }

            @Override
            public void handleEdit() {
                EditUpgradeModulePathDialog dialog = new EditUpgradeModulePathDialog(this.getText());
                String newModulePath = dialog.showDialog();
                if (newModulePath != null) {
                    this.setText(newModulePath);
                    RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newModulePath, this.getRow(), 2);
                    logger.trace("After EditUpgradeModulePathDialog returns, updated model and rowData to " + newModulePath);
                }
                RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
            }
        };
        upgradeModulePath.setPlaceholderText(placeholderText);
        upgradeModulePath.setAccessibleRowName(RunConfigModuleSupportArb.getString(94));
        return upgradeModulePath;
    }

    private RowData getLimitModulesHeader(RunConfiguration runConfiguration) {
        String rowName = "--limit-modules header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasLimitModulesOption();
        String text = "--limit-modules";
        String helpText = RunConfigModuleSupportArb.getString(64);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData limitModulesHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasLimitModulesOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        limitModulesHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(95));
        return limitModulesHeader;
    }

    private RowData getLimitModulesDetail(RunConfiguration runConfiguration) {
        String rowName = "--limit-modules detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = runConfiguration.getUserSuppliedAddModules();
        String placeholderText = RunConfigModuleSupportArb.getString(23);
        String helpText = null;
        boolean allowAdd = false;
        boolean allowEdit = true;
        boolean allowDelete = false;
        RowData limitModulesDetail = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setLimitModulesOptionData((String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 2));
            }

            @Override
            public void handleEdit() {
                EditLimitModulesDialog dialog = new EditLimitModulesDialog(this.getText());
                String newLimitModules = dialog.showDialog();
                if (newLimitModules != null) {
                    this.setText(newLimitModules);
                    RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newLimitModules, this.getRow(), 2);
                }
                RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
            }
        };
        limitModulesDetail.setPlaceholderText(placeholderText);
        limitModulesDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(96));
        return limitModulesDetail;
    }

    private RowData getPatchModuleHeader(RunConfiguration runConfiguration) {
        String rowName = "--patch-module header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasPatchModuleOption();
        String text = "--patch-module";
        String helpText = RunConfigModuleSupportArb.getString(65);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData patchModuleHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasPatchModuleOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        patchModuleHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(97));
        return patchModuleHeader;
    }

    private List<RowData> getPatchModuleDetail(RunConfiguration runConfiguration) {
        ArrayList<RowData> options = new ArrayList<RowData>();
        String placeholderText = RunConfigModuleSupportArb.getString(24);
        List<String> patchModuleOptions = runConfiguration.getPatchModuleOptionData();
        List<Boolean> patchModuleSelections = runConfiguration.getPatchModuleDetailsSelected();
        if (patchModuleOptions == null) {
            patchModuleOptions = new ArrayList<String>();
            patchModuleSelections = new ArrayList<Boolean>();
        }
        if (patchModuleOptions.isEmpty()) {
            patchModuleOptions.add("");
            patchModuleSelections.add(false);
        }
        for (int i = 0; i < patchModuleOptions.size(); ++i) {
            String patchModuleOption = patchModuleOptions.get(i);
            boolean selected = patchModuleSelections.get(i);
            PatchModuleDetailRowData patchModuleDetail = new PatchModuleDetailRowData(patchModuleOption, selected);
            patchModuleDetail.setPlaceholderText(placeholderText);
            patchModuleDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(98));
            options.add(patchModuleDetail);
        }
        return options;
    }

    private RowData getListModulesHeader(RunConfiguration runConfiguration) {
        String rowName = "--list-modules header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasListModulesOption();
        String text = "--list-modules";
        String helpText = RunConfigModuleSupportArb.getString(66);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData listModulesHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasListModulesOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        listModulesHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(99));
        return listModulesHeader;
    }

    private RowData getListModulesDetail(RunConfiguration runConfiguration) {
        String rowName = "--list-modules detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = runConfiguration.getUserSuppliedAddModules();
        String placeholderText = RunConfigModuleSupportArb.getString(25);
        String helpText = null;
        boolean allowAdd = false;
        boolean allowEdit = true;
        boolean allowDelete = false;
        RowData listModulesDetail = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setListModulesOptionData((String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 2));
            }

            @Override
            public void handleEdit() {
                EditListModulesDialog dialog = new EditListModulesDialog(this.getText());
                String newList = dialog.showDialog();
                if (newList != null) {
                    this.setText(newList);
                    RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newList, this.getRow(), 2);
                }
                RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
            }
        };
        listModulesDetail.setPlaceholderText(placeholderText);
        listModulesDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(100));
        return listModulesDetail;
    }

    private RowData getShowModuleGraphResolutionHeader(RunConfiguration runConfiguration) {
        String rowName = "Show Module Graph Resolution header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasShowModuleGraphResolutionOption();
        String text = "Show Module Graph Resolution";
        String helpText = RunConfigModuleSupportArb.getString(67);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData showResolutionHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasShowModuleGraphResolutionOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        showResolutionHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(101));
        return showResolutionHeader;
    }

    private RowData getShowModuleGraphResolutionDetail(RunConfiguration runConfiguration) {
        String rowName = "Show Module Graph Resolution detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = "-Xdiag:resolver";
        String helpText = RunConfigModuleSupportArb.getString(55);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData showResolutionDetail = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete);
        showResolutionDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(102));
        return showResolutionDetail;
    }

    private RowData getDebugModuleAccessChecksHeader(RunConfiguration runConfiguration) {
        String rowName = "DebugModuleAccessChecks header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasDebugModuleAccessChecksOption();
        String text = RunConfigModuleSupportArb.getString(16);
        String helpText = RunConfigModuleSupportArb.getString(68);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData debugModuleAccessChecksHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasDebugModuleAccessChecksOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        debugModuleAccessChecksHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(103));
        return debugModuleAccessChecksHeader;
    }

    private RowData getDebugModuleAccessChecksDetail(RunConfiguration runConfiguration) {
        String rowName = "DebugModuleAccessChecks detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String text = "-Dsun.reflect.debugModuleAccessChecks";
        String helpText = RunConfigModuleSupportArb.getString(55);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData debugAcccessChecksDetail = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete);
        debugAcccessChecksDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(104));
        return debugAcccessChecksDetail;
    }

    private RowData getTraceModuleDefinitionChangesHeader(RunConfiguration runConfiguration) {
        String rowName = "Trace module definition changes header";
        Boolean contentSelected = null;
        Boolean categorySelected = runConfiguration.hasTraceModuleDefinitionChangesOption();
        String text = RunConfigModuleSupportArb.getString(17);
        String helpText = RunConfigModuleSupportArb.getString(69);
        boolean allowAdd = false;
        boolean allowEdit = false;
        boolean allowDelete = false;
        RowData traceChangesHeader = new RowData(rowName, categorySelected, contentSelected, text, helpText, allowAdd, allowEdit, allowDelete){

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setHasTraceModuleDefinitionChangesOption((Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 0));
            }
        };
        traceChangesHeader.setAccessibleRowName(RunConfigModuleSupportArb.getString(105));
        return traceChangesHeader;
    }

    private RowData getTraceModuleDefinitionChangesDetail(RunConfiguration runConfiguration) {
        String rowName = "Trace module definition changes detail";
        Boolean contentSelected = null;
        Boolean categorySelected = null;
        String savedText = runConfiguration.getTraceModuleDefinitionChangesLevel();
        String text = savedText == null ? "-Xlog:modules=" : savedText;
        String placeholderText = RunConfigModuleSupportArb.getString(26);
        boolean allowAdd = false;
        boolean allowEdit = true;
        boolean allowDelete = false;
        RowData traceChangesDetail = new RowData(rowName, categorySelected, contentSelected, text, null, allowAdd, allowEdit, allowDelete){

            @Override
            public void handleEdit() {
                EditTraceModuleChangesDialog dialog = new EditTraceModuleChangesDialog(this.getText());
                String newOption = dialog.showDialog();
                if (newOption != null) {
                    this.setText(newOption);
                    RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newOption, this.getRow(), 2);
                }
                RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
            }

            @Override
            public void save(RunConfiguration runConfiguration) {
                runConfiguration.setTraceModuleDefinitionChangesLevel((String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), 2));
            }
        };
        traceChangesDetail.setPlaceholderText(placeholderText);
        traceChangesDetail.setAccessibleRowName(RunConfigModuleSupportArb.getString(106));
        return traceChangesDetail;
    }

    public void onEntry(TraversableContext tc) {
        this.runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)tc);
        this.loadFrom(this.runConfiguration);
    }

    public void onExit(TraversableContext tc) {
        this.commitTo(this.runConfiguration);
    }

    private void loadFrom(RunConfiguration runConfiguration) {
        RowData modulePathCategory = this.getModulePathCategoryData(runConfiguration);
        this.tableContent.add(modulePathCategory);
        modulePathCategory.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(modulePathCategory);
        RowData modulePathFromCPHeader = this.getModulePathFromCPHeader(runConfiguration);
        this.tableContent.add(modulePathFromCPHeader);
        modulePathCategory.addChild(modulePathFromCPHeader);
        modulePathFromCPHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(modulePathFromCPHeader);
        RowData modulePathFromCPDetail = this.getModulePathFromCPDetail(runConfiguration);
        this.tableContent.add(modulePathFromCPDetail);
        modulePathFromCPHeader.addChild(modulePathFromCPDetail);
        modulePathFromCPDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(modulePathFromCPDetail);
        RowData modulePathFromUserHeader = this.getModulePathFromUserHeader(runConfiguration);
        this.tableContent.add(modulePathFromUserHeader);
        modulePathCategory.addChild(modulePathFromUserHeader);
        modulePathFromUserHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(modulePathFromUserHeader);
        RowData modulePathFromUserDetail = this.getModulePathFromUserDetail(runConfiguration);
        this.tableContent.add(modulePathFromUserDetail);
        modulePathFromUserHeader.addChild(modulePathFromUserDetail);
        modulePathFromUserDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(modulePathFromUserDetail);
        RowData addModulesCategory = this.getAddModulesCategoryData(runConfiguration);
        this.tableContent.add(addModulesCategory);
        addModulesCategory.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(addModulesCategory);
        RowData addModulesFromCPHeader = this.getAddModulesFromCPHeader(runConfiguration);
        this.tableContent.add(addModulesFromCPHeader);
        addModulesCategory.addChild(addModulesFromCPHeader);
        addModulesFromCPHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(addModulesFromCPHeader);
        RowData addModulesFromCPDetail = this.getAddModulesFromCPDetail(runConfiguration);
        this.tableContent.add(addModulesFromCPDetail);
        addModulesFromCPHeader.addChild(addModulesFromCPDetail);
        addModulesFromCPDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(addModulesFromCPDetail);
        RowData addModulesFromUserHeader = this.getAddModulesFromUserHeader(runConfiguration);
        this.tableContent.add(addModulesFromUserHeader);
        addModulesCategory.addChild(addModulesFromUserHeader);
        addModulesFromUserHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(addModulesFromUserHeader);
        RowData addModulesFromUserDetail = this.getAddModulesFromUserDetail(runConfiguration);
        this.tableContent.add(addModulesFromUserDetail);
        addModulesFromUserHeader.addChild(addModulesFromUserDetail);
        addModulesFromUserDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(addModulesFromUserDetail);
        RowData moduleHeader = this.getModuleHeader(runConfiguration);
        this.tableContent.add(moduleHeader);
        moduleHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(moduleHeader);
        RowData moduleDetail = this.getModuleDetail(runConfiguration);
        this.tableContent.add(moduleDetail);
        moduleHeader.addChild(moduleDetail);
        moduleDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(moduleDetail);
        RowData addReadsHeader = this.getAddReadsHeader(runConfiguration);
        this.tableContent.add(addReadsHeader);
        addReadsHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(addReadsHeader);
        RowGroup addReadsGroup = new RowGroup(addReadsHeader);
        addReadsGroup.setContentClass(AddReadsDetailRowData.class);
        List<RowData> addReadsDetails = this.getAddReadsDetail(runConfiguration);
        for (RowData addReadsDetail : addReadsDetails) {
            this.tableContent.add(addReadsDetail);
            addReadsHeader.addChild(addReadsDetail);
            addReadsDetail.setRow(this.tableContent.size() - 1);
            this.moduleOptionsModel.populateFromRowData(addReadsDetail);
            addReadsGroup.addDetail(addReadsDetail);
        }
        addReadsGroup.enableButtons();
        RowData addExportsHeader = this.getAddExportsHeader(runConfiguration);
        this.tableContent.add(addExportsHeader);
        addExportsHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(addExportsHeader);
        RowGroup addExportsGroup = new RowGroup(addExportsHeader);
        addExportsGroup.setContentClass(AddExportsDetailRowData.class);
        List<RowData> addExportsDetails = this.getAddExportsDetail(runConfiguration);
        for (RowData addExportsDetail : addExportsDetails) {
            this.tableContent.add(addExportsDetail);
            addExportsHeader.addChild(addExportsDetail);
            addExportsDetail.setRow(this.tableContent.size() - 1);
            this.moduleOptionsModel.populateFromRowData(addExportsDetail);
            addExportsGroup.addDetail(addExportsDetail);
        }
        addExportsGroup.enableButtons();
        RowData upgradeModulePathHeader = this.getUpgradeModulePathHeader(runConfiguration);
        this.tableContent.add(upgradeModulePathHeader);
        upgradeModulePathHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(upgradeModulePathHeader);
        RowData upgradeModulePathDetail = this.getUpgradeModulePathDetail(runConfiguration);
        this.tableContent.add(upgradeModulePathDetail);
        upgradeModulePathHeader.addChild(upgradeModulePathDetail);
        upgradeModulePathDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(upgradeModulePathDetail);
        RowData limitModulesHeader = this.getLimitModulesHeader(runConfiguration);
        this.tableContent.add(limitModulesHeader);
        limitModulesHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(limitModulesHeader);
        RowData limitModulesDetail = this.getLimitModulesDetail(runConfiguration);
        this.tableContent.add(limitModulesDetail);
        limitModulesHeader.addChild(limitModulesDetail);
        limitModulesDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(limitModulesDetail);
        RowData patchModuleHeader = this.getPatchModuleHeader(runConfiguration);
        this.tableContent.add(patchModuleHeader);
        patchModuleHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(patchModuleHeader);
        RowGroup patchModuleGroup = new RowGroup(patchModuleHeader);
        patchModuleGroup.setContentClass(PatchModuleDetailRowData.class);
        List<RowData> patchModuleDetails = this.getPatchModuleDetail(runConfiguration);
        for (RowData patchModuleDetail : patchModuleDetails) {
            this.tableContent.add(patchModuleDetail);
            patchModuleHeader.addChild(patchModuleDetail);
            patchModuleDetail.setRow(this.tableContent.size() - 1);
            this.moduleOptionsModel.populateFromRowData(patchModuleDetail);
            patchModuleGroup.addDetail(patchModuleDetail);
        }
        patchModuleGroup.enableButtons();
        RowData listModulesHeader = this.getListModulesHeader(runConfiguration);
        this.tableContent.add(listModulesHeader);
        listModulesHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(listModulesHeader);
        RowData listModulesDetail = this.getListModulesDetail(runConfiguration);
        this.tableContent.add(listModulesDetail);
        listModulesHeader.addChild(listModulesDetail);
        listModulesDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(listModulesDetail);
        RowData showResolutionHeader = this.getShowModuleGraphResolutionHeader(runConfiguration);
        this.tableContent.add(showResolutionHeader);
        showResolutionHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(showResolutionHeader);
        RowData showResolutionDetail = this.getShowModuleGraphResolutionDetail(runConfiguration);
        this.tableContent.add(showResolutionDetail);
        showResolutionHeader.addChild(showResolutionDetail);
        showResolutionDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(showResolutionDetail);
        RowData debugAccessHeader = this.getDebugModuleAccessChecksHeader(runConfiguration);
        this.tableContent.add(debugAccessHeader);
        debugAccessHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(debugAccessHeader);
        RowData debugAccessDetail = this.getDebugModuleAccessChecksDetail(runConfiguration);
        this.tableContent.add(debugAccessDetail);
        debugAccessHeader.addChild(debugAccessDetail);
        debugAccessDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(debugAccessDetail);
        RowData moduleChangesHeader = this.getTraceModuleDefinitionChangesHeader(runConfiguration);
        this.tableContent.add(moduleChangesHeader);
        moduleChangesHeader.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(moduleChangesHeader);
        RowData moduleChangesDetail = this.getTraceModuleDefinitionChangesDetail(runConfiguration);
        this.tableContent.add(moduleChangesDetail);
        moduleChangesHeader.addChild(moduleChangesDetail);
        moduleChangesDetail.setRow(this.tableContent.size() - 1);
        this.moduleOptionsModel.populateFromRowData(moduleChangesDetail);
        this.revalidate();
        this.moduleOptionsTable.revalidate();
        for (RowData data : this.tableContent) {
            if (data.allowCategorySelection() && !data.categorySelected()) {
                data.selectionChanged(0);
                continue;
            }
            if (!data.allowContentSelection() || data.contentSelected()) continue;
            data.selectionChanged(1);
        }
        this.moduleOptionsModel.addTableModelListener(e -> {
            if (e.getType() == 1 || e.getType() == -1) {
                return;
            }
            int row = e.getFirstRow();
            int column = e.getColumn();
            RowData data = this.tableContent.get(row);
            switch (column) {
                case 0: {
                    boolean value = (Boolean)this.moduleOptionsTable.getValueAt(row, column);
                    data.selectionChanged(column);
                    break;
                }
                case 1: {
                    boolean value = (Boolean)this.moduleOptionsTable.getValueAt(row, column);
                    data.selectionChanged(column);
                    break;
                }
                case 2: {
                    String value = (String)this.moduleOptionsTable.getValueAt(row, column);
                    logger.trace("TableModelEvent: row " + row + " content " + data.getText() + " -> " + value);
                    data.textChanged(column);
                    if (data.getRowGroup() == null) break;
                    data.getRowGroup().enableButtons();
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    logger.trace("TableModelEvent: unexpected change for row " + row + " column " + column);
                }
            }
        });
    }

    private void commitTo(RunConfiguration runConfiguration) {
        for (RowData row : this.tableContent) {
            row.save(runConfiguration);
        }
    }

    private TableColumnModel getTableColumnModel() {
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        JCheckBox sampleCB = new JCheckBox();
        TableColumn tc0 = new TableColumn(0);
        tc0.setPreferredWidth(sampleCB.getPreferredSize().width);
        tcm.addColumn(tc0);
        TableColumn tc1 = new TableColumn(1);
        tc1.setPreferredWidth(sampleCB.getPreferredSize().width);
        tcm.addColumn(tc1);
        TableColumn tc2 = new TableColumn(2);
        tc2.setPreferredWidth(1000);
        tcm.addColumn(tc2);
        TableColumn tc3 = new TableColumn(3);
        tc3.setPreferredWidth(OracleIcons.getIcon((String)"help.png").getIconWidth() + 5);
        tcm.addColumn(tc3);
        TableColumn tc4 = new TableColumn(4);
        tc4.setPreferredWidth(OracleIcons.getIcon((String)"edit.png").getIconWidth() + 5);
        tcm.addColumn(tc4);
        TableColumn tc5 = new TableColumn(5);
        tc5.setPreferredWidth(OracleIcons.getIcon((String)"delete.png").getIconWidth() + 5);
        tcm.addColumn(tc5);
        TableColumn tc6 = new TableColumn(6);
        tc6.setPreferredWidth(OracleIcons.getIcon((String)"add.png").getIconWidth() + 5);
        tcm.addColumn(tc6);
        return tcm;
    }

    private class ContentRenderer
    extends DefaultTableCellRenderer {
        private ContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String accessibleDescription;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelRow = table.convertRowIndexToModel(row);
            RowData data = RunConfigurationModuleOptionsPanel.this.tableContent.get(modelRow);
            if (data.allowEdit()) {
                Border b = BorderFactory.createLineBorder(Color.BLACK, 1);
                label.setBorder(b);
            }
            if (data.getText() == null || data.getText().isEmpty()) {
                if (data.getPlaceholderText() != null) {
                    label.setText(data.getPlaceholderText());
                    label.setForeground(Color.gray);
                }
            } else {
                label.setForeground(Color.black);
            }
            if (data.getFontAttributes() != 0) {
                Font currentFont = label.getFont();
                label.setFont(currentFont.deriveFont(data.getFontAttributes()));
            }
            AccessibleContext ac = label.getAccessibleContext();
            String accessibleName = data.accessibleName(column);
            if (accessibleName != null) {
                ac.setAccessibleName(accessibleName);
            }
            if ((accessibleDescription = data.accessibleDescription(column)) != null) {
                ac.setAccessibleDescription(accessibleDescription);
            }
            return label;
        }
    }

    private class ModuleOptionsModel
    extends DefaultTableModel {
        private ModuleOptionsModel() {
        }

        public void populateFromRowData(RowData row) {
            Boolean categorySelected = row.allowCategorySelection() ? Boolean.valueOf(row.categorySelected()) : null;
            Boolean contentSelected = row.allowContentSelection() ? Boolean.valueOf(row.contentSelected()) : null;
            this.addRow(new Object[]{categorySelected, contentSelected, row.text(), row.helpIcon(), row.editIcon(), row.deleteIcon(), row.addIcon()});
        }

        public void insertFromRowData(int index, RowData row) {
            Boolean categorySelected = row.allowCategorySelection() ? Boolean.valueOf(row.categorySelected()) : null;
            Boolean contentSelected = row.allowContentSelection() ? Boolean.valueOf(row.contentSelected()) : null;
            this.insertRow(index, new Object[]{categorySelected, contentSelected, row.text(), row.helpIcon(), row.editIcon(), row.deleteIcon(), row.addIcon()});
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: 
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return Icon.class;
                }
            }
            return Object.class;
        }
    }

    private class ModuleOptionsTable
    extends JTable {
        public ModuleOptionsTable(TableModel tm, TableColumnModel tcm) {
            super(tm, tcm);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            RowData data = RunConfigurationModuleOptionsPanel.this.tableContent.get(row);
            if (!data.isEnabled()) {
                return false;
            }
            if (column == 0) {
                return RunConfigurationModuleOptionsPanel.this.tableContent.get(row).allowCategorySelection();
            }
            if (column == 1) {
                return RunConfigurationModuleOptionsPanel.this.tableContent.get(row).allowContentSelection();
            }
            if (column == 2) {
                boolean isEditable = RunConfigurationModuleOptionsPanel.this.tableContent.get(row).allowEdit();
                return isEditable;
            }
            return false;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer = this.getValueAt(row, column) instanceof Boolean ? super.getDefaultRenderer(Boolean.class) : (this.getValueAt(row, column) instanceof Icon ? super.getDefaultRenderer(Icon.class) : (column == 2 ? RunConfigurationModuleOptionsPanel.this.contentRenderer : super.getDefaultRenderer(Object.class)));
            Object value = this.getValueAt(row, column);
            boolean isSelected = false;
            boolean hasFocus = false;
            JComponent c = (JComponent)renderer.getTableCellRendererComponent(RunConfigurationModuleOptionsPanel.this.moduleOptionsTable, value, isSelected, hasFocus, row, column);
            RowData data = RunConfigurationModuleOptionsPanel.this.tableContent.get(row);
            if (!data.isEnabled()) {
                c.setBackground(new Color(0, 0, 0, 25));
            } else {
                c.setBackground(RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.getBackground());
            }
            switch (column) {
                case 2: {
                    c.setToolTipText(data.getText());
                    break;
                }
                case 3: {
                    c.setToolTipText(data.helpText());
                    break;
                }
                case 6: {
                    c.setToolTipText(RunConfigModuleSupportArb.getString(27));
                    break;
                }
                case 4: {
                    c.setToolTipText(RunConfigModuleSupportArb.getString(28));
                    break;
                }
                case 5: {
                    c.setToolTipText(RunConfigModuleSupportArb.getString(29));
                }
            }
            return renderer;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (this.getValueAt(row, column) instanceof Boolean) {
                TableCellEditor editor = super.getDefaultEditor(Boolean.class);
                return editor;
            }
            if (column == 2) {
                TableCellEditor editor = super.getDefaultEditor(String.class);
                return editor;
            }
            return super.getDefaultEditor(Object.class);
        }
    }

    class RowData {
        private String name;
        private String accessibleRowName;
        private boolean showCategorySelectionCheckbox;
        private boolean categorySelected;
        private boolean showContentSelectionCheckbox;
        private boolean contentSelected;
        private String text;
        private String placeholderText;
        private int textAttributes = 0;
        private String helpText;
        private boolean allowAdd;
        private boolean allowDelete;
        private boolean allowEdit;
        private int row = -1;
        private List<RowData> children = new ArrayList<RowData>();
        private boolean enabled = true;
        private RowGroup memberOfGroup;
        private Icon help;
        private Icon add;
        private Icon edit;
        private Icon delete;

        RowData(String rowName, Boolean categorySelector, Boolean contentSelector, String text, String helpText, boolean allowsAdd, boolean allowsEdit, boolean allowsDelete) {
            this.name = rowName;
            boolean bl = this.showCategorySelectionCheckbox = categorySelector != null;
            if (categorySelector != null) {
                this.categorySelected = categorySelector;
            }
            boolean bl2 = this.showContentSelectionCheckbox = contentSelector != null;
            if (contentSelector != null) {
                this.contentSelected = contentSelector;
            }
            this.text = text;
            if (helpText != null) {
                this.help = OracleIcons.getIcon((String)"help.png");
                this.helpText = helpText;
            }
            if (allowsAdd) {
                this.allowAdd = true;
                this.add = OracleIcons.getIcon((String)"add.png");
            }
            if (allowsEdit) {
                this.allowEdit = true;
                this.edit = OracleIcons.getIcon((String)"edit.png");
            }
            if (allowsDelete) {
                this.allowDelete = true;
                this.delete = OracleIcons.getIcon((String)"delete.png");
            }
        }

        void setAllowAdd(boolean allow) {
            this.allowAdd = allow;
            Icon icon = allow ? OracleIcons.getIcon((String)"add.png") : null;
            RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(icon, this.getRow(), 6);
        }

        void setAllowDelete(boolean allow) {
            this.allowDelete = allow;
            Icon icon = allow ? OracleIcons.getIcon((String)"delete.png") : null;
            RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(icon, this.getRow(), 5);
        }

        void setAccessibleRowName(String aname) {
            this.accessibleRowName = aname;
        }

        void addChild(RowData child) {
            this.children.add(child);
        }

        void removeChild(RowData child) {
            if (child.children != null && child.children.size() > 0) {
                throw new IllegalStateException("Deleting child " + child.name() + " that has attached children");
            }
            this.children.remove(child);
        }

        void setMemberOfGroup(RowGroup group) {
            this.memberOfGroup = group;
        }

        RowGroup getRowGroup() {
            return this.memberOfGroup;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        void setFontAttributes(int attributes) {
            this.textAttributes = attributes;
        }

        int getFontAttributes() {
            return this.textAttributes;
        }

        String getText() {
            return this.text;
        }

        String getPlaceholderText() {
            return this.placeholderText;
        }

        void setPlaceholderText(String text) {
            this.placeholderText = text;
        }

        void setText(String text) {
            this.text = text;
        }

        void setEnabled(boolean enabled) {
            this.enabled = enabled;
            for (RowData child : this.children) {
                logger.trace("Cascading enabled=" + enabled + " from " + this.name() + " to " + child.name());
                child.setEnabled(enabled);
            }
        }

        String name() {
            return this.name;
        }

        boolean allowCategorySelection() {
            return this.showCategorySelectionCheckbox;
        }

        boolean categorySelected() {
            return this.categorySelected;
        }

        boolean allowContentSelection() {
            return this.showContentSelectionCheckbox;
        }

        boolean contentSelected() {
            return this.contentSelected;
        }

        String text() {
            return this.text;
        }

        Icon helpIcon() {
            return this.help;
        }

        String helpText() {
            return this.helpText;
        }

        Icon addIcon() {
            return this.add;
        }

        boolean allowEdit() {
            return this.allowEdit;
        }

        Icon editIcon() {
            return this.edit;
        }

        Icon deleteIcon() {
            return this.delete;
        }

        String accessibleName(int column) {
            String state = "";
            switch (column) {
                case 0: {
                    state = !this.isEnabled() ? RunConfigModuleSupportArb.getString(73) : (this.categorySelected ? RunConfigModuleSupportArb.getString(71) : RunConfigModuleSupportArb.getString(72));
                    return RunConfigModuleSupportArb.format(70, this.accessibleRowName, state);
                }
                case 1: {
                    state = !this.isEnabled() ? RunConfigModuleSupportArb.getString(73) : (this.contentSelected ? RunConfigModuleSupportArb.getString(71) : RunConfigModuleSupportArb.getString(72));
                    return RunConfigModuleSupportArb.format(70, this.accessibleRowName, state);
                }
                case 2: {
                    return this.text;
                }
                case 3: {
                    return this.helpText;
                }
                case 4: {
                    return RunConfigModuleSupportArb.format(74, this.accessibleRowName);
                }
                case 6: {
                    return RunConfigModuleSupportArb.format(75, this.accessibleRowName);
                }
                case 5: {
                    state = RunConfigModuleSupportArb.getString(76);
                }
            }
            return this.text;
        }

        String accessibleDescription(int column) {
            return null;
        }

        void setRow(int newRow) {
            this.row = newRow;
        }

        int getRow() {
            return this.row;
        }

        void selectionChanged(int column) {
            Boolean value = (Boolean)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), column);
            for (RowData child : this.children) {
                child.setEnabled(value);
            }
            RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint(50L);
        }

        void textChanged(int column) {
            String value = (String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(this.getRow(), column);
            this.setText(value);
        }

        void handleAdd() {
            if (!this.allowAdd) {
                return;
            }
            int locationOfInsert = this.getRow() + 1;
            RowGroup group = this.getRowGroup();
            if (!group.allowAdd()) {
                return;
            }
            RowData rowToInsert = group.insertNewRow();
            rowToInsert.setRow(locationOfInsert);
            rowToInsert.setPlaceholderText(this.placeholderText);
            rowToInsert.setAccessibleRowName(RunConfigModuleSupportArb.getString(88));
            RunConfigurationModuleOptionsPanel.this.tableContent.add(locationOfInsert, rowToInsert);
            RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.insertFromRowData(locationOfInsert, rowToInsert);
            for (int i = locationOfInsert + 1; i < RunConfigurationModuleOptionsPanel.this.tableContent.size(); ++i) {
                RowData data = RunConfigurationModuleOptionsPanel.this.tableContent.get(i);
                data.setRow(data.getRow() + 1);
            }
            group.enableButtons();
        }

        void handleDelete() {
            if (!this.allowDelete) {
                return;
            }
            int locationOfDelete = this.getRow();
            RowGroup group = this.getRowGroup();
            RowData removed = RunConfigurationModuleOptionsPanel.this.tableContent.remove(locationOfDelete);
            group.getHeaderRow().removeChild(removed);
            group.removeDetail(removed);
            RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.removeRow(locationOfDelete);
            for (int i = locationOfDelete; i < RunConfigurationModuleOptionsPanel.this.tableContent.size(); ++i) {
                RowData data = RunConfigurationModuleOptionsPanel.this.tableContent.get(i);
                data.setRow(data.getRow() - 1);
            }
            group.enableButtons();
        }

        void handleEdit() {
            logger.trace("base handleEdit should never be called");
        }

        void save(RunConfiguration runConfig) {
            logger.trace("RowData default nop save() called for " + this.name() + "; nothing saved to RunConfig.");
        }
    }

    public class AddReadsDetailRowData
    extends RowData {
        private static final String arRowName = "--add-reads detail";

        public AddReadsDetailRowData() {
            this(null, false);
        }

        AddReadsDetailRowData(String addReadsOption, boolean selected) {
            super(arRowName, null, selected, addReadsOption, null, true, true, false);
        }

        @Override
        void handleEdit() {
            EditAddReadsDialog dialog = new EditAddReadsDialog(this.getText());
            String newAddRead = dialog.showDialog();
            if (newAddRead != null) {
                this.setText(newAddRead);
                RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newAddRead, this.getRow(), 2);
            }
            RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
        }

        @Override
        void save(RunConfiguration runConfiguration) {
            if (this.getRowGroup().isDirty()) {
                List<String> storableContent = this.getRowGroup().prepareForSave();
                runConfiguration.setAddReadsOptionData(storableContent);
                List<Boolean> contentSelections = this.getRowGroup().getDetailSelections();
                runConfiguration.setAddReadsDetailsSelected(contentSelections);
            }
        }
    }

    public class AddExportsDetailRowData
    extends RowData {
        private static final String aeRowName = "--add-exports detail";

        public AddExportsDetailRowData() {
            this(null, false);
        }

        AddExportsDetailRowData(String addExportsOption, boolean selected) {
            super(aeRowName, null, selected, addExportsOption, null, true, true, false);
        }

        @Override
        void handleEdit() {
            EditAddExportsDialog dialog = new EditAddExportsDialog(this.getText());
            String newAddExport = dialog.showDialog();
            if (newAddExport != null) {
                this.setText(newAddExport);
                RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newAddExport, this.getRow(), 2);
            }
            RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
        }

        @Override
        void save(RunConfiguration runConfiguration) {
            if (this.getRowGroup().isDirty()) {
                List<String> storableContent = this.getRowGroup().prepareForSave();
                runConfiguration.setAddExportsOptionData(storableContent);
                List<Boolean> contentSelections = this.getRowGroup().getDetailSelections();
                runConfiguration.setAddExportsDetailsSelected(contentSelections);
            }
        }
    }

    public class PatchModuleDetailRowData
    extends RowData {
        private static final String pmRowName = "--patch-module detail";

        public PatchModuleDetailRowData() {
            this(null, false);
        }

        PatchModuleDetailRowData(String patchModuleOption, boolean selected) {
            super(pmRowName, null, selected, patchModuleOption, null, true, true, false);
        }

        @Override
        void handleEdit() {
            EditPatchModuleDialog dialog = new EditPatchModuleDialog(this.getText());
            String newPatch = dialog.showDialog();
            if (newPatch != null) {
                this.setText(newPatch);
                RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.setValueAt(newPatch, this.getRow(), 2);
            }
            RunConfigurationModuleOptionsPanel.this.moduleOptionsTable.repaint();
        }

        @Override
        void save(RunConfiguration runConfiguration) {
            if (this.getRowGroup().isDirty()) {
                List<String> storableContent = this.getRowGroup().prepareForSave();
                runConfiguration.setPatchModuleOptionData(storableContent);
                List<Boolean> contentSelections = this.getRowGroup().getDetailSelections();
                runConfiguration.setPatchModuleDetailsSelected(contentSelections);
            }
        }
    }

    private class RowGroup {
        private RowData headerRow;
        private List<RowData> detailRows;
        private int firstDetailRowNumber = -1;
        private int detailCount = 0;
        private boolean isDirty = false;
        private Class<? extends RowData> contentClass;
        private List<Boolean> detailSelections;

        public RowGroup(RowData headerRow) {
            this.headerRow = headerRow;
            this.detailRows = new ArrayList<RowData>();
            this.detailCount = 0;
            headerRow.setMemberOfGroup(this);
        }

        public void setContentClass(Class<? extends RowData> contentClass) {
            this.contentClass = contentClass;
        }

        public RowData getHeaderRow() {
            return this.headerRow;
        }

        public RowData insertNewRow() {
            try {
                Constructor[] cs = this.contentClass.getDeclaredConstructors();
                System.out.println("c array " + cs);
                Constructor<? extends RowData> c = this.contentClass.getDeclaredConstructor(RunConfigurationModuleOptionsPanel.class);
                System.out.println("c " + c);
                RowData newDetailRow = c.newInstance(new Object[]{RunConfigurationModuleOptionsPanel.this});
                this.getHeaderRow().addChild(newDetailRow);
                this.addDetail(newDetailRow);
                newDetailRow.setMemberOfGroup(this);
                this.addDetail(newDetailRow);
                return newDetailRow;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        public void addDetail(RowData detail) {
            if (this.firstDetailRowNumber == -1) {
                this.firstDetailRowNumber = detail.getRow();
            }
            this.detailRows.add(detail);
            detail.setMemberOfGroup(this);
            ++this.detailCount;
            this.isDirty = true;
        }

        public void removeDetail(RowData detail) {
            this.detailRows.remove(detail);
            --this.detailCount;
            this.isDirty = true;
        }

        public boolean allowAdd() {
            for (RowData detail : this.detailRows) {
                if (detail.getText() != null && !detail.getText().isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean allowDelete() {
            return this.detailCount > 1;
        }

        public List<String> prepareForSave() {
            ArrayList<String> contentToSave = new ArrayList<String>();
            this.detailSelections = new ArrayList<Boolean>();
            for (RowData detail : this.detailRows) {
                String modelContent;
                String rowContent = detail.getText();
                if (!rowContent.equals(modelContent = (String)RunConfigurationModuleOptionsPanel.this.moduleOptionsModel.getValueAt(detail.getRow(), 2))) {
                    detail.setText(modelContent);
                }
                contentToSave.add(detail.getText());
                this.detailSelections.add(detail.contentSelected());
            }
            this.isDirty = false;
            return contentToSave;
        }

        public List<Boolean> getDetailSelections() {
            return this.detailSelections;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void enableButtons() {
            for (RowData detail : this.detailRows) {
                detail.setAllowAdd(this.allowAdd());
                detail.setAllowDelete(this.allowDelete());
            }
        }
    }

    private class EditTraceModuleChangesDialog
    extends AbstractDialog {
        private JRadioButton traceButton;
        private JRadioButton debugButton;

        EditTraceModuleChangesDialog(String currentContent) {
            super(currentContent);
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(52));
            ButtonGroup bg = new ButtonGroup();
            this.traceButton = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.traceButton, (String)RunConfigModuleSupportArb.getString(36));
            this.traceButton.addActionListener(e -> this.updateCurrentContent());
            bg.add(this.traceButton);
            this.debugButton = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.debugButton, (String)RunConfigModuleSupportArb.getString(37));
            this.debugButton.addActionListener(e -> this.updateCurrentContent());
            bg.add(this.debugButton);
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.traceButton, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.debugButton, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            if (this.initialContent != null) {
                String[] tokens = this.initialContent.split("=");
                if (tokens.length != 2) {
                    return;
                }
                if (tokens[1].equalsIgnoreCase("TRACE")) {
                    this.traceButton.setSelected(true);
                } else if (tokens[1].equalsIgnoreCase("DEBUG")) {
                    this.debugButton.setSelected(true);
                }
            }
        }

        @Override
        void updateCurrentContent() {
            if (this.traceButton.isSelected()) {
                this.currentContentText.setText("Xlog:modules=TRACE");
            } else if (this.debugButton.isSelected()) {
                this.currentContentText.setText("Xlog:modules=DEBUG");
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(9);
            return super.showDialog(title, this.traceButton);
        }
    }

    private class EditListModulesDialog
    extends AbstractDialog {
        private JComboBox<String> knownModulesCombo;

        EditListModulesDialog(String currentContent) {
            super(currentContent);
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(39));
            this.knownModulesCombo = new JComboBox();
            this.knownModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.knownModulesCombo, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.resetComboModelFromModuleList(this.initialContent);
        }

        private void resetComboModelFromModuleList(String list) {
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            if (list != null) {
                String[] modules;
                for (String module : modules = list.split(",")) {
                    knownModuleNames.remove(module);
                }
            }
            super.resetModuleComboModel(this.knownModulesCombo, knownModuleNames);
        }

        @Override
        void updateCurrentContent() {
            if (this.knownModulesCombo.getSelectedIndex() != -1) {
                String current = this.currentContentText.getText();
                if (current != null && current.startsWith("ALL-")) {
                    this.currentContentText.setText("");
                }
                if (this.currentContentText.getText().isEmpty()) {
                    this.currentContentText.setText(this.knownModulesCombo.getSelectedItem().toString());
                } else {
                    this.currentContentText.setText(current + "," + this.knownModulesCombo.getSelectedItem());
                }
            }
            this.enableControls();
        }

        private void enableControls() {
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(1);
            return super.showDialog(title, this.knownModulesCombo);
        }
    }

    private class EditPatchModuleDialog
    extends AbstractDialog {
        private JLabel selectSourceModuleLabel;
        private JComboBox<String> sourceModulesCombo;
        private String previousSourceModuleSelection;
        private JLabel sourcePackageLabel;
        private JTextField sourcePackageText;
        private JLabel selectTargetModuleLabel;
        private JRadioButton selectTargetRadio;
        private JComboBox<String> targetModulesCombo;
        private String previousTargetModuleSelection;
        private JRadioButton selectAllUnnamedRadio;
        private boolean nonUserUpdate;

        EditPatchModuleDialog(String initialContent) {
            super(initialContent);
            this.nonUserUpdate = false;
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(50));
            this.selectSourceModuleLabel = new JLabel();
            this.sourceModulesCombo = new JComboBox();
            ResourceUtils.resLabel((JLabel)this.selectSourceModuleLabel, this.sourceModulesCombo, (String)RunConfigModuleSupportArb.getString(45));
            this.sourceModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.sourcePackageLabel = new JLabel();
            this.sourcePackageText = new JTextField(120);
            ResourceUtils.resLabel((JLabel)this.sourcePackageLabel, (Component)this.sourcePackageText, (String)RunConfigModuleSupportArb.getString(53));
            this.sourcePackageText.addActionListener(e -> this.updateCurrentContent());
            this.selectTargetModuleLabel = new JLabel();
            this.targetModulesCombo = new JComboBox();
            ResourceUtils.resLabel((JLabel)this.selectTargetModuleLabel, this.targetModulesCombo, (String)RunConfigModuleSupportArb.getString(46));
            this.targetModulesCombo.addActionListener(e -> this.updateCurrentContent());
            ButtonGroup bg = new ButtonGroup();
            this.selectTargetRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.selectTargetRadio, (String)RunConfigModuleSupportArb.getString(35));
            this.selectTargetRadio.addActionListener(e -> {
                this.updateCurrentContent();
                this.enableButtons();
            });
            bg.add(this.selectTargetRadio);
            this.selectAllUnnamedRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.selectAllUnnamedRadio, (String)"&ALL-UNNAMED");
            this.selectAllUnnamedRadio.addActionListener(e -> {
                this.updateCurrentContent();
                this.enableButtons();
            });
            bg.add(this.selectAllUnnamedRadio);
            this.selectAllUnnamedRadio.setSelected(true);
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectSourceModuleLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.sourceModulesCombo, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.sourcePackageLabel, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.sourcePackageText, new GridBagConstraints(3, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectTargetModuleLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectTargetRadio, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.targetModulesCombo, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectAllUnnamedRadio, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.nonUserUpdate = true;
            if (this.initialContent == null || this.initialContent.length() == 0) {
                return;
            }
            this.currentContentText.setText(this.initialContent);
            String[] tokens = this.initialContent.split("=");
            if (tokens.length != 2) {
                logger.trace("EditPatchModuleDialog.parseInitialContent(): expected 2 tokens, found " + tokens.length);
            }
            String[] moduleAndPackage = tokens[0].split("/");
            this.sourceModulesCombo.setSelectedItem(moduleAndPackage[0].trim());
            if (moduleAndPackage.length >= 2) {
                this.sourcePackageText.setText(moduleAndPackage[1].trim());
            }
            if ("ALL-UNNAMED".equals(tokens[1].trim())) {
                this.selectAllUnnamedRadio.setSelected(true);
            } else {
                this.selectTargetRadio.setSelected(true);
                this.targetModulesCombo.setSelectedItem(tokens[1].trim());
            }
            this.nonUserUpdate = false;
        }

        @Override
        void updateCurrentContent() {
            String selectedModule;
            if (this.nonUserUpdate) {
                return;
            }
            this.nonUserUpdate = true;
            StringBuilder sb = new StringBuilder();
            if (this.sourceModulesCombo.getSelectedIndex() == -1) {
                if (this.previousSourceModuleSelection != null) {
                    sb.append(this.previousSourceModuleSelection);
                }
            } else {
                selectedModule = (String)this.sourceModulesCombo.getSelectedItem();
                sb.append(selectedModule);
                this.previousSourceModuleSelection = selectedModule;
            }
            if (this.sourcePackageText.getText() != null && this.sourcePackageText.getText().length() > 0) {
                sb.append('/');
                sb.append(this.sourcePackageText.getText());
            }
            sb.append(" = ");
            if (this.selectTargetRadio.isSelected()) {
                if (this.targetModulesCombo.getSelectedIndex() == -1) {
                    if (this.previousTargetModuleSelection != null) {
                        sb.append(this.previousTargetModuleSelection);
                    }
                } else {
                    selectedModule = (String)this.targetModulesCombo.getSelectedItem();
                    sb.append(selectedModule);
                    this.previousTargetModuleSelection = selectedModule;
                }
            } else {
                sb.append("ALL-UNNAMED");
            }
            this.currentContentText.setText(sb.toString());
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            knownModuleNames.remove(this.sourceModulesCombo.getSelectedItem());
            knownModuleNames.remove(this.targetModulesCombo.getSelectedItem());
            super.resetModuleComboModel(this.sourceModulesCombo, knownModuleNames);
            super.resetModuleComboModel(this.targetModulesCombo, knownModuleNames);
            this.enableButtons();
            this.nonUserUpdate = false;
        }

        public void enableButtons() {
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(1);
            return super.showDialog(title, this.sourceModulesCombo);
        }
    }

    private class EditLimitModulesDialog
    extends AbstractDialog {
        private JComboBox<String> knownModulesCombo;

        EditLimitModulesDialog(String currentList) {
            super(currentList);
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(39));
            this.knownModulesCombo = new JComboBox();
            this.knownModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.knownModulesCombo, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.resetComboModelFromModuleList(this.initialContent);
        }

        private void resetComboModelFromModuleList(String list) {
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            if (list != null) {
                String[] modules;
                for (String module : modules = list.split(",")) {
                    knownModuleNames.remove(module);
                }
            }
            super.resetModuleComboModel(this.knownModulesCombo, knownModuleNames);
        }

        @Override
        void updateCurrentContent() {
            if (this.knownModulesCombo.getSelectedIndex() != -1) {
                String current = this.currentContentText.getText();
                if (current != null && current.startsWith("ALL-")) {
                    this.currentContentText.setText("");
                }
                if (this.currentContentText.getText().isEmpty()) {
                    this.currentContentText.setText(this.knownModulesCombo.getSelectedItem().toString());
                } else {
                    this.currentContentText.setText(current + "," + this.knownModulesCombo.getSelectedItem());
                }
            }
            this.enableControls();
        }

        private void enableControls() {
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(6);
            return super.showDialog(title, this.knownModulesCombo);
        }
    }

    private class EditUpgradeModulePathDialog
    extends AbstractDialog {
        private JRadioButton addModuleRadio;
        private JComboBox<String> knownModulesCombo;
        private JRadioButton addDirectoryRadio;
        private JButton browseDirectoriesButton;
        private URLTextField directoryTextField;

        EditUpgradeModulePathDialog(String currentPath) {
            super(currentPath);
            this.directoryTextField = new URLTextField(null, true, false);
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(38));
            ButtonGroup bg = new ButtonGroup();
            this.addModuleRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.addModuleRadio, (String)RunConfigModuleSupportArb.getString(31));
            this.addModuleRadio.addActionListener(e -> this.enableButtons());
            bg.add(this.addModuleRadio);
            this.addDirectoryRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.addDirectoryRadio, (String)RunConfigModuleSupportArb.getString(30));
            this.addDirectoryRadio.addActionListener(e -> this.enableButtons());
            bg.add(this.addDirectoryRadio);
            this.addModuleRadio.setSelected(true);
            this.knownModulesCombo = new JComboBox();
            this.knownModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.browseDirectoriesButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.browseDirectoriesButton, (String)RunConfigModuleSupportArb.getString(33));
            this.browseDirectoriesButton.addActionListener((ActionListener)this.directoryTextField);
            this.directoryTextField.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("url")) {
                    this.updateCurrentContent();
                }
            });
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.addModuleRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.knownModulesCombo, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.addDirectoryRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.browseDirectoriesButton, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.resetComboModelFromPath(this.initialContent);
        }

        private void resetComboModelFromPath(String path) {
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            if (path != null) {
                String[] pathElements;
                for (String pathElement : pathElements = path.split(File.pathSeparator)) {
                    knownModuleNames.remove(pathElement);
                }
            }
            super.resetModuleComboModel(this.knownModulesCombo, knownModuleNames);
        }

        @Override
        void updateCurrentContent() {
            StringBuilder sb = new StringBuilder();
            if (this.currentContentText.getText() != null && this.currentContentText.getText().length() > 0) {
                sb.append(this.currentContentText.getText());
                sb.append(File.pathSeparatorChar);
            }
            if (this.addModuleRadio.isSelected() && this.knownModulesCombo.getSelectedIndex() != -1) {
                String module = (String)this.knownModulesCombo.getModel().getSelectedItem();
                sb.append(module);
                this.resetComboModelFromPath(sb.toString());
            } else {
                sb.append(this.directoryTextField.getText());
                this.directoryTextField.setURL(null);
            }
            this.currentContentText.setText(sb.toString());
            this.enableButtons();
        }

        public void enableButtons() {
            this.knownModulesCombo.setEnabled(this.addModuleRadio.isSelected() && this.knownModulesCombo.getModel().getSize() > 0);
            if (!this.knownModulesCombo.isEnabled()) {
                this.addModuleRadio.setEnabled(false);
                this.addDirectoryRadio.setSelected(true);
            }
            this.browseDirectoriesButton.setEnabled(this.addDirectoryRadio.isSelected());
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(5);
            return super.showDialog(title, this.knownModulesCombo);
        }
    }

    private class EditAddExportsDialog
    extends AbstractDialog {
        private JLabel selectSourceModuleLabel;
        private JComboBox<String> sourceModulesCombo;
        private String previousSourceModuleSelection;
        private JLabel sourcePackageLabel;
        private JTextField sourcePackageText;
        private JLabel selectTargetModuleLabel;
        private JRadioButton selectTargetRadio;
        private JComboBox<String> targetModulesCombo;
        private String previousTargetModuleSelection;
        private JRadioButton selectAllUnnamedRadio;
        private boolean nonUserUpdate;

        EditAddExportsDialog(String initialContent) {
            super(initialContent);
            this.nonUserUpdate = false;
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(47));
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            this.selectSourceModuleLabel = new JLabel();
            this.sourceModulesCombo = new JComboBox();
            ResourceUtils.resLabel((JLabel)this.selectSourceModuleLabel, this.sourceModulesCombo, (String)RunConfigModuleSupportArb.getString(45));
            this.sourceModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.sourcePackageLabel = new JLabel();
            this.sourcePackageText = new JTextField(120);
            ResourceUtils.resLabel((JLabel)this.sourcePackageLabel, (Component)this.sourcePackageText, (String)RunConfigModuleSupportArb.getString(53));
            this.sourcePackageText.addActionListener(e -> this.updateCurrentContent());
            this.selectTargetModuleLabel = new JLabel();
            this.targetModulesCombo = new JComboBox();
            ResourceUtils.resLabel((JLabel)this.selectTargetModuleLabel, this.targetModulesCombo, (String)RunConfigModuleSupportArb.getString(46));
            this.targetModulesCombo.addActionListener(e -> this.updateCurrentContent());
            ButtonGroup bg = new ButtonGroup();
            this.selectTargetRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.selectTargetRadio, (String)RunConfigModuleSupportArb.getString(35));
            this.selectTargetRadio.addActionListener(e -> {
                this.updateCurrentContent();
                this.enableButtons();
            });
            bg.add(this.selectTargetRadio);
            this.selectAllUnnamedRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.selectAllUnnamedRadio, (String)"&ALL-UNNAMED");
            this.selectAllUnnamedRadio.addActionListener(e -> {
                this.updateCurrentContent();
                this.enableButtons();
            });
            bg.add(this.selectAllUnnamedRadio);
            this.selectAllUnnamedRadio.setSelected(true);
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectSourceModuleLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.sourceModulesCombo, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.sourcePackageLabel, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.sourcePackageText, new GridBagConstraints(3, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectTargetModuleLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectTargetRadio, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.targetModulesCombo, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectAllUnnamedRadio, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.nonUserUpdate = true;
            if (this.initialContent == null || this.initialContent.length() == 0) {
                return;
            }
            this.currentContentText.setText(this.initialContent);
            String[] tokens = this.initialContent.split("=");
            if (tokens.length != 2) {
                logger.trace("EditAddExportsDialog.parseInitialContent(): expected 2 tokens, found " + tokens.length);
            }
            String[] moduleAndPackage = tokens[0].split("/");
            this.sourceModulesCombo.setSelectedItem(moduleAndPackage[0].trim());
            if (moduleAndPackage.length >= 2) {
                this.sourcePackageText.setText(moduleAndPackage[1].trim());
            }
            if ("ALL-UNNAMED".equals(tokens[1].trim())) {
                this.selectAllUnnamedRadio.setSelected(true);
            } else {
                this.selectTargetRadio.setSelected(true);
                this.targetModulesCombo.setSelectedItem(tokens[1].trim());
            }
            this.nonUserUpdate = false;
        }

        @Override
        void updateCurrentContent() {
            String selectedModule;
            if (this.nonUserUpdate) {
                return;
            }
            this.nonUserUpdate = true;
            StringBuilder sb = new StringBuilder();
            if (this.sourceModulesCombo.getSelectedIndex() == -1) {
                if (this.previousSourceModuleSelection != null) {
                    sb.append(this.previousSourceModuleSelection);
                }
            } else {
                selectedModule = (String)this.sourceModulesCombo.getSelectedItem();
                sb.append(selectedModule);
                this.previousSourceModuleSelection = selectedModule;
            }
            if (this.sourcePackageText.getText() != null && this.sourcePackageText.getText().length() > 0) {
                sb.append('/');
                sb.append(this.sourcePackageText.getText());
            }
            sb.append(" = ");
            if (this.selectTargetRadio.isSelected()) {
                if (this.targetModulesCombo.getSelectedIndex() == -1) {
                    if (this.previousTargetModuleSelection != null) {
                        sb.append(this.previousTargetModuleSelection);
                    }
                } else {
                    selectedModule = (String)this.targetModulesCombo.getSelectedItem();
                    sb.append(selectedModule);
                    this.previousTargetModuleSelection = selectedModule;
                }
            } else {
                sb.append("ALL-UNNAMED");
            }
            this.currentContentText.setText(sb.toString());
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            knownModuleNames.remove(this.sourceModulesCombo.getSelectedItem());
            knownModuleNames.remove(this.targetModulesCombo.getSelectedItem());
            String[] unselectedModules = knownModuleNames.toArray(new String[knownModuleNames.size()]);
            this.sourceModulesCombo.setModel(new DefaultComboBoxModel<String>(unselectedModules));
            this.targetModulesCombo.setModel(new DefaultComboBoxModel<String>(unselectedModules));
            this.enableButtons();
            this.nonUserUpdate = false;
        }

        public void enableButtons() {
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(1);
            return super.showDialog(title, this.sourceModulesCombo);
        }
    }

    private class EditAddReadsDialog
    extends AbstractDialog {
        private JLabel selectSourceModuleLabel;
        private JComboBox<String> sourceModulesCombo;
        private JLabel selectTargetModuleLabel;
        private JRadioButton selectTargetRadio;
        private JComboBox<String> targetModulesCombo;
        private JRadioButton selectAllUnnamedRadio;
        private boolean nonUserUpdate;

        EditAddReadsDialog(String initialContent) {
            super(initialContent);
            this.nonUserUpdate = false;
            this.initialContent = initialContent;
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(44));
            this.selectSourceModuleLabel = new JLabel();
            this.sourceModulesCombo = new JComboBox();
            this.sourceModulesCombo.setSelectedIndex(-1);
            ResourceUtils.resLabel((JLabel)this.selectSourceModuleLabel, this.sourceModulesCombo, (String)RunConfigModuleSupportArb.getString(45));
            this.sourceModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.selectTargetModuleLabel = new JLabel();
            this.targetModulesCombo = new JComboBox();
            this.targetModulesCombo.setSelectedIndex(-1);
            ResourceUtils.resLabel((JLabel)this.selectTargetModuleLabel, this.targetModulesCombo, (String)RunConfigModuleSupportArb.getString(46));
            this.targetModulesCombo.addActionListener(e -> this.updateCurrentContent());
            ButtonGroup bg = new ButtonGroup();
            this.selectTargetRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.selectTargetRadio, (String)RunConfigModuleSupportArb.getString(35));
            this.selectTargetRadio.addActionListener(e -> {
                this.updateCurrentContent();
                this.enableButtons();
            });
            bg.add(this.selectTargetRadio);
            this.selectAllUnnamedRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.selectAllUnnamedRadio, (String)"&ALL-UNNAMED");
            this.selectAllUnnamedRadio.addActionListener(e -> {
                this.updateCurrentContent();
                this.enableButtons();
            });
            bg.add(this.selectAllUnnamedRadio);
            this.selectAllUnnamedRadio.setSelected(true);
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectSourceModuleLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.sourceModulesCombo, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectTargetModuleLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectTargetRadio, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.targetModulesCombo, new GridBagConstraints(2, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectAllUnnamedRadio, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.nonUserUpdate = true;
            String source = null;
            String target = null;
            if (this.initialContent != null && this.initialContent.length() > 0) {
                String[] tokens = this.initialContent.split("=");
                if (tokens.length != 2) {
                    logger.trace("EditAddReadsDialog.parseInitialContent(): expected 2 tokens, found " + tokens.length);
                } else {
                    source = tokens[0].trim();
                    this.sourceModulesCombo.setSelectedItem(source);
                    if ("ALL_UNNAMED".equals(tokens[1].trim())) {
                        this.selectAllUnnamedRadio.setSelected(true);
                    } else {
                        target = tokens[1].trim();
                        this.selectTargetRadio.setSelected(true);
                        this.targetModulesCombo.setSelectedItem(target);
                    }
                }
            }
            this.resetComboModelFromCurrentContent(source, target);
            this.nonUserUpdate = false;
        }

        private void resetComboModelFromCurrentContent(String source, String target) {
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            knownModuleNames.remove(source);
            super.resetModuleComboModel(this.targetModulesCombo, knownModuleNames);
            this.targetModulesCombo.setSelectedItem(target);
            knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            knownModuleNames.remove(target);
            super.resetModuleComboModel(this.sourceModulesCombo, knownModuleNames);
            this.sourceModulesCombo.setSelectedItem(source);
        }

        @Override
        void updateCurrentContent() {
            if (this.nonUserUpdate) {
                return;
            }
            this.nonUserUpdate = true;
            StringBuilder sb = new StringBuilder();
            String source = (String)this.sourceModulesCombo.getSelectedItem();
            sb.append(source);
            sb.append(" = ");
            String target = null;
            if (this.selectTargetRadio.isSelected()) {
                target = (String)this.targetModulesCombo.getSelectedItem();
                sb.append(target);
            } else {
                sb.append("ALL-UNNAMED");
            }
            this.currentContentText.setText(sb.toString());
            this.resetComboModelFromCurrentContent(source, target);
            this.enableButtons();
            this.nonUserUpdate = false;
        }

        public void enableButtons() {
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(3);
            return super.showDialog(title, this.sourceModulesCombo);
        }
    }

    private class EditModuleDialog
    extends AbstractDialog {
        private JLabel selectModuleLabel;
        private JComboBox<String> knownModulesCombo;
        private String selectedModule;
        private JLabel selectMainClassLabel;
        private JButton browseClassesButton;
        private URLTextField classTextField;
        private JLabel selectMainClassFootnote;

        EditModuleDialog(String currentPath) {
            super(currentPath);
            this.classTextField = new URLTextField(null, false, false);
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(40));
            this.selectModuleLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this.selectModuleLabel, this.knownModulesCombo, (String)RunConfigModuleSupportArb.getString(41));
            this.knownModulesCombo = new JComboBox();
            this.knownModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.selectMainClassLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)this.selectMainClassLabel, (Component)this.browseClassesButton, (String)RunConfigModuleSupportArb.getString(42));
            this.browseClassesButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.browseClassesButton, (String)RunConfigModuleSupportArb.getString(33));
            this.browseClassesButton.addActionListener((ActionListener)this.classTextField);
            this.classTextField.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("url")) {
                    this.updateCurrentContent();
                }
            });
            this.selectMainClassFootnote = new JLabel(RunConfigModuleSupportArb.getString(43));
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectModuleLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.knownModulesCombo, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectMainClassLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.browseClassesButton, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectMainClassFootnote, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.resetComboModelFromCurrentContent(this.initialContent);
            if (this.initialContent != null) {
                String[] elements = this.initialContent.split("/", 2);
                this.knownModulesCombo.setSelectedItem(elements[0]);
                if (elements.length > 1) {
                    this.classTextField.setText(elements[1]);
                }
            }
        }

        @Override
        void updateCurrentContent() {
            StringBuilder sb = new StringBuilder();
            if (this.knownModulesCombo.getSelectedIndex() != -1) {
                String module = (String)this.knownModulesCombo.getModel().getSelectedItem();
                sb.append(module);
                this.resetComboModelFromCurrentContent(sb.toString());
            }
            if (this.classTextField.getText() != null && this.classTextField.getText().length() > 0) {
                sb.append("/");
                sb.append(this.classTextField.getText());
            }
            this.currentContentText.setText(sb.toString());
            this.enableButtons();
        }

        private void resetComboModelFromCurrentContent(String current) {
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            if (current != null) {
                this.selectedModule = current.indexOf(47) != -1 ? current.substring(0, current.indexOf(47)) : current;
                knownModuleNames.remove(this.selectedModule);
            }
            super.resetModuleComboModel(this.knownModulesCombo, knownModuleNames);
        }

        private void enableButtons() {
            this.knownModulesCombo.setEnabled(this.knownModulesCombo.getModel().getSize() > 0);
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(2);
            return super.showDialog(title, this.knownModulesCombo);
        }
    }

    private class EditUserAddModulesDialog
    extends AbstractDialog {
        private JRadioButton selectModulesRadio;
        private JRadioButton allDefaultRadio;
        private JRadioButton allModulePathRadio;
        private JComboBox<String> knownModulesCombo;

        EditUserAddModulesDialog(String currentPath) {
            super(currentPath);
            this.initialContent = currentPath;
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(39));
            ButtonGroup bg = new ButtonGroup();
            this.selectModulesRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.selectModulesRadio, (String)RunConfigModuleSupportArb.getString(34));
            this.selectModulesRadio.addActionListener(e -> this.enableControls());
            bg.add(this.selectModulesRadio);
            this.allDefaultRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.allDefaultRadio, (String)"&ALL-DEFAULT");
            this.allDefaultRadio.addActionListener(e -> this.updateCurrentContent());
            bg.add(this.allDefaultRadio);
            this.allModulePathRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.allModulePathRadio, (String)"ALL-&MODULE-PATH");
            this.allModulePathRadio.addActionListener(e -> this.updateCurrentContent());
            bg.add(this.allModulePathRadio);
            this.selectModulesRadio.setSelected(true);
            this.knownModulesCombo = new JComboBox();
            this.knownModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.selectModulesRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.knownModulesCombo, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.allDefaultRadio, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.allModulePathRadio, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            if (this.initialContent != null) {
                if (this.initialContent.equals("ALL-DEFAULT")) {
                    this.allDefaultRadio.setSelected(true);
                } else if (this.initialContent.equals("ALL-MODULE-PATH")) {
                    this.allModulePathRadio.setSelected(true);
                } else {
                    this.selectModulesRadio.setSelected(true);
                }
                this.resetComboModelFromCurrentContent(this.initialContent);
            }
        }

        private void resetComboModelFromCurrentContent(String current) {
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            if (current != null) {
                String[] modulesUsed;
                for (String module : modulesUsed = current.split(",")) {
                    knownModuleNames.remove(module);
                }
            }
            super.resetModuleComboModel(this.knownModulesCombo, knownModuleNames);
        }

        @Override
        void updateCurrentContent() {
            if (this.selectModulesRadio.isSelected()) {
                if (this.knownModulesCombo.getSelectedIndex() != -1) {
                    String current = this.currentContentText.getText();
                    if (current != null && current.startsWith("ALL-")) {
                        this.currentContentText.setText("");
                    }
                    this.currentContentText.setText(current + this.knownModulesCombo.getSelectedItem());
                }
            } else if (this.allDefaultRadio.isSelected()) {
                this.currentContentText.setText("ALL-DEFAULT");
            } else if (this.allModulePathRadio.isSelected()) {
                this.currentContentText.setText("ALL-MODULE-PATH");
            }
            this.enableControls();
        }

        private void enableControls() {
            this.knownModulesCombo.setEnabled(this.selectModulesRadio.isSelected() && this.knownModulesCombo.getModel().getSize() > 0);
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(1);
            return super.showDialog(title, this.knownModulesCombo);
        }
    }

    private class EditUserModulePathDialog
    extends AbstractDialog {
        private JRadioButton addModuleRadio;
        private JComboBox<String> knownModulesCombo;
        private JRadioButton addDirectoryRadio;
        private JButton browseDirectoriesButton;
        private URLTextField directoryTextField;

        EditUserModulePathDialog(String currentPath) {
            super(currentPath);
            this.directoryTextField = new URLTextField(null, true, false);
            ResourceUtils.resLabel((JLabel)this.currentContentLabel, (Component)this.currentContentText, (String)RunConfigModuleSupportArb.getString(38));
            ButtonGroup bg = new ButtonGroup();
            this.addModuleRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.addModuleRadio, (String)RunConfigModuleSupportArb.getString(31));
            this.addModuleRadio.addActionListener(e -> this.enableButtons());
            bg.add(this.addModuleRadio);
            this.addDirectoryRadio = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.addDirectoryRadio, (String)RunConfigModuleSupportArb.getString(30));
            this.addDirectoryRadio.addActionListener(e -> this.enableButtons());
            bg.add(this.addDirectoryRadio);
            this.addModuleRadio.setSelected(true);
            this.knownModulesCombo = new JComboBox();
            this.knownModulesCombo.addActionListener(e -> this.updateCurrentContent());
            this.browseDirectoriesButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.browseDirectoriesButton, (String)RunConfigModuleSupportArb.getString(33));
            this.browseDirectoriesButton.addActionListener((ActionListener)this.directoryTextField);
            this.directoryTextField.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("url")) {
                    this.updateCurrentContent();
                }
            });
            this.parseInitialContent();
            int y = 0;
            this.add((Component)this.currentContentLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.currentContentText, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.addModuleRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add(this.knownModulesCombo, new GridBagConstraints(1, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.addDirectoryRadio, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.browseDirectoriesButton, new GridBagConstraints(1, y, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        }

        @Override
        void parseInitialContent() {
            this.resetComboModelFromCurrentContent(this.initialContent);
        }

        @Override
        void updateCurrentContent() {
            StringBuilder sb = new StringBuilder();
            if (this.currentContentText.getText() != null && this.currentContentText.getText().length() > 0) {
                sb.append(this.currentContentText.getText());
                sb.append(File.pathSeparatorChar);
            }
            if (this.addModuleRadio.isSelected() && this.knownModulesCombo.getSelectedIndex() != -1) {
                String module = (String)this.knownModulesCombo.getModel().getSelectedItem();
                sb.append(module);
                this.resetComboModelFromCurrentContent(sb.toString());
            } else {
                sb.append(this.directoryTextField.getText());
                this.directoryTextField.setURL(null);
            }
            this.currentContentText.setText(sb.toString());
            this.enableButtons();
        }

        private void resetComboModelFromCurrentContent(String current) {
            List<String> knownModuleNames = RunConfigurationModuleOptionsPanel.this.runConfiguration.getPathsConfigModules();
            if (current != null) {
                String[] pathElements;
                for (String pathElement : pathElements = current.split(File.pathSeparator)) {
                    knownModuleNames.remove(pathElement);
                }
            }
            super.resetModuleComboModel(this.knownModulesCombo, knownModuleNames);
        }

        public void enableButtons() {
            this.knownModulesCombo.setEnabled(this.addModuleRadio.isSelected() && this.knownModulesCombo.getModel().getSize() > 0);
            if (!this.knownModulesCombo.isEnabled()) {
                this.addModuleRadio.setEnabled(false);
                this.addDirectoryRadio.setSelected(true);
            }
            this.browseDirectoriesButton.setEnabled(this.addDirectoryRadio.isSelected());
            if (this.dlg != null) {
                this.dlg.setOKButtonEnabled(this.canOk());
            }
        }

        String showDialog() {
            String title = RunConfigModuleSupportArb.getString(0);
            return super.showDialog(title, this.knownModulesCombo);
        }
    }

    private abstract class AbstractDialog
    extends JPanel {
        protected String initialContent;
        protected JLabel currentContentLabel;
        protected JTextField currentContentText;
        protected JEWTDialog dlg;

        AbstractDialog(String currentContent) {
            super(new GridBagLayout());
            this.initialContent = currentContent;
            this.currentContentLabel = new JLabel();
            this.currentContentText = new JTextField(this.initialContent);
            this.currentContentText.setEditable(false);
        }

        abstract void parseInitialContent();

        abstract void updateCurrentContent();

        protected void resetModuleComboModel(JComboBox<String> combo, List<String> availableModules) {
            String[] unselectedModules = availableModules.toArray(new String[availableModules.size()]);
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(unselectedModules);
            combo.setModel(model);
            combo.setSelectedIndex(-1);
        }

        public boolean canOk() {
            return true;
        }

        String showDialog(String dialogTitle, JComponent initiallyFocusedComponent) {
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)initiallyFocusedComponent, (String)dialogTitle);
            if (WizardLauncher.runDialog((JDialog)this.dlg)) {
                return this.currentContentText.getText();
            }
            return null;
        }
    }
}

